/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "wifi_util.h"

#include "wifi_drv_ko.h"
#include <semaphore.h>
#include <sys/wait.h>
//#include <unistd.h>
#include "wifi_ap_ctrl.h"
#include "wpa_ctrl.h"
#include <poll.h>
#include "wifi_socket.h"
#include "rtk_arch.h"

#if defined(__AIC_8800DW_CHIP__)
#define TXRX_PARA								SIOCDEVPRIVATE+1
#endif

#define UEVENT_BUFFER_SIZE   1024*2
#define AP_STA_CONNECTED "AP-STA-CONNECTED "
#define AP_STA_DISCONNECTED "AP-STA-DISCONNECTED "
#define AP_EVENT_ENABLED "AP-ENABLED "

#define MULTI_AP_STA_CONNECTED "MULTI-AP-STA-CONNECTED "
#define MULTI_AP_STA_DISCONNECTED "MULTI-AP-STA-DISCONNECTED "
#define MULTI_AP_EVENT_ENABLED "MULTI-AP-ENABLED "
#define MULTI_AP_REJECTED_MAX_STA "MULTI-AP-REJECTED-MAX-STA "
#define MULTI_AP_REJECTED_BLOCKED_STA "MULTI-AP-REJECTED-BLOCKED-STA "


//WPS-PIN-NEEDED 81cd0b24-1bcb-59c3-897b-ae51d0db3bf6 a4:44:d1:86:c5:d9 [m3note|Meizu|m3 note|m3 note|91QECP856P5Z|10-0050F204-5]
#define  WPS_PIN_NEEDED	"WPS-PIN-NEEDED"
#define  WPS_SUCCESS	  "WPS-SUCCESS"
#define AP_REJECTED_MAX_STA "AP-REJECTED-MAX-STA "
#define AP_REJECTED_BLOCKED_STA "AP-REJECTED-BLOCKED-STA "

//ʱ
#define WIFI_WPS_PIN_TIMEOUT_TIMER_ID  130
#define WIFI_CHANNEL_FOLLOW_TIMEOUT_TIMER_ID    131 //Apstaⲿȵ㳬ʱʱap
#ifdef USE_CAP_SUPPORT
#define WIFI_AP_ENABLED_TIMER_ID 132 //hostapdǷap-enabledɹ
#endif

#if defined(__SSV_6X5X_CHIP__)
#define HT_CAPAB_40 "[HT40+][HT40-][SHORT-GI-20][SHORT-GI-40]"
#define HT_CAPAB_20 "[HT20][SHORT-GI-20]"
#elif defined(__AIC_8800DW_CHIP__)
#define HT_CAPAB_40 "[LDPC][HT40+][HT40-][SHORT-GI-20][SHORT-GI-40]"
#define HT_CAPAB_20 "[HT20][LDPC][SHORT-GI-20]"

#define VHT_CAPAB_160 "[SHORT-GI-80][SHORT-GI-160][VHT160]"//unsupport
#define VHT_CAPAB_80 "[VHT40+]" //invalid parameter [SHORT-GI-80][MAX-A-MPDU-LEN-EXP7]
#define VHT_CAPAB_40 "[HT40+][HT40-][SHORT-GI-20][SHORT-GI-40]" //5G ht
#endif

/**********mmi wlan wps status***************/
#define WPS_ACTIVING "0"
#define WPS_ACTIVED "1"
#define WPS_DEACTIVING "2"
#define WPS_DEACTIVED "3"
#define WPS_ACTIVE_MAX "4"

#if defined(__AIC_8800DW_CHIP__)
typedef struct android_wifi_priv_cmd {
	char *buf;
	int used_len;
	int total_len;
} android_wifi_priv_cmd;
#endif

static const char ACCEPT_MAC_FILE[] ="/etc_rw/wifi/hostapd.accept";
static const char DENY_MAC_FILE[] ="/etc_rw/wifi/hostapd.deny";
static const char HOSTAPD_CONF_FILE[]    = "/etc_rw/wifi/hostapd.conf";
static const char HOSTAPD_BIN_FILE[]    = "/bin/hostapd";
static const char WPS_PIN_REQUESTS[] = "/etc_rw/wifi/hostapd_wps_pin_requests";


static const char CONTROL_IFACE_PATH[]  = "/etc_rw/wifi/hostapd";
static const char IFACE[]         = "wlan0";

char  sta_wps_uuid[64]={0};


sem_t g_hostap_id;
int g_hostap = 0;
static int g_ap_enabled = 0;
int need_channel_follow = 0;
static int g_ap_sta_num_full = 0;

#if defined( __MULTI_AP__)
sem_t g_m_hostap_id;
int g_m_hostap = 0;
#endif

#ifdef USE_CAP_SUPPORT
#define PATH_MAX 256
#define INT_MAX 2147483647

extern int g_work_mode;

extern void acl_mode_set();
extern void acl_mode_set_5g();
#endif

extern struct   wlan_ap_server  * ap_server;
int wifi_start_hostapd (struct  wlan_ap_server  *ap_svr);
static void wlan_ap_init(struct wlan_ap_server  *ap_svr);
int wifi_stop_hostapd (struct  wlan_ap_server  *ap_svr);
int wifi_set_hostapd (struct  wlan_ap_server  *ap_svr);
static void  wifi_ap_disable(struct  wlan_ap_server  *ap_svr);
static int wifi_ap_enable(struct  wlan_ap_server  *ap_svr);

static void wlan_set_txpwr(void);


bool isSoftapStarted(struct wlan_ap_server  *ap_svr);
void generate_acl_list_file(char* accesspolicy);
int  acl_mode_value_transist(char* accesspolicy0);
void basic_deal (struct wlan_ap_server  *ap_svr, int cmd);
void acl_set_process();
static void str_remove_chr(char *str, char chr);
extern void  get_mac_config_ssid_key_nv();
extern void wlan_station_init(void);
extern void wifi_station_close();
#ifdef __STA_FUNC__
extern void wifi_station_cancel_scan(void);
#endif
#ifdef USE_CAP_SUPPORT
extern int send_ap_status_to_cap(int idx, int status);
#endif

struct wlan_ap_server  rda5995_ap = {
	.sock    		={
		.iface_name	= 	"wlan0",
		.sockets_dir	= 	"/etc_rw/wifi/hostapd",
	},
	.drv_proxy =
	{	
		.drv_init_flag	= 0,
		.iface_name 	=	"wlan0",
		.insmod_cmd 	=  	RDA5995_INSMODE_APCMD,
		.rmmod_cmd 	=	RDA5995_RMMOD_CMD,
		.drv_init		= 	wlan_drv_init,
		.drv_deinit	=	wlan_drv_deinit,
	},
	.init 			=  	wlan_ap_init,
	.startap		= 	wifi_start_hostapd,
	.stopap 		= 	wifi_stop_hostapd,
	.setap		= 	wifi_set_hostapd,

};


struct wlan_ap_server  esp8089_ap = {
	.sock    		={
		.iface_name	= 	"wlan0",
		.sockets_dir	= 	"/etc_rw/wifi/hostapd",
	},

	.drv_proxy =
	{
	
		.drv_init_flag = 0,
		.iface_name 	=	"wlan0",
		.insmod_cmd 	=  	ESP8089_INSMODE_STACMD,
		.rmmod_cmd 	=	ESP8089_RMMOD_STACMD,
		.drv_init		= 	wlan_drv_init,
		.drv_deinit	=	wlan_drv_deinit,

	},	
	.init 			=  	wlan_ap_init,
	.enable		=	wifi_ap_enable,
	.disable		=	wifi_ap_disable,
	.startap		= 	wifi_start_hostapd,
	.stopap 		= 	wifi_stop_hostapd,
	.setap		= 	wifi_set_hostapd,
	.basic_deal 	=     basic_deal,
};

struct wlan_ap_server  xr819_ap = {
	.sock = {
		.iface_name 	= 	"wlan0",
		.sockets_dir	= 	"/etc_rw/wifi/hostapd",
	},

	.drv_proxy = {
		.drv_init_flag 	= 	0,
		.iface_name 	=	"wlan0",
		.insmod_cmd 	=  	XR819_INSMODE_STACMD,
		.rmmod_cmd 		=	XR819_RMMOD_STACMD,
		.drv_init		= 	wlan_drv_init,
		.drv_deinit		=	wlan_drv_deinit,
	},	
	.init 			=  	wlan_ap_init,
	.enable			=	wifi_ap_enable,
	.disable		=	wifi_ap_disable,
	.startap		= 	wifi_start_hostapd,
	.stopap 		= 	wifi_stop_hostapd,
	.setap			= 	wifi_set_hostapd,
	.basic_deal 	=   basic_deal,
};

struct wlan_ap_server  ssv6x5x_ap = {
	.sock = {
		.iface_name 	= 	"wlan0",
		.sockets_dir	= 	"/etc_rw/wifi/hostapd",
	},

	.drv_proxy = {
		.drv_init_flag 	= 	0,
		.iface_name 	=	"wlan0",
		.insmod_cmd 	=  	SSV6X5X_INSMODE_STACMD,
		.rmmod_cmd 		=	SSV6X5X_RMMOD_STACMD,
		.drv_init		= 	wlan_drv_init,
		.drv_deinit		=	wlan_drv_deinit,
	},	
	.init 			=  	wlan_ap_init,
	.enable			=	wifi_ap_enable,
	.disable		=	wifi_ap_disable,
	.startap		= 	wifi_start_hostapd,
	.stopap 		= 	wifi_stop_hostapd,
	.setap			= 	wifi_set_hostapd,
	.basic_deal 	=   basic_deal,
};

struct wlan_ap_server  aic8800dw_ap = {
	.sock = {
		.iface_name 	= 	"wlan0",
		.sockets_dir	= 	"/etc_rw/wifi/hostapd",
	},
#if defined(__MULTI_AP__)
	.sock_m = {
		.iface_name 	=	"wlan0-va1",
		.sockets_dir	=	"/etc_rw/wifi/hostapd",
	},
#endif

	.drv_proxy = {
		.drv_init_flag 	= 	0,
		.iface_name 	=	"wlan0",
		.insmod_cmd 	=  	AIC8800DW_INSMODE_STACMD,
		.rmmod_cmd 		=	AIC8800DW_RMMOD_STACMD,
		.drv_init		= 	wlan_drv_init,
		.drv_deinit		=	wlan_drv_deinit,
	},	
	.init 			=  	wlan_ap_init,
	.enable			=	wifi_ap_enable,
	.disable		=	wifi_ap_disable,
	.startap		= 	wifi_start_hostapd,
	.stopap 		= 	wifi_stop_hostapd,
	.setap			= 	wifi_set_hostapd,
	.basic_deal 	=   basic_deal,
};

static void  wifi_ap_wps_get_uuid (char *buf,  char *uuid, int uuid_len)
{

	int i = 0, j=0;
	char * reply = NULL;

	char *splited_string = NULL;
	char *save = NULL;
	const char *delimiter = " ";

	splited_string = strtok_r(buf, delimiter, &save);
	
	wf_log("splited_string = %s\n",splited_string);
	
	while (splited_string) {
		if(0 == j){
			j = 1;
		}
		else{
			strncpy(uuid, splited_string,  uuid_len);
			break;
		}
		splited_string = strtok_r(NULL, delimiter, &save);
		wf_log("splited_string = %s\n",splited_string);
	}
}


inline char * ap_docmd(const char *cmd,  char* content)
{
	char tmp[128]={0};
	if(!isSoftapStarted(ap_server)) {//kw
		wf_log("hostapd is not run, %s can not be execute", cmd);
		return NULL;
	}
	if(content ==NULL){
		sprintf(tmp, "%s", cmd);
	}
	else{
		sprintf(tmp, "%s %s", cmd, content);
	}
		
	return docmd (&ap_server->sock, tmp);
}

inline char * ap_docmd_m(const char *cmd,  char* content)
{
	char tmp[128]={0};
	if(!isSoftapStarted(ap_server)) {//kw
		wf_log("hostapd is not run, %s can not be execute", cmd);
		return NULL;
	}
	if(content ==NULL){
		sprintf(tmp, "%s", cmd);
	}
	else{
		sprintf(tmp, "%s %s", cmd, content);
	}
		
	return docmd(&ap_server->sock_m, tmp);
}

int startSoftap(struct wlan_ap_server  *ap_svr) {
    pid_t pid = 1;

    if (ap_svr->sock.pid) {
        wf_log("SoftAP is already running");
        return 0;
    }

    if ((pid = fork()) < 0) {
        wf_log("fork failed (%s)", strerror(errno));
        return -1;
    }

    if (!pid) {
		//kw 3
        execl(HOSTAPD_BIN_FILE, HOSTAPD_BIN_FILE,
                  "-d", HOSTAPD_CONF_FILE, (char *) NULL);
        wf_log("SoftAP failed to start (%s)", strerror(errno));
        return -1;
    } else {
        ap_svr->sock.pid = pid;
#if defined(__MULTI_AP__)
		ap_svr->sock_m.pid = pid;
#endif		
        wf_log("SoftAP started successfully pid=%d pid=%d", ap_svr->sock.pid,ap_svr->sock_m.pid);
        usleep(AP_BSS_START_DELAY);
    }
    return 0;
}

int stopSoftap(struct wlan_ap_server  *ap_svr) {

    if (ap_svr->sock.pid == 0) {
        wf_log("SoftAP is not running");
        return 0;
    }

    wf_log("Stopping the SoftAP service...");
    kill(ap_svr->sock.pid, SIGTERM);
    waitpid(ap_svr->sock.pid, NULL, 0);

    ap_svr->sock.pid = 0;
	ap_svr->sock_m.pid = 0;
    wf_log("SoftAP stopped successfully");
    usleep(AP_BSS_STOP_DELAY);
    return 0;
}

bool isSoftapStarted(struct wlan_ap_server  *ap_svr) 
{
    return (ap_svr->sock.pid!= 0);
}



void  wlan_ap_get_para(struct wlan_ap_server  *ap_svr)
{
	struct  wlan_ap_para *  para = &ap_svr->ap_para;
	
	sc_cfg_get ("wifi_set_flags", para->wifi_set_flags, NVIO_WIFI_LEN_8-1);
	sc_cfg_get ("SSID1", para->ssid, WIFI_STATION_SSID_LEN-1);
	sc_cfg_get ("HideSSID", para->ignore_broadcast_ssid, NVIO_WIFI_LEN_8-1);
	sc_cfg_get ("AuthMode", para->auth_mode, WIFI_STATION_AUTH_MODE_LEN-1);
	sc_cfg_get ("WPAPSK1", para->password, WIFI_STATION_SPOT_PASSWORD_LEN-1);
	sc_cfg_get ("wifi_11n_cap", para->wifi_11n_cap, NVIO_WIFI_LEN_8-1);
	sc_cfg_get ("wifi_band", para->wifi_band, NVIO_WIFI_LEN_8-1);
	sc_cfg_get ("WirelessMode", para->WirelessMode, NVIO_WIFI_LEN_8-1);
	sc_cfg_get ("Channel", para->Channel, NVIO_WIFI_LEN_8-1);
	
	sc_cfg_get ("CountryCode", para->CountryCode, NVIO_WIFI_LEN_8-1);
	if (0 == strcmp(para->CountryCode, "NONE")) {
		strcpy(para->CountryCode, "00");
	}
	
	sc_cfg_get ("wifi_coverage", para->wifi_coverage, NVIO_WIFI_LEN_16-1);
	sc_cfg_get ("MAX_Access_num", para->max_num_sta, NVIO_WIFI_LEN_8-1);
	sc_cfg_get ("AccessPolicy0", para->accesspolicy0, NVIO_WIFI_LEN_8-1);

	wf_log("SSID1=%s HideSSID=%s, AuthMode=%s, WPAPSK1=%s, wifi_11n_cap=%s, \n"
		"wifi_band=%s, WirelessMode=%s, Channel=%s, CountryCode=%s, wifi_coverage=%s, MAX_Access_num=%s, AccessPolicy0=%s\n", 
		para->ssid, para->ignore_broadcast_ssid, para->auth_mode, para->password, para->wifi_11n_cap, 
		para->wifi_band, para->WirelessMode,para->Channel, para->CountryCode, para->wifi_coverage, para->max_num_sta,para->accesspolicy0);

	sc_cfg_set("tmp_channel", para->Channel);

	char m_ssid_enable[8] = {0};
	sc_cfg_get ("m_ssid_enable", m_ssid_enable, sizeof (m_ssid_enable));	
	if(strcmp (m_ssid_enable, "1") == 0){	
		sc_cfg_get ("m_SSID", para->m_ssid, WIFI_STATION_SSID_LEN-1);
		sc_cfg_get ("m_HideSSID", para->m_ignore_broadcast_ssid, NVIO_WIFI_LEN_8-1);
		sc_cfg_get ("m_AuthMode", para->m_auth_mode, WIFI_STATION_AUTH_MODE_LEN-1);
		sc_cfg_get ("m_WPAPSK1", para->m_password, WIFI_STATION_SPOT_PASSWORD_LEN-1);
		sc_cfg_get ("m_MAX_Access_num", para->m_max_num_sta, NVIO_WIFI_LEN_8-1);
		wf_log("m_SSID=%s m_HideSSID=%s, m_AuthMode=%s, m_password=%s,MAX_Station_num:%s m_MAX_Access_num=%s\n", 
		para->m_ssid, para->m_ignore_broadcast_ssid, para->m_auth_mode, para->m_password,para->max_num_sta, para->m_max_num_sta);
	}	

}

/*
 else if (os_strcmp(buf, "hw_mode") == 0) {
		if (os_strcmp(pos, "a") == 0)
			conf->hw_mode = HOSTAPD_MODE_IEEE80211A;
		else if (os_strcmp(pos, "b") == 0)
			conf->hw_mode = HOSTAPD_MODE_IEEE80211B;
		else if (os_strcmp(pos, "g") == 0)
			conf->hw_mode = HOSTAPD_MODE_IEEE80211G;
		else if (os_strcmp(pos, "ad") == 0)
			conf->hw_mode = HOSTAPD_MODE_IEEE80211AD;
		else if (os_strcmp(pos, "any") == 0)
			conf->hw_mode = HOSTAPD_MODE_IEEE80211ANY;
		else {
			wpa_printf(MSG_ERROR, "Line %d: unknown hw_mode '%s'",
				   line, pos);
			return 1;
		}

*/

static void wlan_80211Mode_config(char *wirelessMode)
{
	
	if ( !strcmp (wirelessMode, "4")) {//11b/g/n mixed mode
		ap_docmd ("SET hw_mode g", NULL);
		ap_docmd ("SET ieee80211n 1", NULL);
	}
	else if (!strcmp (wirelessMode, "2")) {//11n
		ap_docmd ("SET hw_mode g", NULL);
		ap_docmd ("SET ieee80211n 1", NULL);
	}	
	else if  (!strcmp (wirelessMode, "0")) {//11b only
		ap_docmd ("SET hw_mode b", NULL);
		ap_docmd ("SET ieee80211n 0", NULL);
	}	
	else if  (!strcmp (wirelessMode, "1")) {//11g only
		ap_docmd ("SET hw_mode g", NULL);
		ap_docmd ("SET ieee80211n 0", NULL);
	}	
	else if (!strcmp (wirelessMode, "3")) {//11b/g
		ap_docmd ("SET hw_mode g", NULL);
		ap_docmd ("SET ieee80211n 1", NULL);
	}
	else if (!strcmp (wirelessMode, "6")) {//11b/g/n/ax mixed mode
		ap_docmd ("SET hw_mode g", NULL);
		ap_docmd ("SET ieee80211n 1", NULL);
		ap_docmd ("SET ieee80211ac 1", NULL);
		ap_docmd ("SET ieee80211ax 1", NULL);
	}
	else {
		ap_docmd ("SET hw_mode g", NULL);
		ap_docmd ("SET ieee80211n 1", NULL);
	}

}

#if defined(__AIC_8800DW_CHIP__)
static int aic_send_cmd_to_net_iface(char *if_name, char *cmd)
{
	int sock;
	struct ifreq ifr;
	int ret = 0;
	char buf[128] = {0};
	struct android_wifi_priv_cmd priv_cmd;

	wf_log("[%s,%s]!\n", if_name, cmd);

	if (strlen(cmd) >= sizeof(buf)) {
		wf_log("data too long!\n");
	}
	
	sock = socket(PF_INET, SOCK_DGRAM, 0);
	if (sock < 0) {
		wf_log("bad sock!\n");
		return -1;
	}

	memset(&ifr, 0, sizeof(ifr));
	strcpy(ifr.ifr_name, if_name);

	if (ioctl(sock, SIOCGIFFLAGS, &ifr) != 0) {
		wf_log("Could not read interface %s flags: %s", if_name, strerror(errno));
		return -1;
	}

	if (!(ifr.ifr_flags & IFF_UP)) {
		wf_log("%s is not up!\n", if_name);
		return -1;
	}

	memset(&priv_cmd, 0, sizeof(priv_cmd));
	memset(buf, 0, sizeof(buf));

	snprintf(buf, sizeof(buf), "%s", cmd);

	priv_cmd.buf = buf;
	priv_cmd.used_len = strlen(buf);
	priv_cmd.total_len = sizeof(buf);
	ifr.ifr_data = (void*)&priv_cmd;

    if ((ret = ioctl(sock, TXRX_PARA, &ifr)) < 0) {
        wf_log("%s:error ioctl[TX_PARA] ret= %d\n", ret);
        return -1;
    }

    return 0;
}

static void wlan_set_wifiConverage_aic(char *if_name, char *wifiCoverage)
{
	if (!strcmp (wifiCoverage, "short_mode")) {
		aic_send_cmd_to_net_iface("wlan0", "SET_TXPWR_LOSS -6");
	} else if (!strcmp (wifiCoverage, "medium_mode")) {
		aic_send_cmd_to_net_iface("wlan0", "SET_TXPWR_LOSS -3");
	} else { //long mode
		aic_send_cmd_to_net_iface("wlan0", "SET_TXPWR_LOSS 0");
	}
}
#endif

static void wlan_set_txpwr(void)
{
#if defined(__AIC_8800DW_CHIP__)
	char wifi_coverage[NVIO_WIFI_LEN_16] = {0};
	sc_cfg_get("wifi_coverage", wifi_coverage, sizeof(wifi_coverage)-1);
	wlan_set_wifiConverage_aic(ap_server->drv_proxy.iface_name, wifi_coverage);
#endif
}

static void wlan_set_wifiConverage(char *wifiCoverage)
{

	if (!strcmp (wifiCoverage, "short_mode")) {
		ap_docmd("SET local_pwr_constraint 20", NULL);
	} else if (!strcmp (wifiCoverage, "medium_mode")) {
		ap_docmd("SET local_pwr_constraint 100", NULL);
	} else { //long mode
		ap_docmd("SET local_pwr_constraint 200", NULL);
	}
}
static void wlan_set_ht(char *htMode)
{
#if (defined(__SSV_6X5X_CHIP__) || defined(__AIC_8800DW_CHIP__))
	if (!strcmp (htMode, "1")) {
		char f_40M[8] = {0};
		sc_cfg_get ("wifi_force_40m", f_40M, sizeof(f_40M));
		ap_docmd("SET force_40mhz", f_40M);
		
		ap_docmd("SET ht_capab "HT_CAPAB_40, NULL);
	} else {
		//ap_docmd("SET force_40mhz", "0");
		ap_docmd("SET ht_capab "HT_CAPAB_20, NULL);
	}
#endif
}

void  wifi_config_ap(struct wlan_ap_server  *ap_svr)
{
	struct  wlan_ap_para*  para = &ap_svr->ap_para;
	char max_Access_num_bbak[16]={0};

	unsigned int flags = 0;
	flags = atoi(para->wifi_set_flags);
	wf_log("wifi_set_flags=0x%x", flags);

	if( 0 == flags ){
		//quick_setupû
		flags = ZTE_WLAN_SSID_SET|ZTE_WLAN_BROADCAST_SET|ZTE_WLAN_BASIC_SECURITY_SET;
	}
	
	if( flags & ZTE_WLAN_SSID_SET){
		ap_docmd("SET ssid", para->ssid);
//		hostapd_conf_change_para("ssid", para->ssid);
	}
	if( flags & ZTE_WLAN_BROADCAST_SET){
		ap_docmd("SET ignore_broadcast_ssid", para->ignore_broadcast_ssid);
//		hostapd_conf_change_para("ssid", para->ssid);
		ap_docmd("SET wps_state", "2");
	}
	if( flags & ZTE_WLAN_BASIC_SECURITY_SET){
		if (!strcmp (para->auth_mode, "WPAPSKWPA2PSK") || !strcmp (para->auth_mode, "WPA-PSK/WPA2-PSK")) {
			ap_docmd("SET wpa","3");
			ap_docmd("SET ieee80211w","0");
			ap_docmd("SET wpa_key_mgmt","WPA-PSK");
			ap_docmd("SET wpa_pairwise","TKIP CCMP");
			ap_docmd("SET rsn_pairwise","TKIP CCMP");
			ap_docmd("SET wpa_passphrase",para->password);
		} else if (!strcmp(para->auth_mode, "WPA2PSK")) {
			ap_docmd("SET wpa","2");
			ap_docmd("SET ieee80211w","0");
			ap_docmd("SET wpa_key_mgmt","WPA-PSK");
			ap_docmd("SET wpa_pairwise","TKIP");
			ap_docmd("SET rsn_pairwise","CCMP");
			ap_docmd("SET wpa_passphrase",para->password);
		} else if (!strcmp(para->auth_mode, "WPA3Personal")) {
			ap_docmd("SET wpa","2");
			ap_docmd("SET ieee80211w","2");
			ap_docmd("SET wpa_key_mgmt","SAE");
			ap_docmd("SET wpa_pairwise","CCMP");
			ap_docmd("SET rsn_pairwise","CCMP");
			ap_docmd("SET wpa_passphrase",para->password);
			ap_docmd("SET sae_pwe","2");
		} else if (!strcmp(para->auth_mode, "WPA2WPA3")) {
			ap_docmd("SET wpa","2");
			ap_docmd("SET ieee80211w","1");
			ap_docmd("SET wpa_key_mgmt","SAE WPA-PSK");
			ap_docmd("SET wpa_pairwise","CCMP");
			ap_docmd("SET rsn_pairwise","CCMP");
			ap_docmd("SET wpa_passphrase",para->password);
			ap_docmd("SET sae_pwe","2");
		} else if (!strcmp(para->auth_mode, "OPEN")) {
			ap_docmd("SET wpa","0");
		}
	}
		
	if( flags & ZTE_WLAN_MAX_ACCESS_NUM_SET){
		ap_docmd("SET max_num_sta", para->max_num_sta);		
		sc_cfg_get("MAX_Access_num_bbak", max_Access_num_bbak, sizeof(max_Access_num_bbak));
		if(strlen(max_Access_num_bbak) != 0 && strcmp(max_Access_num_bbak,"0")){
			sc_cfg_set("MAX_Access_num_bbak","0");
		}
	}

	if( flags & ZTE_WLAN_CHANNEL_SET) {
		ap_docmd("SET channel", para->Channel);
	}

	if( flags & ZTE_WLAN_COUNTRY_SET)
		ap_docmd("SET country_code", para->CountryCode);


	if( flags & ZTE_WLAN_WIRELESS_MODE_SET)
		wlan_80211Mode_config(para->WirelessMode);
	
	if( flags & ZTE_WLAN_POWER_SET) {
#if defined(__AIC_8800DW_CHIP__)
		wlan_set_wifiConverage_aic(ap_svr->drv_proxy.iface_name, para->wifi_coverage);
		wf_log("ZTE_WLAN_POWER_SET:%08x", flags);
		return;
#else
		wlan_set_wifiConverage(para->wifi_coverage);
#endif
	}

	if( flags & ZTE_WLAN_WIRELESS_MODE_SET)
		wlan_set_ht(para->wifi_11n_cap);


	//ap_docmd("RELOAD", NULL);
	ap_docmd("DISABLE", NULL);
	ap_docmd("ENABLE", NULL);
	wlan_set_txpwr();
}


int  wlan_ap_save_config(struct wlan_ap_server  *ap_svr) 
{
    int ret = 0;
    int i = 0;
    int fd;
    char *wbuf = NULL;
    char *fbuf = NULL;
	char *sbuf = NULL;
	char *sbuf2 = NULL;
    struct  wlan_ap_para*  para = &ap_svr->ap_para;

	char wifi_mac[64] = {0};
	char m_read_mac[32] = {0};
	char m_ssid_enable[8] = {0};
	sc_cfg_get ("wifi_mac", wifi_mac, sizeof(wifi_mac));
	str_remove_chr(wifi_mac, ':');	

	//acs_num_scans
	char acs_num[8] = {0};
	sc_cfg_get ("wifi_acs_num", acs_num, sizeof(acs_num));
	
#if (defined(__SSV_6X5X_CHIP__) || defined(__AIC_8800DW_CHIP__))
	//40M
	char f_40M[8] = {0};
	sc_cfg_get ("wifi_force_40m", f_40M, sizeof(f_40M));

	//WirelessMode 80211n support 40M
	char w11n_ht_cap[64] = {0};
	if (0 == strcmp(para->wifi_11n_cap, "1")) {
		strncpy(w11n_ht_cap, HT_CAPAB_40, sizeof(w11n_ht_cap)-1);
	} else {
		strncpy(w11n_ht_cap, HT_CAPAB_20, sizeof(w11n_ht_cap)-1);
		//strncpy(f_40M, "0", sizeof(f_40M) - 1);
	}
#endif
	sc_cfg_get ("m_ssid_enable", m_ssid_enable, sizeof (m_ssid_enable));	

    asprintf(&wbuf, "interface=wlan0\n"
    		"driver=nl80211\n"
    		"bridge=br0\n"
    		"ctrl_interface=/etc_rw/wifi/hostapd\n"    		
    		"logger_syslog= 8\n"
    		"logger_syslog_level=2\n"
    		"logger_stdout=8\n"
    		"logger_stdout_level=2\n"    		
    		"ssid=%s\n"
    		"ignore_broadcast_ssid=%s\n"
   		
    		"channel=%s\n"
    		"acs_num_scans=%s\n"

#if defined(__AIC_8800DW_CHIP__)
			"ieee80211ac=1\n"
			"ieee80211ax=1\n"
			"dtim_period=1\n"
			//"ht_capab=[LDPC][SHORT-GI-20]\n"
			//"ht_capab=[LDPC][HT40+][HT40-][SHORT-GI-20][SHORT-GI-40]\n"
			//"vht_capab=[MAX-A-MPDU-LEN-EXP7][RXLDPC]\n"
			//"ap_max_inactivity=10\n"
			
			//TX MCS11
			"he_basic_mcs_nss_set=65534\n"
#endif

#if (defined(__SSV_6X5X_CHIP__) || defined(__AIC_8800DW_CHIP__))
    		"ht_capab=%s\n"
			"force_40mhz=%s\n"
#endif
    		"chanlist=6-13\n"
    		
    		"ieee80211n=1\n"
    		"hw_mode=g\n"
    		"ieee80211d=1\n"
    		"local_pwr_constraint=200\n"
    		"wowlan_triggers=any\n"
		
    		"country_code=%s\n"
     		"max_num_sta=%s\n"
     		"macaddr_acl=%d\n"
    		"accept_mac_file=/etc_rw/wifi/hostapd.accept\n"
    		"deny_mac_file=/etc_rw/wifi/hostapd.deny\n"
#if defined(__AIC_8800DW_CHIP__)
			//nangui use default
			"ap_max_inactivity=10\n"
#endif
#if defined(__SSV_6X5X_CHIP__)
			//nangui
			"skip_inactivity_poll=1\n"
#endif
    		"wps_state=2\n"
    		"eap_server=1\n"
    		"ap_setup_locked=1\n"
    		"wps_pin_requests=/etc_rw/wifi/hostapd_wps_pin_requests\n"
    		"manufacturer=zxic\n"
    		"model_name=MF922\n"
    		"model_number=7520V3WLAN\n"
    		"serial_number=%s\n"
    		"device_type=6-0050F204-1\n"
    		"os_version=01020300\n"
    		"config_methods=virtual_push_button\n",
    		para->ssid, para->ignore_broadcast_ssid,
    		para->Channel, acs_num, 
#if (defined(__SSV_6X5X_CHIP__) || defined(__AIC_8800DW_CHIP__))
    		w11n_ht_cap, f_40M,
#endif
    		para->CountryCode,   para->max_num_sta, 
    		acl_mode_value_transist(para->accesspolicy0), wifi_mac+6);

    if (!strcmp (para->auth_mode, "WPAPSKWPA2PSK") || !strcmp (para->auth_mode, "WPA-PSK/WPA2-PSK")) {
        asprintf(&fbuf, "%swpa=3\nwpa_key_mgmt=WPA-PSK\nwpa_pairwise=TKIP CCMP\nrsn_pairwise=TKIP CCMP\nwpa_passphrase=%s\nwpa_group_rekey=3600\n", wbuf, para->password);
    } else if (!strcmp(para->auth_mode, "WPA2PSK")) {
        asprintf(&fbuf, "%swpa=2\nwpa_key_mgmt=WPA-PSK\nwpa_pairwise=TKIP\nrsn_pairwise=CCMP\nwpa_passphrase=%s\nwpa_group_rekey=3600\n", wbuf, para->password);
    } else if (!strcmp(para->auth_mode, "WPA3Personal")) {
        asprintf(&fbuf, "%swpa=2\nwpa_key_mgmt=SAE\nwpa_pairwise=CCMP\nrsn_pairwise=CCMP\nieee80211w=2\nwpa_passphrase=%s\nwpa_group_rekey=3600\nsae_pwe=2\n", wbuf, para->password);
    } else if (!strcmp(para->auth_mode, "WPA2WPA3")) {
        asprintf(&fbuf, "%swpa=2\nwpa_key_mgmt=SAE WPA-PSK\nwpa_pairwise=CCMP\nrsn_pairwise=CCMP\nieee80211w=1\nwpa_passphrase=%s\nwpa_group_rekey=3600\nsae_pwe=2\n", wbuf, para->password);
    } else if (!strcmp(para->auth_mode, "OPEN")) {
        asprintf(&fbuf, "%swpa=0\n", wbuf);
    } else {//kw
        wf_log("Unsupport auth_mode: %s", para->auth_mode);
        free(wbuf);
        return -1;
    }
	
	if (strcmp (m_ssid_enable, "1") == 0) {	
		sc_cfg_get ("m_wifi_mac", m_read_mac, sizeof (m_read_mac));
		sc_cfg_get ("m_wifi_mac", wifi_mac, sizeof (wifi_mac));
		str_remove_chr(wifi_mac, ':');	
		wf_log("asprintf sbuf m_read_mac : %s,wifi_mac : %s wifi_mac+6 : %s",m_read_mac,wifi_mac,wifi_mac+6);
		asprintf(&sbuf, "%sbss=wlan0-va1\n"
			"bssid=%s\n"
			"ssid=%s\n"
			"ignore_broadcast_ssid=%s\n"
			"max_num_sta=%s\n"
			"bridge=br0\n"
			"ctrl_interface=/etc_rw/wifi/hostapd\n"
			"dtim_period=1\n"
			"wowlan_triggers=any\n"
			"macaddr_acl=%d\n"
    		"accept_mac_file=/etc_rw/wifi/hostapd.accept\n"
    		"deny_mac_file=/etc_rw/wifi/hostapd.deny\n"
#if defined(__AIC_8800DW_CHIP__)
			"ap_max_inactivity=10\n"
#endif
#if defined(__SSV_6X5X_CHIP__)
			"skip_inactivity_poll=1\n"
#endif
			"wps_state=2\n"
    		"eap_server=1\n"
    		"ap_setup_locked=1\n"
    		"wps_pin_requests=/etc_rw/wifi/hostapd_wps_pin_requests_2\n"
    		"manufacturer=zxic_2\n"
    		"model_name=MF922_2\n"
    		"model_number=7520V3WLAN_2\n"
    		"serial_number=%s\n"
    		"device_type=6-0050F204-1_2\n"
    		"os_version=01020300_2\n"
    		"config_methods=virtual_push_button\n", 
			fbuf,m_read_mac, para->m_ssid, para->m_ignore_broadcast_ssid, 
			para->m_max_num_sta,acl_mode_value_transist(para->accesspolicy0),wifi_mac+6);
		
		if (!strcmp (para->m_auth_mode, "WPAPSKWPA2PSK") || !strcmp (para->m_auth_mode, "WPA-PSK/WPA2-PSK")) {
			asprintf(&sbuf2, "%swpa=3\nwpa_key_mgmt=WPA-PSK\nwpa_pairwise=TKIP CCMP\nrsn_pairwise=TKIP CCMP\nwpa_passphrase=%s\nwpa_group_rekey=3600\n", sbuf, para->m_password);
		} else if (!strcmp(para->m_auth_mode, "WPA2PSK")) {
			asprintf(&sbuf2, "%swpa=2\nwpa_key_mgmt=WPA-PSK\nwpa_pairwise=TKIP\nrsn_pairwise=CCMP\nwpa_passphrase=%s\nwpa_group_rekey=3600\n", sbuf, para->m_password);
		} else if (!strcmp(para->m_auth_mode, "WPA3Personal")) {
			asprintf(&sbuf2, "%swpa=2\nwpa_key_mgmt=SAE\nwpa_pairwise=CCMP\nrsn_pairwise=CCMP\nieee80211w=2\nwpa_passphrase=%s\nwpa_group_rekey=3600\nsae_pwe=2\n", sbuf, para->m_password);
		} else if (!strcmp(para->m_auth_mode, "WPA2WPA3")) {
			asprintf(&sbuf2, "%swpa=2\nwpa_key_mgmt=SAE WPA-PSK\nwpa_pairwise=CCMP\nrsn_pairwise=CCMP\nieee80211w=1\nwpa_passphrase=%s\nwpa_group_rekey=3600\nsae_pwe=2\n", sbuf, para->m_password);
		} else if (!strcmp(para->m_auth_mode, "OPEN")) {
			asprintf(&sbuf2, "%swpa=0\n", sbuf);
		} else {//kw
			wf_log("Unsupport m_auth_mode: %s", para->m_auth_mode);
			free(wbuf);
			free(fbuf);
			free(sbuf);
			return -1;
		}	

	}

    generate_acl_list_file(para->accesspolicy0);

    fd = open(HOSTAPD_CONF_FILE, O_CREAT | O_TRUNC | O_WRONLY, 0660);
    if (fd < 0) {
        wf_log("Cannot update \"%s\": %s", HOSTAPD_CONF_FILE, strerror(errno));
        return -1;
    }
	if(strcmp (m_ssid_enable, "1") == 0){
		if (write(fd, sbuf2, strlen(sbuf2)) < 0) {
	        wf_log("Cannot write to \"%s\": %s", HOSTAPD_CONF_FILE, strerror(errno));
	        ret = -1;
    	}
		free(sbuf);
		free(sbuf2);
	}else{
	    if (write(fd, fbuf, strlen(fbuf)) < 0) {
	        wf_log("Cannot write to \"%s\": %s", HOSTAPD_CONF_FILE, strerror(errno));
	        ret = -1;
	    }
	}
	free(wbuf);
	free(fbuf);
    /* Note: apparently open can fail to set permissions correctly at times */
    if (fchmod(fd, 0660) < 0) {
        wf_log("Error changing permissions of %s to 0660: %s",
                HOSTAPD_CONF_FILE, strerror(errno));
        close(fd);
        unlink(HOSTAPD_CONF_FILE);
        return -1;
    }
	
    close(fd);
    return ret;
}

#ifdef USE_CAP_SUPPORT
void wlan_ap_get_para_5g(struct wlan_ap_server *ap_svr)
{
	struct  wlan_ap_para *  para = &ap_svr->ap_para;
	
	sc_cfg_get ("wifi_set_flags", para->wifi_set_flags, NVIO_WIFI_LEN_8-1);
	sc_cfg_get ("SSID1_5g", para->ssid, WIFI_STATION_SSID_LEN-1);
	sc_cfg_get ("HideSSID_5g", para->ignore_broadcast_ssid, NVIO_WIFI_LEN_8-1);
	sc_cfg_get ("AuthMode_5g", para->auth_mode, WIFI_STATION_AUTH_MODE_LEN-1);
	sc_cfg_get ("WPAPSK1_5g", para->password, WIFI_STATION_SPOT_PASSWORD_LEN-1);
	sc_cfg_get ("wifi_11n_cap_5g", para->wifi_11n_cap, NVIO_WIFI_LEN_8-1);//bandwhidh
	//sc_cfg_get ("wifi_band_5g", para->wifi_band, NVIO_WIFI_LEN_8-1);
	sc_cfg_get ("WirelessMode_5g", para->WirelessMode, NVIO_WIFI_LEN_8-1);
	sc_cfg_get ("Channel_5g", para->Channel, NVIO_WIFI_LEN_8-1);
	
	sc_cfg_get ("CountryCode_5g", para->CountryCode, NVIO_WIFI_LEN_8-1);
	if (0 == strcmp(para->CountryCode, "NONE")) {
		strcpy(para->CountryCode, "00");
	}
	
	sc_cfg_get ("wifi_coverage", para->wifi_coverage, NVIO_WIFI_LEN_16-1);
	sc_cfg_get ("MAX_Access_num_5g", para->max_num_sta, NVIO_WIFI_LEN_8-1);
	sc_cfg_get ("ACL_mode_5g", para->accesspolicy0, NVIO_WIFI_LEN_8-1);

	wf_log("5G SSID1=%s HideSSID=%s, AuthMode=%s, WPAPSK1=%s, wifi_11n_cap=%s, \n"
		"wifi_band=%s, WirelessMode=%s, Channel=%s, CountryCode=%s, wifi_coverage=%s, MAX_Access_num=%s, AccessPolicy0=%s\n", 
		para->ssid, para->ignore_broadcast_ssid, para->auth_mode, para->password, para->wifi_11n_cap, 
		para->wifi_band, para->WirelessMode,para->Channel, para->CountryCode, para->wifi_coverage, para->max_num_sta,para->accesspolicy0);

	sc_cfg_set("tmp_channel", para->Channel);

	char m_ssid_enable[8] = {0};
	sc_cfg_get ("m_ssid_enable", m_ssid_enable, sizeof (m_ssid_enable));	
	if(strcmp (m_ssid_enable, "1") == 0){	//v3v not use
		sc_cfg_get ("m_SSID_5g", para->m_ssid, WIFI_STATION_SSID_LEN-1);
		sc_cfg_get ("m_HideSSID_5g", para->m_ignore_broadcast_ssid, NVIO_WIFI_LEN_8-1);
		sc_cfg_get ("m_AuthMode_5g", para->m_auth_mode, WIFI_STATION_AUTH_MODE_LEN-1);
		sc_cfg_get ("m_WPAPSK1_5g", para->m_password, WIFI_STATION_SPOT_PASSWORD_LEN-1);
		sc_cfg_get ("m_MAX_Access_num_5g", para->m_max_num_sta, NVIO_WIFI_LEN_8-1);
		wf_log("5G m_SSID=%s m_HideSSID=%s, m_AuthMode=%s, m_password=%s,MAX_Station_num:%s m_MAX_Access_num=%s\n", 
		para->m_ssid, para->m_ignore_broadcast_ssid, para->m_auth_mode, para->m_password,para->max_num_sta, para->m_max_num_sta);
	}	

}

static int get_centr_freq_seg0_idx(int band, int chan)
{
	int center_segment0 = 0;
	
	if (band == 160) {//20/40/80/160
		if (chan >= 36 && chan <= 64) {
			center_segment0 = 50;
		}
		else if (chan >= 100 && chan <= 128) {
			center_segment0 = 114;
		}
		else {
			center_segment0 = 0;
		}
		
	}
	else if (band == 80) {//20/40/80
		//center_segment0 = 0;
		if (chan >= 36 && chan <= 48) {
			center_segment0 = 42;
		}
		else if (chan >= 52 && chan <= 64) {
			center_segment0 = 58;
		}
		else if (chan >= 100 && chan <= 112) {
			center_segment0 = 106;
		}
		else if (chan >= 116 && chan <= 128) {
			center_segment0 = 122;
		}
		else if (chan >= 132 && chan <= 144) {
			center_segment0 = 138;
		}
		else if (chan >= 149 && chan <= 161) {
			center_segment0 = 155;
		}
		else {
			center_segment0 = 0;
		}
	}
	else if (band == 40) {//20/40
		center_segment0 = 0;
	}
	else {
		center_segment0 = 0;;
	}

	return center_segment0;
}

static void wlan_80211Mode_config_5g(char *wirelessMode)
{
	if (!strcmp(wirelessMode, "4")) {//11a/n mixed mode
		ap_docmd("SET hw_mode a", NULL);
		ap_docmd("SET ieee80211n 1", NULL);
		ap_docmd("SET ieee80211ac 0", NULL);
		ap_docmd("SET ieee80211ax 0", NULL);
	}
	else if (!strcmp(wirelessMode, "5")) {//11a/an/ac
		ap_docmd("SET hw_mode a", NULL);
		ap_docmd("SET ieee80211n 1", NULL);
		ap_docmd("SET ieee80211ac 1", NULL);
		ap_docmd("SET ieee80211ax 0", NULL);
	}	
	else if (!strcmp(wirelessMode, "6")) {//11a/an/ac/ax
		ap_docmd("SET hw_mode a", NULL);
		ap_docmd("SET ieee80211n 1", NULL);
		ap_docmd("SET ieee80211ac 1", NULL);
		ap_docmd("SET ieee80211ax 1", NULL);
		
	}	
	else {
		ap_docmd("SET hw_mode a", NULL);
		ap_docmd("SET ieee80211n 1", NULL);
		wf_log("wirelessMode=%s not support", wirelessMode);
	}

}
static void wlan_set_ht_5g(char *htMode)
{
	if (!strcmp(htMode, "6")) {//20/40/80/160
		ap_docmd("SET he_oper_chwidth", "2");
		ap_docmd("SET vht_oper_chwidth", "2");
		ap_docmd("SET ht_capab", VHT_CAPAB_40);
		ap_docmd("SET vht_capab", VHT_CAPAB_160);
	}
	else if (!strcmp(htMode, "4")) {//20/40/80
		ap_docmd("SET he_oper_chwidth", "1");
		ap_docmd("SET vht_oper_chwidth", "1");
		ap_docmd("SET ht_capab", VHT_CAPAB_40);
		ap_docmd("SET vht_capab", VHT_CAPAB_80);
	}
	else if (!strcmp(htMode, "1")) {//20/40
		ap_docmd("SET he_oper_chwidth", "0");
		ap_docmd("SET vht_oper_chwidth", "0");
		ap_docmd("SET ht_capab", VHT_CAPAB_40);
	}
	else { //0
		//defualt use 20M
		ap_docmd("SET ht_capab", HT_CAPAB_20);
		ap_docmd("SET vht_oper_chwidth", "0");
	}

}
static void wlan_set_channel_5g(char *channel, char *htMode)
{
	char idx0[8] = {0};
	int idx0_i = 0;
	
	if (!strcmp(htMode, "6")) {//20/40/80/160
		idx0_i = get_centr_freq_seg0_idx(160, atoi(channel));
	}
	else if (!strcmp(htMode, "4")) {//20/40/80
		idx0_i = get_centr_freq_seg0_idx(80, atoi(channel));
	}
	else if (!strcmp(htMode, "1")) {//20/40
		idx0_i = get_centr_freq_seg0_idx(40, atoi(channel));
	}
	else {
		idx0_i = get_centr_freq_seg0_idx(20, atoi(channel));
	}

	snprintf(idx0, sizeof(idx0), "%d", idx0_i);
	//when channel=0, can't be set at runtime, idx has a value(channel id)?
	ap_docmd("SET vht_oper_centr_freq_seg0_idx", idx0);
	ap_docmd("SET he_oper_centr_freq_seg0_idx", idx0);
	//80+80
	//ap_docmd_5g("SET vht_oper_centr_freq_seg1_idx", "0");
	//ap_docmd_5g("SET he_oper_centr_freq_seg1_idx", "0");
	
	if (0 == strcmp(channel, "165") && 0 != strcmp(htMode, "0")) {
		ap_docmd("SET ht_capab", HT_CAPAB_20);
		ap_docmd("SET he_oper_chwidth", "0");
		ap_docmd("SET vht_oper_chwidth", "0");
	}
	ap_docmd("SET channel", channel);
}
static void wlan_advance_set_5g(struct wlan_ap_para *para)
{

	wlan_80211Mode_config_5g(para->WirelessMode); // an wang kou ge li
	wlan_set_ht_5g(para->wifi_11n_cap);
	wlan_set_channel_5g(para->Channel, para->wifi_11n_cap);

}

void wifi_config_ap_5g(struct wlan_ap_server *ap_svr)
{
	struct  wlan_ap_para*  para = &ap_svr->ap_para;
	char max_Access_num_bbak[16]={0};

	unsigned int flags = 0;
	flags = atoi(para->wifi_set_flags);
	wf_log("wifi_set_flags=0x%x", flags);

	if( 0 == flags ){
		//quick_setupû
		flags = ZTE_WLAN_SSID_SET|ZTE_WLAN_BROADCAST_SET|ZTE_WLAN_BASIC_SECURITY_SET;
	}
	
	if( flags & ZTE_WLAN_SSID_SET){
		ap_docmd("SET ssid", para->ssid);
//		hostapd_conf_change_para("ssid", para->ssid);
	}
	if( flags & ZTE_WLAN_BROADCAST_SET){
		ap_docmd("SET ignore_broadcast_ssid", para->ignore_broadcast_ssid);
//		hostapd_conf_change_para("ssid", para->ssid);
		ap_docmd("SET wps_state", "2");
	}
	if( flags & ZTE_WLAN_BASIC_SECURITY_SET){
		if (!strcmp (para->auth_mode, "WPAPSKWPA2PSK") || !strcmp (para->auth_mode, "WPA-PSK/WPA2-PSK")) {
			ap_docmd("SET wpa","3");
			ap_docmd("SET ieee80211w","0");
			ap_docmd("SET wpa_key_mgmt","WPA-PSK");
			ap_docmd("SET wpa_pairwise","TKIP CCMP");
			ap_docmd("SET rsn_pairwise","TKIP CCMP");
			ap_docmd("SET wpa_passphrase",para->password);
		} else if (!strcmp(para->auth_mode, "WPA2PSK")) {
			ap_docmd("SET wpa","2");
			ap_docmd("SET ieee80211w","0");
			ap_docmd("SET wpa_key_mgmt","WPA-PSK");
			ap_docmd("SET wpa_pairwise","TKIP");
			ap_docmd("SET rsn_pairwise","CCMP");
			ap_docmd("SET wpa_passphrase",para->password);
		} else if (!strcmp(para->auth_mode, "WPA3Personal")) {
			ap_docmd("SET wpa","2");
			ap_docmd("SET ieee80211w","2");
			ap_docmd("SET wpa_key_mgmt","SAE");
			ap_docmd("SET wpa_pairwise","CCMP");
			ap_docmd("SET rsn_pairwise","CCMP");
			ap_docmd("SET wpa_passphrase",para->password);
			ap_docmd("SET sae_pwe","2");
		} else if (!strcmp(para->auth_mode, "WPA2WPA3")) {
			ap_docmd("SET wpa","2");
			ap_docmd("SET ieee80211w","1");
			ap_docmd("SET wpa_key_mgmt","SAE WPA-PSK");
			ap_docmd("SET wpa_pairwise","CCMP");
			ap_docmd("SET rsn_pairwise","CCMP");
			ap_docmd("SET wpa_passphrase",para->password);
			ap_docmd("SET sae_pwe","2");
		} else if (!strcmp(para->auth_mode, "OPEN")) {
			ap_docmd("SET wpa","0");
		}
	}
		
	if( flags & ZTE_WLAN_MAX_ACCESS_NUM_SET){
		ap_docmd("SET max_num_sta", para->max_num_sta);		
		sc_cfg_get("MAX_Access_num_bbak", max_Access_num_bbak, sizeof(max_Access_num_bbak));
		if(strlen(max_Access_num_bbak) != 0 && strcmp(max_Access_num_bbak,"0")){
			sc_cfg_set("MAX_Access_num_bbak","0");
		}
	}

	if ((flags & ZTE_WLAN_COUNTRY_SET) || (flags & ZTE_WLAN_CHANNEL_SET) || (flags & ZTE_WLAN_WIRELESS_MODE_SET)) {
		ap_docmd("SET country_code", para->CountryCode);
		wlan_advance_set_5g(para);
	}
	
	if( flags & ZTE_WLAN_POWER_SET) {
#if defined(__AIC_8800DW_CHIP__)
		wlan_set_wifiConverage_aic(ap_svr->drv_proxy.iface_name, para->wifi_coverage);
		wf_log("ZTE_WLAN_POWER_SET:%08x", flags);
		return;
#else
		wlan_set_wifiConverage(para->wifi_coverage);
#endif
	}

	//ap_docmd("RELOAD", NULL);
	ap_docmd("DISABLE", NULL);
	ap_docmd("ENABLE", NULL);
	wlan_set_txpwr();
}

static void wlan_get_ht_5g(struct wlan_ap_para *para, char *ht_conf, int ht_len)
{
	char ieee_mode[64] = {0};
	char ht_cap[172] = {0};
	int idx0 = 0;

	if (!strcmp(para->WirelessMode, "4")) {//11a/n mixed mode
		snprintf(ieee_mode, sizeof(ieee_mode), "ieee80211n=1\n");
	}
	else if (!strcmp(para->WirelessMode, "5")) {//11a/an/ac
		snprintf(ieee_mode, sizeof(ieee_mode), "ieee80211n=1\nieee80211ac=1\n");
	}	
	else if (!strcmp(para->WirelessMode, "6")) {//11a/an/ac/ax
		snprintf(ieee_mode, sizeof(ieee_mode), "ieee80211n=1\nieee80211ac=1\nieee80211ax=1\n");
	}	
	else {
		snprintf(ieee_mode, sizeof(ieee_mode), "ieee80211n=1\n");
	}

	if (0 == strcmp(para->wifi_11n_cap, "6")) {
		snprintf(ht_cap, sizeof(ht_cap), "ht_capab=%s\nvht_capab=%s\nhe_oper_chwidth=2\nvht_oper_chwidth=2\n",
			VHT_CAPAB_40, VHT_CAPAB_160);
		idx0 = get_centr_freq_seg0_idx(160, atoi(para->Channel));
	}
	else if (0 == strcmp(para->wifi_11n_cap, "4")) {
		snprintf(ht_cap, sizeof(ht_cap), "ht_capab=%s\nvht_capab=%s\nhe_oper_chwidth=1\nvht_oper_chwidth=1\n",
			VHT_CAPAB_40, VHT_CAPAB_80);
		idx0 = get_centr_freq_seg0_idx(80, atoi(para->Channel));
	}
	else if (0 == strcmp(para->wifi_11n_cap, "1")) {
		snprintf(ht_cap, sizeof(ht_cap), "ht_capab=%s\nhe_oper_chwidth=0\nvht_oper_chwidth=0\n",
			VHT_CAPAB_40);
		idx0 = get_centr_freq_seg0_idx(40, atoi(para->Channel));
	}
	else {
		snprintf(ht_cap, sizeof(ht_cap), "ht_capab=%s\nhe_oper_chwidth=0\nvht_oper_chwidth=0\n",
			HT_CAPAB_20);
		idx0 = get_centr_freq_seg0_idx(20, atoi(para->Channel));
	}
#if 1
	//channel 149~161, if 160M, to 80M
	//ch 165, to 20M
	//country code BZ\BO, not support 160M, to 80M
	if (0 != strcmp(para->wifi_11n_cap, "0") && 0 == strcmp(para->Channel, "165")) {//error: please set correct channel\bandwith
		snprintf(ht_cap, sizeof(ht_cap), "ht_capab=%s\nhe_oper_chwidth=0\nvht_oper_chwidth=0\n",
			HT_CAPAB_20);
		idx0 = get_centr_freq_seg0_idx(20, atoi(para->Channel));
		wf_log("error: please set correct channel(%s)-bandwith(%s) nv!!", para->Channel, para->wifi_11n_cap);
	}
	else if ((0 == strcmp(para->wifi_11n_cap, "6")) && 
		(0 == strcmp(para->Channel, "149") || 0 == strcmp(para->Channel, "153") ||
		0 == strcmp(para->Channel, "157") || 0 == strcmp(para->Channel, "161"))) {
		snprintf(ht_cap, sizeof(ht_cap), "ht_capab=%s\nvht_capab=%s\nhe_oper_chwidth=1\nvht_oper_chwidth=1\n",
			VHT_CAPAB_40, VHT_CAPAB_80);
		idx0 = get_centr_freq_seg0_idx(80, atoi(para->Channel));
		wf_log("error: please set correct channel(%s)-bandwith(%s) nv!!", para->Channel, para->wifi_11n_cap);
	}
	else if ((0 == strcmp(para->wifi_11n_cap, "6")) && (0 == strcmp(para->Channel, "0"))
		&& (0 == strcmp(para->CountryCode, "BZ") || 0 == strcmp(para->CountryCode, "HN") ||
		0 == strcmp(para->CountryCode, "PK") || 0 == strcmp(para->CountryCode, "BD") ||
		0 == strcmp(para->CountryCode, "BO") || 0 == strcmp(para->CountryCode, "JO") ||
		0 == strcmp(para->CountryCode, "KE"))) {
		snprintf(ht_cap, sizeof(ht_cap), "ht_capab=%s\nvht_capab=%s\nhe_oper_chwidth=1\nvht_oper_chwidth=1\n",
			VHT_CAPAB_40, VHT_CAPAB_80);
		idx0 = get_centr_freq_seg0_idx(80, atoi(para->Channel));
		wf_log("error: please set correct countrycode(%s)-bandwith(%s) nv!!", para->CountryCode, para->wifi_11n_cap);
	}
#endif
	//no 80+80
	//"vht_oper_centr_freq_seg1_idx=0\n" //ac
	//"he_oper_centr_freq_seg1_idx=0\n" //ax

	snprintf(ht_conf, ht_len, "%s%svht_oper_centr_freq_seg0_idx=%d\nhe_oper_centr_freq_seg0_idx=%d\n", 
		ieee_mode, ht_cap, idx0, idx0);

}

int wlan_ap_save_config_5g(struct wlan_ap_server *ap_svr) 
{
	int ret = 0;
	int i = 0;
	int fd;
	char *wbuf = NULL;
	char *fbuf = NULL;
	char *sbuf = NULL;
	char *sbuf2 = NULL;
	struct	wlan_ap_para*  para = &ap_svr->ap_para;

	char wifi_mac[64] = {0};
	char m_read_mac[32] = {0};
	char m_ssid_enable[8] = {0};
	sc_cfg_get ("wifi_mac", wifi_mac, sizeof(wifi_mac));
	str_remove_chr(wifi_mac, ':');	

	//acs_num_scans
	char acs_num[8] = {0};
	sc_cfg_get ("wifi_acs_num", acs_num, sizeof(acs_num));
	
	char w11n_ht_cap[256] = {0};
	wlan_get_ht_5g(para, w11n_ht_cap, sizeof(w11n_ht_cap));

	sc_cfg_get ("m_ssid_enable", m_ssid_enable, sizeof (m_ssid_enable));	

	asprintf(&wbuf, "interface=wlan0\n"
			"driver=nl80211\n"
			"bridge=br0\n"
			"ctrl_interface=/etc_rw/wifi/hostapd\n" 		
			"logger_syslog= 8\n"
			"logger_syslog_level=2\n"
			"logger_stdout=8\n"
			"logger_stdout_level=2\n"			
			"ssid=%s\n"
			"ignore_broadcast_ssid=%s\n"
		
			"channel=%s\n"
			"acs_num_scans=%s\n"

			//"ieee80211ac=1\n"
			//"ieee80211ax=1\n"
			"dtim_period=1\n"
			
			//TX MCS11
			"he_basic_mcs_nss_set=65534\n"
			
			"wmm_enabled=1\n"

			"require_ht=0\n"
			"require_vht=0\n"
			"%s"
			
			//"ieee80211n=1\n"
			"hw_mode=a\n"
			"ieee80211d=1\n"
			"wowlan_triggers=any\n"
		
			"country_code=%s\n"
			"max_num_sta=%s\n"
			"macaddr_acl=%d\n"
			"accept_mac_file=/etc_rw/wifi/hostapd.accept\n"
			"deny_mac_file=/etc_rw/wifi/hostapd.deny\n"

			"ap_max_inactivity=10\n"

			"wps_state=2\n"
			"eap_server=1\n"
			"ap_setup_locked=1\n"
			"wps_pin_requests=/etc_rw/wifi/hostapd_wps_pin_requests\n"
			"manufacturer=zxic\n"
			"model_name=MF922\n"
			"model_number=7520V3WLAN\n"
			"serial_number=%s\n"
			"device_type=6-0050F204-1\n"
			"os_version=01020300\n"
			"config_methods=virtual_push_button\n",
			para->ssid, para->ignore_broadcast_ssid,
			para->Channel, acs_num, 

			w11n_ht_cap,

			para->CountryCode,	 para->max_num_sta, 
			acl_mode_value_transist(para->accesspolicy0), wifi_mac+6);

	if (!strcmp (para->auth_mode, "WPAPSKWPA2PSK") || !strcmp (para->auth_mode, "WPA-PSK/WPA2-PSK")) {
		asprintf(&fbuf, "%swpa=3\nwpa_key_mgmt=WPA-PSK\nwpa_pairwise=TKIP CCMP\nrsn_pairwise=TKIP CCMP\nwpa_passphrase=%s\nwpa_group_rekey=3600\n", wbuf, para->password);
	} else if (!strcmp(para->auth_mode, "WPA2PSK")) {
		asprintf(&fbuf, "%swpa=2\nwpa_key_mgmt=WPA-PSK\nwpa_pairwise=TKIP\nrsn_pairwise=CCMP\nwpa_passphrase=%s\nwpa_group_rekey=3600\n", wbuf, para->password);
	} else if (!strcmp(para->auth_mode, "WPA3Personal")) {
		asprintf(&fbuf, "%swpa=2\nwpa_key_mgmt=SAE\nwpa_pairwise=CCMP\nrsn_pairwise=CCMP\nieee80211w=2\nwpa_passphrase=%s\nwpa_group_rekey=3600\nsae_pwe=2\n", wbuf, para->password);
	} else if (!strcmp(para->auth_mode, "WPA2WPA3")) {
		asprintf(&fbuf, "%swpa=2\nwpa_key_mgmt=SAE WPA-PSK\nwpa_pairwise=CCMP\nrsn_pairwise=CCMP\nieee80211w=1\nwpa_passphrase=%s\nwpa_group_rekey=3600\nsae_pwe=2\n", wbuf, para->password);
	} else if (!strcmp(para->auth_mode, "OPEN")) {
		asprintf(&fbuf, "%swpa=0\n", wbuf);
	} else {//kw
		wf_log("Unsupport auth_mode: %s", para->auth_mode);
		free(wbuf);
		return -1;
	}
	
	if (strcmp (m_ssid_enable, "1") == 0) { 
		sc_cfg_get ("m_wifi_mac", m_read_mac, sizeof (m_read_mac));
		sc_cfg_get ("m_wifi_mac", wifi_mac, sizeof (wifi_mac));
		str_remove_chr(wifi_mac, ':');	
		wf_log("asprintf sbuf m_read_mac : %s,wifi_mac : %s wifi_mac+6 : %s",m_read_mac,wifi_mac,wifi_mac+6);
		asprintf(&sbuf, "%sbss=wlan0-va1\n"
			"bssid=%s\n"
			"ssid=%s\n"
			"ignore_broadcast_ssid=%s\n"
			"max_num_sta=%s\n"
			"bridge=br0\n"
			"ctrl_interface=/etc_rw/wifi/hostapd\n"
			"dtim_period=1\n"
			"wmm_enabled=1\n"
			"wowlan_triggers=any\n"
			"macaddr_acl=%d\n"
			"accept_mac_file=/etc_rw/wifi/hostapd.accept\n"
			"deny_mac_file=/etc_rw/wifi/hostapd.deny\n"
			
			"ap_max_inactivity=10\n"

			"wps_state=2\n"
			"eap_server=1\n"
			"ap_setup_locked=1\n"
			"wps_pin_requests=/etc_rw/wifi/hostapd_wps_pin_requests_2\n"
			"manufacturer=zxic_2\n"
			"model_name=MF922_2\n"
			"model_number=7520V3WLAN_2\n"
			"serial_number=%s\n"
			"device_type=6-0050F204-1_2\n"
			"os_version=01020300_2\n"
			"config_methods=virtual_push_button\n", 
			fbuf,m_read_mac, para->m_ssid, para->m_ignore_broadcast_ssid, 
			para->m_max_num_sta,acl_mode_value_transist(para->accesspolicy0),wifi_mac+6);
		
		if (!strcmp (para->m_auth_mode, "WPAPSKWPA2PSK") || !strcmp (para->m_auth_mode, "WPA-PSK/WPA2-PSK")) {
			asprintf(&sbuf2, "%swpa=3\nwpa_key_mgmt=WPA-PSK\nwpa_pairwise=TKIP CCMP\nrsn_pairwise=TKIP CCMP\nwpa_passphrase=%s\nwpa_group_rekey=3600\n", sbuf, para->m_password);
		} else if (!strcmp(para->m_auth_mode, "WPA2PSK")) {
			asprintf(&sbuf2, "%swpa=2\nwpa_key_mgmt=WPA-PSK\nwpa_pairwise=TKIP\nrsn_pairwise=CCMP\nwpa_passphrase=%s\nwpa_group_rekey=3600\n", sbuf, para->m_password);
		} else if (!strcmp(para->m_auth_mode, "WPA3Personal")) {
			asprintf(&sbuf2, "%swpa=2\nwpa_key_mgmt=SAE\nwpa_pairwise=CCMP\nrsn_pairwise=CCMP\nieee80211w=2\nwpa_passphrase=%s\nwpa_group_rekey=3600\nsae_pwe=2\n", sbuf, para->m_password);
		} else if (!strcmp(para->m_auth_mode, "WPA2WPA3")) {
			asprintf(&sbuf2, "%swpa=2\nwpa_key_mgmt=SAE WPA-PSK\nwpa_pairwise=CCMP\nrsn_pairwise=CCMP\nieee80211w=1\nwpa_passphrase=%s\nwpa_group_rekey=3600\nsae_pwe=2\n", sbuf, para->m_password);
		} else if (!strcmp(para->m_auth_mode, "OPEN")) {
			asprintf(&sbuf2, "%swpa=0\n", sbuf);
		} else {//kw
			wf_log("Unsupport m_auth_mode: %s", para->m_auth_mode);
			free(wbuf);
			free(fbuf);
			free(sbuf);
			return -1;
		}	

	}
	
	generate_acl_list_file(para->accesspolicy0);

	fd = open(HOSTAPD_CONF_FILE, O_CREAT | O_TRUNC | O_WRONLY, 0660);
	if (fd < 0) {
		wf_log("Cannot update \"%s\": %s", HOSTAPD_CONF_FILE, strerror(errno));
		return -1;
	}
	if(strcmp (m_ssid_enable, "1") == 0){
		if (write(fd, sbuf2, strlen(sbuf2)) < 0) {
			wf_log("Cannot write to \"%s\": %s", HOSTAPD_CONF_FILE, strerror(errno));
			ret = -1;
		}
		free(sbuf);
		free(sbuf2);
	}else{
		if (write(fd, fbuf, strlen(fbuf)) < 0) {
			wf_log("Cannot write to \"%s\": %s", HOSTAPD_CONF_FILE, strerror(errno));
			ret = -1;
		}
	}
	free(wbuf);
	free(fbuf);
	/* Note: apparently open can fail to set permissions correctly at times */
	if (fchmod(fd, 0660) < 0) {
		wf_log("Error changing permissions of %s to 0660: %s",
				HOSTAPD_CONF_FILE, strerror(errno));
		close(fd);
		unlink(HOSTAPD_CONF_FILE);
		return -1;
	}
	
	close(fd);
	return ret;
}
#endif

static void open_wifi_nv_set()
{
	sc_cfg_set ("wifiSleep", "0");
	sc_cfg_set ("wifiEnabled", "1");
	sc_cfg_set ("wifi_cur_state", WIFI_OPENED);
	wf_log("set wifi_cur_state=1");
	sc_cfg_save();
}

static void close_wifi_nv_set()
{
	sc_cfg_set ("wifi_cur_state", WIFI_CLOSED);
//	sc_cfg_set ("wifiEnabled", "0");
	sc_cfg_save();
}

static void wlan_set_state(int va0_state, int va1_state)
{
	wf_log("wlan_set_state va0_state : %d va1_state : %d",va0_state,va1_state);
	ap_server->ap0_state = va0_state;
	ap_server->ap1_state = va1_state;
	
	if(va0_state == WLAN_OFF){
		close_wifi_nv_set();
		write_status (WIFISTATUS, WIFI_CLOSED);
	}
	else if(va0_state == WLAN_ON){
		open_wifi_nv_set();
		write_status (WIFISTATUS, WIFI_OPENED);
	}
}

/* Ƴַеĳһַָ */ 
static void str_remove_chr(char *str, char chr) 
{
    int i, j;

    for (i = 0; str[i] != '\0'; i++) { 
        if (str[i] == chr) { 
            for (j = i+1; str[j] != '\0'; j++) { 
                str[j-1] = str[j]; 
            } 
            str[j-1] = '\0'; 
        } 
    } 
}
#if defined(CONFIG_WIFI_EFUSE_MAC)
int wifi_fw_mac_config_ssid(struct         wlan_ap_server *ap_svr)
{
	char ssid_write_flag[8] = {0};

	sc_cfg_get ("ssid_write_flag", ssid_write_flag, sizeof (ssid_write_flag));
	wf_log ("wifi_ssid_init: ssid_write_flag = %s", ssid_write_flag);

	/*NVǷдSSID ı־λȽϣΪ1ʾд룬д0ʾδд*/
	if (!strcmp (ssid_write_flag, "0")) {
		char  wifi_mac[18]={0};
		char  fake_at_wifi_mac[64] = {0};
		int ret = -1;
		ret = wfsystem("ifconfig wlan0|grep HWaddr |cut -d' ' -f10 > /tmp/wifi_mac");
		if (ret == -1) { //cov m
			system("ifconfig wlan0|grep HWaddr |cut -d' ' -f10 > /tmp/wifi_mac");
		}
		wlan_readfile("/tmp/wifi_mac", wifi_mac, sizeof(wifi_mac)-1);
		wifi_mac[sizeof(wifi_mac)-1] = '\0';//cov
		str_remove_chr(wifi_mac, ':');
		snprintf(fake_at_wifi_mac, sizeof(fake_at_wifi_mac), "+MAC:%s", wifi_mac);
		sc_cfg_set("at_wifi_mac", fake_at_wifi_mac);

		get_mac_config_ssid_key_nv();
#ifndef USE_CAP_SUPPORT
		wlan_ap_get_para(ap_svr);//D80 update when ap start api
		wlan_ap_save_config(ap_svr);
#endif
	}
	return 0;
}
#endif

#ifdef USE_CAP_SUPPORT
static void ap_enabled_cb(void *param)
{
	slog(WIFI_PRINT, SLOG_ERR, "ap_enabled_timeout!\n");
	//2.4Gssidͬһ״̬
	send_ap_status_to_cap(IN_WIFI_AP_INDEX_MAX, IN_WIFI_AP_STATUS_ERROR);
	return 0;
}
#endif

//maybe bridge not ready, max 30s
static void wait_bridge(void)
{
	int i = 0;
	int br_ifindex = 0;
	
	for (i = 1; i <= 150; i++) {	
		br_ifindex = if_nametoindex("br0");
		if (br_ifindex == 0) {
			usleep(200000);
		} else {
			break;
		}
	}
	
	wf_log ("wait_bridge i: %d, index: %d", i, br_ifindex);
}

int wifi_start_hostapd (struct  wlan_ap_server  *ap_svr)
{
	int ret = -1;

	if (isSoftapStarted (ap_svr)){
		//wf_log("softap has started");
		if(ap_svr->ap0_state == 0) {
			ret = wifi_ap_enable(ap_svr); 
			if (ret == 0) {
			#ifdef USE_CAP_SUPPORT
				send_ap_status_to_cap(IN_WIFI_AP_INDEX_MAX, IN_WIFI_AP_STATUS_ENABLED);
			#endif
				return 0;
			}
			//enable fail, close hostapd
			wifi_stop_hostapd(ap_svr);
		}
	}
#ifdef USE_CAP_SUPPORT
	if (g_work_mode == IN_WIFI_WORK_MODE_AP1) {
		acl_mode_set_5g();
		wlan_ap_get_para_5g(ap_svr);
		wlan_ap_save_config_5g(ap_svr);
	}
	else {
		acl_mode_set();
		wlan_ap_get_para(ap_svr);
		wlan_ap_save_config(ap_svr);
	}
#endif
	
	/* Reset sockets used for exiting from hung state */
	ap_svr->sock.exit_sockets[0] = ap_svr->sock.exit_sockets[1] = -1;
	ap_svr->sock_m.exit_sockets[0] = ap_svr->sock_m.exit_sockets[1] = -1;

//	if(&esp8089_ap != ap_svr ) wifi_insmod(ap_svr);

	ret = ap_svr->drv_proxy.drv_init(&ap_svr->drv_proxy);
	if(-1 == ret) {
	#ifdef USE_CAP_SUPPORT
		send_ap_status_to_cap(IN_WIFI_AP_INDEX_MAX, IN_WIFI_AP_STATUS_ERROR);
	#endif
		return -1;
	}

	wait_bridge();
	usleep (200000);
	if(0 == startSoftap (ap_svr)){
	#ifdef USE_CAP_SUPPORT
		sc_timer_delete(WIFI_AP_ENABLED_TIMER_ID);
		sc_timer_create(WIFI_AP_ENABLED_TIMER_ID, TIMER_FLAG_ONCE, 60*1000, ap_enabled_cb, NULL);
	#endif
		//usleep (200000);
		if(0 == wifi_connect_to_hostapd(&ap_svr->sock)){
			g_hostap = 1;
			sem_post (&g_hostap_id);
			ret =0;
			wlan_set_state(WLAN_ON,WLAN_OFF);
			wlan_set_txpwr();

			char m_ssid_enable[8] = {0};
			sc_cfg_get ("m_ssid_enable", m_ssid_enable, sizeof (m_ssid_enable));
			wf_log ("hostapd start second ap m_ssid_enable : %s",m_ssid_enable);
			if (strcmp (m_ssid_enable, "1") == 0) {
				if(0 == wifi_connect_to_hostapd(&ap_svr->sock_m)){
#if defined(__MULTI_AP__)					
					g_m_hostap = 1;
					sem_post(&g_m_hostap_id);	
#endif					
					wlan_set_state(WLAN_ON,WLAN_ON);
					wf_log ("hostapd start wifi_state=%d, m_wifi_state=%d", ap_svr->ap0_state, ap_svr->ap1_state);
					return 0;
				} 
				else {
					wf_log ("m_ssid socket connect or attach failed.");
					wifi_close_sockets (&ap_svr->sock_m); 
					wlan_set_state(WLAN_ON,WLAN_OFF);
					return -1;
				}
			}
	
		}
		else{
			wf_log (" socket connect or attach failed.");
			wlan_set_state(WLAN_OFF,WLAN_OFF);
		}

	}else{
		wf_log ("hostapd start failed");
		wlan_set_state(WLAN_OFF,WLAN_OFF);
	#ifdef USE_CAP_SUPPORT
		send_ap_status_to_cap(IN_WIFI_AP_INDEX_MAX, IN_WIFI_AP_STATUS_ERROR);
	#endif
	}
	
	wf_log ("hostapd start g_wifi_state=%d", ap_svr->ap0_state);

	return ret;
}

int wifi_stop_hostapd (struct  wlan_ap_server  *ap_svr)
{
	stopSoftap (ap_svr);
	wifi_close_sockets (&ap_svr->sock);	
	g_hostap = 0;
#if defined(__MULTI_AP__)
	wifi_close_sockets (&ap_svr->sock_m);
	g_m_hostap=0;
#endif	
	
	wlan_set_state(WLAN_OFF,WLAN_OFF);
	ap_svr->drv_proxy.drv_deinit(&ap_svr->drv_proxy);
	
	return 0;
}
#ifdef USE_CAP_SUPPORT
int wifi_set_hostapd (struct  wlan_ap_server  *ap_svr)
{
	if (g_work_mode == IN_WIFI_WORK_MODE_AP1) {
		acl_mode_set_5g();
		wlan_ap_get_para_5g(ap_svr);
		wlan_ap_save_config_5g(ap_svr);
		wifi_config_ap_5g(ap_svr);
	}
	else {
		acl_mode_set();
		wlan_ap_get_para(ap_svr);
		wlan_ap_save_config(ap_svr);
		wifi_config_ap(ap_svr);
	}
#ifdef __AP_FUNC__
#ifdef __USE_AES__
	wifi_encrypt_code();
#endif
#endif

//	wifi_stop_hostapd(ap_svr);
//	wifi_start_hostapd(ap_svr);
	//acl_set_process();
	sc_cfg_set("wifi_set_flags", "");
	return 0;
}
#else
int wifi_set_hostapd (struct  wlan_ap_server  *ap_svr)
{
	wlan_ap_get_para(ap_svr);
	wlan_ap_save_config(ap_svr);
	wifi_config_ap(ap_svr);
#ifdef __AP_FUNC__
#ifdef __USE_AES__
	wifi_encrypt_code();
#endif
#endif

//	wifi_stop_hostapd(ap_svr);
//	wifi_start_hostapd(ap_svr);
	//acl_set_process();
	sc_cfg_set("wifi_set_flags", "");
	return 0;
}
#endif

void *channel_follow_timer_handle(void *arg)
{
	ipc_send_message (MODULE_ID_WLAN_SERVER, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_CONNECTED_ENABLE_AP_CMD, 0, NULL, 0);
	return NULL;
}

static int wifi_channel_follow(struct  wlan_ap_server  *ap_svr)
{
	char t_channel[NVIO_WIFI_LEN_8] = {0};
	char f_channel[NVIO_WIFI_LEN_8] = {0};
	char w_11n_ht[NVIO_WIFI_LEN_8] = {0};

	//wlan_ap_get_para(ap_svr);
	//wlan_ap_save_config(ap_svr);
	sc_cfg_get ("tmp_channel", t_channel, NVIO_WIFI_LEN_8-1);
	sc_cfg_get ("flower_channel", f_channel, NVIO_WIFI_LEN_8-1);
	wf_log ("wifi_channel_follow retry %s#%s!!", t_channel, f_channel);

	if (0 != strcmp(t_channel, f_channel)) {
		
#ifdef USE_CAP_SUPPORT		
		if (g_work_mode == IN_WIFI_WORK_MODE_AP1) {
			sc_cfg_get ("wifi_11n_cap_5g", w_11n_ht, NVIO_WIFI_LEN_8-1);
			wlan_set_channel_5g(f_channel, w_11n_ht);
		}
		else {
			int fchan = atoi(f_channel);
		
			sc_cfg_get ("wifi_11n_cap", w_11n_ht, NVIO_WIFI_LEN_8-1);
			if (0 == strcmp(w_11n_ht, "1")) {
				ap_docmd("SET force_40mhz", "0");//set channel fail
				//ap_docmd("SET ht_capab [HT40+][HT40-][SHORT-GI-20][SHORT-GI-40]", NULL);
			}
			if (fchan > 11) {
				//ap_docmd("SET country_code", "CN");
				char country_code[NVIO_WIFI_LEN_8] = {0};
				sc_cfg_get("CountryCode", country_code, NVIO_WIFI_LEN_8-1);
				wf_log("wifi_channel_follow country_code %s!!", country_code);
			}
			ap_docmd("SET channel", f_channel);
		}
#else
		int fchan = atoi(f_channel);
				
		sc_cfg_get ("wifi_11n_cap", w_11n_ht, NVIO_WIFI_LEN_8-1);
		if (0 == strcmp(w_11n_ht, "1")) {
			ap_docmd("SET force_40mhz", "0");//set channel fail
			//ap_docmd("SET ht_capab [HT40+][HT40-][SHORT-GI-20][SHORT-GI-40]", NULL);
		}

		if (fchan > 11) {
			ap_docmd("SET country_code", "CN");
		}
		ap_docmd("SET channel", f_channel);
#endif

		ap_docmd("DISABLE", NULL);

		if(ap_server->ap0_wps_state == 1){
			wf_msg_to_self(MSG_CMD_WIFI_WPS_DOWN, 2, "1");
		}
		
#if defined(__AIC_8800DW_CHIP__)
		int ret = -1;
		sc_timer_delete(WIFI_CHANNEL_FOLLOW_TIMEOUT_TIMER_ID);
	
    	ret = sc_timer_create(WIFI_CHANNEL_FOLLOW_TIMEOUT_TIMER_ID,
				TIMER_FLAG_ONCE, 10000, channel_follow_timer_handle, NULL);
		if (ret == 0) {
			need_channel_follow=1;
			wf_log ("add channel follow timer success");
		} else {
			wf_log ("add channel follow timer failed and enable AP");
		#ifdef __STA_FUNC__
			wifi_station_cancel_scan();
		#endif
			ap_docmd("ENABLE", NULL);
			wlan_set_txpwr();
			sc_cfg_set("tmp_channel", f_channel);
			wf_log ("wifi_channel_follow change %s->%s!!", t_channel, f_channel);
		}
#else
    #ifdef __STA_FUNC__
		wifi_station_cancel_scan();
    #endif
		ap_docmd("ENABLE", NULL);
		
		sc_cfg_set("tmp_channel", f_channel);
		wf_log ("wifi_channel_follow change %s->%s!!", t_channel, f_channel);
#endif
	}
	return 0;
}

static void  wifi_ap_reset_para(struct  wlan_ap_server  *ap_svr)
{
	char f_40M[NVIO_WIFI_LEN_8] = {0};
	char w_11n_ht[NVIO_WIFI_LEN_8] = {0};
	char conf_chan[NVIO_WIFI_LEN_8] = {0};//config_file
	char t_channel[NVIO_WIFI_LEN_8] = {0};
	
#if (defined(__SSV_6X5X_CHIP__) || defined(__AIC_8800DW_CHIP__))
	sc_cfg_get ("wifi_force_40m", f_40M, NVIO_WIFI_LEN_8-1);
	sc_cfg_get ("wifi_11n_cap", w_11n_ht, NVIO_WIFI_LEN_8-1);
	if (0 == strcmp(w_11n_ht, "1")) {
		ap_docmd("SET force_40mhz", f_40M);
		ap_docmd("SET ht_capab "HT_CAPAB_40, NULL);
	}
#endif
	sc_cfg_get ("tmp_channel", t_channel, NVIO_WIFI_LEN_8-1);
	sc_cfg_get ("Channel", conf_chan, NVIO_WIFI_LEN_8-1);
	//reset after channel follow
	if (0 != strcmp(t_channel, conf_chan)) {
		ap_docmd("SET channel", conf_chan);
		sc_cfg_set("tmp_channel", conf_chan);
	}
	
	//reduce the time of running acs again
	ap_docmd("SET acs_num_scans", "1");
}

static void  wifi_ap_reset_para_with_apsta(struct  wlan_ap_server  *ap_svr)
{
#if (defined(__SSV_6X5X_CHIP__) || defined(__AIC_8800DW_CHIP__))
	char w_11n_ht[NVIO_WIFI_LEN_8] = {0};

	sc_cfg_get ("wifi_11n_cap", w_11n_ht, NVIO_WIFI_LEN_8-1);
	if (0 == strcmp(w_11n_ht, "1")) {
		ap_docmd("SET ht_capab "HT_CAPAB_40, NULL);
	}
#endif
}


static void  wifi_ap_disable(struct  wlan_ap_server  *ap_svr)
{
#if defined(__MULTI_AP__)
	if (1 == ap_server->ap1_state) {
		docmd(&ap_svr->sock_m, "DISABLE");
		g_m_hostap = 0;
	}
#endif	

	docmd(&ap_svr->sock, "DISABLE");
	ap_svr->drv_proxy.drv_deinit(&ap_svr->drv_proxy);

	g_hostap = 0;
	wlan_set_state(WLAN_OFF,WLAN_OFF);
}

static int wifi_ap_enable(struct  wlan_ap_server  *ap_svr)
{
	int i = 1;
	int find_wlan = -1;
	char *reply = NULL;
	ap_svr->drv_proxy.drv_init(&ap_svr->drv_proxy);
	for (i = 1; i <= 10; i++) {
		wf_log ("ifconfig wlan i=%d", i);
		find_wlan = wfsystem ("ifconfig wlan0");
		if (-1 == find_wlan) {
			if (i == 10) {
				wf_log ("drv_init failed!!");
				return;
			} else {
				usleep (200000 * i);
				continue;
			}
		}
		break;
	}
	
	reply = docmd(&ap_svr->sock, "ENABLE");
	
	g_hostap = 1;
	sem_post (&g_hostap_id);
	wlan_set_state(WLAN_ON,WLAN_OFF);

	if(reply==NULL){
		wf_log ("ap enable failed\n");
		return -1;
	}
	
	wlan_set_txpwr();
	return 0;
}

//wait max 10s for acs scan finish
static void wait_ap_enabled(void)
{
	int i = 0;
	for (i = 1; i <= 50; i++) {
		if (g_ap_enabled == 0) {
			usleep(200000);
		} else {
			usleep(100000);
			break;
		}
	}

}


 void *hostap_loop (void *param)
{	
	char name[32] = {0};

	strncpy(name, (char*) param, sizeof(name)-1);//kw
	prctl (PR_SET_NAME, name, 0, 0, 0);

	while (1) {    //charging״̬Ĳ
		char buf[UEVENT_BUFFER_SIZE] = {0};
		if (g_hostap == 0) {
			sem_wait (&g_hostap_id);
		}
		wf_log ("start hostapd loop");
		// ¼οwpa_supplantwpa_ctrl.hж
		int nread = wifi_wait_for_event (&ap_server->sock, buf, sizeof (buf));

		if (nread > 0) {
			wf_log ("STA: %s", buf);
			char *p=NULL;
			char mac[20]={0};
			//kw 3
			if ((p=strstr (buf, AP_STA_CONNECTED)) != NULL) {//STA: AP-STA-CONNECTED a4:44:d1:86:c5:d9
				strncpy(mac ,p+strlen(AP_STA_CONNECTED),17);
				wf_msg_to_self (MSG_CMD_AP_STA_CONNECTED, sizeof(mac), mac);
				wf_msg_to_self (MSG_CMD_STA_COUNT_CHANGE, 0, NULL);

			}
			else if ((p=strstr (buf, AP_STA_DISCONNECTED)) != NULL) {//STA: AP-STA-DISCONNECTED a4:44:d1:86:c5:d9
				strncpy(mac ,p+strlen(AP_STA_DISCONNECTED),17);
				wf_msg_to_self (MSG_CMD_AP_STA_DISCONNECTED, sizeof(mac), mac);
				wf_msg_to_self (MSG_CMD_STA_COUNT_CHANGE, 0, NULL);
				
			}
#if 0
			else if (p=strstr (buf, WPS_EVENT_PIN_NEEDED)) {
			//WPS-PIN-NEEDED 81cd0b24-1bcb-59c3-897b-ae51d0db3bf6 a4:44:d1:86:c5:d9 [m3note|Meizu|m3 note|m3 note|91QECP856P5Z|10-0050F204-5]
				wifi_ap_wps_get_uuid(buf, sta_wps_uuid, 63);
				
				wf_msg_to_self(MSG_CMD_WIFI_WPS, 0, NULL);

			}
#endif
			else if ((p=strstr (buf, WPS_EVENT_SUCCESS)) != NULL) {
				sc_timer_delete(WIFI_WPS_PIN_TIMEOUT_TIMER_ID);
				wf_msg_to_self(MSG_CMD_WIFI_WPS_DOWN, 2, "0");
			}
			else if (strstr (buf, WPS_EVENT_FAIL) ||strstr (buf, WPS_EVENT_TIMEOUT)) {
				sc_timer_delete(WIFI_WPS_PIN_TIMEOUT_TIMER_ID);
				wf_msg_to_self(MSG_CMD_WIFI_WPS_DOWN, 2, "1");
			}
			else if ((p=strstr (buf, AP_EVENT_ENABLED)) != NULL) {
				g_ap_enabled = 1;
			#ifdef USE_CAP_SUPPORT
				sc_timer_delete(WIFI_AP_ENABLED_TIMER_ID);
				send_ap_status_to_cap(IN_WIFI_AP_INDEX_MAX, IN_WIFI_AP_STATUS_ENABLED);
			#endif
			}
		}
		else {
			wf_log ("Could not read pending message.");
		}
	}

	return NULL;
}

#if defined(__MULTI_AP__)
 void *hostap_loop_multi(void *param)
 {	 
	 char name[32] = {0};
 
	 strncpy(name, (char*) param, sizeof(name)-1);//kw
	 prctl(PR_SET_NAME, name, 0, 0, 0);
 
	 while (1) {	//charging״̬Ĳ
		 char buf[UEVENT_BUFFER_SIZE] = {0};
		 if (g_m_hostap == 0) {
			 sem_wait(&g_m_hostap_id);
		 }
		 wf_log ("start multi hostapd loop");
		 // ¼οwpa_supplantwpa_ctrl.hж
		 int nread = wifi_wait_for_event(&ap_server->sock_m, buf, sizeof (buf));
 
		 if (nread > 0) {
			 wf_log ("STA: %s", buf);
			 char *p=NULL;
			 char mac[20]={0};
			 //kw 3
			 if ((p=strstr (buf, AP_STA_CONNECTED)) != NULL) {//STA: AP-STA-CONNECTED a4:44:d1:86:c5:d9
				 strncpy(mac ,p+strlen(AP_STA_CONNECTED),17);
				 wf_msg_to_self (MSG_CMD_AP_STA_CONNECTED, sizeof(mac), mac);
				 wf_msg_to_self (MSG_CMD_STA_COUNT_CHANGE, 0, NULL);
 
			 }
			 else if ((p=strstr (buf, AP_STA_DISCONNECTED)) != NULL) {//STA: AP-STA-DISCONNECTED a4:44:d1:86:c5:d9
				 strncpy(mac ,p+strlen(AP_STA_DISCONNECTED),17);
				 wf_msg_to_self (MSG_CMD_AP_STA_DISCONNECTED, sizeof(mac), mac);
				 wf_msg_to_self (MSG_CMD_STA_COUNT_CHANGE, 0, NULL);
				 
			 }
#if 0
			 else if (p=strstr (buf, WPS_EVENT_PIN_NEEDED)) {
			 //WPS-PIN-NEEDED 81cd0b24-1bcb-59c3-897b-ae51d0db3bf6 a4:44:d1:86:c5:d9 [m3note|Meizu|m3 note|m3 note|91QECP856P5Z|10-0050F204-5]
				 wifi_ap_wps_get_uuid(buf, sta_wps_uuid, 63);
				 
				 wf_msg_to_self(MSG_CMD_WIFI_WPS, 0, NULL);
 
			 }
#endif
			 else if ((p=strstr (buf, WPS_EVENT_SUCCESS)) != NULL) {
				 sc_timer_delete(WIFI_WPS_PIN_TIMEOUT_TIMER_ID);
				 wf_msg_to_self(MSG_CMD_WIFI_WPS_DOWN, 2, "0");
			 }
			 else if (strstr (buf, WPS_EVENT_FAIL) ||strstr (buf, WPS_EVENT_TIMEOUT)) {
				 sc_timer_delete(WIFI_WPS_PIN_TIMEOUT_TIMER_ID);
				 wf_msg_to_self(MSG_CMD_WIFI_WPS_DOWN, 2, "1");
			 }/*
			 else if ((p=strstr (buf, AP_EVENT_ENABLED)) != NULL) {
				 //g_ap_enabled = 1;
			 }*/
		 }
		 else {
			 wf_log ("Could not read pending message.");
		 }
	 }
 
	 return NULL;
 }
#endif


static void wlan_ap_init(struct wlan_ap_server  *ap_svr)
{

	int ret = -1;
	char path[PATH_MAX]={0};
	
	wf_log (" enter");
	wlan_drv_pre_init(&ap_svr->drv_proxy);
	ap_svr->drv_proxy.drv_init(&ap_svr->drv_proxy);// if init failed ,  check wlan assure the process
		
	ensure_config_dir_exist(CONTROL_IFACE_PATH);
	ensure_file_exist(DENY_MAC_FILE);
	ensure_file_exist(ACCEPT_MAC_FILE);
	ensure_file_exist(WPS_PIN_REQUESTS);

	snprintf (path, sizeof (path), "%s/%s", ap_svr->sock.sockets_dir, ap_svr->sock.iface_name);
	unlink(path);  
	
	char m_ssid_enable[8] = {0};
	sc_cfg_get ("m_ssid_enable", m_ssid_enable, sizeof (m_ssid_enable));	
	if(strcmp (m_ssid_enable, "1") == 0){	
		memset(path, 0, sizeof (path));
		snprintf (path, sizeof (path), "%s/%s", ap_svr->sock_m.sockets_dir, ap_svr->sock_m.iface_name);
		unlink(path);
	}

	wlan_ap_get_para(ap_svr);

	wlan_ap_save_config(ap_svr);// according SSID1 and WPAPSK to generate hostapd.conf
}


void wlan_ap_open ()
{
	wf_log ("enter.");
	wf_msg_to_self(MSG_CMD_WIFI_SET_ON_REQ, 0, NULL);
}


//just for compile compatible
LONG wlan_get_wps_sta()
{
	return 0;
}
int captureWlanStaInfo()
{
	return  ap_server->g_sta_num;

}


static int validate_pin_code(unsigned long code)
{
    unsigned long accum = 0;
    
    accum += 3 * ((code / 10000000) % 10); 
    accum += 1 * ((code / 1000000) % 10); 
    accum += 3 * ((code / 100000) % 10); 
    accum += 1 * ((code / 10000) % 10);
    accum += 3 * ((code / 1000) % 10);
    accum += 1 * ((code / 100) % 10);
    accum += 3 * ((code / 10) % 10); 
    accum += 1 * ((code / 1) % 10);
    
    return (0 == (accum % 10)); 
}

void  hostapd_conf_change_para(char *var,  char  *value)
{
	FILE *  fp = fopen(HOSTAPD_CONF_FILE, "r+");
	int ret = 0;
	if(fp == NULL) {
		wf_log("hostapd.conf open failed");
		return;
	}

	wf_log("hostapd.conf change %s to %s", var, value);
	
	int  len = get_file_size(HOSTAPD_CONF_FILE);
	char *buf = malloc(len+1);
	if (buf == NULL)  {
		fclose(fp);
		wf_log("hostapd.conf malloc failed");
		return;
	}
	
	wf_log("hostapd.conf change %d", ftell(fp));
	memset(buf, 0, len+1);
	ret = fread(buf, 1, len, fp);//cov m
	if (ret != len) {
		free(buf);
		fclose(fp);
		wf_log("hostapd.conf fread failed");
		return;
	}
	*(buf+len)='\0';//cov

	char *ptr = strstr(buf, var) ;
	if (ptr == NULL)  {
		free(buf);
		fclose(fp);
		wf_log("hostapd.conf find: %s failed", var);
		return;
	}
	int	locate = ptr - buf  + strlen(var) + 1;
	wf_log("hostapd.conf change %d", ftell(fp));
	wf_log("hostapd.conf change %s", ptr);
	wf_log("hostapd.conf change %s", buf+locate);
	ret = fseek(fp, locate, SEEK_SET);//cov m
	if (ret != 0) {
		free(buf);
		fclose(fp);
		wf_log("hostapd.conf fseek failed");
		return;
	}
	wf_log("hostapd.conf change %d", ftell(fp));
	fwrite(value, strlen(value), 1, fp);
	free(buf);
	fclose(fp);

	wf_log("exit");
}


void generate_acl_list_file(char* accesspolicy)
{
	char accesscontrollist0[720] = {0};
	sc_cfg_get ("AccessControlList0", accesscontrollist0, sizeof (accesscontrollist0));

	char * ptr = NULL;
	while( (ptr=strstr(accesscontrollist0, ";")) != NULL){
		*ptr = '\n';
	}
	strcat(accesscontrollist0,"\n");

	if (!strcmp (accesspolicy, "1")) {       // white-list
		wlan_write_file(ACCEPT_MAC_FILE, accesscontrollist0);
		wlan_write_file(DENY_MAC_FILE, "\n");
	} else if (!strcmp (accesspolicy, "2")) { // black-list
		wlan_write_file(DENY_MAC_FILE, accesscontrollist0);
		wlan_write_file(ACCEPT_MAC_FILE, "\n");
	} else {
		wlan_write_file(ACCEPT_MAC_FILE, "\n");
		wlan_write_file(DENY_MAC_FILE, "\n");
	}

}

int  acl_mode_value_transist(char* accesspolicy0)
{
	if (!strcmp (accesspolicy0, "1")) {       // white-list
		return 1;
	} else if (!strcmp (accesspolicy0, "2")) { // black-list
		return 0;
	}else
		return 0;
}

void acl_set_process()
{
	char accesspolicy0[10] = {0};
	char macaddr_acl[10] = {0};
	sc_cfg_get ("AccessPolicy0", accesspolicy0, sizeof (accesspolicy0));

	if (!strcmp (accesspolicy0, "1")) { // white-list
		strcpy(macaddr_acl, "1");
	} else { // Ϊblack-list
		strcpy(macaddr_acl, "0");
	}
	
	generate_acl_list_file(accesspolicy0);
	
	ap_docmd("SET macaddr_acl",macaddr_acl);
	ap_docmd("ACCEPT_ACL CLEAR", NULL);
	ap_docmd("DENY_ACL CLEAR", NULL);
	if (!strcmp (accesspolicy0, "1")) { // white-list
		ap_docmd("SET accept_mac_file", ACCEPT_MAC_FILE);
	} else { // Ϊblack-list
		ap_docmd("SET deny_mac_file", DENY_MAC_FILE);
	}
	char m_ssid_enable[8] = {0};
	sc_cfg_get ("m_ssid_enable", m_ssid_enable, sizeof (m_ssid_enable));
	if (strcmp (m_ssid_enable, "1") == 0) {
		ap_docmd_m("SET macaddr_acl",macaddr_acl);
		ap_docmd_m("ACCEPT_ACL CLEAR", NULL);
		ap_docmd_m("DENY_ACL CLEAR", NULL);
		if (!strcmp (accesspolicy0, "1")) { // white-list
			ap_docmd_m("SET accept_mac_file", ACCEPT_MAC_FILE);
		} else { // Ϊblack-list
			ap_docmd_m("SET deny_mac_file", DENY_MAC_FILE);
		}
	}
	
	//Ϸsta,ܻڽзǷsta߲
#if 0
	hostapd_conf_change_para("macaddr_acl", macaddr_acl);
	if(0 != ap_server->sock.pid)
		kill(ap_server->sock.pid, SIGHUP);
#endif
	sc_cfg_set("wifi_set_flags", "");
}
void wps_over (void)
{
    sc_cfg_set("WscModeOption", "0");
    ap_server->ap0_wps_state = 0;
	ap_server->ap1_wps_state = 0;
    //write_status(WPSSTATUS,"0");
    sc_cfg_set("wps_pin", "");
    memset(sta_wps_uuid, 0, 64);
    wf_log("wps_over  end\n");
}

void wps_down (MSG_BUF* pMsg)
{
	char wps_result[8] = {0}; 
	int result_int = -1;

// wps failed (wps_result =1), wps success(wps_result = 0)
// handle wps result already write wpsstatus file, can not write again,  need to fix up
	//cov m
	if(pMsg != NULL)
	{
	    strncpy(wps_result, (char*)pMsg->aucDataBuf, 1);
	    result_int = atoi(wps_result);
	}

	if(0 == result_int) {
		write_status (WPSDISPLAYSTATUS, WPS_ACTIVED);
		write_status(WPSSTATUS,"2");
	}
	else if(1 == result_int){
		write_status(WPSSTATUS,"0");
	}
	wps_over();

}
void wps_up()
{
    wf_log("wps_up----\n");
    write_status(WPSSTATUS,"1");
	char m_ssid_enable[8] = {0};
	char wifi_wps_index[8]={0};
	sc_cfg_get("wifi_wps_index",wifi_wps_index,sizeof(wifi_wps_index));
	sc_cfg_get ("m_ssid_enable", m_ssid_enable, sizeof (m_ssid_enable));
	if (strcmp (m_ssid_enable, "1") == 0 && strcmp(wifi_wps_index,"2")==0) {
		ap_server->ap1_wps_state = 1;
		ap_server->ap0_wps_state = 0;
	}else{
		ap_server->ap0_wps_state = 1;
		ap_server->ap1_wps_state = 0;
	}

}
void *wps_pin_timeout_handle(void *arg)
{
	wf_msg_to_self(MSG_CMD_WIFI_WPS_DOWN, 2, "1");

	return NULL;
}


/*
	webui and  hostapd loop use the same msg , but  sometimes webui comes  firstly , sometimes hostapdloop  comes firstly

*/
void wps_deal (MSG_BUF *pstMsg)
{
	char wifi_wps_index[8]={0};
	char wps_mode[8]={0};
	char  WscModeOption[8]={0};

	int wps_pin_len = 0;
	char * ret = NULL;


	wf_log(" wps deal start\n");

	sc_cfg_get("wifi_wps_index",wifi_wps_index,sizeof(wifi_wps_index));
	sc_cfg_get("wps_mode",wps_mode,sizeof(wps_mode));
	sc_cfg_get("WscModeOption",WscModeOption,sizeof(WscModeOption));

	wf_log("[%s] wifi_wps_index=%s, wps_mode=%s\n", __FUNCTION__, wifi_wps_index,wps_mode);

	//hostapd loop msg,  check webui msg comes ? 
	// WscModeOption  can be set by webui, but msg not send yet
	if(pstMsg->src_id ==  MODULE_ID_WLAN_SERVER && atoi(WscModeOption)  == 0){
		wf_log("webui or mmi not start");
		return;
	}

	if(pstMsg->src_id ==  MODULE_ID_WEB_CGI && ap_server->ap0_wps_state == 1){
		wf_log("wps already start");
		return;
	}


	if (!strcmp(wps_mode, "PBC")) {
		if(strcmp(wifi_wps_index,"2")==0){
			wf_log("wifi_wps_index 2 PBC");
			ap_docmd("SET wps_state 0", NULL);
			ap_docmd_m("SET wps_state 2", NULL);
			ret = ap_docmd_m("WPS_PBC", NULL);
		}else{
			ap_docmd("SET wps_state 2", NULL);
			ap_docmd_m("SET wps_state 0", NULL);
			ret = ap_docmd("WPS_PBC", NULL);
		}
		if (ret == NULL) {
			wps_over();
			return;
		}
		wf_log("ret=%s\n",ret);
		if(strncmp(ret,"OK",2))
			wps_over();
		else
			wps_up();
	}
	else if((!strcmp(wps_mode, "PIN")) || (!strcmp(wps_mode, "APPIN"))){
#if 0
		if(strlen(sta_wps_uuid) == 0) {
			wf_log("no sta_wps_uuid\n");
			wps_over();
			return ;
		}
#endif
		char wps_pin[10]={0};
		sc_cfg_get("wps_pin",wps_pin,sizeof(wps_pin));
		wf_log("wps_pin=%s\n",wps_pin);
		wps_pin_len = strlen(wps_pin);
		int wps_pin_num = atoi(wps_pin);
		if(wps_pin_num<0 || wps_pin_num> INT_MAX-1)
		{
			wps_pin_num = 0;
		}
		if(((wps_pin_len == 8)&&(validate_pin_code(wps_pin_num)))|| (wps_pin_len == 4)){
			char content[128] = {0};
			//sprintf(content, "%s %s", sta_wps_uuid, wps_pin);
			sprintf(content, "any %s 120", wps_pin);
			if(strcmp(wifi_wps_index,"2")==0){
				wf_log("wifi_wps_index 2 wps_pin=%s\n",wps_pin);
				ap_docmd("SET wps_state 0", NULL);
				ap_docmd_m("SET wps_state 2", NULL);
				ret = ap_docmd_m("WPS_PIN", content);
			}else{
				ap_docmd("SET wps_state 2", NULL);
				ap_docmd_m("SET wps_state 0", NULL);
				ret = ap_docmd("WPS_PIN", content);
			}
			//ret = ap_docmd("WPS_PIN",  content);
			if(ret == NULL) {
				wps_over();
				return;
			}
			wf_log("ret=%s\n",ret);
			if(strncmp(ret,"OK",2))
				wps_over();
			else {
				wps_up();
				sc_timer_create(WIFI_WPS_PIN_TIMEOUT_TIMER_ID, 
				TIMER_FLAG_ONCE, 
				120000, 
				wps_pin_timeout_handle, 
				NULL);
			}
		} else {
			wps_over();
		}
	} else{  
		wps_over();
	}

}

void  clear_sta_count_nv()
{
	ap_server->g_sta_num = 0;
	sc_cfg_set ("sta_count", "0");
	sc_cfg_set ("m_sta_count", "0");
}

/*
 䣺΢оƬapstaʱapֻ31Ҫһ
*/
void sta_num_apsta_open()
{
#if defined (__AIC_8800DW_CHIP__)
	char max_access_num[16] = {0};
	char max_Access_num_bbak[16] = {0};
	char max_station_num[16] = {0};
	char max_station_num_bak[16] = {0};
	char MAX_Chip_Capability[16] = {0};
	sc_cfg_get("MAX_Access_num", max_access_num, sizeof(max_access_num));
	sc_cfg_get("MAX_Station_num", max_station_num, sizeof(max_station_num));	
	sc_cfg_get("MAX_Chip_Capability", MAX_Chip_Capability, sizeof(MAX_Chip_Capability));	
	sc_cfg_get("MAX_Station_num_bak", max_station_num_bak, sizeof(max_station_num_bak));	
	sc_cfg_get("MAX_Access_num_bbak", max_Access_num_bbak, sizeof(max_Access_num_bbak));
	wf_log("MAX_Chip_Capability:%s,MAX_Access_num:%s,MAX_Staion_num:%s,MAX_Access_num_bbak:%s,MAX_Station_num_bak:%s",
		MAX_Chip_Capability,max_access_num,max_station_num,max_station_num_bak,max_Access_num_bbak);
	int num=0;
	if((atoi(max_station_num)==atoi(MAX_Chip_Capability))){
		if(strcmp(max_station_num_bak,"0")){
			num = atoi(max_station_num_bak);
			sprintf(max_station_num, "%s", max_station_num_bak);
		}else{
			num = atoi(max_station_num);
			sc_cfg_set("MAX_Station_num_bak",max_station_num);
		}
		char num_str[12]={0}; 
		sprintf(num_str, "%d", num-1);
		sc_cfg_set("MAX_Station_num",num_str);
		if(!strcmp(max_access_num, max_station_num) || !strcmp(max_Access_num_bbak, max_station_num)){	
			sprintf(ap_server->ap_para.max_num_sta, "%s", num_str);
			sc_cfg_set("MAX_Access_num",num_str);
			sc_cfg_set("MAX_Access_num_bbak",max_station_num);
			ap_docmd("SET max_num_sta", num_str);
		}
	}
#endif
}

/*
 䣺apstaرʱΪ32ҪapĽ
*/
void sta_num_apsta_close()
{
	char max_Access_num_bbak[16] = {0};
	char max_station_num[16] = {0};
	char max_station_bak[16] = {0};
	sc_cfg_get("MAX_Access_num_bbak", max_Access_num_bbak, sizeof(max_Access_num_bbak));
	sc_cfg_get("MAX_Station_num", max_station_num, sizeof(max_station_num));
	sc_cfg_get("MAX_Station_num_bak", max_station_bak, sizeof(max_station_bak));
	if(strcmp(max_station_bak,"0")){		
		sc_cfg_set("MAX_Station_num",max_station_bak);
		sc_cfg_set("MAX_Station_num_bak","0");
	}
	if(strcmp(max_Access_num_bbak, "0")){
		sprintf(ap_server->ap_para.max_num_sta, "%s", max_Access_num_bbak);
		sc_cfg_set("MAX_Access_num",max_Access_num_bbak);
		ap_docmd("SET max_num_sta", max_Access_num_bbak);
		sc_cfg_set("MAX_Access_num_bbak","0");
	}	
}

/*
 1.apstaлap--->station close(֮ǰĴʱֻߵwlan_station_deinit,)
 2.apлapsta--->station open
 3.˫ssidлapsta--->station open
 رmultissid,Ҫݲ
 webui  ڵapmssidģʽ¿apsta
*/
void wlan_basic_restart_apsta()
{
	//when multi-ssid to apsta, goahead has set m_ssid_enable to 0
	//sc_cfg_get("m_ssid_enable", m_ssid_enable, sizeof (m_ssid_enable));
	if (1 == ap_server->ap1_state) { 
		write_status (WIFISTATUS, WIFI_CLOSED);
		clear_sta_count_nv();
		//close mssid
		ap_server->stopap(ap_server);
		g_ap_enabled = 0;
		sc_cfg_set("m_ssid_enable","0");
		wlan_ap_get_para(ap_server);
		wlan_ap_save_config(ap_server); //5g will set in startap
		ap_server->startap(ap_server);
		wlan_set_state(WLAN_ON, WLAN_OFF);
	}
#ifdef  __STA_FUNC__
	wait_ap_enabled();
	wlan_station_init();
	sta_num_apsta_open();
#endif
}

#if defined(__MULTI_AP__)
/*
	򿪵ڶSSID
*/
void init_va1_on_access_num()
{	
	char max_access_num[16] = {0};
	char m_max_Access_num[16] = {0};
	sc_cfg_get("MAX_Access_num", max_access_num, sizeof(max_access_num));
	sc_cfg_get("m_MAX_Access_num", m_max_Access_num, sizeof(m_max_Access_num));
	wf_log("MAX_Access_num : %s m_max_Access_num : %s",max_access_num,m_max_Access_num);
	ap_docmd("SET max_num_sta", max_access_num);
	ap_docmd_m("SET max_num_sta", m_max_Access_num);
}


//open wlan0 + va1, include poweron, wakeup
//same as: wlan_basic_open_va0_va1
void wlan_basic_open_mssid()
{
	sc_cfg_set ("wifi_process_state", "processing");
	ap_server->stopap(ap_server);
	wlan_ap_get_para(ap_server);
	wlan_ap_save_config(ap_server);	
	ap_server->startap(ap_server);
	wlan_set_state(WLAN_ON,WLAN_ON);
	sc_cfg_set ("wifi_process_state", "end");
}

void wlan_basic_open_va1()
{
	clear_sta_count_nv();

	ap_server->stopap(ap_server);
	wlan_ap_get_para(ap_server);
	wlan_ap_save_config(ap_server);	
	ap_server->startap(ap_server);	
	wlan_set_state(WLAN_ON,WLAN_ON);
	init_va1_on_access_num();
}

void wlan_basic_close_va1()
{
	char m_ssid_enable[8] = {0};
	clear_sta_count_nv();
	ap_server->stopap(ap_server);	
	wlan_ap_get_para(ap_server);
	wlan_ap_save_config(ap_server);
	ap_server->startap(ap_server);
	wlan_set_state(WLAN_ON,WLAN_OFF);
	sc_cfg_set("MAX_Access_num_bbak","0");
	sc_cfg_set("MAX_Station_num_bak","0");
}

void wlan_basic_closesta_openmssid()
{
	clear_sta_count_nv();
	write_status (WIFISTATUS, "0");//??
	
	wifi_station_close(); //has executed, before this message
	ap_server->stopap(ap_server);
	wlan_ap_get_para(ap_server);
	wlan_ap_save_config(ap_server);
	ap_server->startap(ap_server);
		
	wlan_set_state(WLAN_ON,WLAN_ON);
	init_va1_on_access_num();
}

////wifi_config_ap
void  wlan_basic_cfg_va1(struct wlan_ap_server  *ap_svr)
{	
	struct  wlan_ap_para*  para = &ap_svr->ap_para;
	unsigned int flags = 0;
	flags = atoi(para->wifi_set_flags);//get nv direct
	wlan_ap_get_para(ap_svr);
	wlan_ap_save_config(ap_svr);
	wf_log("set m_ssid param");
	ap_docmd_m("SET ssid", para->m_ssid);
	ap_docmd_m("SET ignore_broadcast_ssid", para->m_ignore_broadcast_ssid);
	ap_docmd_m("SET wps_state", "2");
	ap_docmd_m("SET max_num_sta", para->m_max_num_sta);
	if (!strcmp (para->m_auth_mode, "WPAPSKWPA2PSK") || !strcmp (para->m_auth_mode, "WPA-PSK/WPA2-PSK")) {
		ap_docmd_m("SET wpa","3");
		ap_docmd_m("SET ieee80211w","0");
		ap_docmd_m("SET wpa_key_mgmt","WPA-PSK");
		ap_docmd_m("SET wpa_pairwise","TKIP CCMP");
		ap_docmd_m("SET rsn_pairwise","TKIP CCMP");
		ap_docmd_m("SET wpa_passphrase",para->m_password);
	} else if (!strcmp(para->m_auth_mode, "WPA2PSK")) {
		ap_docmd_m("SET wpa","2");
		ap_docmd_m("SET ieee80211w","0");
		ap_docmd_m("SET wpa_key_mgmt","WPA-PSK");
		ap_docmd_m("SET wpa_pairwise","TKIP");
		ap_docmd_m("SET rsn_pairwise","CCMP");
		ap_docmd_m("SET wpa_passphrase",para->m_password);
	} else if (!strcmp(para->m_auth_mode, "WPA3Personal")) {
		ap_docmd_m("SET wpa","2");
		ap_docmd_m("SET ieee80211w","2");
		ap_docmd_m("SET wpa_key_mgmt","SAE");
		ap_docmd_m("SET wpa_pairwise","CCMP");
		ap_docmd_m("SET rsn_pairwise","CCMP");
		ap_docmd_m("SET wpa_passphrase",para->m_password);
		ap_docmd_m("SET sae_pwe","2");
	} else if (!strcmp(para->m_auth_mode, "WPA2WPA3")) {
		ap_docmd_m("SET wpa","2");
		ap_docmd_m("SET ieee80211w","1");
		ap_docmd_m("SET wpa_key_mgmt","SAE WPA-PSK");
		ap_docmd_m("SET wpa_pairwise","CCMP");
		ap_docmd_m("SET rsn_pairwise","CCMP");
		ap_docmd_m("SET wpa_passphrase",para->m_password);
		ap_docmd_m("SET sae_pwe","2");
	} else if (!strcmp(para->m_auth_mode, "OPEN")) {
		ap_docmd_m("SET wpa","0");
	}

#ifdef __AP_FUNC__
#ifdef __USE_AES__
	wifi_encrypt_code();
#endif
#endif	
	
	sc_cfg_set("wifi_set_flags", "");
	ap_docmd_m("DISABLE", NULL);
	ap_docmd_m("ENABLE", NULL);
	wlan_set_txpwr();

}
#endif

void apsta_connect_enable_ap(){
	int ret = -1;
	ret = sc_timer_delete(WIFI_CHANNEL_FOLLOW_TIMEOUT_TIMER_ID);
	if (ret == 0) {
		wf_log ("del channel follow timer id success");
	} else {
		wf_log ("del channel follow timer id failed");
	}
	char t_channel[NVIO_WIFI_LEN_8] = {0};
	char f_channel[NVIO_WIFI_LEN_8] = {0};

	sc_cfg_get ("tmp_channel", t_channel, NVIO_WIFI_LEN_8-1);
	sc_cfg_get ("flower_channel", f_channel, NVIO_WIFI_LEN_8-1);
#ifdef __STA_FUNC__
	wifi_station_cancel_scan();
#endif
	ap_docmd("ENABLE", NULL);
	wlan_set_txpwr();

	sc_cfg_set("tmp_channel", f_channel);
	wf_log ("wifi_channel_follow change %s->%s!!", t_channel, f_channel);
	need_channel_follow=0;
}

void basic_deal (struct wlan_ap_server  *ap_svr, int cmd)
{
	char wifi_sta_connection[8] = {0};
	sc_cfg_get ("wifi_sta_connection", wifi_sta_connection, sizeof (wifi_sta_connection));
//	wf_log ("cmd=%d(%s) start=%ld", cmd, to_string(cmd), time (NULL));

	switch (cmd) {
	case WIFI_CFG_CLOSE:
	case WIFI_CFG_SLEEP:
#ifdef  __STA_FUNC__
		if (strcmp (wifi_sta_connection, "1") == 0) {
			wifi_station_close();
			wifi_ap_reset_para_with_apsta(ap_svr);
		} else {
			wifi_ap_reset_para(ap_svr);
		}
#endif 
#ifdef USE_CAP_SUPPORT
		ap_svr->stopap(ap_svr);
#else
		ap_svr->disable(ap_svr);
#endif
		g_ap_enabled = 0;
		break;

	case WIFI_CFG_OPEN://open include open main ssid and apstation,	
		ap_svr->startap(ap_svr);
#ifdef  __STA_FUNC__
		if (strcmp (wifi_sta_connection, "1") == 0) {
			wait_ap_enabled();
			wlan_station_init();
			sta_num_apsta_open();
		}
#endif
		break;
		
	case WIFI_CFG_AP:
	case WIFI_CFG_RF:
		ap_svr->setap(ap_svr);
		break;
	
	case WIFI_CFG_FORCE_RESTART:
#ifdef  __STA_FUNC__
		if (strcmp (wifi_sta_connection, "1") == 0) {
			wifi_station_close();
			wifi_ap_reset_para_with_apsta(ap_svr);
		} else {
			wifi_ap_reset_para(ap_svr);
		}
#endif
		ap_svr->disable(ap_svr);
		g_ap_enabled = 0;
		ap_svr->startap(ap_svr);
#ifdef  __STA_FUNC__
		if (strcmp (wifi_sta_connection, "1") == 0) {
			wait_ap_enabled();
			wlan_station_init();
			sta_num_apsta_open();
		}
#endif
		break;
	
	case WIFI_CFG_CHANNEL_FOLLOW:
		wifi_channel_follow(ap_svr);
		break;
	case WIFI_CFG_RESTART_APSTATION://open vxd, at this point, va1 may opened
		wlan_basic_restart_apsta();
		break;
	case WIFI_CFG_APSTA_OPEN_AP:	
		if(need_channel_follow){
			apsta_connect_enable_ap();
		}
		break;	
#if defined(__AIC_8800DW_CHIP__)		
	//when kill wpa_supplicant(close apstation), no need restart hostapd
	case WIFI_CFG_RESTART_AP:
		sta_num_apsta_close();
		break;
#endif	
#if defined(__MULTI_AP__)
	case WIFI_CFG_OPEN_VA0_VA1://open-mssid include open va0+va1	
		wlan_basic_open_mssid();
		break;
	case WIFI_CFG_OPEN_MSSID://when wlan0 open, turn on va1
		wlan_basic_open_va1();
		break;
	case WIFI_CFG_CLOSE_MSSID://when wlan0 open, turn off va1
		wlan_basic_close_va1();
		break;
	case WIFI_CFG_CLOSESTA_OPENMSSID:
		wlan_basic_closesta_openmssid();
		break;
	/* when kill wpa_supplicant(close apstation), no need restart hostapd
	case WIFI_CFG_RESTART_AP:
		wlan_basic_restart_ap();
		break;
	*/
	case WIFI_CFG_MSSID: 
		wlan_basic_cfg_va1(ap_svr);
		break;
#endif
	default:
		wf_log ("cmd=%d, not deal", cmd);
		break;
	}
//	wf_log ("cmd=%d(%s) end=%ld", cmd, to_string(cmd), time (NULL));
}

