#include <sys/ioctl.h>

#include "wifi_util.h"
#include "wifi_drv_ko.h"

#define WIFI_IOCTL_STOP 0
#define WIFI_IOCTL_START 1

int config_wlan_mac(struct wlan_drv_proxy *proxy)
{
#if !(defined(__ESP_8089_CHIP__) || defined(__XR_819_CHIP__) || defined(__SSV_6X5X_CHIP__) \
       || defined(__AIC_8800DW_CHIP__))
	char   wifi_mac[20]={0};
	char cmd[64] = {0};
	
	sc_cfg_get("wifi_mac", wifi_mac, sizeof(wifi_mac));

	if(strlen(wifi_mac) == 0) {
		wf_log("wifi_mac is null");
		return  -1;
	}

	sprintf(cmd, "/sbin/ifconfig %s hw ether %s", proxy->iface_name, wifi_mac);
	wf_log("cmd = %s", cmd);
	//kw 3
	if (zxic_system(cmd) != 0)
		return -1;
	else
		return 0;	
#else
	return 0;
#endif
}

int  wifi_insmod(char *cmd )
{
	int ret = -1;
	wf_log (" enter");
	ret = zxic_system(cmd);
	wf_log (" insmod  ret = %d", ret);
	if (ret != 0) //kw 3
		ret = -1;
	usleep(200000);

	return ret;
}

int  wifi_rmmod(char *cmd)
{
	int ret = -1;
	ret = zxic_system(cmd);
	wf_log (" rmmod  ret = %d", ret);
	if (ret != 0) //kw 3
		ret = -1;
	return ret;
}

int wifi_ioctl_handle(int cmd)
{
	int fd = -1;
	int ret = 0;
	wf_log("enter");
	fd = open("/dev/wifi_device", O_RDWR);
	if (fd < 0) {
		wf_log("ioctl fail = %d", ret);
		return -1;
	}
	ret = ioctl(fd, cmd);
	if (ret < 0)
		printf("ioctl wifi_device err:%d\n", ret);
	close(fd);
	wf_log("ioctl ret = %d", ret);
	return ret;
}


int   wlan_drv_init(struct  wlan_drv_proxy * proxy)
{
#if (defined(__ESP_8089_CHIP__) || defined(__RDA_5995_CHIP__) || defined(__XR_819_CHIP__) || defined(__SSV_6X5X_CHIP__) \
	  || defined(__AIC_8800DW_CHIP__))

	int ret = -1;
	char *cmd = NULL;
	wf_log (" enter ");
	if(1 == proxy->drv_init_flag || 2 == proxy->drv_init_flag) return 0;

	asprintf(&cmd, "/sbin/ifconfig %s", proxy->iface_name);

//kw 3
	if (zxic_system(cmd) != 0)//wlan0 not exist
	{
#if (defined(__SSV_6X5X_CHIP__) || defined(__AIC_8800DW_CHIP__))
		if(wifi_ioctl_handle(WIFI_IOCTL_START) == 0) {
#else
		if(wifi_insmod(proxy->insmod_cmd) == 0) {
#endif
			ret = 0;
			proxy->drv_init_flag = 1;
		}
	}
	else
	{// wlan0 already exist
		ret = 0;
		proxy->drv_init_flag = 1;
	}


	free(cmd);

	if(ret ==0){	
		ret = config_wlan_mac(proxy);//realtek  will exec  ifconfig in  shelll scripts
	}
	wf_log (" exit ");
	return  ret;
#else
	return 0;
#endif

}




int   wlan_drv_deinit(struct  wlan_drv_proxy * proxy)
{
//rdaжӰʡ
//#if  defined(__RDA_5995_CHIP__)
#if (defined(__ESP_8089_CHIP__) || defined(__RDA_5995_CHIP__) || defined(__XR_819_CHIP__) || defined(__SSV_6X5X_CHIP__) \
	  || defined(__AIC_8800DW_CHIP__))

	int ret = -1;
	char *cmd = NULL;

	if(2 == proxy->drv_init_flag) return 0; //apstation not need

	if(0 == proxy->drv_init_flag) return -1; 

	asprintf(&cmd, "/sbin/ifconfig %s", proxy->iface_name);


	if (zxic_system(cmd) == 0)//indicates wlan0  exist
	{
#if (defined(__SSV_6X5X_CHIP__) || defined(__AIC_8800DW_CHIP__))
		if(wifi_ioctl_handle(WIFI_IOCTL_STOP) == 0) {
#else
		if(wifi_rmmod(proxy->rmmod_cmd) == 0) {
#endif			
			proxy->drv_init_flag = 0;  // sucess deinit
			ret = 0;
		}
	}
	else{
			proxy->drv_init_flag = 0;  // sucess deinit
			ret = 0;
	}
	
	free(cmd); //kw 2
	return ret;
#else
	return 0;
#endif
}

int wlan_drv_pre_init(struct  wlan_drv_proxy * proxy)
{
#if 0
//#if defined(__SSV_6X5X_CHIP__)
	wf_log ("wlan_drv_pre_init enter");
	if(wifi_insmod(SSV6X5X_PREALLOC_INSMODE) != 0) {
		wf_log ("wlan_drv_pre_init fail");
		return -1;
	}
	wf_log ("wlan_drv_pre_init succ");
#endif
	return 0;
}

