/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_keystokes.c
*  ļʶ  
*  ļ  
*  ʵֹ  MMI
*                
*                V1.0
*    2014-6-20
*  ˵  
*
*******************************************************************************/
/*****************************************************************************
                         ͷļ
******************************************************************************/
#include <fcntl.h>
#include <sys/syscall.h>
#include <linux/reboot.h>
#include <linux/input.h>
#include "mmi_common.h"
#include "mmi_lcd.h"

extern int g_customer_type;

/************************************************************************************
                            ȫֱ
***********************************************************************************/
static int g_mmi_kpd_handle = -1;//ȡ豸
static BOOL g_longPressFlag = FALSE;//Ƿ񳤰
static BOOL g_key_wakeup_flag = FALSE;//ʾMMIʱ ֻѵ ܲӦ
static long s_mmi_keypress_begin = 0;//ºʼʱ
BOOL g_mmi_key_longpress_flag = FALSE;//ǷΪmmipowerĹػ
extern E_zMmiShowMode g_showMode;
extern UINT32 g_fast_poweron;
static int g_mmi_kpd_longpress_time = 3;//жʱS
static int g_mmi_wifi_longpress_time = 5;//wifiжʱS, ҢԶcpe

BOOL mmi_get_wakeup_flag(VOID);
/**********************************************************************************
:ȡʱ
***********************************************************************************/
static long mmi_get_keypress_time()
{
	struct timeval tv;
	long second;
	gettimeofday(&tv, NULL);
	second = tv.tv_sec;
	return second;
}


/************************************************************************************
 :ȡϢ
***********************************************************************************/
static VOID mmi_get_keystrokes_data(MMI_KP_INFO *kp_info)
{

	int retR = -1;
	struct input_event kp_event = {0};

	retR = read(g_mmi_kpd_handle, (CHAR *)(&kp_event), sizeof(kp_event));
	slog(MMI_PRINT, SLOG_DEBUG, "MMI  Key's type:%d, value:%d, code:%d\n", kp_event.type, kp_event.value, kp_event.code);
	if (retR < 0) {
		slog(MMI_PRINT, SLOG_ERR, "MMI get_keystrokes_data read falied k-err:%d!",errno);
		return;
	}

	if (kp_event.type == 1) {
		if (kp_event.value == 1) {
			set_wake_lock(MMI_MAIN_LOCK_ID);
			kp_info->status = KEY_STATUS_DOWN;
			s_mmi_keypress_begin = mmi_get_keypress_time();
			if (kp_event.code == KEY_WIFI_CODE) {
				if (mmi_get_wifi_state()) {
					g_mmi_wifi_longpress_time = 5;
				} else {
					g_mmi_wifi_longpress_time = 1;
				}
			}
		} else if (kp_event.value == 0) {
			kp_info->status = KEY_STATUS_UP;
			s_mmi_keypress_begin = 0;
		} else if (kp_event.value == 2) {
			long sec_end = mmi_get_keypress_time();
			int sec_lingpress = (int)(sec_end - s_mmi_keypress_begin);
			if (kp_event.code == KEY_WIFI_CODE) {
				if (sec_lingpress >= g_mmi_wifi_longpress_time) {
					kp_info->status = KEY_STATUS_LONGPRESS;
				}
			}
			else {
				if (sec_lingpress >= g_mmi_kpd_longpress_time) {
					kp_info->status = KEY_STATUS_LONGPRESS;
				}
			}
		}
		if (kp_event.code == KEY_POWER_CODE) {
			kp_info->type = KEY_TYPE_POWER;
		} else if (kp_event.code == KEY_RESET_CODE) {
			kp_info->type = KEY_TYPE_RESET;
		} else if (kp_event.code == KEY_WPS_CODE) {
			kp_info->type = KEY_TYPE_WPS;
		} else if (kp_event.code == KEY_WIFI_CODE) {
			kp_info->type = KEY_TYPE_WIFI;
		}
	} else {
		kp_info->status = (KEY_STATUS)0;
		return;
	}

}

/***********************************************************************************
   :wifi
***********************************************************************************/
static VOID mmi_wakeup_wifi(int key_type)
{
	if (key_type == KEY_TYPE_WPS || key_type == KEY_TYPE_RESET) {
		if (!mmi_get_wifi_state()) {
			if (g_fast_poweron) {
				if (mmi_get_lcd_mode() != MMI_FAKE_POWEROFF_MODE && mmi_get_lcd_mode() != MMI_FAKE_POWEROFF_CHARGE_MODE
				    && mmi_get_led_mode() != MMI_FAKE_POWEROFF_MODE && mmi_get_led_mode() != MMI_FAKE_POWEROFF_CHARGE_MODE) {
					mmi_wifi_operate(WIFI_TURN_ON);
				}
			} else
				mmi_wifi_operate(WIFI_TURN_ON);
		}
	}
	if (key_type == KEY_TYPE_POWER) { //LCDģʽעͻѣLEDģʽûƲ
		if (g_showMode == MMI_MODE_LCD || g_showMode == MMI_MODE_ALL) {
			if ((mmi_get_lcd_mode() == MMI_ACTIVE_MODE || mmi_get_led_mode() == MMI_ACTIVE_MODE) && mmi_get_wakeup_flag()) {
				mmi_wifi_operate(WIFI_TURN_ON);
			}
		} else {
			if ((mmi_get_lcd_mode() == MMI_ACTIVE_MODE || mmi_get_led_mode() == MMI_ACTIVE_MODE) && !mmi_get_wifi_state()) {
				mmi_wifi_operate(WIFI_TURN_ON);
			}
		}
	}
}
/***********************************************************************************
   :ðѱʶ
***********************************************************************************/
VOID mmi_set_wakeup_flag(BOOL flag)
{
	if(g_customer_type == CUSTOMER_NANDIAN){//ûlcd ledҪѹ
		g_key_wakeup_flag = FALSE;
	}else{
		g_key_wakeup_flag = flag;
	}
}

/***********************************************************************************
   :ذѱʶ
***********************************************************************************/
BOOL mmi_get_wakeup_flag(VOID)
{
	return g_key_wakeup_flag;
}

/***********************************************************************************
   :ðʶ
***********************************************************************************/
VOID mmi_set_longpress_flag(BOOL flag)
{
	g_longPressFlag = flag;
}

/***********************************************************************************
   :ذʶ
***********************************************************************************/
BOOL mmi_get_longpress_flag(VOID)
{
	return g_longPressFlag;
}

/***********************************************************************************
   :LED/LCD ûѱ־λ
***********************************************************************************/
static VOID mmi_set_active_mode_key()
{
	if (g_showMode == MMI_MODE_LCD || g_showMode == MMI_MODE_ALL) {
		E_zMmi_Work_Mode lcd_mode = mmi_get_lcd_mode();
		if (lcd_mode == MMI_BACKLIGHT_OFF_MODE || lcd_mode == MMI_BACKLIGHT_HALFBRIGHT_MODE) {
			mmi_set_wakeup_flag(TRUE);
		} else {
			if (g_fast_poweron) {
				if (lcd_mode == MMI_FAKE_POWEROFF_MODE && (mmi_get_charge_state() == STATE_CHARGING || mmi_get_charge_state() == STATE_FULL)) {
					mmi_set_lcd_mode(MMI_FAKE_POWEROFF_CHARGE_MODE);
					mmi_set_update_flag(MMI_TASK_CTRL);
					mmi_set_wakeup_flag(TRUE);
				}
			}
		}
	}

	if (g_showMode == MMI_MODE_LED || g_showMode == MMI_MODE_ALL) {
		E_zMmi_Work_Mode led_mode = mmi_get_led_mode();
		if (led_mode == MMI_IDLE_LEDOFF_MODE || led_mode == MMI_IDLE_STANDBY_LEDOFF_MODE || led_mode == MMI_IDLE_CHG_LEDOFF_MODE) {
			mmi_set_wakeup_flag(TRUE);
		}
	}
	mmi_set_mode_active();
}


/***********************************************************************************
   :downϢ
***********************************************************************************/
static VOID mmi_handle_keystroke_down()
{
	BOOL long_press = mmi_get_longpress_flag();
	slog(MMI_PRINT, SLOG_DEBUG, "MMI  KEYDOWN  long_press=%d!!!\n ", long_press);
	if (FALSE == long_press) {
		// öʱ
		if (g_fast_poweron && (mmi_get_charge_state() == STATE_DISCHARGE) && ((mmi_get_lcd_mode() == MMI_FAKE_POWEROFF_MODE) || (mmi_get_led_mode() == MMI_FAKE_POWEROFF_MODE))) {
			mmi_reset_fast_poweron_idle_timer();
		} else {
			mmi_reset_idle_timer();
		}

		mmi_set_active_mode_key();
		
		if (mmi_get_wifi_state()) {
			//mmi_send_message(MODULE_ID_WIFI, (USHORT)MSG_CMD_WIFI_RESET_TIMER, 0, NULL);

			ipc_send_message(MODULE_ID_MMI, MODULE_ID_WIFI, MSG_CMD_WIFI_RESET_TIMER, 0, NULL, 0);
		}
	}
}

/***********************************************************************************
   :upϢ
***********************************************************************************/
static VOID mmi_handle_keystroke_up(int key_type)
{
	BOOL longPress = mmi_get_longpress_flag();
	BOOL key_wakeup = mmi_get_wakeup_flag();

	slog(MMI_PRINT, SLOG_DEBUG, "MMI  KEYUP KEYUP !!! longPress=%d key_wakeup=%d\n", longPress, key_wakeup);
	mmi_wakeup_wifi(key_type);
#ifndef DISABLE_LCD
	if (FALSE == longPress && (g_showMode == MMI_MODE_LCD || g_showMode == MMI_MODE_ALL)) {
		if (key_type == KEY_TYPE_WPS) {
			if (mmi_get_lcd_mode() == MMI_ACTIVE_MODE && key_wakeup == FALSE && mmi_getSSIDFirstShowInfo() == FALSE) {
				mmi_handle_lcd_key_switch_page();
			}
		} else if (key_type == KEY_TYPE_POWER && mmi_getShowingPowerOnInfo() == FALSE) {
			if (mmi_get_lcd_mode() == MMI_ACTIVE_MODE && key_wakeup == FALSE) {
				slog(MMI_PRINT, SLOG_DEBUG, "MMI  mmi_handle_keystroke_up ssssss");
				mmi_idle_timer_stop();
				mmi_set_lcd_mode(MMI_BACKLIGHT_OFF_MODE);
				mmi_set_update_flag(MMI_TASK_CTRL);

			}
		}
	}
#endif
	if (TRUE == longPress) {
		mmi_set_longpress_flag(FALSE); //ǳ
	}
	if (TRUE == key_wakeup) {
		mmi_set_wakeup_flag(FALSE);
	}
}

/***********************************************************************************
   óϢ
***********************************************************************************/
static VOID mmi_handle_keystroke_longpress(int key_type)
{
	BOOL longPress = mmi_get_longpress_flag();
	BOOL key_wakeup = mmi_get_wakeup_flag();
	slog(MMI_PRINT, SLOG_DEBUG, "MMI  mmi_handle_keystroke_longpress  longPress=%d key_wakeup=%d\n", longPress, key_wakeup);
	if ((FALSE == longPress) && (FALSE == key_wakeup)) {
		slog(MMI_PRINT, SLOG_DEBUG, "MMI KEYLONGPRESS!KEYLONGPRESS!\n");
		mmi_set_longpress_flag(TRUE);
		if (key_type == KEY_TYPE_POWER) {
			slog(MMI_PRINT, SLOG_DEBUG, "MMI handleKey ######KEY_POWER LONGPRESS######\n\n");

			if (g_fast_poweron) {
				if (mmi_get_lcd_mode() == MMI_FAKE_POWEROFF_MODE || mmi_get_lcd_mode() == MMI_FAKE_POWEROFF_CHARGE_MODE
				    || mmi_get_led_mode() == MMI_FAKE_POWEROFF_MODE || mmi_get_led_mode() == MMI_FAKE_POWEROFF_CHARGE_MODE) {
					g_mmi_key_longpress_flag = FALSE;
					mmi_handle_fast_poweron();
				} else {
					g_mmi_key_longpress_flag = TRUE;

					slog(MMI_PRINT, SLOG_NORMAL, "MMI poweroff,longpress!!!\n");
					mmi_set_poweroff();
				}
			} else {
				slog(MMI_PRINT, SLOG_NORMAL, "MMI poweroff,longpress!!!\n");
				mmi_set_poweroff();
			}
		} else if (key_type == KEY_TYPE_RESET) {
			slog(MMI_PRINT, SLOG_DEBUG, "MMI handleKey ######KEY_RESET LONGPRESS######\n\n");
			if (mmi_get_lcd_mode() == MMI_FAKE_POWEROFF_CHARGE_MODE || mmi_get_lcd_mode() == MMI_FAKE_POWEROFF_MODE
			    || mmi_get_led_mode() == MMI_FAKE_POWEROFF_CHARGE_MODE || mmi_get_led_mode() == MMI_FAKE_POWEROFF_MODE) {
				return;//break;
			}
			mmi_set_factory_reset();
		} else if ((key_type == KEY_TYPE_WPS)) {
			slog(MMI_PRINT, SLOG_DEBUG, "MMI handleKey ######KEY_WPS LONGPRESS######\n");
			if (mmi_get_wifi_state()) {
				mmi_wps_operate();
			}
		} else if ((key_type == KEY_TYPE_WIFI)) {
			slog(MMI_PRINT, SLOG_DEBUG, "MMI handleKey ######KEY_WIFI LONGPRESS######\n");
			if (mmi_get_wifi_state()) {
				mmi_wifi_operate(WIFI_TURN_OFF);
			} else {
				mmi_wifi_operate(WIFI_TURN_ON);
			}
		} else {
			slog(MMI_PRINT, SLOG_DEBUG, "MMI invalid operation!!\n");
		}
	}
}


/***********************************************************************************
   :
***********************************************************************************/
VOID *mmi_handle_keystrokes_thread(VOID *arg)
{
	MMI_KP_INFO keyData = {0};


	slog(MMI_PRINT, SLOG_DEBUG, "MMI handleKey handle_keystrokes_thread begin !!\n ");
	prctl(PR_SET_NAME, "mmihandlekey", 0, 0, 0);
	while (1) {
		mmi_get_keystrokes_data(&keyData);

		switch (keyData.status) {
		case KEY_STATUS_DOWN: {
			mmi_handle_keystroke_down();
			break;
		}

		case KEY_STATUS_UP: {
			mmi_handle_keystroke_up(keyData.type);
			break;
		}
		case KEY_STATUS_LONGPRESS: {
			mmi_handle_keystroke_longpress(keyData.type);
			break;
		}
		default: {
			break;
		}
		}
	}

}
#if 0
/***********************************************************************************
   :Զģⰴ
***********************************************************************************/
SINT32 zMMI_Handle_Msg_Atest_Key(VOID *data)
{
	//value:¼ code:ֵ
	autotest_key_rspmsg *kp_event = (autotest_key_rspmsg *)data;
	MMI_KP_INFO keyData = {0};

	if (kp_event->value == 1) {
		set_wake_lock(MMI_MAIN_LOCK_ID);
		keyData.status = KEY_STATUS_DOWN;
		s_mmi_keypress_begin = mmi_get_keypress_time();
	} else if (kp_event->value == 0) {
		keyData.status = KEY_STATUS_UP;
		s_mmi_keypress_begin = 0;
	} else if (kp_event->value == 2) {
		long sec_end = mmi_get_keypress_time();
		int sec_lingpress = (int)(sec_end - s_mmi_keypress_begin);
		if (sec_lingpress >= g_mmi_kpd_longpress_time) {
			keyData.status = KEY_STATUS_LONGPRESS;
		}
	}
	
	if (kp_event->code == KEY_POWER_CODE) {
		keyData.type = KEY_TYPE_POWER;
	} else if (kp_event->code == KEY_RESET_CODE) {
		keyData.type = KEY_TYPE_RESET;
	} else if (kp_event->code == KEY_WPS_CODE) {
		keyData.type = KEY_TYPE_WPS;
	}

	switch (keyData.status) {
		case KEY_STATUS_DOWN: {
			mmi_handle_keystroke_down();
			break;
		}
		case KEY_STATUS_UP: {
			mmi_handle_keystroke_up(keyData.type);
			break;
		}
		case KEY_STATUS_LONGPRESS: {
			mmi_handle_keystroke_longpress(keyData.type);
			break;
		}
		default: {
			break;
		}
	}
	return 0;
}
#endif

/************************************************************************************
 :ʼ
***********************************************************************************/
VOID mmi_keyStrokes_init(VOID)
{
	pthread_t  mmi_handlekey_thread;
	/*ƿflagź*/
	g_mmi_kpd_handle = open(KPD_PATH, O_RDONLY);
	if (g_mmi_kpd_handle == -1) {
		slog(MMI_PRINT, SLOG_ERR, "handleKey Couldn't open kp /dev/event0\n");
		return;//MMI_ASSERT(0);
	}
	if(g_customer_type == CUSTOMER_GUODIAN || g_customer_type == CUSTOMER_NANDIAN){
		g_mmi_kpd_longpress_time = 1;//1s
	}
	if (pthread_create(&mmi_handlekey_thread, NULL, &mmi_handle_keystrokes_thread, NULL) == -1) {
		slog(MMI_PRINT, SLOG_DEBUG, "MMI create handle_keystrokes_thread error\n");
		return ;
	}
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_keyStrokes_Init finish!!\n");
}

