/**
 * @file at_com.c 
 * @brief at_ctlڲڲʹõĹӿʵ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "at_context.h"
#include "at_zephyr.h"
#if (APP_OS_TYPE == APP_OS_LINUX)
#include <sys/un.h>
#include "ext_socket_func.h"
#endif

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
#define MAX_UINT_SIZE   8  // unsigned intܹȫλΪ8

#define ZAT_TAB_REPLACE                     ((unsigned char )(0xFC))    /* Ʊ滻     */
#define ZAT_NULL_FILL                       ((unsigned char )(0xFD))    /* մռλ       */
#define ZAT_SPACE_REPLACE                   ((unsigned char )(0xFE))    /* ո滻       */
#define ZAT_LF_REPLACE                      ((unsigned char )(0xFB))    /* LF滻         */
#define ZAT_CR_REPLACE                      ((unsigned char )(0xFA))    /* CR滻 */
//

/* Convert the letter from lowercase to uppercase  Сдתд*/
#define  ATI_UPCASE( c ) ( ((c) >= 'a' && (c) <= 'z') ? ((c) - 0x20) : (c) )

/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
typedef struct
{
    char *pprefixStr;/*Ӧַ*/
    int at_cmd_type;/*ӦAT*/
}
SPECIAL_CMD_TYPE;

//ϢATĶƣΪ0ʱΪƽ̨̬ܶϢͨΪ1ʱſרãӦϢMSG_CMD_SET_MSG_IS_FD
//int  is_xinke_msg = 0;mbimҪATֹget_modem_infoͻ

int g_customer_type = CUSTOMER_SDK; // 1-guodian, 2-nandian
int g_ap_lock =0; //0-1-ͷ
extern int g_ppp_ptm;		    //ptmӦ豸ļ
extern int g_ppp_ttyfd;		//pppӦtty豸
extern int g_atv;
extern int g_atq;
/*******************************************************************************
 *                        Local function declarations                          *
 ******************************************************************************/
static void set_next_param(const char ** ppstrNextParam, const char * pstrNextValue);
static const char * skip_str(const char * pstrAtCmd);
static const char * extract_int(const char * pstrAtCmdInt, int * piIntParam);
static char *find_special_prefix_cmd(char *pAtSpecialcmd, int *piNum);
/*******************************************************************************
 *                         Local variable definitions                          *
 ******************************************************************************/
/*ATӦATƥ*/
static const SPECIAL_CMD_TYPE ATCMEERRCODE[] =
    {
        {"OK",           AT_TYPE_RESPONSE},
        {"ZMSRI",        AT_TYPE_INFORM},
        {"ZREFRESHIND",  AT_TYPE_INFORM},
        {"ZLTENOCELL",   AT_TYPE_INFORM},
    };
/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/
/*******************************************************************************
 *                      Local function implementations                         *
 ******************************************************************************/
/* ֵ*/
static void set_next_param(const char ** ppstrNextParam, const char * pstrNextValue)
{
    if(ppstrNextParam != NULL)
    {
        *ppstrNextParam = pstrNextValue;
    }
}

/* ˫źͶ*/
static const char * skip_str(const char * pstrAtCmd)
{
    const char * pstrCur = pstrAtCmd;

    for(; !is_at_cmd_end(pstrCur); pstrCur++)
    {
        if('"' == *pstrCur)
        {
            break;
        }
    }
    return pstrCur;
}
/* ȡint*/
static const char * extract_int(const char * pstrAtCmdInt, int * piIntParam)
{
    char cCur = 0;
    char strInt[MAX_UINT_SIZE + 1] = {0};
    int iOffset = 0;

    for(iOffset = 0; !is_at_cmd_end(pstrAtCmdInt + iOffset); iOffset++)
    {
        cCur = *(pstrAtCmdInt + iOffset);
        if(!isdigit(cCur))
        {
            break;
        }
		if(iOffset <= MAX_UINT_SIZE)//볬intµadd by zpr 210115
        strInt[iOffset] = cCur;
    }
    if(NULL != piIntParam)
    {
        sscanf(strInt, "%d", piIntParam);
    }
    return pstrAtCmdInt + iOffset;
}

/* ȷATӦǷָATӦǷNULL*/
static char *find_special_prefix_cmd(char *pAtSpecialcmd, int *piNum)
{
    int i = 0;
    int tableSize = sizeof(ATCMEERRCODE)/sizeof(SPECIAL_CMD_TYPE);
    char *pstrTemp = pAtSpecialcmd;
	//at_print(AT_DEBUG,"pstrTemp = %s, len = %d\n", pstrTemp, strlen(pstrTemp));
	
	//ҵ׸ĸֵĲ
    for(; *pstrTemp != '\0'; pstrTemp++)
    {
        if(isalnum(*pstrTemp))
            break;
    }
    for(i = 0; i < tableSize; i++)
    {
    	//at_print(AT_ERR,"i=%d,len=%d\n", i, strlen(ATCMEERRCODE[i].pprefixStr));
		if(0 == at_strncmp(pstrTemp, ATCMEERRCODE[i].pprefixStr, MAXSTR(pstrTemp,strlen(ATCMEERRCODE[i].pprefixStr))))
		{
            *piNum = i;
            return pstrTemp;
        }
    }
    return NULL;
}


/*******************************************************************************
 *                      Global function implementations                        *
 ******************************************************************************/
/**
 * @brief ַѰƥӴ˫ڵݳ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
char *find_sub_str(const char *pStr, const char *pSubStr,const int strLen)
{
    int subStrLen = 0;
    //int bInSideQuote = FALSE; /* Ƿ˫ */
    int wIndex = 0;
    char *pTmpStr = (char *)pStr;

    if ((pStr == NULL) || (pSubStr == NULL) || (strLen <= 0))
    {
        return NULL;
    }

    subStrLen = strlen(pSubStr);

    if (strLen < subStrLen)
    {
        return NULL;
    }

    for (wIndex=0; wIndex<((strLen-subStrLen)+1); wIndex++)
    {
        /* жǷ˫ */
        //if (*pTmpStr == '"')
        //{
        //    bInSideQuote = bInSideQuote==TRUE?FALSE:TRUE;
        //}
        /* ӴȽ */
        if (*pTmpStr == *pSubStr)
        {
            if (at_strncmp(pTmpStr, pSubStr, (int)subStrLen) == 0)
            {
                return pTmpStr;
            }
        }
        pTmpStr++;
    }
    return NULL;
}

/**
 * @brief ӵǰַлȡATӦӴ
 * @param 
 * @return Ӵ
 * @note   
 * @warning 
 */
int get_sub_at_Str(const char *pCurAtStr, char *pSubAtStr, int iDataLen, char *atRecvBuf)
{
    char *pAtHead = NULL; /* ATӦͷ */
    char *pAtTail = NULL; /* ATӦβ */
    int iSubAtStrLen = ZAT_INVALID_LEN; /* ATӦӴ */
    int iFreeDataLen = ZAT_INVALID_LEN; /* δATӦݳ */

    if ((pCurAtStr == NULL) || (pSubAtStr == NULL))
    {
        return ZAT_INVALID_LEN;
    }

    /* ATӦATӦʼ"\r\n" */
    iFreeDataLen = iDataLen - (pCurAtStr - atRecvBuf);
    pAtHead = find_sub_str(pCurAtStr, "\r\n", iFreeDataLen);
    if (pAtHead == NULL)
    {
        return ZAT_INVALID_LEN;
    }
    if(pAtHead != pCurAtStr)
    {
        pAtTail = pAtHead;
        pAtHead = pCurAtStr;
    }
    else
    {
        /* ATӦATӦ"\r\n" */
        pAtHead += 2;
        iFreeDataLen = iDataLen - (pAtHead - atRecvBuf);
        pAtTail = find_sub_str(pAtHead, "\r\n", iFreeDataLen);
        if (pAtTail == NULL)
        {
            if (strlen(pAtHead) == 0)
            {
                return ZAT_INVALID_LEN;
            }
            else
            {
                pAtTail = pAtHead + strlen(pAtHead);
            }
        }
    }
    /* ȡ"\r\n"֮ATӦ */
    iSubAtStrLen = pAtTail - pAtHead;
    if ((iSubAtStrLen > 0) && (iSubAtStrLen < REPLY_DATA_BUF_MAX_LEN))
    {
        memcpy(pSubAtStr, pAtHead, (UINT32)iSubAtStrLen);
        return iSubAtStrLen;
    }

    return iSubAtStrLen == 0? 0 : ZAT_INVALID_LEN;
}

/**
 * @brief жǷATĽβַβ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
int is_at_cmd_end(const char * pstrAtCmd)
{
    if('\0' == *pstrAtCmd)
    {
        return TRUE;
    }
    if('\r' == *pstrAtCmd)
    {
        return TRUE;
    }
    return FALSE;
}

/*ַĿո񣬷ȥͷпոַ*/
const char * skip_at_cmd_head_blanks(const char * pstrAtCmd)
{
    const char * pstrCur = pstrAtCmd;

    for(; !is_at_cmd_end(pstrCur); pstrCur++)
    {
        if(' ' != *pstrCur)
        {
            break;
        }
    }
    return pstrCur;
}

/**
 * @brief Ƶһ
 * @param 
 * @return 
 * @note   Ƿ񵽽ûнŲԵǰĿո
 * @warning 
 */
E_AT_PARSE move_to_next_param(const char * pstrAtCmd, const char ** ppstrNextParam)
{
    const char * pstrCur = pstrAtCmd;

    if(NULL == pstrCur || NULL == ppstrNextParam)
    {
        return AT_PARSE_ERR_INPUT;
    }
    pstrCur = skip_at_cmd_head_blanks(pstrCur);
    if(is_at_cmd_end(pstrCur))
    {
        return AT_PARSE_ERR_ATEND;
    }
    if(',' != *pstrCur)
    {
        return AT_PARSE_ERR_FORMAT;
    }
    pstrCur++;
    *ppstrNextParam = skip_at_cmd_head_blanks(pstrCur);
    return AT_PARSE_SUCCESS;
}

/**
 * @brief ȡintͲ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
E_AT_PARSE get_at_cmd_param_int(const char * pstrAtCmd, int * piParam, const char ** ppstrNext)
{
    const char * pstrNext = pstrAtCmd;

    if(NULL == pstrNext || NULL == piParam)
    {
        return AT_PARSE_ERR_INPUT;
    }
    pstrNext = skip_at_cmd_head_blanks(pstrAtCmd);
    set_next_param(ppstrNext, pstrNext);
    if(',' == *pstrNext || is_at_cmd_end(pstrNext))
    {
        return AT_PARSE_NO_PARAM;
    }
    if(!isdigit(*pstrNext))
    {
        return AT_PARSE_ERR_FORMAT;
    }
    pstrNext = extract_int(pstrNext, piParam);
    set_next_param(ppstrNext, pstrNext);
    if(' ' == *pstrNext || ',' == *pstrNext || is_at_cmd_end(pstrNext))
    {
        return AT_PARSE_SUCCESS;
    }
    else if(isdigit(*pstrNext))
    {
        return AT_PARSE_ERR_TOOLONG;
    }
    else
    {
        return AT_PARSE_ERR_FORMAT;
    }
}

/**
 * @brief ȡַͲ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
E_AT_PARSE get_at_cmd_param_str(const char * pstrAtCmd, char * pstrParam, int iPramLen, const char ** ppstrNext)
{
    int iPramRealLen = 0;
    const char *pstrCur = pstrAtCmd;
    const char *pstrNext = NULL;

    if(NULL == pstrCur || NULL == pstrParam || 0 == iPramLen)
    {
        set_next_param(ppstrNext, pstrCur);
        return AT_PARSE_ERR_INPUT;
    }
    pstrNext = skip_at_cmd_head_blanks(pstrCur);
    set_next_param(ppstrNext, pstrNext);
    if(is_at_cmd_end(pstrNext))
    {
        return AT_PARSE_ERR_ATEND;
    }
    if(',' == *pstrNext)
    {
        return AT_PARSE_NO_PARAM;
    }
    if('"' != *pstrNext)
    {
        return AT_PARSE_ERR_FORMAT;
    }
    pstrNext = skip_str(++pstrCur); // ++pCurͷ"
    set_next_param(ppstrNext, pstrNext);
    if('"' != *pstrNext)
    {
        return AT_PARSE_ERR_FORMAT;
    }
    iPramRealLen = pstrNext - pstrCur;
    set_next_param(ppstrNext, ++pstrNext); // ++pNextβ"
    if(iPramRealLen >= iPramLen)
    {
        return AT_PARSE_ERR_TOOLONG;
    }
    if(iPramRealLen > 0)
    {
        memset(pstrParam, 0, iPramLen);
        iPramRealLen = (iPramLen>iPramRealLen)?iPramRealLen:(iPramLen-1);
        memcpy(pstrParam, pstrCur, iPramRealLen);
    }
    return AT_PARSE_SUCCESS;
}


/**
 * @brief ATǰ׺Ϣʶǰ׺ݼAT
 * @param 
 * @return 
 * @return 
 * @note   
 * @note  ҪԸⳡ̷ֱ:
			?ָat
			=ָat
			:ָat
			/rָat
 
			ڲĸ뵥:
				ERROR:ǰ׺+
				ERROR:ǰ׺
				OK:ǰ׺
				ZMRSI:ǰ׺
				"> "ǷҲǰ׺
				PDUϢ:вûǰ׺
 *
 * @warning 
 */
int parase_at_cmd(char *at_str, void **at_cmd_prefix, int* prefix_len, void ** at_cmd_paras, int * paras_len)
{
    char *pszAtHead = NULL;
    char *pstrCur = NULL;
    char *ptemstr = NULL;
    int iNum = -1;
    char *pstr = NULL;
    int isRequest = 0;

    //at_print(AT_DEBUG,"parase_at_cmd at_str = %s\n",at_str);

	//pstrCur=at_str;
	pstrCur = (char *)skip_at_cmd_head_blanks(at_str);  
    if((*pstrCur == 'A'||*pstrCur == 'a')&&(*(pstrCur+1) == 'T'||*(pstrCur+1) == 't'))
    {
        isRequest=1;
        if(isalpha(*(pstrCur+2)))
        {
            *at_cmd_prefix = pstrCur;
            *prefix_len = 3;
            *at_cmd_paras = pstrCur+3;
            *paras_len = strlen(pstrCur+3);
            //at_print(AT_DEBUG,"1 prefixlen=%d paralen=%d prefix= %s\n",*prefix_len, *paras_len, (char *)*at_cmd_prefix);
            return AT_TYPE_REQUEST;
        }
    }
    if(!isRequest && (pstr = find_special_prefix_cmd(pstrCur, &iNum)) != NULL)
    {
        *at_cmd_prefix = pstr;
        *prefix_len = strlen(ATCMEERRCODE[iNum].pprefixStr);
        if(strlen(pstr) == *prefix_len)
        {
            *at_cmd_paras = NULL;
            *paras_len = 0;
        }
        else
        {
            *at_cmd_paras = (char *)skip_at_cmd_head_blanks(pstr+*prefix_len);
            *paras_len = strlen(*at_cmd_paras);
        }
        //at_print(AT_DEBUG,"2 prefixlen=%d paralen=%d prefix= %s\n",*prefix_len, *paras_len, (char *)*at_cmd_prefix);
        return ATCMEERRCODE[iNum].at_cmd_type;
    }
    pszAtHead = pstrCur;
    //ҵ׸ĸֵĲ+
    for(; *pstrCur != '\0'; pstrCur++)
    {
        if(!(isalnum(*pstrCur) || *pstrCur == '\r' || *pstrCur == '\n'))
        {
            pszAtHead = pstrCur;
            pszAtHead++;
            break;
        }
    }
    if(isRequest)
    {

        if((ptemstr = strchr(pszAtHead, '=')) != NULL)//=Һ治?
        {
            if(*(ptemstr+1) != '?')
            {
                *at_cmd_prefix = pszAtHead;
                *prefix_len = (int)(ptemstr-pszAtHead+1);
                *at_cmd_paras = (char *)skip_at_cmd_head_blanks(++ptemstr);
                *paras_len = strlen(*at_cmd_paras);
                //at_print(AT_DEBUG,"3 prefixlen=%d paralen=%d prefix= %s\n",*prefix_len, *paras_len, (char *)*at_cmd_prefix);
                return AT_TYPE_REQUEST;
            }
            else
            {
                *at_cmd_prefix = pszAtHead;
                *prefix_len = (int)(ptemstr-pszAtHead+2);
                *at_cmd_paras = NULL;
                *paras_len = 0;
                //at_print(AT_DEBUG,"4 prefixlen=%d paralen=%d prefix= %s\n",*prefix_len, *paras_len, (char *)*at_cmd_prefix);
                return AT_TYPE_REQUEST;
            }
        }
        else if((ptemstr = strchr(pszAtHead, '?')) != NULL)//?Լ=?
        {
            *at_cmd_prefix = pszAtHead;
            *prefix_len = (int)(ptemstr-pszAtHead+1);
            *at_cmd_paras = NULL;
            *paras_len = 0;
            //at_print(AT_DEBUG,"5 prefixlen=%d paralen=%d prefix= %s\n",*prefix_len, *paras_len, (char *)*at_cmd_prefix);
            return AT_TYPE_REQUEST;
        }
		else if((ptemstr = strchr(pszAtHead, '\r')) != NULL)//ڲclientִ
        {
            *at_cmd_prefix = pszAtHead;
            *prefix_len = (int)(ptemstr-pszAtHead);
            *at_cmd_paras = NULL;
            *paras_len = 0;
            //at_print(AT_DEBUG,"6 prefixlen=%d paralen=%d prefix= %s\n",*prefix_len, *paras_len, (char *)*at_cmd_prefix);
            return AT_TYPE_REQUEST;
        }
        else
        {
        	if(*pszAtHead == '\0')//ѾַĩβַΪǰ׺
        	{
				*at_cmd_prefix = at_str;
	            *prefix_len = strlen(at_str);
	            *at_cmd_paras = NULL;
	            *paras_len = 0;
        	}
			else
			{
	            *at_cmd_prefix = pszAtHead;
	            *prefix_len = strlen(pszAtHead);
	            *at_cmd_paras = NULL;
	            *paras_len = 0;
			}
            //at_print(AT_DEBUG,"7 prefixlen=%d paralen=%d prefix= %s\n",*prefix_len, *paras_len, (char *)*at_cmd_prefix);
            return AT_TYPE_REQUEST;
        }
    }
	if((ptemstr = at_strstr(pszAtHead, "CME ERROR:")) != NULL || (ptemstr = at_strstr(pszAtHead, "CMS ERROR:")) != NULL || (ptemstr = at_strstr(pszAtHead, "ERROR:")) != NULL)
	{
		*at_cmd_prefix = ptemstr;
		*prefix_len = strchr(ptemstr,':')-ptemstr+1;
		*at_cmd_paras = (char *)skip_at_cmd_head_blanks(ptemstr+*prefix_len);
		*paras_len = strlen(*at_cmd_paras);
		//at_print(AT_DEBUG,"8 prefixlen=%d paralen=%d prefix= %s\n",*prefix_len, *paras_len, (char *)*at_cmd_prefix);
		return AT_TYPE_RESPONSE;
	}
    if((ptemstr = strchr(pszAtHead, ':')) != NULL)
    {
        *at_cmd_prefix = pszAtHead;
        *prefix_len = (int)(ptemstr-pszAtHead);
        *at_cmd_paras = (char *)skip_at_cmd_head_blanks(++ptemstr);
        *paras_len = strlen(*at_cmd_paras);
        //at_print(AT_DEBUG,"9 prefixlen=%d paralen=%d prefix= %s\n",*prefix_len, *paras_len, (char *)*at_cmd_prefix);
        return AT_TYPE_INFORM;
    }
	if(at_strstr(pszAtHead, "ZT10DEREG") != NULL)
	{
		*at_cmd_prefix = pszAtHead;
        *prefix_len = strlen(pszAtHead);
        *at_cmd_paras = NULL;
        *paras_len = 0;
        //at_print(AT_DEBUG,"10 prefixlen=%d paralen=%d prefix= %s\n",*prefix_len, *paras_len, (char *)*at_cmd_prefix);
        return AT_TYPE_INFORM;
	}
    if(at_strstr(pszAtHead, "ERROR") != NULL)
    {
        *at_cmd_prefix = pszAtHead;
        *prefix_len = strlen(pszAtHead);
        *at_cmd_paras = NULL;
        *paras_len = 0;
        //at_print(AT_DEBUG,"10 prefixlen=%d paralen=%d prefix= %s\n",*prefix_len, *paras_len, (char *)*at_cmd_prefix);
        return AT_TYPE_RESPONSE;
    }
    if(strstr(at_str, "> ") != NULL)
    {
        *at_cmd_prefix = pstrCur;
        *prefix_len = strlen(pstrCur);
        *at_cmd_paras = NULL;
        *paras_len = 0;
        //at_print(AT_DEBUG,"11 prefixlen=%d paralen=%d prefix= %s\n\n",*prefix_len, *paras_len, (char *)*at_cmd_prefix);
        return AT_TYPE_INFORM;
    }
    if(strstr(at_str, "0") != NULL)
    {
        *at_cmd_prefix = NULL;
        *prefix_len = 0;
        *at_cmd_paras = at_str;   
        *paras_len = strlen(at_str);
        //at_print(AT_DEBUG,"12 prefixlen=%d paralen=%d prefix= NULL\n",*prefix_len, *paras_len);
        return AT_TYPE_PDU;
    }
    else
    {
        *at_cmd_prefix = at_str;
        *prefix_len = strlen(at_str);
        *at_cmd_paras = NULL;
        *paras_len = 0;
        //at_print(AT_DEBUG,"13 prefixlen=%d paralen=%d prefix= %s\n",*prefix_len, *paras_len, (char *)*at_cmd_prefix);
        return AT_TYPE_INFORM;
    }
}


#if (APP_OS_TYPE == APP_OS_LINUX)
int at_sys_write(int fd,char *buf,int len)
{
	int resendcnt = 0;
	int written_bytes = 0; 
	int left_len = len;
	char *pstr = buf;
	struct at_channel_info * at_chan = at_context_find_chn_by_fd(fd);
	while(left_len > 0)
	{
		written_bytes = write(fd, pstr, left_len);	
		if(written_bytes <= 0)
		{
			resendcnt++;
			//˼ͨдʧܣط
			if(at_chan && at_chan->attribution & (1<<CH_COMM))
			{	
				if(resendcnt > 10)
				{
					softap_assert("at_write AP and CP fail!");
				}
				else
				{
					usleep(100 * 1000 * resendcnt);
				}	
				continue;
			}
			else
			{
				//дʧ
				if(errno == EINTR || errno == EAGAIN)//жϴ󣬼д
					written_bytes = 0;
				else
					return -errno;
			}
		}
		left_len -=written_bytes;
		pstr += written_bytes;
		if(resendcnt > 10)
		{
			at_print(AT_ERR,"at_sys_write fd=%d len=%d left=%d curr=%d err_no=%d \n", fd, len, left_len, written_bytes, errno);
			return len - left_len;
		}
		if(left_len > 0)
		{
			usleep(100 * 1000);
		}
	}
	return len;
}

static int at_transform_write(int fd,char *buf,int len)
{
	char *ptemstr = NULL;
	char *write_buf = buf;
	
	assert(buf);
	if(g_atq == 0 && g_atv == 0)//Ҫתԭʼ
	{
		return at_sys_write(fd, buf, len);
	}
	if(g_atv != 0 && strncmp(buf, "\r\n", 2) == 0)
	{
		write_buf = buf + 2;
	}
	if((ptemstr = at_strstr(buf, "\r\n+CME ERROR:")) != NULL 
		|| (ptemstr = at_strstr(buf, "\r\n+CMS ERROR:")) != NULL 
		|| (ptemstr = at_strstr(buf, "\r\nERROR")) != NULL 
		|| (ptemstr = at_strstr(buf, "\r\nOK")) != NULL)
	{
		int write_len = ptemstr - write_buf;
		int ret = 0;
		
		if(write_len > 0)//ǵӦ
		{
			//ȰӦǰݷȥ
			ret = at_sys_write(fd, write_buf, write_len);
			if(ret < 0)
				return ret;
		}
		if(g_atq != 0)
		{
			return ret;
		}
		if(g_atv != 0)
		{
			int ret1 = 0;
			
			if(at_strstr(buf, "\r\nOK") != NULL)
			{
				ret1 = at_sys_write(fd, "0\r", 2);
			}
			else
			{
				ret1 = at_sys_write(fd, "4\r", 2);
			}
			if(ret1 < 0)
				return ret1;
			return ret + ret1;
		}
	}
	return at_sys_write(fd, write_buf, strlen(write_buf));
}

//дĳATͨתATϽڵײãϲͨfwd_all_at_str(fwd_fd,whole_cmd_str);ʽдͨ
int at_write(int fd,char *buf,int len)
{
	if(fd != g_ppp_ttyfd && fd != g_ppp_ptm)//pppʱ򣬲¼
    	save_monitor_at_buf(fd, buf, len, AT_SEND_TYPE);
    //ʵʱΪϢʽģIDΪϢϲӦ
    if(0 == check_is_fd(fd))
    {
		struct at_channel_info * at_chan = at_context_find_chn_by_fd(fd);
        //ƽ̨Ķ̬ϢͨظӦ̬ͷϢͨ
        if(at_chan && at_chan->is_xinke_msg == 0)
        {
            //յӦʱ̬ͷŸϢͨ
            if((at_strstr(buf, "ERROR") != NULL) || (at_strstr(buf, "OK") != NULL))
            {
                del_channel_info(fd,FAR_PS);
            }
            if (0 == ipc_send_message(MODULE_ID_AT_CTL, fd, MSG_CMD_SEND_AT_MSG_RSP, len, (unsigned char *)buf, 0))
				return len;
			else
				return -1;
        }
        //ſɶƵϢͨ
        else 
		{
			int plen = len;
			int poffset = 0;
			int psend = MSG_DATA_MAX_LEN - 4;
			
			while(plen > 0) {
				if(plen >= psend) { 	
					if (0 != ipc_send_message(MODULE_ID_AT_CTL, fd, MSG_CMD_SEND_ATRSP_BY_MSG, psend, (unsigned char *)(buf+poffset), 0))			
						return -1;
					else {
						plen -= psend;
						poffset += psend;
					}
				}
				else {
					if (0 == ipc_send_message(MODULE_ID_AT_CTL, fd, MSG_CMD_SEND_ATRSP_BY_MSG, plen, (unsigned char *)(buf+poffset), 0))			
						return len; 		
					else 
						return -1;
				}
			}	
			return len;
        }
		
    }
	else if((fd >= MODULE_ID_ATCTL_TO_VOLTE && fd < MODULE_ID_ATCTL_TO_VOLTE+VOLTE_PTY1_MAX)
		|| (fd >= MODULE_ID_VOLTE_TO_ATCTL && fd < MODULE_ID_VOLTE_TO_ATCTL+VOLTE_PTY2_MAX))
	{
#ifdef _USE_VOLTE
		int ret = -1;
		int snd_len = 0;
		VOLTE_MSG_DATA volte_msg;
		msgget(MODULE_ID_VOLTE, IPC_CREAT | 0600);
		if(len >= sizeof(volte_msg.msg_data))//if(len >= MSG_DATA_MAX_LEN)
		{
			snd_len = sizeof(volte_msg.msg_data) - 1;			
		}
		else
		{
			snd_len = len;
		}

		memset(&volte_msg, 0x00, sizeof(VOLTE_MSG_DATA));
		memcpy(volte_msg.msg_data, buf, snd_len);
		volte_msg.msg_len = snd_len;
		if(fd >= MODULE_ID_ATCTL_TO_VOLTE && fd < MODULE_ID_ATCTL_TO_VOLTE+VOLTE_PTY1_MAX)
		{
			volte_msg.at_fd = fd - MODULE_ID_ATCTL_TO_VOLTE+1;		
			ret = ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_VOLTE, MSG_CMD_FD1_ATCTL_TO_VOLTE, volte_msg.msg_len+sizeof(VOLTE_MSG_DATA_HEAD), (unsigned char *)&volte_msg, IPC_NOWAIT);
			at_print(AT_ERR,"====>FD1_ATCTL_TO_VOLTE len=%d str=%s\n", len, get_small_str(buf));
			while(ret == 0 && snd_len < len)
			{/*û*/
				int next_len = 0;
				if((len - snd_len) >= sizeof(volte_msg.msg_data))
				{
					next_len = sizeof(volte_msg.msg_data) - 1;
				}
				else
				{
					next_len = len - snd_len;
				}
				memset(volte_msg.msg_data, 0x00, sizeof(volte_msg.msg_data));
				memcpy(volte_msg.msg_data, buf+snd_len, next_len);
				volte_msg.msg_len = next_len;
				ret = ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_VOLTE, MSG_CMD_FD1_ATCTL_TO_VOLTE, volte_msg.msg_len+sizeof(VOLTE_MSG_DATA_HEAD), (unsigned char *)&volte_msg, IPC_NOWAIT);
				at_print(AT_ERR,"====>FD1_ATCTL_TO_VOLTE+%d str=%s\n", snd_len, get_small_str(buf+snd_len));
				snd_len = snd_len + next_len;
			}
			if(ret < 0 && ((strstr(volte_msg.msg_data, "ERROR") != NULL) || (strstr(volte_msg.msg_data, "OK") != NULL)))
				ret = ipc_send_message2(MODULE_ID_AT_CTL, MODULE_ID_VOLTE, MSG_CMD_FD1_ATCTL_TO_VOLTE, volte_msg.msg_len+sizeof(VOLTE_MSG_DATA_HEAD), (unsigned char *)&volte_msg, 0);
		}
		else
		{
			volte_msg.at_fd = fd - MODULE_ID_VOLTE_TO_ATCTL+1;
						
			ret = ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_VOLTE, MSG_CMD_FD2_ATCTL_TO_VOLTE, volte_msg.msg_len+sizeof(VOLTE_MSG_DATA_HEAD), (unsigned char *)&volte_msg, IPC_NOWAIT);
			at_print(AT_ERR,"====>FD2_ATCTL_TO_VOLTE len=%d str=%s, fd=%d\n", len, get_small_str(buf), volte_msg.at_fd);
			while(ret == 0 && snd_len < len)
			{/*û*/
				int next_len = 0;
				if((len - snd_len) >= sizeof(volte_msg.msg_data))
				{
					next_len = sizeof(volte_msg.msg_data) - 1;			
				}
				else
				{
					next_len = len - snd_len;
				}
				memset(volte_msg.msg_data, 0x00, sizeof(volte_msg.msg_data));
				memcpy(volte_msg.msg_data, buf+snd_len, next_len);
				volte_msg.msg_len = next_len;
				ret = ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_VOLTE, MSG_CMD_FD2_ATCTL_TO_VOLTE, volte_msg.msg_len+sizeof(VOLTE_MSG_DATA_HEAD), (unsigned char *)&volte_msg, IPC_NOWAIT);
				at_print(AT_ERR,"====>FD2_ATCTL_TO_VOLTE+%d str=%s\n", snd_len, get_small_str(buf+snd_len));
				snd_len = snd_len + next_len;
			}
			if(ret < 0 && ((strstr(volte_msg.msg_data, "ERROR") != NULL) || (strstr(volte_msg.msg_data, "OK") != NULL)))
				ret = ipc_send_message2(MODULE_ID_AT_CTL, MODULE_ID_VOLTE, MSG_CMD_FD2_ATCTL_TO_VOLTE, volte_msg.msg_len+sizeof(VOLTE_MSG_DATA_HEAD), (unsigned char *)&volte_msg, 0);
		}
		return (ret == 0)?len:-1;	
#else
		return len;
#endif
	}

	//return write(fd, buf, len);
	return at_transform_write(fd, buf, len);
}
#endif

/**
 * @brief ʮƺʮƵַתʮ
 * @param sStr ַ
 * @param DorH  TRUE ʮ  FALSE ʮ
 * @param pValue תʮ
 * @return TRUE ɹ  
 * @return FALSE ʧ
 * @note   
 * @warning 
 */
BOOL trans_Str2Value(CHAR *sStr , BOOL DorH, UINT32 * pValue)
{
    UINT8 i = 0;
    UINT8 j = 0;             /* ѭñ */
    UINT8 totalLen = 0;      /* ֵַ󳤶 */
    UINT8 carry = 0;         /* λֵ */
    UINT8 sTemp[10] = {0};   /* ŵַӦֵ */
    UINT32 iValTmp = 0;      /* תֵ */

    if (sStr == NULL || pValue == NULL)
    {
        return FALSE;
    }

    /* ͬȵ10ַ16ַ󳤶Ⱥͽλֵͬ FFFFFFFF--4294967295*/
    totalLen = (DorH? 10 : 8);
    carry = (DorH? 10 : 16);/*10ַ16ַ*/

    /* λַΧ,,򽫵ַתΪӦֵ,ݴ;
       ʧ,ѭ */
    for (i = 0; (*(sStr+i) != 0) && (i < totalLen); i++)
    {
        if ((*(sStr+i) >= '0') && (*(sStr+i) <= '9'))
        {
            *(sTemp+i) = *(sStr+i) - '0';
        }
        else if ((ATI_UPCASE(*(sStr+i)) >= 'A') && (ATI_UPCASE(*(sStr+i)) <= 'F') && (!DorH))
        {
            *(sTemp+i) = ATI_UPCASE(*(sStr+i)) - 'A' + 10;
        }
        else
        {
            return FALSE;
        }
    }

    /* ûг4ֵַֽ󳤶ȣ
       򽫵ֵַӸλλ˳λۼ */
    iValTmp = sTemp[0];
    for(j = 0; j < i-1; j++)
    {
        if (iValTmp * carry <= 0xffffffff - sTemp[j + 1])
        {
            iValTmp = iValTmp * carry + sTemp[j + 1];
        }
    }

    *pValue = iValTmp;

    return TRUE;
}

/*ͨUNIX׽ַݵzte_socketӦý*/
int unix_send_proc(int sockfd, int dst_id, unsigned short Msg_cmd, unsigned short us_DataLen, unsigned char *pData, int msgflag)
{
#if (APP_OS_TYPE == APP_OS_LINUX)
    //struct sockaddr_un addr;
    //static int sockfd = -1;
    int len;
    int ret;
    
    MSG_BUF stMsg;
	long errNo = 0;
	
    memset(&stMsg, 0, sizeof(MSG_BUF));

    if(us_DataLen >= MSG_DATA_MAX_LEN)
    {
        slog(NET_PRINT,SLOG_ERR, "send_message failed:us_DataLen %d is too big! \n", us_DataLen);/*lint !e26*/
		softap_assert("send_message failed:us_DataLen %d is too big!", us_DataLen);
        return -1;
    }
    
    if((us_DataLen > 0) && (NULL == pData))
    {
        slog(NET_PRINT,SLOG_ERR, "send_message failed:us_DataLen is %d,but pData is NULL! \n", us_DataLen);/*lint !e26*/
		softap_assert("send_message failed:us_DataLen is %d,but pData is NULL!", us_DataLen);
        return -1;
    }

      
    /*if(sockfd == -1)
    {
        sockfd = socket(PF_UNIX, SOCK_STREAM, 0);
        if(sockfd < 0)
        {
            printf("socket failed : %s!\r\n", strerror(errno));
            return -1;
        }
        addr.sun_family = AF_UNIX;
        strcpy(addr.sun_path, UNIX_SOCKET_SERVER);
        len = sizeof(addr);

        ret = connect(sockfd, (struct sockaddr *)&addr, len);
        if(ret < 0)
        {
            printf("connect failed : %s!\r\n", strerror(errno));
            close(sockfd);
            sockfd = -1;
            return -1;
        }
    }*/
    stMsg.ulMagic = MSG_MAGIC_WORD;
    stMsg.lMsgType = MSG_TYPE_DEFAULT;
    stMsg.src_id = MODULE_ID_AT_CTL;
    stMsg.dst_id = dst_id;
    stMsg.usMsgCmd = Msg_cmd;
    stMsg.usDataLen = us_DataLen;
    
    if(us_DataLen > 0)
    {
        memcpy(stMsg.aucDataBuf, pData, us_DataLen);
    }  
send_again:
    len = send(sockfd, &stMsg, sizeof(stMsg), 0);
    if(len < 0)
    {
        if(errno == EINTR || errno == EWOULDBLOCK || errno == EAGAIN)
			goto send_again;
        else
        {
            printf("unix_send_proc: send failed: errno=%d, %s\r\n", errno, strerror(errno));        
            close(sockfd);
            sockfd = -1;
            return -1;
        }
    }
    else if(len == 0)
    {
		printf("unix_send_proc: send 0 data errno=%d, %s \n", errno, strerror(errno));
    }
#endif
    return 0;
}

