#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <getopt.h>
#include <time.h>
#include <wifi_msg.h>
#include "softap_api.h"


#include "wifi_sta_ctrl.h"
#include "wifi_util.h"
/*
static char * g_short_string = "u:b:s:d:h";

static struct option g_long_options[] = {
	{"upgrade",   		required_argument,	NULL,	'u'},
	{"boot",    		required_argument,	NULL,	'b'},
	{"status",   		required_argument,	NULL,	's'},
	{"debug",   		required_argument,	NULL,	'd'},
	{"help",			no_argument,		NULL,	'h'},
};

static option_handle_t g_option_handle[] = {
	{'u',		excute_command_upgrade},
	{'b',		excute_command_boot},
	{'s',		excute_command_status},
	{'d',		excute_command_debug},
	{'h',		excute_command_help}
};

*/

int  msg_queue_id = 0;
scan_result_t  g_scan_spot_list[60];
int g_spot_cur_num = 0;
void usage (void)
{
	printf ("cmd list: "
			"  open		open wifi\n"
			"  close	close wifi\n"
			"  results	display the scan results\n"
	         "  mmi		display scan list to simulate watch mmi\n"
	         "  help	dispaly this message\n"
             "  scan	send scan cmd\n"			 
             "  conn	connect the ap specified by the index of scan list ,and need input the password\n"			 
	         "  forget	disconnect and forget the ap\n"
	         "  dump	dump the content of the global variable in wlan_manager\n"
	         "  cmd 	you can send a wpa_supplicant cmd directly\n");
}

static scan_result_t* parse_spot_string(scan_result_t *spot, char *spot_string)
{
	char *splited_string = NULL;
	char *save = NULL;
	const char *delimiter = ",";
	scan_content_t scan_content = WIFI_STATION_AP_CONTENT_UNDEFINED;
	char spot_string_tmp[256] = {0};

	if (spot_string == NULL) {
		return NULL;
	}

	safe_strcpy(spot_string_tmp, spot_string, 256);

	//ַָ洢ṹ
	splited_string = strtok_r(spot_string_tmp, delimiter, &save);

//	wf_log("%s", splited_string);
	while (splited_string) {
		scan_content++;
		switch (scan_content) {
		case WIFI_STATION_AP_MAC:
			safe_strcpy(spot->mac, splited_string, WIFI_STATION_MAC_LEN);
			break;
		case WIFI_STATION_AP_SSID:
			safe_strcpy(spot->ssid, splited_string, WIFI_STATION_SSID_LEN);
			break;		
		case WIFI_STATION_AP_AUTH_MODE:
			safe_strcpy(spot->auth_mode, splited_string, WIFI_STATION_AUTH_MODE_LEN);
			break;
		case WIFI_STATION_AP_ENCRYPT_TYPE:
			safe_strcpy(spot->encrypt_type, splited_string, WIFI_STATION_ENCRYPT_TYPE_LEN);
			break;
		case WIFI_STATION_AP_CHANNEL:
			spot->channel = atoi(splited_string);
			break;
		case WIFI_STATION_AP_SIGNAL:
			spot->signal = atoi(splited_string);
			break;
		case WIFI_STATION_AP_CONNECT_STATUS:
			spot->connect_status = atoi(splited_string);
			break;
		case WIFI_STATION_AP_NETWORK_ID:
			spot->network_id = atoi(splited_string);
			break;
		default:
			break;
		}

		splited_string = strtok_r(NULL, delimiter, &save);
//		wf_log("%s", splited_string);
	}

	if (scan_content != WIFI_STATION_AP_NETWORK_ID) {
		return NULL;
	}

	return spot;

}

static void parse_scan_result(char *aplist,char* aplist1)
{
	char *splited_string = NULL;
	char *save = NULL;
	const char *delimiter = ";";
	char spot_string_tmp[2048+2] = {0};// nv Դ洢1024 byte
	int index = 0;
	if (aplist == NULL) {
		return;
	}
	if(strlen(aplist)>0){
		safe_strcpy(spot_string_tmp, aplist, sizeof(spot_string_tmp));
		if(strlen(aplist1)>0){
			strcat(spot_string_tmp, ";");
			strcat(spot_string_tmp, aplist1);
		}
	}
	else{
		return;
	}

	//ַָ洢ṹ
	splited_string = strtok_r(spot_string_tmp, delimiter, &save);
//	wf_log("profile=%s", splited_string);
	while (splited_string) {
		parse_spot_string(&g_scan_spot_list[index], splited_string);
		index++;
		splited_string = strtok_r(NULL, delimiter, &save);
//		wf_log("profile=%s", splited_string);
	}

	g_spot_cur_num = index;

}

static void set_spot_state(msg_act_spot_t *mas)
{
	int i = 0;
	spot_action_t  action = mas->act;
	for(i = 0; i< g_spot_cur_num; i++ ){
		if( strcmp(g_scan_spot_list[i].mac, mas->mac) ==0){
			if(SAVE_ACTION == action){
				g_scan_spot_list[i].network_id = mas->network_id;
			}
			else if(DEL_ACTION == action)
				g_scan_spot_list[i].network_id = -1;
			else if(CONNECTING_ACTION == action)
				g_scan_spot_list[i].connect_status = CONNECTING_STATUS;
			else if(DHCPING_ACTION == action)
				g_scan_spot_list[i].connect_status = DHCPING_STATUS;
			else if(CONNECTED_ACTION == action)
				g_scan_spot_list[i].connect_status = CONNECTED_STATUS;
			else if(DISCONNECT_ACTION == action)
				g_scan_spot_list[i].connect_status = DISCONNECT_STATUS;
			
			break;
		}
	}
}


static void process_msg(MSG_BUF *pMsg)
{
	switch (pMsg->usMsgCmd) {
		case   MSG_CMD_WIFI_STATION_INDICATE_SCAN_RESULTS:
		{
			if(pMsg->usDataLen ==0){
				char aplist[1025]={0};
				char aplist1[1025]={0};
				sc_cfg_get("EX_APLIST", aplist, 1024);
				sc_cfg_get("EX_APLIST1", aplist1, 1024);
				parse_scan_result(aplist,aplist1);
			}
			else
			{
				msg_act_spot_t *mas = (msg_act_spot_t *)pMsg->aucDataBuf;
				set_spot_state(mas);
			}
			break;
		}
		default:
			break;
	}

}

void dump_spot_list()
{
	int i = 0;
	printf("%-8s%-24s%-32s%-16s%-8s%-8s%-8s\n","Index","MAC","SSID","CHANNEL","SIGNAL","ID","State");
	for(i = 0; i< g_spot_cur_num; i++){
		scan_result_t  *spot = &g_scan_spot_list[i];
		printf("%-8d%-24s%-32s%-16d%-8d%-8d%-8s\n",i, spot->mac, spot->ssid,spot->channel, 
		spot->signal,spot->network_id, spot->connect_status==CONNECTED_STATUS?"O":"x");
	}
}
void dump_conn_ap(spot_t *conn_ap)
{
	printf("mac=%s\n",conn_ap->mac);
	printf("ssid=%s\n",conn_ap->ssid);
	printf("auth_mode=%s\n",conn_ap->auth_mode);
	printf("encrypt_type=%s\n",conn_ap->encrypt_type);
	printf("password=%s\n",conn_ap->password);
	printf("network_id=%d\n",conn_ap->network_id);
}
int mmi_display_loop = 0;



static void *mmi_loop (void *param)
{
	MSG_BUF wlanMsg ={0};
	char name[32] = {0};
	int ret = -1;

	strcpy (name, (char*) param);
	prctl (PR_SET_NAME, name, 0, 0, 0);

	while (1) { 
		if(0 == mmi_display_loop)break;
		dump_spot_list();
		sleep(1);
		printf("\033[2J");//clear screen
		printf("\033[0;0H");//locate cursor to head
	}

	return NULL;
}
void mmi_display()
{
	mmi_display_loop = 1;

	wf_create_thread ("mmi_loop", mmi_loop);

	while(1){
		char cmd;
		scanf("%c", &cmd);
		if(cmd == 'q'){
			mmi_display_loop = 0;
			break;
		}
	}
	
	return;
}

static void *station_loop (void *param)
{
	MSG_BUF wlanMsg ={0};
	char name[32] = {0};
	int ret = -1;

	strcpy (name, (char*) param);
	prctl (PR_SET_NAME, name, 0, 0, 0);

	while (1) { 
		memset (&wlanMsg, 0, sizeof (MSG_BUF));
		ret = msgrcv (msg_queue_id, &wlanMsg, sizeof (MSG_BUF) - sizeof (LONG), 0, 0);
		if (ret == -1) {
			continue;
		}
		process_msg (&wlanMsg);
		
	}

	return NULL;
}


int main (int argc, char *argv[])
{
	int c=0;
	int iRet = -1;
	char cmd[128]={0};
	
	msg_queue_id = wf_create_msg_qid (MODULE_ID_WLAN_SERVER);
	wf_create_thread ("wlan-mmi", station_loop);
	printf("rda_mmi v1.0\n"
		"please use results, conn, disc three cmd to control it\n\n");
	
	for (;;) {

		printf(">>");
		scanf("%s", cmd);

		if(!strcmp(cmd, "open")){
			wf_msg_to_self(MSG_CMD_WIFI_STATION_OPEN, 0, NULL);
		}
		else if(!strcmp(cmd, "close")){
			wf_msg_to_self(MSG_CMD_WIFI_STATION_CLOSE, 0, NULL);
		}
		else if(!strcmp(cmd, "results")){
			dump_spot_list();
		}
		else if(!strcmp(cmd, "scan")){
			wf_msg_to_self(MSG_CMD_WIFI_STATION_SCAN, 0, NULL);
		}
		else if(!strcmp(cmd, "conn")){
			int num = 0;
			char pwd[WIFI_STATION_SPOT_PASSWORD_LEN]={0};
			printf("please enter the ssid num\n num=");
			scanf("%d", &num);
			if(g_scan_spot_list[num].network_id == -1){
				printf("\nplease enter the pwd\n pwd=");
				scanf("%s", pwd);
			}
			spot_t  conn_ap ={0};
			strcpy(conn_ap.mac, g_scan_spot_list[num].mac);
			strcpy(conn_ap.ssid, g_scan_spot_list[num].ssid);
			strcpy(conn_ap.auth_mode, g_scan_spot_list[num].auth_mode);
			strcpy(conn_ap.encrypt_type, g_scan_spot_list[num].encrypt_type);
			if(g_scan_spot_list[num].network_id >=0)
				conn_ap.network_id = g_scan_spot_list[num].network_id;
			else{
				strcpy(conn_ap.password, pwd);
				conn_ap.network_id = -1;
			}
			dump_conn_ap(&conn_ap);
			wf_msg_to_self(MSG_CMD_WIFI_STATION_CONNECT, sizeof(conn_ap), &conn_ap);
			
		}
		else if(!strcmp(cmd, "forget")){
			int num = 0;
			printf("please enter the ssid num\n num=");
			scanf("%d", &num);
			spot_t	conn_ap ={0};
			strcpy(conn_ap.mac, g_scan_spot_list[num].mac);
			strcpy(conn_ap.ssid, g_scan_spot_list[num].ssid);
			conn_ap.network_id = g_scan_spot_list[num].network_id;
	
			wf_msg_to_self(MSG_CMD_WIFI_STATION_DISCONNECT, sizeof(conn_ap), &conn_ap);
		}
		else if(!strcmp(cmd, "dump")){
			wf_msg_to_self(MSG_CMD_WIFI_STATION_DEBUG_DUMP, 0, NULL);
		}
		else if(!strcmp(cmd, "mmi")){
			mmi_display();
		}
		else if(!strcmp(cmd, "help")){
			usage();
		}
		else if(!strcmp(cmd, "exit") || !strcmp(cmd, "q")){
			exit(0);
		}
		else if(!strcmp(cmd, "cmd")){
			char cmd[128]={0};
			printf("please enter wpa_supplicant cmd:\n");
			scanf("%s", cmd);
			wf_msg_to_self(MSG_CMD_WIFI_STATION_WPA_CMD, strlen(cmd)+1, cmd);
		}
		printf("done\n");
	}


	return 0;
}
