/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    USBCFGMNG
*  ļ    usbCfgMng_app.c
*  ļʶ  
*  ļ  
*  ʵֹ  usbչҵ
*        
*  汾      V1.0
*    2016-11-3
*  ˵  usbصչҵʼڣ
*                               Ҳɷü򵥵ҵ
*
******************************************************************************/

/*****************************************************************************
                         ͷļ
******************************************************************************/
#include <pthread.h>

#include <errno.h>  
#include <sys/stat.h>
#include <dirent.h>
#include <ctype.h>
#include "zte_drv_usb_ctrl.h"

extern pthread_mutex_t g_usbcfg_usbenum_mutex;
extern T_REF_NV_USB g_USBRefNV;

#define USBCFG_DEVICE_NAME          "/device/name"
#define USBCFG_PARTNAME_CDROM       "cdrom"
#define USBCFG_PART_CDROM_DEV       "/dev/zftl"
#define USBCFG_BLOCK_PART           "/sys/class/block"
#define USBCFG_CDROM_PARTITION_TYPE "zftl"

char g_usbcfg_cdrom_partition_name[USBCFG_LUN_PATH_MAX_LENGTH] = {0};
void usbcfg_getCdromPath(void) ;

/**********************************************************************************
Ϣ
***********************************************************************************/
USBCFG_MSG_PROC_INFO g_usbcfg_info[USBCFG_MSG_MAX_LENGTH] = 
{
    {MSG_CMD_FASTPOWER_IND,                      usbcfg_Handle_Msg_UsbModeFastPowerOff},
    {MSG_CMD_UDISKSTAT_SET_REQ,                   usbcfg_Handle_Msg_SetUdiskState},
    {MSG_CMD_USBMOD_SETREQ,                      usbcfg_Handle_Msg_UsbPlug},
};

void usbcfg_AppInitProc(void)
{
    /*ȡcdrom·*/
    usbcfg_getCdromPath();
}

/**********************************************************************************
: ʵֿٿػʱusb˿
***********************************************************************************/
int usbcfg_Handle_Msg_UsbModeFastPowerOff(void *data)
{
    unsigned int poweroff_state = 0;
    int usbPlugtype =  1;

    slog(USBCFGMNG_PRINT,SLOG_NORMAL, "[usbCfgMng]usbcfg_Handle_Msg_UsbModeFastPowerOff enter \n");
    usbcfg_getMutex(&g_usbcfg_usbenum_mutex);
    set_wake_lock(USBCFG_MAIN_LOCK_ID);
    poweroff_state = *(unsigned int*)data;
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbcfg_Handle_Msg_UsbModeFastPowerOff poweroff_state = %d\n", poweroff_state);

    usbPlugtype = usb_GetUsbPlugState();
    if(usbPlugtype < 0){
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]fastpoweroff: readfile %s fail \n", USB_PLUG_FILE_NAME);
        set_wake_unlock(USBCFG_MAIN_LOCK_ID);
        usbcfg_putMutex(&g_usbcfg_usbenum_mutex);
        return -1;
    }
    
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbcfg_Handle_Msg_UsbModeFastPowerOff usbPlugtype = %d\n", usbPlugtype);
    if(poweroff_state == 0)/*ٹػ*/
    {   
        g_USBRefNV.Fast_PowerOffFlag = 1;
        if(usbPlugtype)
        {
            //usb 룬ٹػģʽ
            usb_disable();
            usb_CfgInfoInit();
            usb_PlugInProc(usbPlugtype);
            slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbcfg_Handle_Msg_UsbModeFastPowerOff enter fastpoweroff state\n");
        }
        else
        {
            //usbδ룬ǰģʽΪٹػģʽ
            slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbcfg_Handle_Msg_UsbModeFastPowerOff fastpoweroff flag\n");
        }
    }
    else if(poweroff_state == 1)/*ٿ*/
    {
        g_USBRefNV.Fast_PowerOffFlag = 0;
        
        if(usbPlugtype)
        {
            slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbcfg_Handle_Msg_UsbModeFastPowerOff enter fastpoweron state\n");
            //usb룬plugin
            usb_disable();
            usb_CfgInfoInit();
            usb_PlugInProc(usbPlugtype);
        }
        else
        {
            //usbδ룬ǰģʽΪinvalid
            slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbcfg_Handle_Msg_UsbModeFastPowerOff fastpoweron flag invalid\n");
        }
    }
    set_wake_unlock(USBCFG_MAIN_LOCK_ID);
    usbcfg_putMutex(&g_usbcfg_usbenum_mutex);
    return 0;
}


static int usbcfg_pstrGetStrInt(const char * pstrPartdevName, char * pstrInt, unsigned int strIntLen)
{
    char cCur = 0;
    unsigned int iOffset = 0;
    unsigned int jOffset = 0;

    if(pstrPartdevName == NULL || pstrInt == NULL || strIntLen == 0)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usbcfg_pstrGetStrInt error! strIntLen = %d\n", strIntLen); 
        return 1;
    }

    for(iOffset = 0; iOffset < strlen(pstrPartdevName); iOffset++)
    {
        cCur = *(pstrPartdevName + iOffset);
        if(isdigit(cCur) && (jOffset < strIntLen))
        {
            pstrInt[jOffset] = cCur;
            jOffset++;
        }
    }

    return 0;
}



int  usbcfg_browse_Partnum_ByPartname(char *part_name, char *part_num, unsigned int len)
{
    FILE *fd = NULL;
    DIR *pdir = NULL;//һĿ¼;Ƕļһ
    struct dirent *pentry = NULL;//Ŀ¼ṹ
    struct stat statbuf;
    char buffer[128] = {0};
    char fullpath[256] = {0};
    char part_dname[256] = {0};
    int statRet = -1;
    
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbcfg_browse_Partnum_ByPartname start!\n"); 
    if(NULL==part_name || NULL==part_num || len<=0)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usbcfg_browse_cdrom has invalid parameter!\n"); 
        return 1;
    }  
    pdir = opendir(USBCFG_BLOCK_PART);//һ·һĿ¼
    if(pdir == NULL)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usbcfg_browse_cdrom opendir %s error!\n", USBCFG_BLOCK_PART);
        return 1;
    }

    while((pentry = readdir(pdir)) != NULL)
    {        
        if(!strcmp(pentry->d_name,".") || !strcmp(pentry->d_name,"..") )
            continue;

        snprintf(fullpath, 256, "%s/%s%s", USBCFG_BLOCK_PART, pentry->d_name, USBCFG_DEVICE_NAME);
        memset(&statbuf, 0, sizeof(struct stat));
        statRet = stat(fullpath,&statbuf);
        
        if(statRet)
        {
            continue;
        }

        fd = fopen(fullpath, "r");
        if(NULL == fd)
        {
            slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usbcfg_browse_cdrom fopen %s failed!\n", fullpath);
            closedir(pdir);
            return 1;
        }
        memset(buffer, 0, sizeof(buffer));
        (void)fgets(buffer, sizeof(buffer), fd);

        if( !strncmp(buffer,part_name,strlen(part_name)) )
        {
            strncpy(part_dname, pentry->d_name, strlen(pentry->d_name));
            statRet = usbcfg_pstrGetStrInt(part_dname, part_num, len);
            fclose(fd);
            closedir(pdir);
			slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usbcfg_browse_cdrom result part_num=%s\n", part_num);
            return statRet;
        }
        fclose(fd);
    }
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbcfg_browse_Partnum_ByPartname failed! part_name=%s\n", part_name); 
    closedir(pdir);
    return 1;
}


void usbcfg_getCdromPath(void) 
{
    int ret = 0;
    char cdrom_part_num[4] = {'\0'};
    //char need_cp_udisk[8] = {0};
   // sc_cfg_get(NV_NEED_CP_UDISK, need_cp_udisk,sizeof(need_cp_udisk));
    usb_NvGetCdromState();
    if(g_USBRefNV.CDROMFlag || g_USBRefNV.CDROMFlagStep2)
  //  if(strncmp(need_cp_udisk, "yes", strlen("yes")) != 0) 
    {
        // ̬ѯcdromӦzftl豸仯µcdrom·
        ret = usbcfg_browse_Partnum_ByPartname(USBCFG_PARTNAME_CDROM, cdrom_part_num, sizeof(cdrom_part_num));
        if(1 == ret)
        {
            slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usbcfg_browse_cdrom error\n");
            return;
        }
        memset(g_usbcfg_cdrom_partition_name, 0, USBCFG_LUN_PATH_MAX_LENGTH);
        snprintf(g_usbcfg_cdrom_partition_name, USBCFG_LUN_PATH_MAX_LENGTH, "%s%s", USBCFG_PART_CDROM_DEV, cdrom_part_num); 
        sc_cfg_set(STR_CDROM_LUNPATH, g_usbcfg_cdrom_partition_name);
        //sc_cfg_save();
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbcfg_browse_cdrom g_usbcfg_cdrom_partition_name =%s\n",g_usbcfg_cdrom_partition_name); 
        return;
    }
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbCfgMng usbcfg_getCdromPath g_USBRefNV.CDROMFlag = 0\n");
    return;
}

/**********************************************************************************
: ʵusbPlugOut/usbPlugIn
***********************************************************************************/
int usbcfg_Handle_Msg_UsbPlug(void *data)
{
    int usbPlug_state = 0;//usb/γ

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbcfg_Handle_Msg_UsbPlug enter\n");
    usbcfg_getMutex(&g_usbcfg_usbenum_mutex);
    set_wake_lock(USBCFG_MAIN_LOCK_ID);

    if(data == NULL)
    {
        set_wake_unlock(USBCFG_MAIN_LOCK_ID);
        usbcfg_putMutex(&g_usbcfg_usbenum_mutex);
        return -1;
    }

    usbPlug_state = atoi((const char*)data);

    if(usbPlug_state == 1)//ģusb
    {
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbcfg_Handle_Msg_UsbPlug plugin\n");
        usb_disable();
        usb_CfgInfoInit();
        usb_PlugInProc(1);
    }
    else if(usbPlug_state == 0)
    {
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbcfg_Handle_Msg_UsbPlug plugout\n");
        usb_disable();//ģusbγ      
    }
    
    set_wake_unlock(USBCFG_MAIN_LOCK_ID);
    usbcfg_putMutex(&g_usbcfg_usbenum_mutex);
    return 0;
}


