
#include <linux/module.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/kmemcheck.h>
#include <linux/mm.h>
#include <linux/interrupt.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/slab.h>
#include <linux/tcp.h>
#include <linux/udp.h>
#include <linux/netdevice.h>
#ifdef CONFIG_NET_CLS_ACT
#include <net/pkt_sched.h>
#endif
#include <linux/string.h>
#include <linux/skbuff.h>
#include <linux/splice.h>
#include <linux/cache.h>
#include <linux/rtnetlink.h>
#include <linux/init.h>
#include <linux/scatterlist.h>
#include <linux/errqueue.h>
#include <linux/prefetch.h>
//#include <linux/psbuff.h>

#include <net/protocol.h>
#include <net/dst.h>
#include <net/sock.h>
#include <net/checksum.h>
#include <net/xfrm.h>

#include <asm/uaccess.h>
#include <trace/events/skb.h>
//#include "../kmap_skb.h"

#include <linux/wakelock.h>


#include <linux/kallsyms.h>
#include <asm/cacheflush.h>
#include <asm/exception.h>
#include <asm/unistd.h>
#include <asm/traps.h>
#include <asm/unwind.h>
#include <asm/tls.h>
#include <asm/system_misc.h>
#include <asm/stacktrace.h>

#include <linux/kprobes.h>
#include <asm/traps.h>
#include <net/SI/net_track.h>




/*
 *
 * skbڴй¶ٺڲʹãṩӿ
 *
 */
//static char first_ent_flag = 0;
//static volatile int g_skb_lock_cnt = 0;

/***Ȫӣùܲ׼ɢļҪȪ***/

enum track_type leak_set = TRACK_START; //ͨmoduleؿ,1ʾskbdataͷŵ㣻2ʾusersԼΪskbʼղͷţʱùв

int leak_list_max = 2000; //ͨmoduleؿƣĴͷŵskbdataĸɵ

int track_max = 2;      //켣ޣuser++--ʱҪ󣬷2ɣ

int stack_lenmax = 100;  //ջ켣ַޣ

unsigned long  now_time;//ǰʱ̵
spinlock_t  leak_lock;//ֹbhбãʹbh

struct leak_list data_leak[TRACK_END], data_free[TRACK_END];//ֱӦʹõݺѾͷŵ
void *data_head[TRACK_END] = {NULL};//ÿڴ͵ĳʼ׵ַȷԱramdumpʱֱ

struct track_info *leak_node = NULL;
void *leak_addr = NULL;
int leak_full_panic = 0;


static void track_memset(struct track_info * node)
{
	node->next = NULL;
	node->addr = NULL;
	node->pri_time = NULL;
	node->user_num = NULL;
	node->track_num = NULL;
	node->len = 0;
	memset(node->func_track,0,stack_lenmax * track_max);

}
//Եǰջлݣַռ
void get_stack_func(unsigned char *my_bkp,int my_len)
{
#if 0
	struct stackframe frame;
	struct task_struct *tsk = current;
	register unsigned long current_sp asm ("sp");

	int len = 0;
	int i = 0;
	int urc;
	int track_num = 0;
	char mytmp[30] = {0};

	frame.fp = (unsigned long)__builtin_frame_address(0);
	frame.lr = (unsigned long)__builtin_return_address(0);
	frame.sp = current_sp;
	frame.pc = (unsigned long)get_stack_func;

    
	while (1) {
		urc = unwind_frame(&frame);
		//ݽ˳
		if (urc < 0)
		    return;

		memset(mytmp, 0, 30);
		snprintf(mytmp, 15, "<%ps", (void *)frame.pc);

		//Ϊ˽ʡڴ棬ϲ4
		if(++i >= 2)
		{
			if(len + strlen(mytmp)>= my_len)
				return;
			strcpy(my_bkp + len, mytmp);
			len += strlen(mytmp);
		}
	}
#endif //cov	
}
//켣浽ڴ
static void dump_my_stack(struct track_info *node)
{
	unsigned char *my_bkp = NULL;
	int track_num = 0;

	//˴δǻⱣӦⲻ
	node->track_num++;
	track_num = (node->track_num - 1) % track_max;
	my_bkp = node->func_track + track_num * stack_lenmax;
	get_stack_func(my_bkp,stack_lenmax - 2);
}

//ժһڵ㣬ڵΪֵ֧һɵĿнڵ
struct track_info *leaklist_del(struct leak_list *list_head, struct track_info *entry)
{
    struct track_info *ret_entry = NULL, *prev = NULL ,**pprev = NULL;
    
    if (!entry)
    {
        ret_entry = list_head->next;
        prev = NULL;
        if (ret_entry)
        {
            /*һڵ*/
            while (ret_entry->next)
            {
                prev = ret_entry;
                ret_entry = ret_entry->next;
            }
            //ڵһڵ㣬Ҳɽڵ
            if (prev)
            {
                prev->next = NULL;
                list_head->count--;
            }
            //һЧڵ
            else
            {
                list_head->next = NULL;
                list_head->count = 0;
            }
        }
        return ret_entry;
    }
    else
    {
        pprev = &list_head->next;
        for (ret_entry = list_head->next; ret_entry; ret_entry = ret_entry->next)
        {
            if(ret_entry == entry)
            {
                *pprev = ret_entry->next;
                list_head->count--;
                return ret_entry;
            }

            pprev = &ret_entry->next;
        }
    }
    
    return NULL;
}

//һĽڵͷ
void leaklist_add(struct leak_list *list_head, struct track_info *entry)
{
    entry->next = list_head->next;
    list_head->next = entry;
    list_head->count++;
}

//ȡһڵ
static struct track_info *leaklist_get_first_node(struct leak_list *head)
{
    struct track_info *h = NULL;
    
    if (head->next == NULL || head->count == 0)
        return NULL;

    h = head->next;
    head->count--;
    head->next = h->next;

    return h;
}
//Ϊȷ켣ʱռڴ棬ʵ˶̬ڴ
void track_init(int type)
{
    int i;
    enum track_type id;
    struct track_info *h;
    unsigned long spin_flag;
	static int init_lock = 0;
    //ִгʼΪ˷ֹӰ쿪ٶȣʼ̬
    if (init_lock == 0)
    {
        spin_lock_init(&leak_lock);
		init_lock++;
    }

    spin_lock_irqsave(&leak_lock, spin_flag);

	if(data_head[type]  != NULL)
		panic("mem  alloc and  release    ERR!!!!!!!!!");
	//һڴռ䣬ͨRAMDUMPDDRڴйؼ
	data_head[type] = kzalloc(leak_list_max * tnode_len, GFP_ATOMIC);    
	memset(data_free+type, 0, sizeof(struct leak_list));
	memset(data_leak+type, 0, sizeof(struct leak_list));
    //ӵ
    for (i = 0; i < leak_list_max; i++)
    {
        h = (struct track_info *)(data_head[type] + i * tnode_len);
		h->func_track = (char *)kzalloc(stack_lenmax * track_max, GFP_ATOMIC); 
        leaklist_add(&data_free[type], h);
    }

    spin_unlock_irqrestore(&leak_lock, spin_flag);
}

/***************************************
* ƣ	track_add
* 	ڴøýӿڣ¼ڴ켣ڼڴй©
* ˵	addr:ڴַ
				type1:֮ǰskb ؼģΪ0
				type2:ڴͣģԶ壬enum track_type
				len:ڴ
****************************************/
void track_add(void *addr, int type1, int type2, int len)
{
    struct track_info *h;
    struct hlist_nulls_node *n;
    unsigned long spin_flag;
    struct sk_buff_head *list;
    if (leak_set != type2 || type2 < 0 || type2 >=TRACK_END)
        return;

    spin_lock_irqsave(&leak_lock, spin_flag);
    
    leak_node = NULL;
    leak_addr = NULL;
    
    //ͨڴ룬˴Ӧöԣuserĸ٣˴ͨuser_numжǷظ
    for (h = data_leak[type2].next; h; h = h->next)
    {
        if(h->addr == addr)
        {
            //ڴͷĸ٣Ҫڴ⴦
            if (type2 == USER_INFO || type2 == LIST_SKB_INFO || type2 == QUEUE_STATE_INFO) 
            {
                dump_my_stack(h);
                if (type2 == LIST_SKB_INFO)
                {
                    list = (struct sk_buff_head *)addr;
                    h->user_num = (int)list->qlen;
                }
                else if (type2 == QUEUE_STATE_INFO)
                {
                    h->user_num |= (1 << type1);
                }
                else
                    h->user_num++;
                
                h->pri_time = jiffies;
                spin_unlock_irqrestore(&leak_lock, spin_flag);
                return;
            }
            else 
                panic("realloc mem\n");
        }
    }
    
    //Ϊ˼ظͷţʹøձͷŵĶӦڵ
    for (h = data_free[type2].next; h; h = h->next)
    {
        if (h->addr == addr)
        {
            leaklist_del(&data_free[type2], h);
            goto init_node;                
        }    
    }
    
    //ӿлȡһڵ
    if (!(h = leaklist_del(&data_free[type2], NULL)))
    {
        //ʸʱleak_list_max岻󣬶豸ռޣ
        //ԣĳ:벻ǿȡµĽڵʹ
        //ΪµĽڵй©ļСʵϴʱֱӶҲǿԵ
        if (leak_full_panic)
        {
            panic("data_leak is full");
        }
        if (!(h = leaklist_get_first_node(&data_leak[type2])))
        {
            now_time = jiffies;
            leak_node = h;
            leak_addr = addr;
            panic("both data_leak & data_free have no node, type:%d !!!\n", type2);
        }
    }
init_node:
    track_memset(h);
    dump_my_stack(h);
    h->addr = addr;
    //queue״̬λͼʾ
    if (type2 == QUEUE_STATE_INFO)
        h->user_num |= (1 << type1);
    //useratomic_setԴ0ʼ
    else if (type2 == USER_INFO)
        h->user_num = 0;
    else
        h->user_num = 1;
    h->pri_time = jiffies;
	h->len = len;
    leaklist_add(&data_leak[type2], h);
    spin_unlock_irqrestore(&leak_lock,spin_flag);
}
EXPORT_SYMBOL(track_add);

//ͷڴøýӿڣ¼ڴͷŹ켣ɼظͷ
void track_del(void *addr, int type1, int type2)
{
    struct track_info *h;
    unsigned long spin_flag;
	struct sk_buff_head *list;
    if (leak_set != type2 || type2 < 0 || type2 >=TRACK_END)
        return;

    leak_node = NULL;
    leak_addr = NULL;

    spin_lock_irqsave(&leak_lock, spin_flag);
    
    //Уͷţظͷ
    for (h = data_leak[type2].next; h; h = h->next)
    {
        if (h->addr == addr)
        {
            dump_my_stack(h);
            if (type2 == LIST_SKB_INFO)
            {
                list = (struct sk_buff_head *)addr;
                h->user_num = (int)list->qlen;
            }
            else if (type2 == QUEUE_STATE_INFO)
            {
                h->user_num &= ~(1 << type1);
            }
            else
                h->user_num--;
            if ( h->user_num == 0 )
            {
                leaklist_del(&data_leak[type2], h);
                leaklist_add(&data_free[type2], h);
            }
            spin_unlock_irqrestore(&leak_lock,spin_flag);        
            return;
        }
    }
    
    //ǷΪظͷ
    for (h = data_free[type2].next; h; h = h->next)
    {
        //LIST_SKB_INFOҲظͷţǷ
        if ((type2 != LIST_SKB_INFO) && (type2 != QUEUE_STATE_INFO) &&(h->addr == addr))
        {
            now_time = jiffies;
            leak_node = h;
            leak_addr = addr;
            panic("skb repeat release type:%d !!!!!!!!!!!!!!\n", type2);
        }
    }
    spin_unlock_irqrestore(&leak_lock, spin_flag);
}
EXPORT_SYMBOL(track_del);

/********************************************************************************/

//ͨģǷϱskbַƫǷȷ
int skbaddr_set;
EXPORT_SYMBOL(skbaddr_set);

//ͨؼ0X4500ƫжskb֡ݵĵַͷǷĵַƫƴ
int test_data_addr(struct sk_buff *skb,int type)
{
	int i,j;
	int ok_diff;
	unsigned char *data;

	if(skbaddr_set == 0)
		return 0;
	//ʼֵƫֵҵMAC֡ͷеtypeֵ
	if(type == MAC)
	{
		data = skb->data-2;
		ok_diff = 14;
	}
	else if(type == IPV4)
	{
		data = skb->data-16;
		ok_diff = 14;
	}
	else
		return 0;

	//ҵIPV4ARPƫֵ
	for(i=0;i<50;i++)
	{
		if((data[i] == 0X08 && data[i+1] == 0)||(data[i] == 0X08 && data[i+1] == 0X06))
			break;
	}
	//ûҵؼ0X4500˳
	if(i>=50)
		return 0;
	
	if(i != ok_diff)
		panic("addr Err,need driver continue find err !!!");
	return 0;
}


