/***********************************************************************
 * Copyright (C) 2014, ZTE Corporation.
 *
 * File Name:   lcd_comm.c
 * File Mark:
 * Description: Lcd function implementation. Adapted to LCM MODEL - LEAD T15DS26.
 * Others:      this file is in BOOTLOADER procedure.
 *                  This LCM MODEL uses SPI-4.
 *                  NOTE: 4-lines-spi uses CS, CLK, D/CX and SDI. Do not using SDO instead of D/CX.
 * Version:     V1.0
 * Author:      qihongfang
 * Date:        2017-9-18
 *
 * History 1:
 *     Date: 2015-1-16
 *     Version:
 *     Author: YinWenguan
 *     Modification: Add brightness setting.
 *
***********************************************************************/

/*************************************************************************
 * Include files
 *************************************************************************/
#include "../include/board.h"
#include <common.h>
#include <malloc.h>
#include <asm/io.h>
#include "../include/spi.h"
#include "../include/ssp.h"
#include <lcd.h>
#include <drvs_gpio.h>
#include <peripheral.h>

/*************************************************************************
 * Macro
 *************************************************************************/
#define LCM_ID_LEAD    		0x7C  /*йst7735s\st7735s*/
#define LCM_ID_ZGD    		0x00  /*й GC9105 IVO1.77*/
#define LCM_ID_ILI			0x54  /*й GC9105 IVO1.77*/
#define LCM_ID_ZGD_9105		0x9105	// 128*160 
#define LCM_ID_ILI_9163		0x8066	// 128*160 
#define LCM_ID_ZGD_9305		0x9305 	// 240*320

#define LCM_ID_BOE			0x7C	// 128*128 
#define LCM_ID_BOE_7735S	0x89F0	// 128*128 

#define LCM_ID_ST			0x85
#define LCM_ID_ST7789V		0x8552		//240 * 320

#define ZSP_LCDINFO_PATH "/LCDINFO.bin"
#define ZSP_LCDINFOBAK_PATH	"/LCDINFOBAK.bin"
#define LCD_BITS_PER_PIXEL	(5 + 6 + 5)

#ifdef LCD_ROTATE_180
#define LCD_MXMYRGB			0x14
#else
#define LCD_MXMYRGB			0xC4
#endif

struct lcd_var_screeninfo {
	unsigned int xs;	//xs_offset	
	unsigned int ys;    //ys_offset
	unsigned int width;	//128 	240 	
	unsigned int height; //128 	240		
	unsigned int xe;	 //width + xs - 1	
	unsigned int ye;     //height + ys - 1
	unsigned int xs_offset; //0x02 0x00 			
	unsigned int ys_offset; //0x03 0x00		
	unsigned int lcd_version;
	//unsigned int bits_per_pixel;		
};
static struct lcd_var_screeninfo var_screeninfo = {0};	/* Current var */


/**************************************************************************
 *                                  Types                                                                                   *
 **************************************************************************/
static volatile T_ZDrvLcd_Instance			g_sLcd_Instance = {false, LCD_NORMAL, LCD_XFER_POLL, LCD_DCX_CMD};
static volatile T_ZDrvLcd_BacklightStatus	g_sLcd_Backlight = LCD_BACKLIGHT_OFF;
static volatile T_ZDrvLcd_Brightness		g_sLcd_Brightness = 255;

/**************************************************************************
 * Global  Variable
 **************************************************************************/
extern volatile T_ZDrvLcd_Info s_lcd_info;
extern int zDrvLcd_Spi_WriteCmd(unsigned char cmd);
extern int zDrvLcd_Spi_WriteData(unsigned char data);

/**************************************************************************
 * Function Implementation
 **************************************************************************/
void lcd_gpio_define(struct T_ZDrvLcd_gpio_define* config)
{
	config->spi_cs_gpio			= GPIO25;
	config->spi_scl_gpio		= GPIO26;
	config->spi_sda_gpio		= GPIO28;
	config->spi_dcx_gpio		= GPIO27;

	config->spi_cs_func_sel		= GPIO25_SSP0_CS;
	config->spi_scl_func_sel	= GPIO26_SSP0_CLK;
	config->spi_sda_func_sel	= GPIO28_SSP0_TXD;
	config->spi_dcx_func_sel	= GPIO27_SSP0_RXD;

	config->spi_cs_gpio_sel		= GPIO25_GPIO25;
	config->spi_scl_gpio_sel	= GPIO26_GPIO26;
	config->spi_sda_gpio_sel	= GPIO28_GPIO28;
	config->spi_dcx_gpio_sel	= GPIO27_GPIO27;

	config->lcd_reset_gpio		= GPIO123;
	config->lcd_reset_gpio_sel	= GPIO123_GPIO123;
	
	config->lcd_blg_gpio		= GPIO119;
	config->lcd_blg_gpio_sel	= GPIO119_GPIO119;
}

/**************************************************************************
* Function: update_rect_color
* Description: used to initialize GPIO usage.
* Parameters:
*       (IN)
*
*       (OUT)
*
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERROR: others error code. For more details, please refer to the source code.
* Others:
**************************************************************************/
int set_ram_addr_color(unsigned short uiLeft, unsigned short uiTop)
{
	int ret = DRV_SUCCESS;

	ret |= zDrvLcd_Spi_WriteCmd(0x2A);
	ret |= zDrvLcd_Spi_WriteData(0x00);
	ret |= zDrvLcd_Spi_WriteData(var_screeninfo.xs);
	ret |= zDrvLcd_Spi_WriteData((var_screeninfo.xe >> 8));
	ret |= zDrvLcd_Spi_WriteData((var_screeninfo.xe &0xff));

	ret |= zDrvLcd_Spi_WriteCmd(0x2B);
	ret |= zDrvLcd_Spi_WriteData(0x00);
	ret |= zDrvLcd_Spi_WriteData(var_screeninfo.ys);
	ret |= zDrvLcd_Spi_WriteData((var_screeninfo.ye >> 8));
	ret |= zDrvLcd_Spi_WriteData((var_screeninfo.ye & 0xff));

	return ret;
}

int update_rect_color(unsigned char *pBuf, unsigned short uiLeft, unsigned short uiTop, unsigned short uiWidth, unsigned short uiHeight)
{
	int ret = DRV_SUCCESS;
	
    ret |= set_ram_addr_color(uiLeft, uiTop); // ָˢµʼַ

    ret |= zDrvLcd_Spi_WriteCmd(0x2c);
    ret = zDrvLcd_Spi_WriteDataBlock((unsigned char *) pBuf, uiWidth * uiHeight * 2);
	
	return ret;
}

/**************************************************************************
* Function: prj_lcm_init
* Description: used to initialize SPI usage.
* Parameters:
*       (IN)
*
*       (OUT)
*
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERROR: others error code. For more details, please refer to the source code.
* Others:
**************************************************************************/
int prj_lcm_init(void)
{
    int ret = DRV_SUCCESS;
    unsigned long uiRow, uiCol;
	uint8_t page_number,column_number;
	
	if(s_lcd_info.lcm_info.lcd_item == BOE7735S_128x128)
	{
		zDrvLcd_DelayMs(120); 
		zDrvLcd_Spi_WriteCmd(0x11); 	
		zDrvLcd_DelayMs(120);

		zDrvLcd_Spi_WriteCmd( 0xB1); 	
		zDrvLcd_Spi_WriteData(0x05);	

		zDrvLcd_Spi_WriteData(0x3C);	
		zDrvLcd_Spi_WriteData(0x3C);	

		zDrvLcd_Spi_WriteCmd(0xB2); 	
		zDrvLcd_Spi_WriteData(0x05);	
		zDrvLcd_Spi_WriteData(0x3C);	
		zDrvLcd_Spi_WriteData(0x3C);	

		zDrvLcd_Spi_WriteCmd(0xB3); 	
		zDrvLcd_Spi_WriteData(0x05);	
		zDrvLcd_Spi_WriteData(0x3C);	
		zDrvLcd_Spi_WriteData(0x3C);	
		zDrvLcd_Spi_WriteData(0x05);	
		zDrvLcd_Spi_WriteData(0x3C);	
		zDrvLcd_Spi_WriteData(0x3C);	

		zDrvLcd_Spi_WriteCmd(0xB4); 	
		zDrvLcd_Spi_WriteData(0x03);	

		zDrvLcd_Spi_WriteCmd(0xC0); 	
		zDrvLcd_Spi_WriteData(0xE0);	
		zDrvLcd_Spi_WriteData(0x00);	
		zDrvLcd_Spi_WriteData(0x84);	

		zDrvLcd_Spi_WriteCmd(0xC1); 	
		zDrvLcd_Spi_WriteData(0x05);	

		zDrvLcd_Spi_WriteCmd(0xC2); 	
		zDrvLcd_Spi_WriteData(0x0D);	
		zDrvLcd_Spi_WriteData(0x00);	

		zDrvLcd_Spi_WriteCmd(0xC3); 	
		zDrvLcd_Spi_WriteData(0x8D);	
		zDrvLcd_Spi_WriteData(0xEA);	

		zDrvLcd_Spi_WriteCmd(0xC4); 	
		zDrvLcd_Spi_WriteData(0x8D);	
		zDrvLcd_Spi_WriteData(0xEE);	

		zDrvLcd_Spi_WriteCmd(0xC5); 	
		zDrvLcd_Spi_WriteData(0x00);	

		zDrvLcd_Spi_WriteCmd(0x36); 	
		zDrvLcd_Spi_WriteData(0xC8);	

		zDrvLcd_Spi_WriteCmd(0x3a); 	
		zDrvLcd_Spi_WriteData(0x55);

		zDrvLcd_Spi_WriteCmd(0xE0); 	
		zDrvLcd_Spi_WriteData(0x1B);	
		zDrvLcd_Spi_WriteData(0x1A);	
		zDrvLcd_Spi_WriteData(0x10);	
		zDrvLcd_Spi_WriteData(0x15);	
		zDrvLcd_Spi_WriteData(0x34);	
		zDrvLcd_Spi_WriteData(0x2E);	
		zDrvLcd_Spi_WriteData(0x2A);	
		zDrvLcd_Spi_WriteData(0x2A);	
		zDrvLcd_Spi_WriteData(0x2C);	
		zDrvLcd_Spi_WriteData(0x27);	
		zDrvLcd_Spi_WriteData(0x2E);	
		zDrvLcd_Spi_WriteData(0x39);	
		zDrvLcd_Spi_WriteData(0x00);	
		zDrvLcd_Spi_WriteData(0x15);	
		zDrvLcd_Spi_WriteData(0x02);	
		zDrvLcd_Spi_WriteData(0x3F);	

		zDrvLcd_Spi_WriteCmd(0xE1); 	
		zDrvLcd_Spi_WriteData(0x1A);	
		zDrvLcd_Spi_WriteData(0x1A);	
		zDrvLcd_Spi_WriteData(0x0F);	
		zDrvLcd_Spi_WriteData(0x15);	
		zDrvLcd_Spi_WriteData(0x34);	
		zDrvLcd_Spi_WriteData(0x2E);	
		zDrvLcd_Spi_WriteData(0x25);	
		zDrvLcd_Spi_WriteData(0x2B);	
		zDrvLcd_Spi_WriteData(0x26);	
		zDrvLcd_Spi_WriteData(0x26);	
		zDrvLcd_Spi_WriteData(0x2F);	
		zDrvLcd_Spi_WriteData(0x3A);	
		zDrvLcd_Spi_WriteData(0x00);	
		zDrvLcd_Spi_WriteData(0x15);	
		zDrvLcd_Spi_WriteData(0x02);	
		zDrvLcd_Spi_WriteData(0x3F);	
		zDrvLcd_Spi_WriteCmd(0x29);
		
		zDrvLcd_Spi_WriteCmd(0x35); /*enable TE*/
		zDrvLcd_Spi_WriteData(0x00);
	}  
	else if(s_lcd_info.lcm_info.lcd_item == ST7789V_240x240)
	{
#ifdef CONFIG_ZX297520V3E_WATCH_CAP
		zDrvLcd_DelayMs(120);				 //Delay 120ms 
		zDrvLcd_Spi_WriteCmd(0x11); 
		zDrvLcd_DelayMs(120);				 //Delay 120ms 
		//--------------------------------display and color format setting----------------------------------// 
		zDrvLcd_Spi_WriteCmd(0x36); 
		zDrvLcd_Spi_WriteData(0x00);  //0x1c 0xC8
		zDrvLcd_Spi_WriteCmd(0x3A); 
		zDrvLcd_Spi_WriteData(0x05);
		//--------------------------------ST7789v Frame rate setting----------------------------------// 
		zDrvLcd_Spi_WriteCmd(0xb2); 
		zDrvLcd_Spi_WriteData(0x0c); 
		zDrvLcd_Spi_WriteData(0x0c); 
		zDrvLcd_Spi_WriteData(0x00); 
		zDrvLcd_Spi_WriteData(0x33); 
		zDrvLcd_Spi_WriteData(0x33); 
		zDrvLcd_Spi_WriteCmd(0xb7); 
		zDrvLcd_Spi_WriteData(0x35); 
		//---------------------------------ST7789v Power setting--------------------------------------// 
		zDrvLcd_Spi_WriteCmd(0xbb); 
		zDrvLcd_Spi_WriteData(0x2c); 
		zDrvLcd_Spi_WriteCmd(0xc0); 
		zDrvLcd_Spi_WriteData(0x2c);
		zDrvLcd_Spi_WriteCmd(0xc2); 
		zDrvLcd_Spi_WriteData(0x01); 
		zDrvLcd_Spi_WriteCmd(0xc3); 
		zDrvLcd_Spi_WriteData(0x19); 
		zDrvLcd_Spi_WriteCmd(0xc4); 
		zDrvLcd_Spi_WriteData(0x20); 
		zDrvLcd_Spi_WriteCmd(0xc6); 
		zDrvLcd_Spi_WriteData(0x0f); 

		zDrvLcd_Spi_WriteCmd(0xd0); 
		zDrvLcd_Spi_WriteData(0xa4); 
		zDrvLcd_Spi_WriteData(0xa1); 
		zDrvLcd_Spi_WriteCmd(0xe0); 
		zDrvLcd_Spi_WriteData(0xD0); 
		zDrvLcd_Spi_WriteData(0x03); 
		zDrvLcd_Spi_WriteData(0x08); 
		zDrvLcd_Spi_WriteData(0x0E); 
		zDrvLcd_Spi_WriteData(0x12); 
		zDrvLcd_Spi_WriteData(0x2D); 
		zDrvLcd_Spi_WriteData(0x42); 
		zDrvLcd_Spi_WriteData(0x45); 
		zDrvLcd_Spi_WriteData(0x53); 
		zDrvLcd_Spi_WriteData(0x29); 
		zDrvLcd_Spi_WriteData(0x16); 
		zDrvLcd_Spi_WriteData(0x15); 
		zDrvLcd_Spi_WriteData(0x22); 
		zDrvLcd_Spi_WriteData(0x24); 
		zDrvLcd_Spi_WriteCmd(0xe1); 
		zDrvLcd_Spi_WriteData(0xD0); 
		zDrvLcd_Spi_WriteData(0x03); 
		zDrvLcd_Spi_WriteData(0x08); 
		zDrvLcd_Spi_WriteData(0x0e); 
		zDrvLcd_Spi_WriteData(0x13); 
		zDrvLcd_Spi_WriteData(0x2c); 
		zDrvLcd_Spi_WriteData(0x42); 
		zDrvLcd_Spi_WriteData(0x54); 
		zDrvLcd_Spi_WriteData(0x50); 
		zDrvLcd_Spi_WriteData(0x2c); 
		zDrvLcd_Spi_WriteData(0x16); 
		zDrvLcd_Spi_WriteData(0x16); 
		zDrvLcd_Spi_WriteData(0x20); 
		zDrvLcd_Spi_WriteData(0x27); 

		//zDrvLcd_Spi_WriteCmd(0x21);

		zDrvLcd_Spi_WriteCmd(0x35); /*enable TE*/
		zDrvLcd_Spi_WriteData(0x00);
		zDrvLcd_Spi_WriteCmd(0x44); 		
		zDrvLcd_Spi_WriteData(0x00);
		zDrvLcd_Spi_WriteData(0x05); 

		zDrvLcd_Spi_WriteCmd(0x29);
		zDrvLcd_Spi_WriteCmd(0x2c);

#else
		zDrvLcd_DelayMs(120);				 //Delay 120ms 
		zDrvLcd_Spi_WriteCmd(0x11); 
		zDrvLcd_DelayMs(120);				 //Delay 120ms 
		//--------------------------------display and color format setting----------------------------------// 
		zDrvLcd_Spi_WriteCmd(0x36); 
		zDrvLcd_Spi_WriteData(0x00);  //0x1c 0xC8
		zDrvLcd_Spi_WriteCmd(0x3A); 
		zDrvLcd_Spi_WriteData(0x55);
		//--------------------------------ST7789v Frame rate setting----------------------------------// 
		zDrvLcd_Spi_WriteCmd(0xb2); 
		zDrvLcd_Spi_WriteData(0x0c); 
		zDrvLcd_Spi_WriteData(0x0c); 
		zDrvLcd_Spi_WriteData(0x00); 
		zDrvLcd_Spi_WriteData(0x33); 
		zDrvLcd_Spi_WriteData(0x33); 
		zDrvLcd_Spi_WriteCmd(0xb7); 
		zDrvLcd_Spi_WriteData(0x22); 
		//---------------------------------ST7789v Power setting--------------------------------------// 
		zDrvLcd_Spi_WriteCmd(0xbb); 
		zDrvLcd_Spi_WriteData(0x3c); 
		zDrvLcd_Spi_WriteCmd(0xc2); 
		zDrvLcd_Spi_WriteData(0x01); 
		zDrvLcd_Spi_WriteCmd(0xc3); 
		zDrvLcd_Spi_WriteData(0x19); 
		zDrvLcd_Spi_WriteCmd(0xc4); 
		zDrvLcd_Spi_WriteData(0x20); 
		zDrvLcd_Spi_WriteCmd(0xc6); 
		zDrvLcd_Spi_WriteData(0x0f); 

		zDrvLcd_Spi_WriteCmd(0xd0); 
		zDrvLcd_Spi_WriteData(0xa4); 
		zDrvLcd_Spi_WriteData(0xa1); 

		zDrvLcd_Spi_WriteCmd(0xd6); 
		zDrvLcd_Spi_WriteData(0xa1); 
		//--------------------------------ST7789v gamma setting---------------------------------------// 
		zDrvLcd_Spi_WriteCmd(0xe0); 
		zDrvLcd_Spi_WriteData(0x70); 
		zDrvLcd_Spi_WriteData(0x04); 
		zDrvLcd_Spi_WriteData(0x08); 
		zDrvLcd_Spi_WriteData(0x09); 
		zDrvLcd_Spi_WriteData(0x09); 
		zDrvLcd_Spi_WriteData(0x05); 
		zDrvLcd_Spi_WriteData(0x2a); 
		zDrvLcd_Spi_WriteData(0x33); 
		zDrvLcd_Spi_WriteData(0x41); 
		zDrvLcd_Spi_WriteData(0x07); 
		zDrvLcd_Spi_WriteData(0x13); 
		zDrvLcd_Spi_WriteData(0x13); 
		zDrvLcd_Spi_WriteData(0x29); 
		zDrvLcd_Spi_WriteData(0x2f); 
		zDrvLcd_Spi_WriteCmd(0xe1); 
		zDrvLcd_Spi_WriteData(0x70); 
		zDrvLcd_Spi_WriteData(0x03); 
		zDrvLcd_Spi_WriteData(0x09); 
		zDrvLcd_Spi_WriteData(0x0a); 
		zDrvLcd_Spi_WriteData(0x09); 
		zDrvLcd_Spi_WriteData(0x06); 
		zDrvLcd_Spi_WriteData(0x2b); 
		zDrvLcd_Spi_WriteData(0x34); 
		zDrvLcd_Spi_WriteData(0x41); 
		zDrvLcd_Spi_WriteData(0x07); 
		zDrvLcd_Spi_WriteData(0x12); 
		zDrvLcd_Spi_WriteData(0x14); 
		zDrvLcd_Spi_WriteData(0x28); 
		zDrvLcd_Spi_WriteData(0x2e); 
		if (var_screeninfo.lcd_version == 2)
		{
		}
		else
		{
		zDrvLcd_Spi_WriteCmd(0x21);
		}
		
		zDrvLcd_Spi_WriteCmd(0x35); /*enable TE*/
		zDrvLcd_Spi_WriteData(0x00);

		zDrvLcd_Spi_WriteCmd(0x29);
		zDrvLcd_Spi_WriteCmd(0x2c);
#endif
	}
		
    // ˢɺɫ
    for (uiRow = 0; uiRow < var_screeninfo.width; uiRow++)
    {
        for (uiCol = 0; uiCol < var_screeninfo.height; uiCol++)
        {
            ret |= zDrvLcd_Spi_WriteData(0x00);
            ret |= zDrvLcd_Spi_WriteData(0x00);
        }
    }

    return ret;
}
/**************************************************************************
* Function: prj_lcd_get_info
* Description: used to get the LCD device information.
* Parameters:
*       (IN)
*               pInfo    the pointer of LCD device information to store into
*       (OUT)
*               pInfo   the pointer of LCD device information allready stored into
* Returns:
*       DRV_SUCCESS: succeeded.
* Others:
*       None.
**************************************************************************/
int prj_lcd_get_info(T_ZDrvLcd_Info* pInfo)
{
	unsigned char tmp;
	char cmd[64] = {0};
	unsigned char lcd_info[16] = {0};
	
	sprintf(cmd, "fsload resource 0x%x %s", (ulong)(&lcd_info), ZSP_LCDINFO_PATH);
	run_command(cmd, 0);
#if 0
	if(fsload_state_query() == 1)
	{
		sprintf(cmd, "fsload resource 0x%x %s", (ulong)(&lcd_info), ZSP_LCDINFOBAK_PATH);
		run_command(cmd, 0);
	}
#endif
	pInfo->width = lcd_info[0]<< 8 | lcd_info[1];//LCD_WIDTH;
	pInfo->height = lcd_info[2]<< 8 | lcd_info[3];//LCD_HEIGHT;
	
	var_screeninfo.lcd_version =  lcd_info[4];
	printf("[LCD]fsload LCDINFO.bin sucess (%d %d) lcd_version (%d) \n",pInfo->width,pInfo->height,var_screeninfo.lcd_version);
	if(pInfo->width == 0 || pInfo->height == 0)
	{
		printf("[LCD]fsload LCDINFO.bin failed!!!!\n");
	}
	
	pInfo->bitsPerPixel = LCD_BITS_PER_PIXEL;
	pInfo->rMask = 0xF800;
	pInfo->gMask = 0x07E0;
	pInfo->bMask = 0x001F;
	pInfo->instance = g_sLcd_Instance;
	pInfo->backlight = g_sLcd_Backlight;
	pInfo->brightness = g_sLcd_Brightness;
	
	tmp = read_st(0xda);//lcd module's manufacturer ID
	pInfo->lcm_info.man_id = tmp;
	tmp = read_st(0xdb);//lcd module's	ID
	pInfo->lcm_info.dev_id = tmp<<8;
	tmp = read_st(0xdc);//lcd module's	ID
	pInfo->lcm_info.dev_id |= tmp;

	if((pInfo->width == 240 && pInfo->height == 240) && 
			((pInfo->lcm_info.man_id == LCM_ID_ST) &&((pInfo->lcm_info.dev_id & 0xfff0) == (LCM_ID_ST7789V & 0xfff0))))
	{
		var_screeninfo.xs_offset = 0;
		var_screeninfo.ys_offset = 0;
		if(var_screeninfo.lcd_version == 2)
		{
			var_screeninfo.ys_offset = 40;
		}
		var_screeninfo.xs = var_screeninfo.xs_offset;
		var_screeninfo.ys = var_screeninfo.ys_offset;
		var_screeninfo.width = 240;
		var_screeninfo.height = 240;
		var_screeninfo.xe = var_screeninfo.width + var_screeninfo.xs - 1;
		var_screeninfo.ye = var_screeninfo.height + var_screeninfo.ys - 1;
		
		pInfo->lcm_info.lcd_item = ST7789V_240x240;
		pInfo->lcm_info.name = "ST7789V_240x240";
	}
	else if (pInfo->width == 128 && pInfo->height == 128)
	{
		var_screeninfo.xs_offset = 2;
		var_screeninfo.ys_offset = 3;
		var_screeninfo.xs = var_screeninfo.xs_offset;
		var_screeninfo.ys = var_screeninfo.ys_offset;
		var_screeninfo.width = 128;
		var_screeninfo.height = 128;
		var_screeninfo.xe = var_screeninfo.width + var_screeninfo.xs - 1;
		var_screeninfo.ye = var_screeninfo.height + var_screeninfo.ys - 1;
		
		pInfo->lcm_info.lcd_item = BOE7735S_128x128;
		pInfo->lcm_info.name = "BOE7735S_128x128";		
	} 
	else
	{
		var_screeninfo.xs_offset = 0;
		var_screeninfo.ys_offset = 0;
		var_screeninfo.xs = var_screeninfo.xs_offset;
		var_screeninfo.ys = var_screeninfo.ys_offset;
		var_screeninfo.width = 240;
		var_screeninfo.height = 240;
		var_screeninfo.xe = var_screeninfo.width + var_screeninfo.xs - 1;
		var_screeninfo.ye = var_screeninfo.height + var_screeninfo.ys - 1;
		
		pInfo->width = 240;
		pInfo->height = 240;
		pInfo->lcm_info.lcd_item = ST7789V_240x240;
		pInfo->lcm_info.name = "ST7789V_240x240";
	}
	
	BOOT_PRINTF(UBOOT_NOTICE, "%s init: lcd man_id = 0x%x, dev_id=0x%x\n", pInfo->lcm_info.name, pInfo->lcm_info.man_id,pInfo->lcm_info.dev_id);
	return 0;
}

int update_rect(unsigned char *pBuf, unsigned short uiLeft, unsigned short uiTop, unsigned short uiWidth, unsigned short uiHeight)
{
	return update_rect_color(pBuf, uiLeft, uiTop, uiWidth, uiHeight);
}
