/*******************************************************************************
 * Copyright (C) 2014, ZTE Corporation.
 *
 * File Name:   hal_led.c
 * File Mark:
 * Description:  This file contains the hal layer routines for i2c driver.
 * Others:
 * Version:       V1.0
 * Author:        yx
 * Date:          2014-07-03
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ******************************************************************************/

/****************************************************************************
*                                  Include files
****************************************************************************/
#include <common.h>
//#include "drvs_general.h"
//#include "drvs_i2c.h"
#include <linux/types.h>
#include <power.h>
#include <zx234290.h>
#include <led.h>
#include <lcd.h>
//#include <lcd_blg.h>
#include <charge.h>
#include <zx234502.h>
#include <partition_table.h>
#include <linux/mtd/compat.h>
/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
#define CHARGER_EN_GPIO		GPIO40
#define CHARGER_EN_GPIO_FUN GPIO40_GPIO40
/****************************************************************************
* 	                                           Local Types
****************************************************************************/

/****************************************************************************
* 	                                           Local Constants
****************************************************************************/
static void ms_delay(unsigned long ms)
{
    volatile int i = 0;
    while (i < (50000 * ms)) {i++;}
}

/****************************************************************************
 * Function:    peripheral_init
 * Description: init the peripheral include pmu\charger\led\lcd etc.
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *     int
 *
 *
 * Others:
 ***************************************************************************/
int peripheral_init(void)
{
    int ret = 0;
    ret = power_init();
	
	/*charger enable*/
	zDrvGpio_SetFunc(CHARGER_EN_GPIO,CHARGER_EN_GPIO_FUN);
    zDrvGpio_SetDirection(CHARGER_EN_GPIO,GPIO_OUT);
    zDrvGpio_SetOutputValue(CHARGER_EN_GPIO,GPIO_HIGH);

	/*reset for the TF card LD08 */
	zx234290_ldo8_enable(0);
	udelay(100000/20); /*50ms*/
	zx234290_ldo8_enable(1);
	
    return ret ;
}

/****************************************************************************
 * Function:    Show_UpdateWait
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 *
 * Returns:
 *     int
 *
 *
 * Others:
 ***************************************************************************/
int Show_UpdateWait(void)
{
    int ret = 0;
/*led*/

/*lcd*/
    ;
    return ret;
}

/****************************************************************************
 * Function:    Show_UpdateSucc
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 *
 * Returns:
 *     int
 *
 *
 * Others:
 ***************************************************************************/
int Show_UpdateSucc(void)
{
    int ret = 0;
/*led*/

/*lcd*/
    ;
    return ret;
}

/****************************************************************************
 * Function:    Show_UpdateFail
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 *
 * Returns:
 *     int
 *
 *
 * Others:
 ***************************************************************************/
int Show_UpdateFail(void)
{
    int ret = 0;
/*led*/

/*lcd*/
    ;
    return ret;
}

/****************************************************************************
 * Function:    Show_LowPower
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 *
 * Returns:
 *     int
 *
 *
 * Others:
 ***************************************************************************/
int Show_LowPower(void)
{
    int ret = 0;
/*led*/

/*lcd*/
    zDrvLcd_ShowLowBattery();
	ms_delay(50);
	zDrvLcd_TurnBacklightOnOff(1);
	zDrvLcd_SetPulseLevel(14);

    return ret;
}

/****************************************************************************
 * Function:    Show_No_Battery
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 *
 * Returns:
 *     int
 *
 *
 * Others:
 ***************************************************************************/
int Show_No_Battery(void)
{
    int ret = 0;
/*led*/

/*lcd*/
	zDrvLcd_ShowNoBattery();
	ms_delay(50);
	zDrvLcd_TurnBacklightOnOff(1);
	zDrvLcd_SetPulseLevel(14);

    return ret;
}

/****************************************************************************
 * Function:    Show_PowerOn_Normal
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 *
 * Returns:
 *     int
 *
 *
 * Others:
 ***************************************************************************/
int Show_PowerOn_Normal(void)
{
    int ret = 0;
/*led*/

/*lcd*/
	zDrvLcd_PowerOnLogo();
	ms_delay(50);
	zDrvLcd_TurnBacklightOnOff(1);
	zDrvLcd_SetPulseLevel(14);

    return ret;
}

/****************************************************************************
 * Function:    Show_PowerOn_Fota
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 *
 * Returns:
 *     int
 *
 *
 * Others:
 ***************************************************************************/

int Show_PowerOn_Fota(void)
{
	int ret = 0;
/*led*/

/*lcd*/
	zDrvLcd_ShowUpdateWait();
	ms_delay(50);
	zDrvLcd_TurnBacklightOnOff(1);
	zDrvLcd_SetPulseLevel(14);

	return ret;
}


/****************************************************************************
 * Function:    Show_Charging
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 *
 * Returns:
 *     int
 *
 *
 * Others:
 ***************************************************************************/
int Show_Charging(void)
{
    int ret = 0;
/*led*/

/*lcd*/
	zDrvLcd_PowerOnLogo();
	ms_delay(50);
	zDrvLcd_TurnBacklightOnOff(1);
	zDrvLcd_SetPulseLevel(14);

    return ret;
}

/****************************************************************************
 * Function:    Show_PowerOn_Rtc
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 *
 * Returns:
 *     int
 *
 *
 * Others:
 ***************************************************************************/

int Show_PowerOn_Rtc(void)
{
	int ret = 0;
/*led*/

/*lcd*/
	zDrvLcd_PowerOnLogo();
	return ret;
}

/****************************************************************************
 * Function:    zx_get_vbat_voltage
 * Description: .
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 *
 * Returns:
 *     int
 *
 *
 * Others:
 ***************************************************************************/
int zx_get_vbat_voltage(void)
{
   // int ret = 0;

	return zx234290_get_adc1_voltage();
}

/****************************************************************************
 * Function:    zx_get_battery_Status
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 *
 * Returns:
 *     int
 *
 *
 * Others:
 ***************************************************************************/
unsigned int zx_get_battery_Status(void)
{
    int ret = 0;
    int battery_status = 0;

    ret = zx234290_get_adc2_voltage();
    if (ret < 0)
    {
        printf("\t[zx234290_get_adc2_voltage] return [%d] in [%s]\n", ret, __FUNCTION__);
        return ret;
    }

    battery_status = (ret < 1670);

    return battery_status;
}
