
#include "cfg_api.h"


int cpe_get_localip(const char * eth_name, char *hostip)
{

    sc_cfg_get(eth_name, hostip, 256);

    return CWMP_OK;

	
#if 0
    register int fd,intrface,retn=0;
    struct ifreq buf[32];
    struct ifconf ifc;
    char domain_host[100] = {0};
    char local_ip_addr[20] = {0};
    char local_mac[20] = {0};
    //Get Domain Name --------------------------------------------------
    strcpy(local_ip_addr, "127.0.0.1");
    if (!hostip)
        return -1;
    if (getdomainname(&domain_host[0], 100) != 0)
    {
        return -1;
    }
    //------------------------------------------------------------------
    //Get IP Address & Mac Address ----------------------------------------
    if ((fd=socket(AF_INET,SOCK_DGRAM,0))>=0)
    {
        ifc.ifc_len=sizeof buf;
        ifc.ifc_buf=(caddr_t)buf;
        if (!ioctl(fd,SIOCGIFCONF,(char*)&ifc))
        {
            intrface=ifc.ifc_len/sizeof(struct ifreq);
            while (intrface-->0)
            {
                if (!(ioctl(fd,SIOCGIFFLAGS,(char*)&buf[intrface])))
                {
                    if (buf[intrface].ifr_flags&IFF_PROMISC)
                    {
                        retn++;
                    }
                }
                //Get IP Address
                if (!(ioctl(fd,SIOCGIFADDR,(char*)&buf[intrface])))
                {
		    if(strcmp(eth_name, buf[intrface].ifr_name) == 0)
		    {
                    sprintf(local_ip_addr, "%s", inet_ntoa(((struct sockaddr_in*)(&buf[intrface].ifr_addr))->sin_addr));
		
		    break;
		    }
                }
                //Get Hardware Address

            }//While
        }
    }
    if ( fd > 0 )
    {
        close(fd);
    }

    strcpy(hostip, local_ip_addr);

    return CWMP_OK;
#endif
	
}

//InternetGatewayDevice.ManagementServer.Username
int cpe_get_igd_ms_username(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{   
    FUNCTION_TRACE();
	*value = cwmp_conf_pool_get(pool, "cwmp:acs_username");
    return FAULT_CODE_OK;
}

//InternetGatewayDevice.ManagementServer.Username
int cpe_set_igd_ms_username(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
    cwmp_conf_set("cwmp:acs_username", value);
	pool_pfree(cwmp->pool, cwmp->acs_user);
	cwmp->acs_user = pool_pstrdup(cwmp->pool, value);
    return FAULT_CODE_OK;
}

//InternetGatewayDevice.ManagementServer.Password
int cpe_get_igd_ms_password(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
    FUNCTION_TRACE();       
	*value = cwmp_conf_pool_get(pool, "cwmp:acs_password");
	return FAULT_CODE_OK;
}

int cpe_set_igd_ms_password(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
    cwmp_conf_set("cwmp:acs_password", value);
	pool_pfree(cwmp->pool, cwmp->acs_pwd);
	cwmp->acs_pwd = pool_pstrdup(cwmp->pool, value);	
    return FAULT_CODE_OK;
}

//InternetGatewayDevice.ManagementServer.URL
int cpe_get_igd_ms_url(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{    
    FUNCTION_TRACE();
	*value = cwmp_conf_pool_get(pool, "cwmp:acs_url");
    return FAULT_CODE_OK;
}

//InternetGatewayDevice.ManagementServer.URL
int cpe_set_igd_ms_url(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
    cwmp_conf_set("cwmp:acs_url", value);
	pool_pfree(cwmp->pool, cwmp->acs_url);
	cwmp->acs_url = pool_pstrdup(cwmp->pool, value);	
    return FAULT_CODE_OK;
}


int cpe_get_igd_ms_PeriodicInformEnable(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{    
    FUNCTION_TRACE();
	*value = cwmp_conf_pool_get(pool, "periodic:enable");
    return FAULT_CODE_OK;
}



int cpe_set_igd_ms_PeriodicInformEnable(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
    cwmp_log_info("set PeriodicInformEnable:%s", value);
	cwmp_conf_set("periodic:enable", value);
	update_periodic_info_enable(cwmp);
    return FAULT_CODE_OK;
}




int cpe_set_igd_ms_PeriodicInformInterval(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
    cwmp_log_info("set PeriodicInformInterval:%s", value);
	cwmp_conf_set("periodic:interval", value);

	update_periodic_info_interval(cwmp);
	
    return FAULT_CODE_OK;
}



int cpe_get_igd_ms_PeriodicInformInterval(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{    
    FUNCTION_TRACE();
	*value = cwmp_conf_pool_get(pool, "periodic:interval");
    return FAULT_CODE_OK;
}

//InternetGatewayDevice.ManagementServer.ConnectionRequestURL
int cpe_get_igd_ms_connectionrequesturl(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
    char buf[512]={0};
    char local_ip[256]={0};
    FUNCTION_TRACE();

    int port = cwmp_conf_get_int("cwmpd:httpd_port");
    int family  = get_family_type();

    if(family == AF_INET)
    {
        cpe_get_localip("wan1_ip", local_ip);
        snprintf(buf, sizeof(buf), "http://%s:%d", local_ip, port);
    }
    else if(family == AF_INET6)
    {
        cpe_get_localip("ipv6_br0_addr", local_ip);
        snprintf(buf, sizeof(buf), "http://[%s]:%d", local_ip, port);
    }
    else
    {
        cpe_get_localip("wan1_ip", local_ip);
        snprintf(buf, sizeof(buf), "http://%s:%d", local_ip, port);
        cwmp_log_error("unknown family type:%d", family);
    }

    cwmp_log_debug("connectionrequesturl:%s", buf);
	
    *value = PSTRDUP(buf);
    return FAULT_CODE_OK;
}

//InternetGatewayDevice.ManagementServer.ConnectionRequestUsername
int cpe_get_igd_ms_connectionrequestusername(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
    FUNCTION_TRACE();
    *value = cwmp_conf_pool_get(pool, "cwmp:cpe_username");	
    return FAULT_CODE_OK;
}
int cpe_set_igd_ms_connectionrequestusername(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
    cwmp_conf_set("cwmp:cpe_username", value);
	pool_pfree(cwmp->pool, cwmp->cpe_user);
	cwmp->cpe_user = pool_pstrdup(cwmp->pool, value);	
    return FAULT_CODE_OK;
}


//InternetGatewayDevice.ManagementServer.ConnectionRequestPassword
int cpe_get_igd_ms_connectionrequestpassword(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{    
    *value = cwmp_conf_pool_get(pool, "cwmp:cpe_password");
    return FAULT_CODE_OK;
}
int cpe_set_igd_ms_connectionrequestpassword(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
	int rc = cwmp_conf_set("cwmp:cpe_password", value);
	cwmp_log_info("set result:%d", rc);
	pool_pfree(cwmp->pool, cwmp->cpe_pwd);
	cwmp->cpe_pwd = pool_pstrdup(cwmp->pool, value);		
    return FAULT_CODE_OK;
}



int cpe_get_igd_ms_STUNEnable(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{    
    FUNCTION_TRACE();
	*value = cwmp_conf_pool_get(pool, "test:stun_enable");
	
    return FAULT_CODE_OK;
}


int cpe_set_igd_ms_STUNEnable(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
    cwmp_conf_set("test:stun_enable", value);
    return FAULT_CODE_OK;
}


int cpe_get_igd_ms_parameterkey(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{    
    FUNCTION_TRACE();
	*value = cwmp_conf_pool_get(pool, "test:parameterkey");
	
    return FAULT_CODE_OK;
}


int cpe_set_igd_ms_parameterkey(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
    cwmp_conf_set("test:parameterkey", value);
    return FAULT_CODE_OK;
}


int cpe_get_igd_ms_stunserveraddress(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{    
    FUNCTION_TRACE();
	*value = cwmp_conf_pool_get(pool, "test:stun_serveraddress");
	
    return FAULT_CODE_OK;
}


int cpe_set_igd_ms_stunserveraddress(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
    cwmp_conf_set("test:stun_serveraddress", value);
    return FAULT_CODE_OK;
}

int cpe_get_igd_ms_stunserverport(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{    
    FUNCTION_TRACE();
	*value = cwmp_conf_pool_get(pool, "test:stun_serverport");
	
    return FAULT_CODE_OK;
}


int cpe_set_igd_ms_stunserverport(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
    cwmp_conf_set("test:stun_serverport", value);
    return FAULT_CODE_OK;
}

int cpe_get_igd_ms_stunusername(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{    
    FUNCTION_TRACE();
	*value = cwmp_conf_pool_get(pool, "test:stun_username");
	
    return FAULT_CODE_OK;
}


int cpe_set_igd_ms_stunusername(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
    cwmp_conf_set("test:stun_username", value);
    return FAULT_CODE_OK;
}

int cpe_get_igd_ms_stunpassword(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{    
    FUNCTION_TRACE();
	*value = cwmp_conf_pool_get(pool, "test:stun_password");
	
    return FAULT_CODE_OK;
}


int cpe_set_igd_ms_stunpassword(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
    cwmp_conf_set("test:stun_password", value);
    return FAULT_CODE_OK;
}

int cpe_get_igd_ms_stunmaximumkeepaliveperiod(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{    
    FUNCTION_TRACE();
	*value = cwmp_conf_pool_get(pool, "test:stun_maximumkeepaliveperiod");
	
    return FAULT_CODE_OK;
}


int cpe_set_igd_ms_stunmaximumkeepaliveperiod(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
    cwmp_conf_set("test:stun_maximumkeepaliveperiod", value);
    return FAULT_CODE_OK;
}


int cpe_get_igd_ms_stunminimumkeepaliveperiod(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{    
    FUNCTION_TRACE();
	*value = cwmp_conf_pool_get(pool, "test:stun_minimumkeepaliveperiod");
	
    return FAULT_CODE_OK;
}


int cpe_set_igd_ms_stunminimumkeepaliveperiod(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
    cwmp_conf_set("test:stun_minimumkeepaliveperiod", value);
    return FAULT_CODE_OK;
}

int cpe_get_igd_ms_natdetected(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{    
    FUNCTION_TRACE();
	*value = cwmp_conf_pool_get(pool, "test:natdetected");
	
    return FAULT_CODE_OK;
}


int cpe_set_igd_ms_natdetected(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
    cwmp_conf_set("test:natdetected", value);
    return FAULT_CODE_OK;
}


