//#include <message.h>
#include <limits.h>
#include <errno.h>
#include <wifi.h>
#include "wlan_interface.h"
#include "softap_api.h"

#define WIFI_SSID_LEN        33
#define WLAN_SECURITY_LEN    20
#define WLAN_ENCRYTYPE_LEN   10
#define WLAN_DEFAULTID_LEN    2
#define WLAN_WEPKEY_LEN      32
#define WLAN_PSK_LEN         65
#define WLAN_ENCODE_PSK_LEN 100

#define WF_AU_OPEN          "OPEN"            //wifi auth mode?
#define WF_AU_SHARE         "SHARED"
#define WF_AU_WEPAUTO       "WEPAUTO"
#define WF_AU_WPA           "WPAPSK"
#define WF_AU_WPA2          "WPA2PSK"
#define WF_AU_WPA_WPA2  	"WPAPSKWPA2PSK" 
#define WF_AU_WAPIPSK	    "WAPIPSK"
#define WF_AU_WPA3          "WPA3Personal"
#define WF_AU_WPA2_WPA3     "WPA2WPA3"
#define WF_ENCRY_NONE       "NONE"   //encrypt
#define WF_ENCRY_WEP        "WEP"
#define WF_ENCRY_TKIP       "TKIP"
#define WF_ENCRY_CCMP       "CCMP"
#define WF_ENCRY_AES        "AES"
#define WF_ENCRY_TKIP_CCMP  "TKIPCCMP"
#define WF_ENCRY_TKIP_AES   "TKIPAES"

#define MAX_WIFI_NUM 32

static int zte_station_connect_time_calc(char *timeStr);
static void zte_get_vap_sta_list(RT_802_11_MAC_TABLE *staList, char *iface);
//int get_vap_sta_num(char *vapIface);

static int zte_wlan_ssid1_basic_set(char *ssid_in)
{
    char  *ssid = NULL; 
	char nv_tmp[WIFI_SSID_LEN] = {0};
	
	if (NULL == ssid_in)
	{
		printf("input ssid is null\n");
		return -1;
	}

	if ((!strcmp(ssid_in, "")) || (strlen(ssid_in) <= 0) || (strlen(ssid_in) > WIFI_SSID_LEN))
	{
		printf("input ssid is error\n");
		return -1;
	}
    
    //ssid
    memset(nv_tmp, 0, sizeof(nv_tmp));
	//kw 3
    sc_cfg_get("SSID1", nv_tmp, sizeof(nv_tmp));
    if (0 != strcmp(ssid_in, nv_tmp))
    {
        sc_cfg_set("SSID1", ssid_in);
		//sc_cfg_save();
    }
	else
	{
		printf("input ssid is same \n");
		return 1;
	}

    return 0;
}

static int zte_wlan_ssid1_security_set(char *password)
{	
    char authMode[WLAN_SECURITY_LEN]      = {0};
    char encrypType[WLAN_ENCRYTYPE_LEN]   = {0};
	char DefaultKeyID[WLAN_DEFAULTID_LEN] = {0};
    int changeSecurityMode = 1;
    
	sc_cfg_get("AuthMode", authMode, sizeof(authMode));
	sc_cfg_get("EncrypType", encrypType, sizeof(encrypType));

	//kw 3  
    printf("wlan_ssid1_security_set authMode = [%s]\n", authMode);
	printf("wlan_ssid1_security_set encrypType = [%s]\n", encrypType);   
	if(NULL == password)//&& (!(!strcmp(authMode, WF_AU_OPEN) && !strcmp(encrypType, WF_ENCRY_NONE))))
	{
		printf("wlan_ssid1_security_set password is null\n");
		return -1;
	}
#if 0 //kw 3
	if((!strcmp(authMode, WF_AU_OPEN)) && (!strcmp(encrypType, WF_ENCRY_NONE)))
	{
		if(strlen(password) == 0 || (!strcmp(password, "")))
		{
			printf("%s, WF_AU_OPEN password len is 0\n", __FUNCTION__);
			return 1;
		}
		else 
		{
			if((strlen(password) < 8) || (strlen(password) > 64))
			{
				printf("%s,  password len is error\n", __FUNCTION__);
				return -1;
			}
		}
	}
	else
	{
		if((strlen(password) < 8) || (strlen(password) > 64) || (!strcmp(password, "")))
		{
			printf("%s, not open password len is error\n", __FUNCTION__);
			return -1;
		}
	}
#endif	
	if(((!strcmp(authMode, WF_AU_WPA_WPA2)) && (!strcmp(encrypType, WF_ENCRY_TKIP_AES))))
	{
		changeSecurityMode = 0;
	}
	else
	{
		sc_cfg_set("AuthMode", WF_AU_WPA_WPA2);
		sc_cfg_set("EncrypType", WF_ENCRY_TKIP_AES);
	}
    if((!strcmp(authMode, WF_AU_OPEN))  || (!strcmp(authMode, WF_AU_SHARE)) ||  (!strcmp(authMode, WF_AU_WEPAUTO)))
    {   
        if(((!strcmp(authMode, WF_AU_OPEN)) && (!strcmp(encrypType, WF_ENCRY_WEP))) ||
        	 (!strcmp(authMode, WF_AU_SHARE)) || (!strcmp(authMode, WF_AU_WEPAUTO))) 
        {
		    int len = 0;
			len = strlen(password);
			if(len != 5 && len != 10 && len != 13 && len != 26) //kw 3 ;wep 5,13(no 16)
			{
				printf("wlan_ssid1_security_set wep psk len = [%d]\n", len);  
				return -1;
			}
			sc_cfg_get("DefaultKeyID",DefaultKeyID,sizeof(DefaultKeyID));
 			//kw 3
			char old_wep_key[WLAN_WEPKEY_LEN] = {0};
			
			if(!strcmp(DefaultKeyID, "1"))
			{
				sc_cfg_get("Key2Str1",old_wep_key,sizeof(old_wep_key));
				if(strcmp(old_wep_key, password))
				{
					sc_cfg_set("Key2Str1", password);
					//sc_cfg_save();
				}
				else
				{
					printf("wlan_ssid1_security_set wep psk is same\n");  
					return 1;
				}
			}
			else if(!strcmp(DefaultKeyID, "2"))
			{
                sc_cfg_get("Key3Str1",old_wep_key,sizeof(old_wep_key));
				
				if(strcmp(old_wep_key, password))
				{
					sc_cfg_set("Key3Str1", password);
					//sc_cfg_save();
				}
				else
				{
					printf("wlan_ssid1_security_set wep psk is same\n");  
					return 1;
				}
			}
			else if(!strcmp(DefaultKeyID, "3"))
			{
				sc_cfg_get("Key4Str1",old_wep_key,sizeof(old_wep_key));
				if(strcmp(old_wep_key, password))
				{
					sc_cfg_set("Key4Str1", password);
					//sc_cfg_save();
				}
				else
				{
					printf("wlan_ssid1_security_set wep psk is same\n");  
					return 1;
				}
			}
			else 
			{
				sc_cfg_get("Key1Str1",old_wep_key,sizeof(old_wep_key));
				if(strcmp(old_wep_key, password))
				{
					sc_cfg_set("Key1Str1", password);
					//sc_cfg_save();
				}
				else
				{
					printf("wlan_ssid1_security_set wep psk is same\n");  
					return 1;
				}
			}
		
        }
        else if(!strcmp(authMode, WF_AU_OPEN) && !strcmp(encrypType, WF_ENCRY_NONE))
        {
            printf("authMode is open and not wep \n");
			return 1;

        }
    }
    else if(!strcmp(authMode, WF_AU_WPA)  || !strcmp(authMode, WF_AU_WPA2) || !strcmp(authMode,  WF_AU_WPA_WPA2))
    {
		char psk[WLAN_PSK_LEN] = {0};
        int len = 0;
		char encode[WLAN_ENCODE_PSK_LEN] = {0};
		len = strlen(password);
		
		if(len < 8 || len > 64)
		{
			printf("%s password len is %d \n",authMode, len);
			return -1;
		}
		sc_cfg_get("WPAPSK1",psk,sizeof(psk));
		//kw 3
		if(strcmp(psk, password))
		{
			sc_cfg_set("WPAPSK1", password);
			base64_encode(password, len, encode, WLAN_ENCODE_PSK_LEN);
			sc_cfg_set("WPAPSK1_encode", encode);
			//sc_cfg_save();
		}
		else
		{
			if(!changeSecurityMode)
			{
				printf("%s, wpapskwpa2psk psk is same\n", __FUNCTION__);
				return 1;
			}
		}

    }
	else if(!strcmp(authMode, WF_AU_WAPIPSK))
	{
		char psk[WLAN_PSK_LEN]                = {0};
		int len = 0;
		char encode[WLAN_ENCODE_PSK_LEN] = {0};
		len = strlen(password);
		
		if(len < 8 || len > 64)
		{
			printf("WF_AU_WAPIPSK password len is %d \n", len);
			return -1;
		}
		sc_cfg_get("WPAPSK1",psk,sizeof(psk));
		//kw 3
		if(strcmp(psk, password))
		{
			sc_cfg_set("WPAPSK1", password);
			base64_encode(password, len, encode, WLAN_ENCODE_PSK_LEN);
			sc_cfg_set("WPAPSK1_encode", encode);
			//sc_cfg_save();
		}
		else
		{
			if(!changeSecurityMode)
			{
				printf("%s, wapi psk is same\n", __FUNCTION__);
				return 1;
			}
		}
	
	}
    else
    {
        // other security mode is invalid
        printf("ERROR:security mode  is invalid\n");
        return -1;
    }

    return 0;
}

int zte_wlan_get_ssid1_settings(char* ssid, char* password, int ssid_len, int password_len)
{
	char authMode[WLAN_SECURITY_LEN]      = {0};
    char encrypType[WLAN_ENCRYTYPE_LEN]   = {0};
	char DefaultKeyID[WLAN_DEFAULTID_LEN] = {0};

	if(NULL == ssid || NULL == password)
	{
		printf("ERROR:input ssid && password is null\n");
		return -1;
	}
	
	//kw 3
	char old_ssid[WIFI_SSID_LEN] = {0};
	sc_cfg_get("SSID1",old_ssid,sizeof(old_ssid));
	strncpy(ssid, old_ssid, ssid_len - 1);

	sc_cfg_get("AuthMode",authMode,sizeof(authMode));
	sc_cfg_get("EncrypType",encrypType,sizeof(encrypType));

	printf("wlan_ssid1_security_get authMode = [%s]\n", authMode);   
	printf("wlan_ssid1_security_get encrypType = [%s]\n", encrypType);   

	if((!strcmp(authMode, WF_AU_OPEN))  || (!strcmp(authMode, WF_AU_SHARE)) ||  (!strcmp(authMode, WF_AU_WEPAUTO)))
	{   
		if(((!strcmp(authMode, WF_AU_OPEN)) && (!strcmp(encrypType, WF_ENCRY_WEP))) ||
			(!strcmp(authMode, WF_AU_SHARE)) || (!strcmp(authMode, WF_AU_WEPAUTO))) 
		{
			sc_cfg_get("DefaultKeyID",DefaultKeyID,sizeof(DefaultKeyID));

			char old_wep_key[WLAN_WEPKEY_LEN] = {0};
			if(!strcmp(DefaultKeyID, "1"))
			{
				sc_cfg_get("Key2Str1",old_wep_key,sizeof(old_wep_key));
				strncpy(password, old_wep_key, password_len-1);
			}
			else if(!strcmp(DefaultKeyID, "2"))
			{
				sc_cfg_get("Key3Str1",old_wep_key,sizeof(old_wep_key));
				strncpy(password, old_wep_key, password_len-1);
			}
			else if(!strcmp(DefaultKeyID, "3"))
			{
				sc_cfg_get("Key4Str1",old_wep_key,sizeof(old_wep_key));
				strncpy(password, old_wep_key, password_len-1);
			}
			else 
			{
				sc_cfg_get("Key1Str1",old_wep_key,sizeof(old_wep_key));
				strncpy(password, old_wep_key, password_len-1);
			}
		
		}
    }
	else if(!strcmp(authMode, WF_AU_WPA)  || !strcmp(authMode, WF_AU_WPA2) || !strcmp(authMode,  WF_AU_WPA_WPA2))
	{
		char psk[WLAN_PSK_LEN]                = {0};
		sc_cfg_get("WPAPSK1",psk,sizeof(psk));
		strncpy(password, psk, password_len-1);
	}
	else if(!strcmp(authMode, WF_AU_WAPIPSK))
	{
		char psk[WLAN_PSK_LEN]                = {0};
		sc_cfg_get("WPAPSK1",psk,sizeof(psk));
		strncpy(password, psk, password_len-1);
	}
	else
	{
		return -1;
	}

	return 0;
}

int zte_wlan_ssid1_set(char* ssid, char* password)
{
	int ret_for_basic = 0;
	int ret_for_security = 0;
	
	ret_for_basic = zte_wlan_ssid1_basic_set(ssid);
    if(-1 == ret_for_basic)
    {
        printf("wlan_ssid1_basic_set is false\n");
        return -1;
    }
	ret_for_security = zte_wlan_ssid1_security_set(password);
    if(-1 == ret_for_security)
    {
        printf("call lan_ssid1_security_set failure .\n");   
		return -1;//kw 3
	}
	
    if(ret_for_basic == 0 || ret_for_security == 0)
	{
		if(0 == ipc_send_message(MODULE_ID_WLAN_SERVER, MODULE_ID_WIFI, MSG_CMD_WIFI_ADVANCED, 2, "1", 0))
		{
			//sc_cfg_set("RadioOff", "0");
			printf("wifi set cmd done!\n");
		}
		else
		{
			printf("wifi set cmd wlan_ssid1_set error!\n");
			return -1;
		}
    }
    return 0; 
}

//wifi_hal.c of realtek, in order to capture sta num of va0 and va1(if multi ssid is enabled)
int zte_wlan_capture_sta_num()
{
    int staNum_va0 = 0;
	int staNum_va1 = 0;
	int staTotalNum = 0;
	char radioOff[8] = {0};
	char mutli_ssid_enable[8] = {0};
	char wifi_cur_state[8] = {0};
	//sc_cfg_get("RadioOff",radioOff,sizeof(radioOff));
	sc_cfg_get("wifi_cur_state",wifi_cur_state,sizeof(wifi_cur_state));
	sc_cfg_get("m_ssid_enable",mutli_ssid_enable,sizeof(mutli_ssid_enable));
	
	if( !strncmp(wifi_cur_state,"0",1) )
	{
	    printf("[%s]wifi is off, can't obtain sta info!!\n",__FUNCTION__);
	    return 0;
	}
	
	//staNum_va0 = get_vap_sta_num("wlan0-va0");
#ifdef __SINGLE_AP__	
	staNum_va0 = get_vap_sta_num("wlan0");
#else	
	staNum_va0 = get_vap_sta_num("wlan0-va0");
#endif

	printf("[%s] the Sta Num of Va0 = %d\n",__FUNCTION__,staNum_va0);
	
	if( !strncmp(mutli_ssid_enable,"1",1))
	{
	    staNum_va1 = get_vap_sta_num("wlan0-va1");
	    printf("[%s] the Sta Num of Va1 = %d\n",__FUNCTION__,staNum_va1);
	}
	if ((staNum_va0 < 0 || staNum_va0 > MAX_WIFI_NUM) ||
		(staNum_va1 < 0 || staNum_va1 > MAX_WIFI_NUM)) { //kw 3
		printf("[%s]staNum error: %d,%d!!\n",__FUNCTION__,staNum_va0,staNum_va1);
	    return 0;
	}
	staTotalNum = staNum_va0 + staNum_va1;
	printf("[%s] staTotalNum = %d\n",__FUNCTION__,staTotalNum);
	return staTotalNum;
 }
#if 0
//get vap sta num, second method:no use of complex algorithms,just read first line of sta_info 
static int get_vap_sta_num(char* vapIface)
{
    int sta_num = 0;
    char buf[128] = {0};
    FILE *fp = NULL;
    FILE *fp_num = NULL;
    printf("[%s] vapIface=%s\n",__FUNCTION__, vapIface);
    memset(buf,0,sizeof(buf));
    sprintf(buf, "cat /proc/%s/sta_info > /tmp/lib-stalist-%s", vapIface,vapIface);
    system(buf);
    
    memset(buf,0,sizeof(buf));
    sprintf(buf, "/tmp/lib-stalist-%s",vapIface);

    fp = fopen(buf, "r");
	
    if(NULL == fp)    
    {       
        fprintf(stderr, "can not open file lib-stalist-%s.",vapIface);  
        return 0;
    } 
    memset(buf,0,sizeof(buf));
    sprintf(buf, "cat /tmp/lib-stalist-%s | grep \"active\" | cut -d \':\' -f 2 | cut -d \')\' -f 1 > /tmp/lib-sta-num-%s",vapIface,vapIface);
    system(buf);
	
    memset(buf,0,sizeof(buf));
    sprintf(buf,"/tmp/lib-sta-num-%s",vapIface);	
    fp_num = fopen(buf,"r");
    
    if(NULL == fp_num)    
    {       
        fprintf(stderr, "can not open file lib-sta-num-%s.",vapIface);   

        goto END;
    }  

    fscanf(fp_num,"%d",&sta_num);
    printf("[%s] sta_num is %d\n",__FUNCTION__,sta_num);
END:
    if(NULL != fp)
    {
        fclose(fp);
    }

    if(NULL != fp_num)
    {
        fclose(fp_num);
    }
    
    return sta_num;
}
#endif

//get vap sta num, second method:no use of complex algorithms,just read first line of sta_info
int get_vap_sta_num(char* vapIface)
{
	int sta_num = 0;
	char sta_num_str[8] = {0};
	char buf[128] = {0};
	char sta_info_buf[128] = {0};
	int sta_info_len = 0;
	int i, j = 0;
	FILE *fp = NULL;
	printf("[%s] vapIface=%s\n",__FUNCTION__, vapIface);

	memset(buf,0,sizeof(buf));
	sprintf(buf, "/proc/%s/sta_info", vapIface);
	
	fp = fopen(buf, "r");
	if(NULL == fp)	  
	{		
		fprintf(stderr, "can not open file /proc/%s/sta_info.",vapIface);  
		return 0;
	} 
	fgets(sta_info_buf,sizeof(sta_info_buf),fp);
	printf("[%s]sta_info_buf is %s\n",__FUNCTION__,sta_info_buf);
	if(strcmp(sta_info_buf,"")==0)
	{
		printf("[%s]sta_info is null\n",__FUNCTION__);
		fclose(fp);
		return 0;
	}
	sta_info_len = strlen(sta_info_buf);
	for(i=0;i<sta_info_len;i++)
	{
		if(sta_info_buf[i] >= '0' && sta_info_buf[i] <= '9')
		{
			sta_num_str[j++] = sta_info_buf[i];
			if (j >= sizeof(sta_num_str)-1)//klocwork
				break;
		}
	}
	
	printf("[%s]sta_num_str:%s\n",__FUNCTION__,sta_num_str);
	
	sta_num = atoi(sta_num_str);

	printf("[%s]sta_num:%d\n",__FUNCTION__,sta_num);
	//kw 3
	fclose(fp);
	
	return sta_num;
}

static int zte_station_connect_time_calc(char* timeStr)
{
    //timeStr : [1 hr 2 min 3 sec]
	//char timeStr[32] = {0};
    char *splited_val = NULL;
    char *splited_str = NULL;
    char *delimiter = " ";
    char *save = NULL;
    int time = 0;
	int splited_int = 0;

	//strncpy(timeStr, str, 31);
	//timeStr[31] = '\0';
	printf("timeStr %s\n", timeStr);
    splited_val = strtok_r(timeStr, delimiter, &save);
    if(NULL != splited_val)
    {
		printf("splited_val is %s\n", splited_val);
        splited_str = strtok_r(NULL, delimiter, &save);
    }
	else
	{
		printf("splited_val is NULL\n");
	}
    
    while(NULL != splited_val && NULL != splited_str)
    {
		printf("val %s, str %s\n", splited_val, splited_str);
		splited_int = atoi(splited_val);
		
		if(splited_int < 0 || splited_int > INT_MAX-1) {//kw 3
			printf("[%s]splited_int error: %d!!\n",__FUNCTION__,splited_int);
	    	return 0;
		}
        if(0 == strncmp(splited_str, "hr", 2))
        {
            time += splited_int * 60 * 60;
        }else if(0 == strncmp(splited_str, "min", 3))
        {
            time += splited_int * 60;
        }else if(0 == strncmp(splited_str, "sec", 3))
        {
            time += splited_int;
        }
        splited_val = strtok_r(NULL, delimiter, &save);
        if(NULL != splited_val)
        {
            splited_str = strtok_r(NULL, delimiter, &save);
        }        
    }
    char temp[32] = {0};
    sprintf(temp, "%d", time);
    sc_cfg_set("link_time", temp);
    return time;
}

int  copyfile(const char *source, const char * target)
{
    FILE  *fp_s = NULL;
    FILE  *fp_t = NULL;
    char  buf[1024]={0};
    int  lenR = 0;
    int  lenW=0;

    if( NULL== source  || NULL == target) return -1;
    if((fp_s = fopen(source,"r"))== NULL)
    {
        printf("[copyfile]sunwenming %s can not be open\n", source);
        return -1;
    }

    if((fp_t = fopen(target,"w"))== NULL)
    {
        printf("[copyfile]sunwenming %s can not be open\n", target);
        fclose(fp_s); //kw 3
        return -1;
    }

    while((lenR = fread(buf, 1, 1024, fp_s)) > 0)
    {
        if((lenW = fwrite(buf, 1, lenR, fp_t)) != lenR)
        {
            printf("[copyfile]sunwenming write to %s failed\n", target);
        	fclose(fp_s); //kw 3
        	fclose(fp_t);
            return  -1;
        }
        memset(buf, 0, 1024);
    }
	//kw 3
    fclose(fp_s);
    fclose(fp_t);
    return 0;
}

static void zte_get_sta_info_to_file(char * iface,char * authmode)
{
	FILE *in_fp = NULL;
	FILE *out_fp = NULL;
	FILE *fp = NULL;
	FILE *tmp_fp = NULL;
	FILE *tmp_fp1 = NULL;
	FILE *tmp_fp2 = NULL;
	FILE *tmp_fp3 = NULL;
	FILE *tmp_fp4 = NULL;

	char sta_info_buf[128] = {0};
	char *ptr = NULL;
	char tmp_buf[128] = {0};
	char out_buf[128]= {0};
	char buf[128]= {0};
	
	memset(buf, 0, sizeof(buf)); 
	memset(out_buf, 0, sizeof(buf)); 
	sprintf(buf, "/proc/%s/sta_info", iface);
	sprintf(out_buf, "/tmp/stalist1");

	copyfile(buf,out_buf);
/*	
	tmp_fp = fopen("/tmp/maclist", "w+");
	fclose(tmp_fp);
	tmp_fp = fopen("/tmp/expiredtime", "w+");
	fclose(tmp_fp);
	tmp_fp = fopen("/tmp/statelist", "w+");
	fclose(tmp_fp);
	tmp_fp = fopen("/tmp/timelist", "w+");
	fclose(tmp_fp);
*/	
	fp = fopen("/tmp/stalist1", "r");
	if(NULL == fp)	  
	{		
		printf("[get_sta_info_to_file]can not open file /tmp/stalist1.");  
		goto END;
	} 
	if((tmp_fp1 = fopen("/tmp/maclist", "w+")) == NULL){
		printf("[get_sta_info_to_file]  can not  open /tmp/maclist\n");
		goto END;

	}
	if((tmp_fp2 = fopen("/tmp/expiredtime", "w+")) == NULL){
		printf("[get_sta_info_to_file]  can not  open /tmp/expiredtime\n");
		goto END;

	}
	if((tmp_fp3 = fopen("/tmp/statelist", "w+")) == NULL)	{
		printf("[get_sta_info_to_file]  can not  open /tmp/statelist\n");
		goto END;

	}
	if((tmp_fp4 = fopen("/tmp/timelist", "w+")) ==NULL){
		printf("[get_sta_info_to_file]  can not  open /tmp/timelist\n");
		goto END;
	}
	
	while(!feof(fp)) 
	{
		fgets(sta_info_buf,sizeof(sta_info_buf),fp);
		if((strstr(sta_info_buf,"hwaddr")) != NULL)
		{
			fputs(sta_info_buf,tmp_fp1);
		}
		else if((strstr(sta_info_buf,"expired_time")) != NULL)
		{
			fputs(sta_info_buf,tmp_fp2);
		}
		else if (((strstr(sta_info_buf,"ieee8021x_ctrlport")) != NULL)&&((!strcmp(authmode,"WPAPSK"))||(!strcmp(authmode,"WPA2PSK"))||(!strcmp(authmode,"WPAPSKWPA2PSK"))||(!strcmp(authmode,"WPA3Personal"))||(!strcmp(authmode,"WPA2WPA3"))))
		{
			fputs(sta_info_buf,tmp_fp3);
		}
		else if(((strstr(sta_info_buf,"wapi_state")) != NULL)&&(!strcmp(authmode,"WAPIPSK")))
		{
			fputs(sta_info_buf,tmp_fp3);
		}
		else if((strstr(sta_info_buf,"link_time")) != NULL)
		{	
			fputs(sta_info_buf,tmp_fp4);
		}
	}

END:	
	if(fp != NULL)fclose(fp);
	if(tmp_fp1 != NULL)fclose(tmp_fp1);
	if(tmp_fp2 != NULL)fclose(tmp_fp2);
	if(tmp_fp3 != NULL)fclose(tmp_fp3);
	if(tmp_fp4 != NULL)fclose(tmp_fp4);
	return;
}

static void  zte_get_vap_sta_list(RT_802_11_MAC_TABLE *staList, char * iface)
{
    int i = 0;
    int s = 0;
    int k = 0;
	int j = 0;
	int index = 0;
	int state_index = 0;
	int ssid_index = 0;
	char authmode[20]			= {0};
	char buf[128]				= {0};
	char connectTime[33] 		= {0};
	char staNum[3]              = {0};
	char num_tmp[3]             = {0};
	char mac_tmp[18]            = {0};
	char state[3]               = {0};//klocwork
	char *p = NULL;
    char *p_tmp = NULL;
	char *p1= NULL;
    char *p_tmp1 = NULL;
	char *p2= NULL;
    char *p_tmp2 = NULL;
	
    //FILE *p_stalist1 = NULL;
	FILE *p_maclist = NULL;
	FILE *p_timelist = NULL;
	FILE *p_statelist = NULL;
	FILE *p_expiredtime = NULL;
	int state_flag[MAX_WIFI_NUM] = {-1};
	int expiredtime_flag[MAX_WIFI_NUM] = {-1};
	char mac_time[33] = {0};
	char expiredtime[4] = {0};
	int security_flag = 0;
	
    printf("\n[%s][%s] iface = %s\n",__FILE__, __FUNCTION__, iface);

#ifdef __SINGLE_AP__	
	if(!strcmp(iface,"wlan0"))
#else
        if(!strcmp(iface,"wlan0-va0"))
#endif
	{
        ssid_index = 1;
	    sc_cfg_get("AuthMode",authmode,sizeof(authmode));
	}
	else if(!strcmp(iface,"wlan0-va1"))
	{
	    ssid_index = 2;
        sc_cfg_get("m_AuthMode",authmode,sizeof(authmode));
	}

        zte_get_sta_info_to_file(iface,authmode);

//	memset(buf, 0, sizeof(buf)); 
//    sprintf(buf, "cat /proc/%s/sta_info > /tmp/stalist1", iface);
//	system(buf);
//    p_stalist1 = fopen("/tmp/stalist1", "r");
//	if(NULL == p_stalist1)    
//	{    	
//		fprintf(stderr, "can not open file /tmp/stalist1.");  
//		return;
//	}    
	
//	system("cat /tmp/stalist1 | grep \"hwaddr\" > /tmp/maclist");
	p_maclist = fopen("/tmp/maclist", "r");
	if(NULL == p_maclist)    
	{    	
		fprintf(stderr, "can not open file /tmp/maclist.");   
                goto END;
	}  
		
//	system("cat /tmp/stalist1 | grep \"expired_time\" > /tmp/expiredtime");
	p_expiredtime = fopen("/tmp/expiredtime", "r");
	if(NULL == p_expiredtime)    
	{    	
		fprintf(stderr, "can not open file /tmp/expiredtime.");   
                goto END;
	}  

	memset(buf, 0, sizeof(buf)); 
	i = 0;
	while(!(feof(p_expiredtime)))    
	{    
		while(fgets(buf, sizeof(buf), p_expiredtime))        
		{            
			memset(expiredtime, 0, 4);
			if((p2 = strstr(buf, ":")) != NULL)            
			{                
				p_tmp2 = p2+2;
				strncpy(expiredtime, p_tmp2, 3);	
				if(atoi(expiredtime) > 0) //kw 3
				{
					expiredtime_flag[index] = i;	
					printf("\n [%s] expiredtime_flag[%d] is %d\n", iface, index, expiredtime_flag[index]); 
					index++;
				}
				i++;
			}            
			memset(buf, 0, sizeof(buf));
		}        
	} 

	if((!strcmp(authmode,"WPAPSK"))||(!strcmp(authmode,"WPA2PSK"))||(!strcmp(authmode,"WPAPSKWPA2PSK"))||(!strcmp(authmode,"WPA3Personal"))||(!strcmp(authmode,"WPA2WPA3")))
	{
//		system("cat /tmp/stalist1 | grep \"ieee8021x_ctrlport\" > /tmp/statelist");
		p_statelist = fopen("/tmp/statelist", "r");
		if(NULL == p_statelist)    
		{    	
			fprintf(stderr, "can not open file /tmp/statelist.");   
            goto END;
		}  
		memset(buf, 0, sizeof(buf)); 
		security_flag = 1;
		i = 0;
		index = 0;
		while(!(feof(p_statelist)))    
		{    
			while(fgets(buf, sizeof(buf), p_statelist))        
			{            
				memset(state, 0, 3);
				if((p1 = strstr(buf, ":")) != NULL)            
				{                 
					p_tmp1 = p1+2;
					strncpy(state, p_tmp1, 1);	
					if(expiredtime_flag[index] == i)
					{
						if(!strcmp(state, "1"))  
						{
							state_flag[state_index] = i;	
							state_index++;
						}
						index++;
					}
					i++;
				}            
				memset(buf, 0, sizeof(buf));
			}        
		} 
	}
	else if(!strcmp(authmode,"WAPIPSK"))
	{
//		system("cat /tmp/stalist1 | grep \"wapi_state\" > /tmp/statelist");
		p_statelist = fopen("/tmp/statelist", "r");
		if(NULL == p_statelist)    
		{    	
			fprintf(stderr, "can not open file /tmp/statelist.");   
            goto END;
		}
		memset(buf, 0, sizeof(buf)); 
		security_flag = 1;
		i = 0;
		index = 0;
		while(!(feof(p_statelist)))    
		{    
			while(fgets(buf, sizeof(buf), p_statelist))        
			{            
				memset(state, 0, 3);
				if((p1 = strstr(buf, ":")) != NULL)            
				{                
					p_tmp1 = p1+2;
					strncpy(state, p_tmp1, 2);	
					if(expiredtime_flag[index] == i)
					{
						if(!strcmp(state, "13"))  
						{
							state_flag[state_index] = i;	
							state_index++;
						}
						index++;
					}
					i++;
				}            
				memset(buf, 0, sizeof(buf));
			}        
		} 
	}
	index = 0;
	state_index = 0;
	i = 0;
	memset(buf, 0, sizeof(buf));    
	while(!(feof(p_maclist)))    
	{    
		while(fgets(buf, sizeof(buf), p_maclist))        
		{            
			memset(mac_tmp, 0, 18);   
			if((p = strstr(buf, ":")) != NULL)              
			{  
				if(((security_flag == 1) && (state_flag[state_index] == i)) || ((security_flag == 0) && (expiredtime_flag[index] == i)))
				{
					p_tmp = p+2;
					strncpy(mac_tmp, p_tmp, 12);	
					for(s=0,k=0; s<6; s++,k+=2)                
					{                     
						memset(num_tmp, 0 ,3);
						strncpy(num_tmp, mac_tmp + k, 2); 
						num_tmp[2] = '\0';                  
						staList->Entry[staList->Num].Addr[s] = s2x(num_tmp);   
					}
                                        staList->Entry[staList->Num].SSID_index = ssid_index;
					staList->Num += 1; 
					if(security_flag == 1)
					{
						state_index++;
					}
					else
					{
						index++;
					}
				}            
				i++;	
			}		
			memset(buf, 0, sizeof(buf));  
		}    
	}    

//	system("cat /tmp/stalist1 | grep \"link_time\" > /tmp/timelist");
	p_timelist = fopen("/tmp/timelist", "r");
	if(NULL == p_timelist)    
	{    	
		printf("[%s]can not open file /tmp/timelist.\n", __FUNCTION__);   
        goto END;
	}
    memset(buf, 0, sizeof(buf)); 
    p = NULL;	
	p_tmp = NULL;
	i = 0;
	state_index = 0;
	index = 0;
	while(!(feof(p_timelist)))
	{
		while(fgets(buf, sizeof(buf), p_timelist))
		{
			memset(mac_time,0,33);

			if((p = strstr(buf, ":")) != NULL)   
			{
				if(((security_flag == 1) && (state_flag[state_index] == i)) || ((security_flag == 0) && (expiredtime_flag[index] == i)))
				{
					
					p_tmp = p+2; 
					strncpy(mac_time,p_tmp,32);
					//kw 3
					staList->Entry[j].ConnectedTime = zte_station_connect_time_calc(mac_time);
					j++;
					if(security_flag == 1)
					{
						state_index++;
					}
					else
					{
						index++;
					}
				}
				i++;
			}
			memset(buf, 0, sizeof(buf));  
			
		}
	}

	/*ȡWIFI նʱ*/
END:
    //if(NULL != p_stalist1) fclose(p_stalist1);//kw 3
    if(NULL != p_maclist) fclose(p_maclist);
    if(NULL != p_timelist)fclose(p_timelist);
    if(NULL != p_statelist)fclose(p_statelist);
    if(NULL != p_expiredtime)fclose(p_expiredtime);
}
 
void zte_get_wifi_sta_list(RT_802_11_MAC_TABLE *staList)
{
    int i = 0, j=0;
    char m_ssid_enable[8]={0};
    RT_802_11_MAC_TABLE  staList_va0={0};
    RT_802_11_MAC_TABLE  staList_va1={0};
	char station_mac[32*18]		= {0}; 
	char station_mac_tmp[32*18]	= {0};
    char staNum[12]={0};
    char RaidoOff[8]={0};
	char wifi_cur_state[8]={0};
    //sc_cfg_get("RadioOff",RaidoOff,sizeof(RaidoOff));
    sc_cfg_get("wifi_cur_state",wifi_cur_state,sizeof(wifi_cur_state));
    if(atoi(wifi_cur_state) == 0)
    {
        printf("wifi is Off, can not read sta_info\n");
		//sc_cfg_set("wificount", staNum);
		//sc_cfg_set("station_num", staNum);
		sc_cfg_set("station_mac", station_mac_tmp);
        return;
    }        
    sc_cfg_get("m_ssid_enable", m_ssid_enable, sizeof(m_ssid_enable));

#ifdef __SINGLE_AP__	    
    zte_get_vap_sta_list(&staList_va0,"wlan0");
#else
    zte_get_vap_sta_list(&staList_va0,"wlan0-va0");

#endif
    
    printf("\n[%s] staList_va0->Num=%d\n",__FUNCTION__, staList_va0.Num);
//    copy staList_va0  to  staList
    staList->Num = staList_va0.Num;
	for (i = 0; i <  staList_va0.Num;  i++)
	{
	    memcpy((void*)&staList->Entry[i],(void*)&staList_va0.Entry[i], sizeof(RT_802_11_MAC_ENTRY));
		sprintf(station_mac + i * 18, "%2.2X:%2.2X:%2.2X:%2.2X:%2.2X:%2.2X;",\
	   	            staList->Entry[i].Addr[0], staList->Entry[i].Addr[1],
				    staList->Entry[i].Addr[2], staList->Entry[i].Addr[3],
				    staList->Entry[i].Addr[4], staList->Entry[i].Addr[5]);
	}

    printf("[%s] m_ssid_enable=%s\n",__FUNCTION__, m_ssid_enable);
    if(atoi(m_ssid_enable) == 1)
    {
            zte_get_vap_sta_list(&staList_va1,"wlan0-va1");
//    copy staList_va1  to  staList
            printf("\n[%s] staList_va1->Num=%d\n",__FUNCTION__, staList_va1.Num);
            staList->Num += staList_va1.Num;
    	for (i = staList_va0.Num,j =0; i <  staList->Num;  i++,j++)
    	{
    	        memcpy((void*)&staList->Entry[i],(void*)&staList_va1.Entry[j], sizeof(RT_802_11_MAC_ENTRY));
    		sprintf(station_mac + i * 18, "%2.2X:%2.2X:%2.2X:%2.2X:%2.2X:%2.2X;",\
    	   	            staList->Entry[i].Addr[0], staList->Entry[i].Addr[1],
    				    staList->Entry[i].Addr[2], staList->Entry[i].Addr[3],
    				    staList->Entry[i].Addr[4], staList->Entry[i].Addr[5]);
    	}
    }
	sprintf(staNum, "%d", staList->Num);	
	//sc_cfg_set("wificount", staNum);
	//sc_cfg_set("station_num", staNum);
	
	if (staList->Num != 0)
	{
		strncpy(station_mac_tmp, station_mac, strlen(station_mac) - 1);
	}
	sc_cfg_set("station_mac", station_mac_tmp);
}
#if 0 //kw 3
int get_channel()
{
	char channel[8] = {0};
	pipecmd("iwpriv wlan0 get_mib channel |cut -d':' -f2", channel);
	return atoi(channel);
}
#endif
