/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name: drvs_hrdtst_voice.h   
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       v1.0
 * Author:        lvwenhua
 * Date:          2010-8-26
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

#ifndef _DRVS_HRDTST_VOICE_H
#define _DRVS_HRDTST_VOICE_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "voice_api.h"
#include "drvs_pmic_audio.h"

/****************************************************************************
* 	                                        Macros
****************************************************************************/


/****************************************************************************
* 	                                        Types
****************************************************************************/
typedef enum
{
    VOICE_PATH_MODE_HANDSET    =0,
    VOICE_PATH_MODE_SPEAKER, 
    VOICE_PATH_MODE_HEADSET, 
    VOICE_PATH_MODE_BLUETOOTH, 
             
    MAX_VOICE_PATH_MODE              
} T_ZDrvVoice_PathMode;

typedef VOID (*T_ZDrvVoice_CallbackFunc) (BOOL isWorking, T_ZDrvVoice_PathMode path);

typedef enum
{
    VOICE_SCAL_IN     = 0,
    VOICE_SCAL_MIC,
    VOICE_LAMBDA0,
    VOICE_GAMMA0,

    VOICE_SCAL_I2S1,
    VOICE_SCAL_OUT,
    VOICE_SCAL_REC,
    VOICE_GAIN_OUT,
    VOICE_KAPPA0,

    VOICE_SIDE_TONE,
             
    MAX_VOICE_DIGITAL_GAIN_TYPE              
} T_ZDrvVoice_DigitalGainType;




typedef struct
{
    UINT16 scal_in;
    UINT16 scal_mic;
    UINT16 lambda0;
    UINT16 gamma0;

    UINT16 scal_i2s1;
    UINT16 scal_out;
    UINT16 scal_rec;
    UINT16 gain_out;
    UINT16 kappa0;
    //UINT16 beta0;

    UINT16 side_tone;

    SINT32 pga_tx;
    SINT32 pga_rx;   

} T_ZDrvVoice_StaticGainConfig;

typedef enum
{
    VOICE_BIQUAD_UPLINK    =0,
    VOICE_BIQUAD_DOWNLINK, 
             
    MAX_VOICE_BIQUAD_ENUM              
} T_ZDrvVoice_Biquad;

typedef struct
{
    UINT16 a0_1;
    UINT16 a1_1;
    UINT16 a2_1;
    UINT16 b1_1;
    UINT16 b2_1;

    UINT16 a0_2;
    UINT16 a1_2;
    UINT16 a2_2;
    UINT16 b1_2;
    UINT16 b2_2;
} T_ZDrvVoice_BiquadParam;

#if 0
typedef struct
{
    UINT16 gain[MAX_VOICE_OUTPUT_VOL_LEVEL];           
} T_ZDrvVoice_VolGainConfig;
#endif

typedef struct
{
  UINT16  mode;
} T_ZDrvVoice_HfOnParam;

typedef struct
{
//  UINT16  gain_analog;
  UINT16  step_width;
  UINT16  lms_length;
  UINT16  lms_offset;
  UINT16  block_length;
  SINT16  rxtx_relation;  // change cai 
  UINT16  nr_sw_2;
  UINT16  nr_u_fak_0;
  UINT16  nr_u_fak;
  UINT16  add_atten;
  UINT16  min_atten;
  UINT16  max_atten;
} T_ZDrvVoice_HfSetParam;

typedef enum
{
     GSM  = 0,
     TD,
     LTE,
    MAX_MODETYPE
} T_ZDrvVoice_Communication_Mode; 


/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/

#endif/*_DRVS_HRDTST_VOICE_H*/

