/***********************************************************************
* Copyright (C) 2001, ZTE Corporation.
* 
* File Name: 	drvs_nand.h
* File Mark:  	
* Description:  tu hal interface declaration.
* Others:  	
* Version:  v1.0
* Author:   wangxia
* Date:      2008-08-28
* 
* History 1:  		
*     Date: 
*     Version:
*     Author: 
*     Modification:  

* History 2: 
**********************************************************************/

#ifndef    DRV_NAND_IDS_H
#define    DRV_NAND_IDS_H

/*************************************************************************
  *                                  Include files                    *
  *************************************************************************/


/*************************************************************************
  *                                  Macro                               *
  *************************************************************************/


/**************************************************************************
 *                                  Types                                 *
 **************************************************************************/
#if 1
/*
*	nand_flash_timing
*/
struct nand_flash_timing
{                        
    unsigned char Twhr;  /*reg offset 0x100*/  /*spi nand: rd delay*/
    unsigned char Trr1;                        /*spi nand: cs setup*/
    unsigned char Tadl;  /*reg offset 0x110*/  /*spi nand: cs hold*/
    unsigned char Trr2;                        /*spi nand: cs desel*/
    unsigned char Trhw;  /*reg offset 0x120*/
    unsigned char Trea;  /*reg offset 0x130*/
    unsigned char Trp;   /*reg offset 0x1f0, or Twp*/
    unsigned char Treh;  /*reg offset 0x200, or Tweh*/
    unsigned char Tcs;   /*reg offset 0x220*/
    unsigned char Trhz;  /*reg offset 0x290*/
};


struct nand_ecc
{
	 unsigned int  strength; /*ECC */
	 unsigned int  sector_size;     /*ECC ݿС*/
};

    
/*nand 豸ṹ*/
struct nand_flash_device_para
{
    unsigned char manuf_id;            /* ID */
    unsigned char device_id;           /* 豸ID */
    unsigned char res_id;              /* ID */
    unsigned char bus_num;             /* 0:8λ  1:16λ */
    unsigned int page_size;            /* ÿҳmainС */
    unsigned int oob_size;             /* ÿҳspareС */
    unsigned int column_addr_num;      /* еַѰַ */
    unsigned int row_addr_num;         /* еַѰַ */
    unsigned int block_size;           /* ÿĴС */
    unsigned int pages_per_block;      /* ÿҳ */
    unsigned int block_num;            /*  */
    unsigned int die_num;	
    unsigned int bad_block_markpos;    /* ־λλ,0ʼ */
    struct nand_flash_timing nand_timeing;
	
	struct nand_ecc ecc;
};
#endif


/**
 * struct nand_flash_dev - NAND Flash Device ID Structure
 * @name:	Identify the device type
 * @id:		device ID code
 * @pagesize:	Pagesize in bytes. Either 256 or 512 or 0
 *		If the pagesize is 0, then the real pagesize
 *		and the eraseize are determined from the
 *		extended id bytes in the chip
 * @erasesize:	Size of an erase block in the flash device.
 * @chipsize:	Total chipsize in Mega Bytes
 * @options:	Bitfield to store chip relevant options
 */
struct nand_flash_dev {
	char *name;
	int id;
	unsigned long pagesize;
	unsigned long chipsize;
	unsigned long erasesize;
	unsigned long options;
};

/**
 * struct nand_manufacturers - NAND Flash Manufacturer ID Structure
 * @name:	Manufacturer name
 * @id:		manufacturer ID code of device.
*/
struct nand_manufacturers {
	int id;
	char * name;
};




/* Option constants for bizarre disfunctionality and real
*  features
*/
/* Chip can not auto increment pages */
#define NAND_NO_AUTOINCR	0x00000001
/* Buswitdh is 16 bit */
#define NAND_BUSWIDTH_16	0x00000002
/* Device supports partial programming without padding */
#define NAND_NO_PADDING		0x00000004
/* Chip has cache program function */
#define NAND_CACHEPRG		0x00000008
/* Chip has copy back function */
#define NAND_COPYBACK		0x00000010
/* AND Chip which has 4 banks and a confusing page / block
 * assignment. See Renesas datasheet for further information */
#define NAND_IS_AND		0x00000020
/* Chip has a array of 4 pages which can be read without
 * additional ready /busy waits */
#define NAND_4PAGE_ARRAY	0x00000040
/* Chip requires that BBT is periodically rewritten to prevent
 * bits from adjacent blocks from 'leaking' in altering data.
 * This happens with the Renesas AG-AND chips, possibly others.  */
#define BBT_AUTO_REFRESH	0x00000080
/* Chip does not require ready check on read. True
 * for all large page devices, as they do not support
 * autoincrement.*/
#define NAND_NO_READRDY		0x00000100
/* Chip does not allow subpage writes */
#define NAND_NO_SUBPAGE_WRITE	0x00000200

/*
 * NAND Flash Manufacturer ID Codes
 */
#define NAND_MFR_TOSHIBA	0x98
#define NAND_MFR_SAMSUNG	0xec
#define NAND_MFR_FUJITSU	0x04
#define NAND_MFR_NATIONAL	0x8f
#define NAND_MFR_RENESAS	0x07
#define NAND_MFR_STMICRO	0x20
#define NAND_MFR_HYNIX		0xad
#define NAND_MFR_MICRON		0x2c
#define NAND_MFR_AMD		0x01
#define NAND_MFR_GIGADEVICE 0xC8


#endif    /* DRV_NAND_IDS_H */

