/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   :
*    :
* ļ :
* ʵֹ :
*      :
*      :
*  :
* ˵ :
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı :
*    :
* ޸ :
* ޸ :
**************************************************************************/
#include "interf_dec.h"
#include "interf_enc.h"
#include "dec_if.h"
#include "enc_if.h"
#include "zmmp_amr_fnc.h"
#include "oscl_base_macros.h"



#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 궨
**************************************************************************/

/**************************************************************************
* ݽṹ
**************************************************************************/
/*ӿںָ*/
typedef VOID*  (*T_zMmp_AmrDecInit)(VOID);
typedef VOID   (*T_zMmp_AmrDecExit)(VOID*);
typedef SINT32 (*T_zMmp_AmrDecProc)(VOID*, const UINT8*, SINT16*, SINT32);
typedef VOID*  (*T_zMmp_AmrEncInit)(SINT32);
typedef VOID   (*T_zMmp_AmrEncExit)(VOID*);
typedef SINT32 (*T_zMmp_AmrEncProc)(VOID*, SINT32, const SINT16*, UINT8*, SINT32);

typedef struct
{
    T_zMmp_AmrDecInit decInit;
    T_zMmp_AmrDecExit decExit;
    T_zMmp_AmrDecProc decProc;
} T_zMmp_AmrDecHandle;

typedef struct
{
    BOOL              isDtxEnable;      /*Ƿ֧DTX*/
    T_zMmp_AmrEncInit encInit;
    T_zMmp_AmrEncExit encExit;
    T_zMmp_AmrEncProc encProc;
} T_zMmp_AmrEncHandle;

typedef struct
{
    T_zMmp_CodecType codecType;
    VOID             *pCodecState;      /*Դڲݽṹŵǰڲ*/
    union
    {
        T_zMmp_AmrDecHandle decHandle;
        T_zMmp_AmrEncHandle encHandle;
    } handle;
} T_zMmp_AmrCodecContext;

/**************************************************************************
* static
**************************************************************************/

/**************************************************************************
*ȫֳ/
**************************************************************************/

/**************************************************************************
* ʵ
**************************************************************************/

/**************************************************************************
* :     AMR
* ˵:
*   ()  T_zMmp_CodecType: AMR뷽ʽ
*   ()  
*   ֵ:     AMR,NULLΪ򿪽ʧ
* ˵:     
**************************************************************************/
//UINT8 *pAmrtoPcm = NULL;
//UINT8 *pdecPcm = NULL;
//int s_pcmcount = 0;

VOID* mmp_AmrDecOpen(T_zMmp_CodecType codecType)

{
    T_zMmp_AmrCodecContext *pCodecContext = NULL;
/* bic r0, r0, #0x02;
A 	Alignment check enable. This is the enable bit for Alignment fault checking:
	0 Alignment fault checking disabled, this is the reset value.
	1 Alignment fault checking enabled. 
*/
#if (PV_COMPILER == EPV_ARM_GNUC)
    __asm__ volatile("mrc p15, 0, r0, c1, c0, 0;"
                     "bic r0, r0, #0x02;" 
                     "orr r0, r0, #0x400000;"
                     "mcr p15, 0, r0, c1, c0, 0;"
                     "nop; nop; nop;"
                     : : :"r0");

#endif
    if((codecType < ZMMP_CODEC_AMR_NB_IF1) && (codecType > ZMMP_CODEC_AMR_WB_IETF))
    {
        zOss_Printf(1, 1, "mmp_AmrDecOpen: codecType is invalid!");
        return NULL;
    }

    pCodecContext = (T_zMmp_AmrCodecContext *)zOss_Malloc(sizeof(T_zMmp_AmrCodecContext));
    zOss_AssertEx(pCodecContext != NULL, NULL);
    pCodecContext->codecType = codecType;

    if( codecType >= ZMMP_CODEC_AMR_NB_IF1  &&  codecType <= ZMMP_CODEC_AMR_NB_IETF )
    {
        pCodecContext->handle.decHandle.decInit = Decoder_Interface_init;
        pCodecContext->handle.decHandle.decExit = Decoder_Interface_exit;
        pCodecContext->handle.decHandle.decProc = Decoder_Interface_Decode;
    }
    else
    {
        pCodecContext->handle.decHandle.decInit = D_IF_init;
        pCodecContext->handle.decHandle.decExit = D_IF_exit;
        pCodecContext->handle.decHandle.decProc = D_IF_decode;
    }

    pCodecContext->pCodecState = pCodecContext->handle.decHandle.decInit();
    if(pCodecContext->pCodecState == NULL)
    {
        zOss_Free(pCodecContext);
        pCodecContext = NULL;
    }
/*
	if (pAmrtoPcm == NULL)
	pAmrtoPcm = zOss_Malloc(0x60000);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"Decoder_Interface_init pAmrtoPcm33 = %x\n", pAmrtoPcm);
	zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"Decoder_Interface_init pAmrtoPcm11 = %x\n", pAmrtoPcm);
	pdecPcm = pAmrtoPcm;
	s_pcmcount = 0;
*/
    return pCodecContext;
}

/**************************************************************************
* :     AMR
* ˵:
*   ()  T_zMmp_CodecType: AMR뷽ʽ
isDtxEnable:      FALSE:֧dtxTRUE:֧dtx
*   ()  
*   ֵ:     AMRģNULLΪ򿪱ʧ
* ˵:     
**************************************************************************/
VOID* mmp_AmrEncOpen(T_zMmp_CodecType codecType, BOOL isDtxEnable)
{
    T_zMmp_AmrCodecContext *pCodecContext = NULL;
#if (PV_COMPILER == EPV_ARM_GNUC)
    __asm__ volatile("mrc p15, 0, r0, c1, c0, 0;"
                     "bic r0, r0, #0x02;"
                     "orr r0, r0, #0x400000;"
                     "mcr p15, 0, r0, c1, c0, 0;"
                     "nop; nop; nop;"
                     : : :"r0");
#endif
    if((codecType < ZMMP_CODEC_AMR_NB_IF1) && (codecType > ZMMP_CODEC_AMR_WB_IETF))
    {
        zOss_Printf(1, 1, "mmp_AmrEncOpen: codecType is invalid!");
        return NULL;
    }

    pCodecContext = (T_zMmp_AmrCodecContext *)zOss_Malloc(sizeof(T_zMmp_AmrCodecContext));
    zOss_AssertEx(pCodecContext != NULL, NULL);
    pCodecContext->codecType             = codecType;
    pCodecContext->handle.encHandle.isDtxEnable = isDtxEnable;

    if(codecType >= ZMMP_CODEC_AMR_NB_IF1  &&  codecType <= ZMMP_CODEC_AMR_NB_IETF )
    {
        pCodecContext->handle.encHandle.encInit = Encoder_Interface_init;
        pCodecContext->handle.encHandle.encExit = Encoder_Interface_exit;
        pCodecContext->handle.encHandle.encProc = Encoder_Interface_Encode;
    }
    else
    {
        pCodecContext->handle.encHandle.encInit = E_IF_init;
        pCodecContext->handle.encHandle.encExit = E_IF_exit;
        pCodecContext->handle.encHandle.encProc = E_IF_encode;
    }

    pCodecContext->pCodecState = pCodecContext->handle.encHandle.encInit(isDtxEnable? 1 : 0);
    if(pCodecContext->pCodecState == NULL)
    {
        zOss_Free(pCodecContext);
        pCodecContext = NULL;
    }
    return pCodecContext;
}

/**************************************************************************
  * :     һ֡AMR
  * ˵:
  *   ()  pCodecContext: AMR
  	pAmr:          AMRʼַ
  *   ()  pPcm:          PCMʼַ
  *   ֵ:     PCMʵݳ 0ʾʧ
  * ˵:     
  **************************************************************************/
UINT16 mmp_AmrDecode(VOID *pCodecContext, const UINT8 *pAmr, UINT16 *pPcm)
{
    T_zMmp_AmrCodecContext *pDecContext = NULL;
    UINT16                 pcmFrameSize = 0;
    if(pCodecContext == NULL || pAmr == NULL || pPcm == NULL)
    {
        zOss_Printf(1, 1, "mmp_AmrDecode: NULL pointer is invalid!");
        return 0;
    }
    pDecContext  = (T_zMmp_AmrCodecContext *)pCodecContext;
    pcmFrameSize = (UINT16)pDecContext->handle.decHandle.decProc(pDecContext->pCodecState, pAmr, (SINT16 *)pPcm, (SINT32)pDecContext->codecType);

	return pcmFrameSize;
}

/**************************************************************************
  * :     һ֡PCM
  * ˵:
  *   ()  pCodecContext: AMR
  mode:          ģʽ
  pPcm:          PCMʼַ
  *   ()  pAmr:          AMRʼַ
  *   ֵ:     AMRʵݳȣ0ʾʧ
  * ˵:     
  **************************************************************************/
UINT16 mmp_AmrEncode(VOID *pCodecContext, T_zMmp_AmrEncMode mode, const UINT16 *pPcm, UINT8 *pAmr)
{
    T_zMmp_AmrCodecContext *pEncContext = NULL;
    UINT16                 amrFrameSize = 0;

    if(pCodecContext == NULL || pPcm == NULL || pAmr == NULL)
    {
        zOss_Printf(1, 1, "mmp_AmrEncode: NULL pointer is invalid!");
        return 0;
    }
    pEncContext  = (T_zMmp_AmrCodecContext *)pCodecContext;
    amrFrameSize = (UINT16)pEncContext->handle.encHandle.encProc(pEncContext->pCodecState, (SINT32)mode, (SINT16 *)pPcm, pAmr, pEncContext->codecType);
    return amrFrameSize;
}


/**************************************************************************
* :     رս
* ˵:
*   ()  pCodecContext: AMR
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
VOID mmp_AmrDecClose(VOID *pCodecContext)
{
    T_zMmp_AmrCodecContext *pDecContext = NULL;
    if(pCodecContext != NULL)
    {
        pDecContext = (T_zMmp_AmrCodecContext *)pCodecContext;
        pDecContext->handle.decHandle.decExit(pDecContext->pCodecState);
        zOss_Free(pDecContext);
        pDecContext   = NULL;
    }

}

/**************************************************************************
* :     رձ
* ˵:
*   ()  pCodecContext: AMR
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
VOID mmp_AmrEncClose(VOID *pCodecContext)
{
    T_zMmp_AmrCodecContext *pEncContext = NULL;
    if(pCodecContext != NULL)
    {
        pEncContext = (T_zMmp_AmrCodecContext *)pCodecContext;
        pEncContext->handle.encHandle.encExit(pEncContext->pCodecState);
        zOss_Free(pEncContext);
        pEncContext   = NULL;
    }
}
#ifdef __cplusplus
}
#endif

