/************************************************************************
* Ȩ(C)2007,ͨѶɷ޹˾
* ģ   OSDģ
* ļƣzte_osd.c
* ļʶ 
* ժҪ    
* 
* ޸      汾     ޸ı       ޸       ޸      
* ----------------------------------------------------------------------
* 2009/3/25    1.0                                              
************************************************************************/
  
/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include "pub.h"
#include "oss_api.h"
#include "drv_api.h"
#include "zte_display.h"      
#include "zte_osd.h"    
#include "zMsp_Com.h"

/**************************************************************************
 *                                                                    *
 **************************************************************************/
#define PIXEL_OSD_BLACK       0x0000             /* RGB565ģʽºɫֵ          */
#define PIXEL_OSD_GREEN       0x07E0             /* RGB565ģʽɫֵ          */
#define PIXEL_OSD_TRANSPARENT 0xF7DE             /* RGB565ģʽ͸ֵ(NXP޸) */
#define pixel_darkergreen     0x0080             /* RGB565ģʽ͸ֵ(P99B for U230) */
#define pixel_darkerred       0x0001             /* RGB565ģʽ͸ֵ(U560) */

#define UPS_DFAULT_INTER     40                  /* GUI߳Ĭˢ      */
#define UPS_15_FRAMES_INTER  40                  /* 15֡/GUI߳ˢ */
#define UPS_25_FRAMES_INTER  40                  /* 25֡/GUI߳ˢ */

/**************************************************************************
 *                                                                      *
 **************************************************************************/
#define VIDEO_15_FRAMES  15                      /* һ15֡Ƶҵ    */
#define VIDEO_25_FRAMES  25                      /* һ25֡Ƶҵ    */
#define ZTE_OSD_LOCK     "zte_osd_lock"          /* OSDģʹõĻ */
#define GUI_UPS_LOCK     "updateLock"            /* GUIˢ     */
#define GUI_UPS_THREAD   "Update_Screen_Thread"  /* GUIˢ߳       */

/**************************************************************************
 *                                                                 *
 **************************************************************************/
typedef struct _OSD_Color
{
    /**
     * the alpha component of a ARGB quarter.
     */
    unsigned char b;
    /**
     * the red component of a ARGB quarter.
     */
    unsigned char g;
    /**
     * the green component of a ARGB quarter.
     */
    unsigned char r;
    /**
     * the blue component of a ARGB quarter.
     */
    unsigned char a;

} OSD_Color;

/**************************************************************************
 *                           ֲԭ                                  *
 **************************************************************************/

/**************************************************************************
 *                           ȫֱ                                      *
 **************************************************************************/
static BOOL                         g_bOsdFlag = FALSE;/* OSD״̬,GUIˢж*/
static BOOL                         g_bFirst = FALSE;  /* GUIǷΪ״νOSD״̬ǷҪȫRGBת*/
static BOOL                         g_bARGB;           /* ƵݸʽǷΪARGB */
static BOOL                         g_bNewVideo;       /* ǷƵݸ     */
static UINT32                       g_uiVideoFd;       /* VIDEOģ         */
static UINT32                       g_uiLcdFd;         /* LCDľ             */
static RECT_T                       g_tVideoOsdRect;   /* ƵݵOSDʾ  */
static ZOSS_MUTEX_ID                g_pOsdLock;        /* OSD         */
static T_ZDrvVideo_BufInfo          g_tOsdOutBufInfo;  /* OSDBufferϢ     */
static T_ZDrvVideo_BufInfo          g_tOsdGuiBuf;      /* OSDGUIBuffer   */
static T_ZDrvVideo_PpuInfo          g_tOsdPpuInfo;     /* OSDݼ        */
static T_ZDrvLcd_VideoDisplayParam   g_tVideoLCDBuffer; /* OSDģʽˢ     */

static BOOL                         updateRectFlag      = FALSE;        /* GUIǷҪˢĻ  */
static VOID                        *pFrameBuffer        = NULL;         /* LCDFramebuffer     */
static UINT32                       g_uiSleepTime       = 40;           /* GUI߳ˢ      */
static RECT_T                       updateRect          = {0, 0, 0, 0}; /* GUIֲ      */
static ZOSS_MUTEX_ID                updateLock          = NULL;                         /* ˢ²       */
static ZOSS_THREAD_ID               pUpdateScreenThread = NULL;         /* Ļˢ̵߳߳ID */

UINT32 g_uiOsdCount = 0;
UINT32 g_uiOsdFreeYUVBufCount = 0;

UINT16 g_TransColor = 0x0080;
UINT8  g_uiAlpha    = 0xff;

/**************************************************************************
 *                ʵ--в֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                ʵ--֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                ʵ--˽в֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                     ȫֺʵ                                      *
 **************************************************************************/
/**
 * ƣ Zte_OsdInit 
 *  OSDģʼ
 * ˵ (IN) uiVideoFd VIDEOģfd
 *            (IN) uiFrames  Ƶҵ֡
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32 Zte_OsdInit(UINT32  uiVideoFd, UINT32 uiFrames)
{
    SINT32               iRet = -1;
    T_ZDrvVideo_BufInfo  tBufInfo;

    /* ظʼ */
    if(g_bOsdFlag)
    {
        return MSP_COM_OP_SUCCESS;
    }

    /* OSDĻûô */
    if(NULL == g_pOsdLock)
    {
        g_pOsdLock = zOss_CreateMutex(ZTE_OSD_LOCK, ZOSS_NO_INHERIT);
        if(NULL == g_pOsdLock)
        {
            return MSP_COM_OP_ERROR;
        }
    }

    /* Ĭϵĺռ */
    g_tOsdOutBufInfo.bufType              = ARGB_TYPE;
	
    /* ˴ΪRGB565ݣֻһĿռ */
    g_tOsdOutBufInfo.bufSize.ARGBBufSize  = g_uiDefaultARGBSize / 2;
    g_tOsdOutBufInfo.pDataBuf.ARGBdataBuf = NULL;
    
    iRet = zDrv_Ioctl(uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &g_tOsdOutBufInfo);
    if(iRet < 0 || NULL == g_tOsdOutBufInfo.pDataBuf.ARGBdataBuf)
    {        
        return MSP_COM_OP_ERROR;
    }    

    /* GUIOSDݿռ */
    g_tOsdGuiBuf.bufType              = ARGB_TYPE;
    g_tOsdGuiBuf.bufSize.ARGBBufSize  = g_uiDefaultARGBSize;
    g_tOsdGuiBuf.pDataBuf.ARGBdataBuf = NULL;
    
    iRet = zDrv_Ioctl(uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &g_tOsdGuiBuf);
    if(iRet < 0 || NULL == g_tOsdGuiBuf.pDataBuf.ARGBdataBuf)
    {
        zDrv_Ioctl(uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &g_tOsdOutBufInfo);     
        
        return MSP_COM_OP_ERROR;
    }    

    /* Ԥһ֡ȫƵ(YUV420)ΪĬϵOSDƵݣ
     * ͼƬΪȫڣ˿ռ佫Zte_OsdUpdateVideoInputͷš
     */
    g_bARGB                            = FALSE;
    tBufInfo.bufType                   = YUV_TYPE;
    tBufInfo.bufSize.YuvBufSize.ySize  = g_uiDefaultYSize;
    tBufInfo.bufSize.YuvBufSize.uSize  = g_uiDefaultUSize;
    tBufInfo.bufSize.YuvBufSize.vSize  = g_uiDefaultVSize;
    iRet = zDrv_Ioctl(uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &tBufInfo);
    if(iRet < 0)
    {
        zDrv_Ioctl(uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &g_tOsdGuiBuf);
        zDrv_Ioctl(uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &g_tOsdOutBufInfo);
        
        return MSP_COM_OP_ERROR;
    }        

    /* Ƶ֡Ϊȫ */
    zOss_Memset((VOID *)tBufInfo.pDataBuf.YuvBuf.Y,  0,   tBufInfo.bufSize.YuvBufSize.ySize);
    zOss_Memset((VOID *)tBufInfo.pDataBuf.YuvBuf.Cb, 128, tBufInfo.bufSize.YuvBufSize.uSize);
    zOss_Memset((VOID *)tBufInfo.pDataBuf.YuvBuf.Cr, 128, tBufInfo.bufSize.YuvBufSize.vSize);

    /* ʾϢ */
    g_tVideoOsdRect.sx     = 0;
    g_tVideoOsdRect.sy     = 0;
    g_tVideoOsdRect.width  = g_uiScreenWidth;
    g_tVideoOsdRect.height = g_uiScreenHeight;

    /* ƵϢ */
    g_tOsdPpuInfo.inputInfo.uiStartX       = 0;
    g_tOsdPpuInfo.inputInfo.uiStartY       = 0;
    g_tOsdPpuInfo.inputInfo.uiWidth        = g_uiScreenWidth;
    g_tOsdPpuInfo.inputInfo.uiHeight       = g_uiScreenHeight;  
    g_tOsdPpuInfo.inputInfo.uiStride       = g_uiScreenWidth;    
    g_tOsdPpuInfo.inputInfo.tPixelFmt      = PIXEL_YCbCr420;            /* YUV420 */
    g_tOsdPpuInfo.inputInfo.pInPutbuffer   = tBufInfo.pDataBuf; 
    
    /* 趨GUIOSDϢ */
    g_tOsdPpuInfo.osdInfo.bEnable          = TRUE;
    g_tOsdPpuInfo.osdInfo.tInput.uiWidth   = g_uiScreenWidth;//- 16;//cyx ƵоƬȱ
    g_tOsdPpuInfo.osdInfo.tInput.uiHeight  = g_uiScreenHeight;// -4 ;// - 16;//cyx ƵоƬȱ
    g_tOsdPpuInfo.osdInfo.tInput.uiStride  = g_uiScreenWidth;
    g_tOsdPpuInfo.osdInfo.globalEnable     = FALSE;
    g_tOsdPpuInfo.osdInfo.globalAlpha      = 0;
    g_tOsdPpuInfo.osdInfo.pImg             = g_tOsdGuiBuf.pDataBuf.ARGBdataBuf;
    g_tOsdPpuInfo.osdInfo.uiOutputStartX   = 0;
    g_tOsdPpuInfo.osdInfo.uiOutputStartY   = 0;
    
    /* 趨OSDϢ */
    g_tOsdPpuInfo.outputInfo.uiWidth       = g_uiScreenWidth;
    g_tOsdPpuInfo.outputInfo.uiHeight      = g_uiScreenHeight;
    g_tOsdPpuInfo.outputInfo.uiStride      = g_uiScreenWidth;
    g_tOsdPpuInfo.outputInfo.tPixelFmt     = PIXEL_RGB565;//PIXEL_ARGB888;             /* ARGBʽ */
    g_tOsdPpuInfo.outputInfo.pOutPutbuffer = g_tOsdOutBufInfo.pDataBuf;

    /* 趨OSDģʽ£LCD²ϢˢݸʽΪARGB32Ϊȫ */
    g_tVideoLCDBuffer.uiStartX = 0;
    g_tVideoLCDBuffer.uiStartY = 0;
    g_tVideoLCDBuffer.uiWidth  = g_uiScreenWidth;
    g_tVideoLCDBuffer.uiHeight = g_uiScreenHeight;
    g_tVideoLCDBuffer.pBuf     = g_tOsdPpuInfo.outputInfo.pOutPutbuffer.ARGBdataBuf;
    g_tVideoLCDBuffer.pixeFmt  = LCD_PIXEL_RGB565;//LCD_PIXEL_ARGB32;

    /* µƵݣ±־ */
    //g_bNewVideo = TRUE;
        
    /* VIDEOģfd */
    g_uiVideoFd = uiVideoFd;
        
    /* òҪLCD BufferתGUIOSDBufferΪ
     * ʱLCD BufferеδMMIҪϢݣЩ
     * 磡Ȱȫ͸GUIṩƵ
     */
    zOss_Memset((void*)g_tOsdGuiBuf.pDataBuf.ARGBdataBuf, 0xFF, g_tOsdGuiBuf.bufSize.ARGBBufSize);

    /* ֪ͨGUIлOSDģʽ */
    g_bFirst      = TRUE;
    g_bOsdFlag    = TRUE;
    updateRectFlag = TRUE;

    if(VIDEO_15_FRAMES == uiFrames)
    {
        g_uiSleepTime = UPS_15_FRAMES_INTER;
    }
    else if(VIDEO_25_FRAMES == uiFrames)
    {
        g_uiSleepTime = UPS_25_FRAMES_INTER;
    }

    return MSP_COM_OP_SUCCESS;
}

/**
 * ƣ Zte_OsdUnInit 
 *  OSDģ鷴ʼ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
VOID Zte_OsdUnInit(VOID)
{
    T_ZDrvVideo_BufInfo tBufInfo;

    /* FIXME: OsdѾ */
    if(0 == g_uiVideoFd)
    {
        zMspCom_Print();
        
        return;
    }    

    zOss_GetMutex(g_pOsdLock, ZOSS_WAIT_FOREVER);

    /* ֪ͨGUIлģʽ */
    {
        g_bFirst      = FALSE;
        g_bOsdFlag    = FALSE;
        g_uiSleepTime = UPS_DFAULT_INTER;        
    }    

    /* ͷGUIOSDռ*/
    g_uiOsdFreeYUVBufCount++;
    zDrv_Ioctl(g_uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &g_tOsdGuiBuf);
    
    /* ͷĬϵĺռ */
    g_uiOsdFreeYUVBufCount++;
    zDrv_Ioctl(g_uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &g_tOsdOutBufInfo);

    zOss_PutMutex(g_pOsdLock);    
    
    /* ͷһ֡Ƶͼ */
    if(g_tVideoOsdRect.width != 0)
    {
        if(g_bARGB)
        {
            /* ȫARGB */
            tBufInfo.bufType             = ARGB_TYPE;
            tBufInfo.bufSize.ARGBBufSize = g_uiDefaultARGBSize / 2;
            tBufInfo.pDataBuf            = g_tOsdPpuInfo.outputInfo.pOutPutbuffer;
        }
        else
        {
            /* ȫYUV420 */
            tBufInfo.bufType                   = YUV_TYPE;
            tBufInfo.bufSize.YuvBufSize.ySize  = g_uiDefaultYSize;
            tBufInfo.bufSize.YuvBufSize.uSize  = g_uiDefaultUSize;
            tBufInfo.bufSize.YuvBufSize.vSize  = g_uiDefaultVSize;
            tBufInfo.pDataBuf                  = g_tOsdPpuInfo.inputInfo.pInPutbuffer;    
            g_uiOsdFreeYUVBufCount++;
        }
        zDrv_Ioctl(g_uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&tBufInfo);            
    }
    
    /* OSDȫֱ */
    zOss_Memset(&g_tOsdPpuInfo,   0, sizeof(T_ZDrvVideo_PpuInfo));
    zOss_Memset(&g_tOsdGuiBuf,    0, sizeof(RECT_T));
    zOss_Memset(&g_tVideoOsdRect, 0, sizeof(RECT_T));
    
    g_bARGB     = FALSE;
    g_uiVideoFd = 0;
    g_bNewVideo = FALSE;
    updateRectFlag = FALSE;
    
    return;
}

/**
 * ƣ Zte_OsdUpdateVideoInput 
 *  Ƶͼ
 * ˵ (IN) pVideoImage    Ƶͼ(Ϊȫ)
 *            (IN) bARGB          ƵͼݸʽǷΪARGB
 *            (IN) tVideoPlayRect Ƶͼʾ
 *   ֵ 
 * ˵ 
 */
VOID Zte_OsdUpdateVideoInput(T_ZDrv_ImageDataBuf *pVideoImage, BOOL bARGB, RECT_T *tVideoPlayRect)
{   
    T_ZDrvVideo_BufInfo tBufInfo;
    
    /* OSD */
    zOss_GetMutex(g_pOsdLock, ZOSS_WAIT_FOREVER);

    /* ͷϴεƵBuffer(һθƵʱҪͷŲ);
     * ƵеȫARGBݣֱΪLCDˢԴ
     * YUV420ƵݣҪGUIOSDݽһλϺ
     * Ȼ󽫻ϺARGBΪLCDˢԴ
     */
    if(g_tVideoOsdRect.width != 0)
    {
        if(g_bARGB)
        {
            /* ȫARGB */
            tBufInfo.bufType             = ARGB_TYPE;
            tBufInfo.bufSize.ARGBBufSize = g_uiDefaultARGBSize / 2;
            tBufInfo.pDataBuf            = g_tOsdPpuInfo.outputInfo.pOutPutbuffer;

            /* ¸ƵռΪĬϵռ */
            g_tOsdPpuInfo.outputInfo.pOutPutbuffer = g_tOsdOutBufInfo.pDataBuf; 
        }
        else
        {
            /* ȫYUV420 */
            tBufInfo.bufType                   = YUV_TYPE;
            tBufInfo.bufSize.YuvBufSize.ySize  = g_uiDefaultYSize;
            tBufInfo.bufSize.YuvBufSize.uSize  = g_uiDefaultUSize;
            tBufInfo.bufSize.YuvBufSize.vSize  = g_uiDefaultVSize;
            tBufInfo.pDataBuf                  = g_tOsdPpuInfo.inputInfo.pInPutbuffer;    
        }

        g_uiOsdFreeYUVBufCount++;
        zDrv_Ioctl(g_uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&tBufInfo);            
    }
    
    /* ƵʾݸʽϢ */
    g_bARGB         = bARGB;
    g_tVideoOsdRect = *tVideoPlayRect;
    
    if(bARGB)
    {
        g_tOsdPpuInfo.outputInfo.pOutPutbuffer = *pVideoImage;
    }
    else
    {
        /* ƵOSDϢ */
        g_tOsdPpuInfo.inputInfo.uiStartX     = 0;
        g_tOsdPpuInfo.inputInfo.uiStartY     = 0;
        g_tOsdPpuInfo.inputInfo.uiWidth      = g_uiScreenWidth;
        g_tOsdPpuInfo.inputInfo.uiHeight     = g_uiScreenHeight;  
        g_tOsdPpuInfo.inputInfo.uiStride     = g_uiScreenWidth;    
        g_tOsdPpuInfo.inputInfo.tPixelFmt    = PIXEL_YCbCr420;              /* YUV420 */
        g_tOsdPpuInfo.inputInfo.pInPutbuffer = *pVideoImage; 
        
    }

    /* µƵݣ±־ */
    g_bNewVideo = TRUE;
    
#if 0
    /* OSDӲ */
    if(!g_bARGB)
    {
        zDrv_Ioctl(g_uiVideoFd, IOCTL_VIDEO_POSTPROCESS, &g_tOsdPpuInfo);
    }

    /* Ŀǰ֧־ֲˢ */
    g_tVideoLCDBuffer.pBuf = g_tOsdPpuInfo.outputInfo.pOutPutbuffer.ARGBdataBuf;
    zDrv_Ioctl(g_uiLcdFd, IOCTL_LCD_VIDEO_UPDATE_DISPLAY, &g_tVideoLCDBuffer);
#endif

    /* OSD */
    zOss_PutMutex(g_pOsdLock);

    return;  
}

#if 1 /*KeyMine2.0ʱʹӿ*/
/* ǷʹúɫΪ͸ɫںɫڳɫ˲òúɫΪ͸ɫСģĿǰֻпӵ绰ʹ */
BOOL g_bUseDefTransColor = FALSE;

VOID zMspOsd_SetUseDefTransColor(BOOL bUse)
{
    g_bUseDefTransColor = (BOOL)bUse;
    return;
}

/**
 * ƣ Zte_LockLcdFrameBuffer 
 *  ˢ
 * ˵ 
 *   ֵ 
 * ˵ 
 */
VOID Zte_LockLcdFrameBuffer(VOID)
{
    if(updateLock != NULL)
    {
        zOss_GetMutex(updateLock, ZOSS_WAIT_FOREVER);
    }
    return;
}

/**
 * ƣ Zte_UnlockLcdFrameBuffer 
 *  ˢ
 * ˵ 
 *   ֵ 
 * ˵ 
 */
VOID Zte_UnlockLcdFrameBuffer(VOID)
{
    if(updateLock != NULL)
    {
        zOss_PutMutex(updateLock);
    }
    return;
}

/**
 * ƣ Zte_GetScreenData 
 *  ȡˢ
 * ˵ 
 *   ֵ 
 * ˵ 
 */
SINT32 Zte_GetScreenData(VOID *dst, UINT32 uiWidth, UINT32 uiHeight)
{
    if(!g_bOsdFlag)
    {
        return -1;
    }
    zOss_GetMutex(g_pOsdLock, ZOSS_WAIT_FOREVER);
    zOss_Memcpy(dst, g_tOsdPpuInfo.outputInfo.pOutPutbuffer.ARGBdataBuf, uiWidth*uiHeight*2);
    zOss_PutMutex(g_pOsdLock);
    return 0;
}



/**
 * ƣ Zte_SetTransformColor 
 *  OSDģ͸ɫ͸
 * ˵ (IN) uiTransColoor: ͸ɫ
                   uiAlpha      : ͸
 *   ֵ 
 * ˵ 
 */
VOID Zte_SetLcdFd(UINT32 uiLcdFd)
{
    zOss_ASSERT(uiLcdFd > 0);
    g_uiLcdFd = uiLcdFd;
    return;
}

/**
 * ƣ Zte_GetUpdateFlag 
 *  ȡĻݸ±
 * ˵ (IN) updateFlag: ±
 *   ֵ 
 * ˵ 
 */
VOID Zte_GetUpdateFlag(BOOL *updateFlag)
{
    *updateFlag = (BOOL)updateRectFlag;
}


/**
 * ƣ Zte_SetTransformColor 
 *  OSDģ͸ɫ͸
 * ˵ (IN) uiTransColoor: ͸ɫ
                   uiAlpha      : ͸
 *   ֵ 
 * ˵ 
 */
VOID Zte_SetTransformColor(UINT16 uiTransColoor, UINT8 uiAlpha)
{
    g_TransColor = uiTransColoor;
    g_uiAlpha    = uiAlpha;
}

/**
 * ƣ Zte_SetScreenSize 
 *  Ļ
 * ˵ (IN) uiWidth : 
                   uiHeight: ߶
 *   ֵ 
 * ˵ 
 */
VOID Zte_SetScreenSize(UINT32 uiWidth, UINT32 uiHeight)
{
     g_uiScreenWidth     = uiWidth;
     g_uiScreenHeight    = uiHeight;
     g_uiDefaultYSize    = uiWidth * uiHeight;       /* ȫYUV420ʽYС */
     g_uiDefaultUSize    = uiWidth * uiHeight / 4;   /* ȫYUV420ʽUС */
     g_uiDefaultVSize    = uiWidth * uiHeight / 4;   /* ȫYUV420ʽVС */
     g_uiDefaultARGBSize = uiWidth * uiHeight * 4;   /* ȫARGB888С         */
}

/**
 * ƣ Zte_Osd565ToARGB8888 
 *  ָڵRGB565ظʽתΪARGB8888ظʽ
 * ˵   (IN) tRect ԴͼҪ
 *              (IN) pSourceData    ȫԴͼ
 *              (IN) SourcePitch    Դͼÿֽ
 *              (OUT) pDesData      תĿͼ
 *              (IN) DestPitch      ȫĿͼÿֽ
 *              (IN)  pixelkey      أҪ͸ֵͨ
 *              (IN)  alpha         Ҫõ͸ֵͨ
 *   ֵ SINT32  
 *                   Ч-1
 *                   Ч-2 
 *                   ȷأ
 *                                      
 * ˵ 
 */
static SINT32 Zte_OsdRGB565ToARGB8888(RECT_T *tRect, unsigned char *pSourceData, UINT32 SourcePitch, unsigned char *pDestData, UINT32 DestPitch)
{
    OSD_Color color;
    unsigned char const *sour_line;
    unsigned char *dst_line;
    int x, y, w, h;
    unsigned char g1, g2;
    unsigned char  alpha    = g_uiAlpha;
    BOOL  bUseDefColor = g_bUseDefTransColor;
    
    if (!tRect || !pSourceData || !pDestData)
    {
        return  - 1;
    }
    if (SourcePitch == 0 || DestPitch == 0)
    {
        return  - 1;
    }

    x = tRect->sx;
    y = tRect->sy;
    w = tRect->width;
    h = tRect->height;
    if (x > g_uiScreenWidth || y > g_uiScreenHeight)
    {
        return  - 2;
    }
    if (x < 0)
    {
        x = 0;
    }
    if (y < 0)
    {
        y = 0;
    }
    if (x + w > g_uiScreenWidth)
    {
        w = g_uiScreenWidth - x;
    }
    if (y + h > g_uiScreenHeight)
    {
        h = g_uiScreenHeight - y;
    }

    /*λʼַ*/
    sour_line = pSourceData + SourcePitch * y + x * 2;
    dst_line  = pDestData   + DestPitch   * y + x * 4;

    for (y = 0; y < h; y++)
    {
        for (x = 0; x < w; x++)
        {
            /* ʹĬ͸ɫ */
            if(bUseDefColor)
            {
                /*ȷALPHAֵеɫֵalphaֵΪȫ͸Ϊ͸*/
                if (PIXEL_OSD_BLACK == *(unsigned short*)sour_line)
                {
                    color.a = 0;//alpha;   /* ȫ͸ */
                }
                else
                {
                    color.a = alpha;//0;       /* ͸ */
                }                
            }
            else
            {            
                /*ȷALPHAֵеɫֵalphaֵΪȫ͸Ϊ͸*/
                if (g_TransColor == *(unsigned short*)sour_line/*PIXEL_OSD_GREEN          == *(unsigned short*)sour_line 
                    || PIXEL_OSD_TRANSPARENT == *(unsigned short*)sour_line
                    || PIXEL_OSD_BLACK     == *(unsigned short*)sour_line
                    || pixel_darkerred       == *(unsigned short*)sour_line 
                    || pixel_darkergreen     == *(unsigned short*)sour_line*/)
                {
                    color.a = 0;//0;//alpha;   /* ȫ͸ */
                }
                else
                {
                    color.a = alpha;//alpha;//0;       /* ͸ */
                }
            }

            //ʱСģʽRGB565ҪǴС
            /*ȷBֵ*/
            color.b = (*sour_line) << 3;
            /*ȷGֵ*/
            g1 = (*sour_line) >> 3;
            sour_line++; //һֽ
            g2 = (*sour_line) << 5;
            color.g = (g1 &0x1c) | (g2 &0xe0);
            /*ȷRֵ*/
            color.r = (*sour_line) &0xf8;
#if 1
            /*ֵARGB*/
            (*dst_line) = color.b;
            (*(dst_line + 1)) = color.g;
            (*(dst_line + 2)) = color.r;
            (*(dst_line + 3)) = color.a;
#endif

            sour_line++;
            dst_line += 4;
        }
        sour_line += (SourcePitch - w * 2);
        dst_line += (DestPitch - w * 4);
    }
    return 0;
}

#endif 
#if 0
/**
 * ƣ Zte_Osd565ToARGB8888 
 *  ָڵRGB565ظʽתΪARGB8888ظʽ
 * ˵ (IN)  tRect          ԴͼҪ
 *            (IN)  pSourceData    ȫԴͼ
 *            (IN)  SourcePitch    Դͼÿֽ
 *            (OUT) pDesData       תĿͼ
 *            (IN)  DestPitch      ȫĿͼÿֽ
 *            (IN)  pAlphaTable    ͸ȱΪҪӦKeyMine1.0
 *   ֵ SINT32  
 *                   Ч-1
 *                   Ч-2 
 *                   ȷأ
 * ˵ KM1.0תʹõĽӿ
 */
static SINT32 Zte_OsdRGB565ToARGB8888(RECT_T  *tRect,       unsigned char *pSourceData, 
                                      UINT32  SourcePitch,  unsigned char *pDestData, 
                                      UINT32  DestPitch,    unsigned char *pAlphaTable)
{
    OSD_Color color;
    unsigned char *sour_line;
    unsigned char *dst_line;
    int x, y, w, h;
    unsigned char g1, g2;

    if (!tRect || !pSourceData || !pDestData || !pAlphaTable)
    {
        return  - 1;
    }
    if (SourcePitch == 0 || DestPitch == 0)
    {
        return  - 1;
    }

    x = tRect->sx;
    y = tRect->sy;
    w = tRect->width;
    h = tRect->height;
    if (x > SCREEN_WIDTH || y > SCREEN_HEIGHT)
    {
        return  - 2;
    }
    if (x < 0)
    {
        x = 0;
    }
    if (y < 0)
    {
        y = 0;
    }
    if (x + w > SCREEN_WIDTH)
    {
        w = SCREEN_WIDTH - x;
    }
    if (y + h > SCREEN_HEIGHT)
    {
        h = SCREEN_HEIGHT - y;
    }

    /* λʼַ */
    sour_line = pSourceData + SourcePitch * y + x * 2;
    dst_line  = pDestData   + DestPitch   * y + x * 4;
    
    /* Ϊ˿Ƽ򵥣ȰRGB565->RGB888,͸ͨʱĬֵ */
    for (y = 0; y < h; y++)
    {
        for (x = 0; x < w; x++)
        {
            /* Ĭ͸ֵ */
            color.a = 0xFF;
            
            //ʱСģʽRGB565ҪǴС
            /* ȷBֵ */
            color.b = (*sour_line) << 3;
            
            /* ȷGֵ */
            g1 = (*sour_line) >> 3;
            sour_line++; //һֽ
            g2 = (*sour_line) << 5;
            color.g = (g1 &0x1c) | (g2 &0xe0);
            
            /* ȷRֵ */
            color.r = (*sour_line) &0xf8;

            /* ֵARGB */
            (*dst_line) = color.b;
            (*(dst_line + 1)) = color.g;
            (*(dst_line + 2)) = color.r;
            (*(dst_line + 3)) = color.a;
            sour_line++;
            dst_line += 4;
        }
        sour_line += (SourcePitch - w * 2);
        dst_line += (DestPitch - w * 4);
    }
    
    /* Ϊھֲˢ͸ȱ仯Ļ͸Ҫ»ȡһ
     * Ϊ˽ʡѭĴ԰ɫ͸ϵһ𡣵Ƚϸӣʱȷֿ㡣
     */
    /* λʼַ */
    dst_line = pDestData;
    for (x = 0; x < 240 *320; x++)
    {
        /* ´͸ͨΪ͸ȱеÿһ[015]ҪŴ17[0255] */
        *(dst_line + 4 * x + 3) = (*(pAlphaTable + x)) *17;
    }

    return 0;
}
#endif

static VOID Zte_OsdUpdateGuiData(void)
{
    zOss_GetMutex(updateLock, ZOSS_WAIT_FOREVER);
    
    if(!updateRectFlag)
    {
        zOss_PutMutex(updateLock);
        
        return;
    }

    /* ǵһνOSDˢ״̬Ҫȫת */
    if (g_bFirst)
    {
        RECT_T rect = {0, 0, 240, 320};
        rect.height = g_uiScreenHeight;
        rect.width  = g_uiScreenWidth;
        
        Zte_OsdRGB565ToARGB8888(&rect, (unsigned char*)pFrameBuffer, g_uiScreenWidth *2, (unsigned char*)g_tOsdGuiBuf.pDataBuf.ARGBdataBuf, g_uiScreenWidth *4); 
        g_bFirst = FALSE; 
    }
    else
    {
        /* ǵһνOSD״̬RGBֻ貿ת */
        Zte_OsdRGB565ToARGB8888(&updateRect, (unsigned char*)pFrameBuffer, g_uiScreenWidth *2, (unsigned char*)g_tOsdGuiBuf.pDataBuf.ARGBdataBuf, g_uiScreenWidth *4); 
    }
    
    zOss_Memset(&updateRect, 0, sizeof(updateRect));
    updateRectFlag = FALSE;
    
    zOss_PutMutex(updateLock);
    
    return;
}
 
/**
 * ƣ Zte_GuiUpdateScreen_Thread_Entry 
 *  LCDˢ߳
 * ˵   (IN) Param       ʱ
 *
 *                              
 * ˵ 
 */
static VOID Zte_GuiUpdateScreen_Thread_Entry(SINT32 Param)
{
    T_ZDrvLcd_DisplayParam displayParam;
    #if 0
    static FILE* pFileARGBDATA = NULL;
    static UINT8 guidata[307200] = {1};
    if(pFileARGBDATA == NULL)
    {
        pFileARGBDATA = zOss_FOpen("C:\\gui_240x320.argb", "rb");
    }
    #endif
    
    while (TRUE)
    {
        zOss_Sleep(g_uiSleepTime);
        if (updateRectFlag || g_bNewVideo)
        {
            if (g_bOsdFlag)   /* ΪOSD״̬ʱ */
            {
                zOss_GetMutex(g_pOsdLock, ZOSS_WAIT_FOREVER);

                /* OSD˳ */
                if(!g_bOsdFlag)
                {
                    g_bNewVideo = FALSE;
                    zOss_PutMutex(g_pOsdLock);

                    continue;
                }
                
                g_uiOsdCount++;
                
                /* OSDӲ */
                if (!g_bARGB)
                {
                    Zte_OsdUpdateGuiData();
                    #if 0
                    zOss_FRead(guidata, 30720, 10, pFileARGBDATA);
                    zOss_Memcpy(g_tOsdGuiBuf.pDataBuf.ARGBdataBuf, guidata, sizeof(guidata));
                    #endif
                    //zOss_Memset(g_tOsdPpuInfo.osdInfo.pImg, 0, 240*320*4);
                    zDrv_Ioctl(g_uiVideoFd, IOCTL_VIDEO_POSTPROCESS, &g_tOsdPpuInfo);
                }
               
                /* ARGBˢ */
                g_tVideoLCDBuffer.pBuf = g_tOsdPpuInfo.outputInfo.pOutPutbuffer.ARGBdataBuf;

                if(g_tVideoLCDBuffer.uiStartX + g_tVideoLCDBuffer.uiWidth >= 1
		    && g_tVideoLCDBuffer.uiStartY + g_tVideoLCDBuffer.uiHeight >= 1)
                {
                    zDrv_Ioctl(g_uiLcdFd, IOCTL_LCD_VIDEO_UPDATE_DISPLAY, &g_tVideoLCDBuffer);
                    //zSvrDm_LcdARGBRefreshReq(g_tVideoLCDBuffer);
                }

                g_bNewVideo = FALSE;
                
                zOss_PutMutex(g_pOsdLock);

            }
            else  /* ûOSD״̬ʱ */
            {
                zOss_GetMutex(updateLock, ZOSS_WAIT_FOREVER);
                displayParam.uiStartX = updateRect.sx;
                displayParam.uiStartY = updateRect.sy;
                displayParam.uiHeight = updateRect.height;
                displayParam.uiWidth  = updateRect.width;
                displayParam.pBuf    = (void*)pFrameBuffer;
                if(displayParam.uiStartX + displayParam.uiWidth >= 1
		    && displayParam.uiStartY + displayParam.uiHeight >= 1)
                {
                    zDrv_Ioctl(g_uiLcdFd, IOCTL_LCD_UPDATE_DISPLAY, &displayParam);
                }
                //zSvrDm_LcdRefreshReq(displayParam);
             
                /*ˢºԭͱ־*/                
                zOss_Memset(&updateRect, 0, sizeof(updateRect));
                updateRectFlag = FALSE;
                
                zOss_PutMutex(updateLock);
            }
        }
    }
}

/**
 * ƣ Zte_GuiDestroyUpdateScreenThread 
 *  ʼʱˢ̵߳Ľӿ
 * ˵ (IN) priority       Ҫ̵߳ȼ
 *            (IN) stack_size     ҪջռС
 *            (IN) LcdFd          LCD豸
 *            (IN) pBuffer        LCD豸Դ
 *   ֵ BOOL    FALSE: ʧܺδ
 *                    TRUE:  ɹ          
 * ˵ GUIʼʱãҪڳɹLCD豸֮󣬾ͷsystem_initialize
 */
BOOL Zte_GuiCreateUpdateScreenThread(UINT32 priority, UINT32 stack_size, VOID *pBuffer)
{
    if (!pBuffer)
    {
        return FALSE;
    }    
    
    /* 豸ִ */
    pFrameBuffer = pBuffer;

    /* GUIˢ² */
    updateLock = zOss_CreateMutex(GUI_UPS_LOCK, ZOSS_NO_INHERIT);
    
    if (NULL == updateLock)
    {
        return FALSE;
    }
    pUpdateScreenThread = zOss_CreateThread(GUI_UPS_THREAD, 
                                            Zte_GuiUpdateScreen_Thread_Entry, 
                                            0, 
                                            stack_size, 
                                            priority, 
                                            0, 
                                            1); 
    if (NULL == pUpdateScreenThread)
    {    
        return FALSE; 
    }
    
    return TRUE; 
}

/**
 * ƣ Zte_GuiDestroyUpdateScreenThread 
 *  ػʱLCDˢ߳
 * ˵   
 *   ֵ BOOL    FALSE: ʧ
 *                    TRUE:  ٳɹ
 * ˵ ڹػʱãԿԲá
 */
BOOL Zte_GuiDestroyUpdateScreenThread(VOID)
{
    if (zOss_DeleteThread(pUpdateScreenThread) != ZOSS_SUCCESS)
    {
        return FALSE; 
    }
    
    return TRUE; 
}

/**
 * ƣ Zte_GuiUpdateScreenRect 
 *  GUIˢ֪ͨ
 * ˵ (IN) left        ֲˢµʼx
 *            (IN) top         ֲˢµʼy
 *            (IN) right       ֲˢµֹx
 *            (IN) bottom      ֲˢµֹy
 *            (IN) pAlphaTable MMIõ͸ȱСΪ240*320ֻOSD״̬Ч
 *                             ״̬Ϊ
 *   ֵ 
 * ˵ primaryUpdateRegionʹ,滻֮ǰˢĲ.
 */
VOID Zte_GuiUpdateScreenRect(UINT32 left, UINT32 top, UINT32 right, UINT32 bottom,  unsigned char  *pAlphaTable)
{

    /* cyx 2009-9-1  Ϊ޸ */
    /* ʱ */
    UINT32 uiLeft = 0, uiTop = 0, uiRight = 0, uiBottom = 0;

	zOss_GetMutex(updateLock, ZOSS_WAIT_FOREVER);

	uiLeft = updateRect.sx;
	uiTop = updateRect.sy;
	uiRight = updateRect.sx + updateRect.width;
	uiBottom = updateRect.sy + updateRect.height;
	
	
	if (uiLeft > left)
	{
		uiLeft  = left;
	}
	
	if (uiTop  > top)
	{
		uiTop  = top;
	}

	if (uiRight < right)
	{
		uiRight  = right;
	}

	if (uiBottom < bottom )
	{
		uiBottom = bottom;
	}

	updateRect.sx = uiLeft;
	updateRect.sy = uiTop;
	updateRect.width = (uiRight - uiLeft);
	updateRect.height= (uiBottom - uiTop);

    /* Լ */
	if(updateRect.sx + updateRect.width  > g_uiScreenWidth)
	{
		updateRect.width = g_uiScreenWidth - updateRect.sx;
	}

	if(updateRect.sy + updateRect.height > g_uiScreenHeight)
	{
		updateRect.height = g_uiScreenHeight - updateRect.sy;
	}

    updateRectFlag = TRUE; 
	
    zOss_PutMutex(updateLock); 


	return;
}

