/************************************************************************
* Ȩ(C)2007,ͨѶɷ޹˾
* ģ  ӵ绰ҵжýģ
* ļƣzte_vtdriver.c
* ļʶ 
* ժҪ 
* 
* ޸      汾     ޸ı       ޸       ޸      
* ----------------------------------------------------------------------
* 2009/6/3    1.0                                              
************************************************************************/
  
/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include "oss_api.h"
#include "zte_display.h"
#include "drv_api.h"    
#include "zte_osd.h"
#include "zMsp_Com.h"
#include "zte_vtdriver.h"
//#include "zplat_svr_api.h"

#define  VT_USE_VIDEOFRAMEBUFFER  /* Ƶ֡ */  
/**************************************************************************
 *                                                                    *
 **************************************************************************/
/* ӵ绰ýڲʹϢ */
enum
{
    EV_VT_VIDEOPROC_QUIT_SYN,           /* Ƶ߳̽Ϣ         */
    EV_VT_VIDEOPROC_SETPARAM_SYN        /* Ƶ߳ʾϢ */
};

enum VT_MSP_ERRCODE
{
    VT_OP_SUCCESS       = 0,                /* VTɹ                 */
#ifdef VT_USE_VIDEOFRAMEBUFFER    
    VT_OP_GO_DECODE     = 1,                /* ģʽ½н     */
    VT_OP_ALREADY_FRAME = 2,                /* ģʽ»һ֡ */
#endif
    VT_OP_ERROR         = -1,               /* VTʧ                 */
    VT_OP_MEM_ERR       = -2,               /* ڴʧ               */
    VT_OP_PARAM_ERR     = -3,               /*                    */
    VT_OP_BUFFER_ERR    = -4,               /* ӲBufferʧ         */
    VT_OP_DEVICE_ERR    = -5,               /* ײ豸쳣           */
    VT_OP_DECODE_ERR    = -6,               /* Ƶ               */
    VT_OP_ENCCODE_ERR   = -7,               /* Ƶ               */
    VT_OP_POSTPPU_ERR   = -8                /* Ƶ             */    
};

#define VT_VOICE_DFTLEN       31            /* ӵ绰ݳ(һ֡AMR)  */
#define VT_PROC_IMG_INTER     60            /* Ƶ̼߳Ϣʱ */
#define VT_DFT_ENC_WIDTH      176           /* ӵ绰Ƶ       */
#define VT_DFT_ENC_HEIGHT     144           /* ӵ绰Ƶ߶       */
#define VT_VIDEO_FRAMEBUFLEN  (25 * 1024)   /* ӵ绰Ƶ֡   */

/**************************************************************************
 *                                                                      *
 **************************************************************************/
#define VT_VDPROC_PRIO      19                      /* VTƵ߳ȼ                */
#define VT_VDPROC_STACK     (4 * 1024)              /* VTƵջռ                  */
#define VT_VDPROC_THREAD    "vt_videoproc_thread"   /* VTƵ߳                  */
#define VT_DEFAULT_FPS      Fps15                   /* VTͷĬϲɼ֡              */
#define VT_DEFAULT_SENSOR   MSP_SENSOR_SUB          /* VTʹõĬͷ                */
#define VT_DEFAULT_IMGSIZE  OUTPUT_IMG_QVGA         /* ͷĬͼС(320 * 240) */

#define VT_VDPROC_SEM       "vt_videoproc_sem"      /* Ƶ߳ź */
#define VT_VDLOCAL_MUTEX    "vt_videolocal_mutex"   /* Ƶû */
#define VT_VDREMOTE_MUTEX   "vt_videoremote_mutex"  /* ԶƵû */

/**************************************************************************
 *                                                                 *
 **************************************************************************/
typedef enum
{
    VT_VOICE_STATE_IDLE,     /* VOICE״̬               */
    VT_VOICE_STATE_OPEN,     /* VOICEѾ             */
    VT_VOICE_STATE_WORKING   /* VOICE״̬(Ѿʼ) */ 
}VT_VOICE_STATE;

typedef enum
{
    VT_VIDEO_STATE_IDLE,     /* VIDEO״̬               */
    VT_VIDEO_STATE_OPEN,     /* VIDEOѾ             */
    VT_VIDEO_STATE_WORKING   /* VIDEO״̬(Ѿʼ) */     
}VT_VIDEO_STATE;

typedef struct _VT_WORK_STATE
{
    VT_VOICE_STATE  eVoiceState;        /* VOICE״̬ */
    VT_VIDEO_STATE  eVideoState;        /* VIDEO״̬ */
}VT_WORK_STATE;

typedef struct _T_VT_VcConParam
{
    UINT32            uiVoiceFd;        /* VOICE豸Fd   */
#ifdef __ZMSP_DEBUG__    
    UINT32            uiReadCount;      /* ȡ  */
    UINT32            uiWriteCount;     /* д  */
    UINT32            uiWErrCount;      /* дʧܴ */
#endif    
    VT_VOICE_PARAM_T  tVoiceParam;      /* VOICEò */
}T_VT_VcConParam;

typedef struct _VT_YUV_Offset
{
    UINT32  uiYOffset;                  /* YӦƫ */
    UINT32  uiUOffset;                  /* UӦƫ */
    UINT32  uiVOffset;                  /* VӦƫ */
}VT_YUV_Offset;

typedef struct _T_VT_VdConParam
{
    BOOL               bEncOpen;        /* ǷѴ       */
    BOOL               bDecOpen;        /* ǷѴ       */
    UINT32             uiVideoFd;       /* Video豸Fd            */
    UINT32             uiCamraFd;       /* ͷ豸Fd           */
#ifdef __ZMSP_DEBUG__    
    UINT32             uiReadCount;     /* Ƶݶȡ       */
    UINT32             uiWriteCount;    /* Ƶд       */
    UINT32             uiWErrCount;     /* Ƶдʧܴ   */
#endif    
    RECT_T             tLocalRect;      /* Ƶʾ(ת) */
    RECT_T             tRemoteRect;     /* ԶƵʾ(ת) */
    DecHandle          pDecHandle;      /* Ƶ         */
    EncHandle          pEncHandle;      /* Ƶ         */
    VT_YUV_Offset      tLocalOffset;    /* ͼƬڱϵƫ */
    VT_YUV_Offset      tRemoteOffset;   /* ԶͼƬڱϵƫ */
    ZOSS_MUTEX_ID      pVTLocalMutex;   /* Ƶ     */
    ZOSS_MUTEX_ID      pVTRemoteMutex;  /* ԶƵ     */  
    ZOSS_THREAD_ID     pVdProcThread;   /* Ƶ߳ID         */
    VT_VIDEO_PARAM_T   tVideoParam;     /* ƵƲ       */
    ZOSS_SEMAPHORE_ID  pVTControlSem;   /* Ƶ߳ź     */
    T_ZDrv_YuvBufSize  tEncInSize;      /* ƵYUVռС    */
    T_ZDrv_YuvBufSize  tDecOutSize;     /* ƵYUVռС    */
}T_VT_VdConParam;

typedef struct _T_VT_VdDisParam
{
    BOOL                 bLImgNew;        /* ƵͼƬ     */
    BOOL                 bRImgNew;        /* ԶƵͼƬ     */
    BOOL                 bLocalHide;      /* ͼǷʾ     */
    UINT32               uiLImgInWidth;   /* ƵͼƬ       */
    UINT32               uiLImgInHeight;  /* ƵͼƬ       */
    UINT32               uiRImgInWidth;   /* ԶƵͼƬ       */
    UINT32               uiRImgInHeight;  /* ԶƵͼƬ       */  
    T_ZDrv_YuvBufSize    tLImgYUVSize;    /* ƵͼƬС     */
    T_ZDrv_YuvBufSize    tRImgYUVSize;    /* ԶƵͼƬ     */
    T_ZDrv_ImageDataBuf  tLImgInData;     /* ƵͼƬ     */
    T_ZDrv_ImageDataBuf  tRImgInData;     /* ԶƵͼƬ     */
}T_VT_VdDisParam;

#ifdef VT_USE_VIDEOFRAMEBUFFER
typedef struct _T_VT_VideoFrameBuf
{
    CHAR   *pFrameBuffer;  /* ʼַ     */
    CHAR   *pCurPos;       /* ǰݲַ */
    CHAR   *pCheckPos;     /* ֡ͷʼλ */    
    UINT32  uiMaxLen;      /* ݳ     */
    UINT32  uiUsedLen;     /* ݳ     */
}T_VT_VideoFrameBuf;       /* Ƶ֡ṹ     */
#endif

/**************************************************************************
 *                           ֲԭ                                  *
 **************************************************************************/
static SINT32 VT_Video_InitFrameBuf(VOID);

static VOID VT_Video_UnInitFrameBuf(VOID);

static SINT32 VT_Video_SaveFrame(CHAR *pFrameBuf,  UINT32 uiBufLen,
                                 CHAR **pNewFrame, UINT32 *pBufLen);

static VOID VT_Video_CheckFrame(CHAR *pFrameBuf,  UINT32  uiBufLen,
                                CHAR **pHead,     UINT32 *uiOffset);

static SINT32 VT_VideoRefreshFrame(SINT32  iSaveRet,     
                                   CHAR   *pFrameBuf,    UINT32 uiBufLen,
                                   CHAR   *pNewFrameAdd, UINT32 uiNewBufLen);

static VOID VT_VoiceConvertParam(T_ZDrvVoice_AmrInfo *pAmrInfo, VT_VOICE_PARAM_T *pVoiceParam);

static SINT32 VT_VideoCreateSemAndMutexs(VOID);

static VOID VT_VideoDestroySemAndMutexs(VOID);

static VOID VT_VideoUpdateLocalImage(T_ZDrv_ImageDataBuf *pLVideoImage, 
                                     UINT32 uiWidth, UINT32 uiHeight,
                                     T_ZDrv_YuvBufSize   *pLYuvSize);

static VOID VT_VideoUpdateRemoteImage(T_ZDrv_ImageDataBuf *pRVideoImage, 
                                      UINT32 uiWidth, UINT32 uiHeight,
                                      T_ZDrv_YuvBufSize   *pRYuvSize);

static SINT32 VT_VideoOpenDev(VOID);

static VOID VT_VideoCloseDev(VOID);

static SINT32 VT_CheckVideoInitParam(VT_VIDEO_PARAM_T  *pCodecParam);

static SINT32 VT_VideoInitDev(VOID);

static VOID VT_VideoReleaseDev(VOID);

static VOID VT_RefreshYUVOffset(VOID);

static EncHandle VT_Video_OpenEncoder(VT_VIDEO_FORMAT tVideoFormat, T_ZDrv_PixelFmt tPixelFmt,
                                      UINT32   uiWidth, UINT32   uiHeight, UINT32   uiStride);


static SINT32 VT_Video_EnCodeData(T_ZDrv_ImageDataBuf *pSrcData, CHAR *pFrameBuf, UINT32 uiBufLen);

static VOID VT_Video_CloseEncoder(EncHandle pEncHandle);

static DecHandle VT_Video_OpenDecoder(VT_VIDEO_FORMAT tVideoFormat, CHAR *pFrameBuf, UINT32 uiBufLen);

static SINT32 VT_Video_DecodeData(T_ZDrv_ImageDataBuf *pDataOut, CHAR *pFrameBuf, UINT32 uiBufLen);

static VOID VT_Video_CloseDecoder(DecHandle pDecHandle);

static VOID VT_VideoProcSetParamMsg(VOID);

static VOID VT_VideoProcLRImages(VOID);

static VOID VT_VideoProcThreadLoop(VOID);    

static VOID VT_VideoProcThreadEntry(SINT32 iArg);

/**************************************************************************
 *                           ȫֱ                                      *
 **************************************************************************/
static SINT32             g_ErrorCode = VT_OP_SUCCESS;                              /* VTýģڲͳ */
static VT_WORK_STATE      g_tCurState = {VT_VOICE_STATE_IDLE, VT_VIDEO_STATE_IDLE}; /* VTýģ״̬ */
static T_VT_VcConParam    g_tVTVcConParam;                                          /* VTýƲ */
static T_VT_VdConParam    g_tVTVdConParam;                                          /* VTýƵƲ */
static T_VT_VdDisParam    g_tVTVdDisParam;                                          /* Ƶ˫ʾ */

#ifdef VT_USE_VIDEOFRAMEBUFFER
static T_VT_VideoFrameBuf g_tVTVideoRFrameBuf;                                       /* VTƵȡ֡       */
static T_VT_VideoFrameBuf g_tVTVideoWFrameBuf;                                      /* VTƵ֡       */
#endif

/**************************************************************************
 *                ʵ--в֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                ʵ--֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                ʵ--˽в֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                     ȫֺʵ                                      *
 **************************************************************************/
/**
 * ƣ VT_Voice_Open 
 *  VTͨ
 * ˵ (IN) 
 *   ֵ ɹDCAMERA_OP_SUCCESS
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E VT_Voice_Open(SINT32  iVoiceFd)
{
    SINT32  iRet     = -1;
    
    if(g_tCurState.eVoiceState != VT_VOICE_STATE_IDLE)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    /* ʼȫֱ */
    zOss_Memset(&g_tVTVcConParam, 0, sizeof(T_VT_VcConParam));
    
    ///* VOICE豸 */
    //iRet = zSvrDm_VoiceOpenReq(&iVoiceFd);
    if(iVoiceFd <= 0)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }
    g_tVTVcConParam.uiVoiceFd = (UINT32)iVoiceFd;
    
    g_tCurState.eVoiceState = VT_VOICE_STATE_OPEN;
    
    return DCAMERA_OP_SUCCESS;    
}
 
/**
 * ƣ VT_Voice_Close 
 *  رVTͨ
 * ˵ (IN) 
 *   ֵ ɹDCAMERA_OP_SUCCESS
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E VT_Voice_Close(VOID)
{
    if(g_tCurState.eVoiceState != VT_VOICE_STATE_OPEN)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    /* رVOICE豸 */
    g_tVTVcConParam.uiVoiceFd = 0;
    //zSvrDm_VoiceCloseReq();
    
    g_tCurState.eVoiceState = VT_VOICE_STATE_IDLE;
    
    #ifdef __ZMSP_DEBUG__
    zOss_Printf(SUBMDL_MMBASE, PRINT_LEVEL_ALLWAYS, "MSP VT Voice Dec Total Count =%d, Err Count = %d", g_tVTVcConParam.uiWriteCount, g_tVTVcConParam.uiWErrCount);
    #endif
    
    return DCAMERA_OP_SUCCESS;    
}

/**
 * ƣ VT_Voice_Init 
 *  ʼVTͨ
 * ˵ (IN) pVoiceParam VTͨʼ
 *   ֵ ɹDCAMERA_OP_SUCCESS
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E VT_Voice_Init(VT_VOICE_PARAM_T *pVoiceParam)
{
    SINT32              iRet = -1;
    T_ZDrvVoice_AmrInfo tAmrInfo;
    
    if(g_tCurState.eVoiceState != VT_VOICE_STATE_OPEN)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    /*  */
    if(NULL == pVoiceParam)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }
    if(pVoiceParam->tVoiceInfo.amrif < VT_VOICE_AMR_IF2
       || pVoiceParam->tVoiceInfo.amrif >= VT_MAX_VOICE_AMR_IF)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }
    if(pVoiceParam->tVoiceInfo.frametype < VT_VOICE_FRAME_MR475
       || pVoiceParam->tVoiceInfo.frametype >= VT_MAX_VOICE_FRAME_TYPE)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }    

    g_tVTVcConParam.tVoiceParam = *pVoiceParam;
 
 #if 0   
    /* ʹVOICE豸ڴ˽ӿڷã˭ȵδ֪
     * ˴˴Էֵж 
     */
    if (0 != zSvrDm_VoiceSwitchInChannelReq(ZSVR_DM_VOICE_MIC))
    {
        zOss_Printf(1, 2, "\r\nzblCcHandleProgressInd--- Error:zSvrDm_VoiceSwitchInChannelReq\r\n");
    }
    if (0 != zSvrDm_VoiceSwitchOutChannelReq(ZSVR_DM_VOICE_SPEAKER))
    {
        zOss_Printf(1, 2, "\r\nzblCcHandleProgressInd--- Error:zSvrDm_VoiceSwitchOutChannelReq\r\n");
    }
    if (0 != zSvrDm_VoiceSetOutVolumeReq(ZSVR_DM_VOICE_OUTPUT_VOL_LEVEL_5))
    {
        zOss_Printf(1, 2, "\r\nzblCcHandleProgressInd--- Error:zSvrDm_VoiceSetOutVolumeReq\r\n");
    }
    if (0 != zSvrDm_VoiceSetInVolumeReq(ZSVR_DM_VOICE_OUTPUT_VOL_LEVEL_5))
    {
        zOss_Printf(1, 2, "\r\nzblCcHandleProgressInd--- Error:zSvrDm_VoiceSetInVolumeReq\r\n");
    }
    
    zSvrDm_VoiceEnableReq();
 #endif

    /* ת */
    VT_VoiceConvertParam(&tAmrInfo, pVoiceParam);
    
    /* ʼӵ绰 */
    iRet = zDrv_Ioctl(g_tVTVcConParam.uiVoiceFd, IOCTL_VOICE_SET_VT_START, &tAmrInfo);
    if(iRet != DRV_SUCCESS)
    {
        zSvrDm_VoiceDisableReq();
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    g_tCurState.eVoiceState = VT_VOICE_STATE_WORKING;
        
    return DCAMERA_OP_SUCCESS;    
}

/**
 * ƣ VT_Voice_Release 
 *  ͷVTͨ
 * ˵ (IN) 
 *   ֵ ɹDCAMERA_OP_SUCCESS
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E VT_Voice_Release(VOID)
{
    if(g_tCurState.eVoiceState != VT_VOICE_STATE_WORKING)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    /* ֹͣӵ绰 */
    zDrv_Ioctl(g_tVTVcConParam.uiVoiceFd, IOCTL_VOICE_SET_VT_STOP, NULL);
 #if 0   
    zSvrDm_VoiceDisableReq();
 #endif
    
    g_tCurState.eVoiceState = VT_VOICE_STATE_OPEN;
    
    return DCAMERA_OP_SUCCESS;    
}

/**
 * ƣ VT_Voice_Read 
 *  VTݶȡһζȡһ֡
 * ˵ (IN/OUT) pVoiceBuf Ŷȡ(AMR)
 *            (IN)     uiBufLen  pVoiceBufĳȣ31ֽ
 *   ֵ ɹѶȡֽʧܷС0ֵ
 * ˵ 
 */
SINT32 VT_Voice_Read(CHAR *pVoiceBuf, UINT32 uiBufLen)
{
    SINT32  iRet = -1;
    
    if(g_tCurState.eVoiceState != VT_VOICE_STATE_WORKING)
    {
        zMspCom_Print();
        
        return VT_OP_ERROR;
    }

    /*  */
    if(NULL == pVoiceBuf || uiBufLen < VT_VOICE_DFTLEN)
    {
        zMspCom_Print();
        return VT_OP_PARAM_ERR;
    }

    /* ݽӿ */
    iRet = zDrv_Read(g_tVTVcConParam.uiVoiceFd, (VOID *)pVoiceBuf, uiBufLen);
    if(iRet < 0)
    {
        zMspCom_Print();
        return VT_OP_DEVICE_ERR;
    }

#ifdef __ZMSP_DEBUG__
    ++g_tVTVcConParam.uiReadCount;
#endif
    
    return iRet;    
}

/**
 * ƣ VT_Voice_Write 
 *  VTһһ֡
 * ˵ (IN) pVoiceBuf (AMR)ַ
 *            (IN) uiBufLen  (AMR)
 *   ֵ ɹֽʧܷС0ֵ
 * ˵ 
 */
SINT32 VT_Voice_Write(CHAR *pVoiceBuf, UINT32 uiBufLen)
{
    SINT32  iRet = -1;
    
    if(g_tCurState.eVoiceState != VT_VOICE_STATE_WORKING)
    {
        zMspCom_Print();
        
        return VT_OP_ERROR;
    }

    /*  */
    if(NULL == pVoiceBuf || uiBufLen > VT_VOICE_DFTLEN)
    {
        zMspCom_Print();
        
        return VT_OP_PARAM_ERR;
    }

    /* дݽӿ */
    iRet = zDrv_Write(g_tVTVcConParam.uiVoiceFd, (VOID *)pVoiceBuf, uiBufLen);
    if(iRet < 0)
    {
        #ifdef __ZMSP_DEBUG__
        ++g_tVTVcConParam.uiWErrCount;
        #endif
        zMspCom_Print();

        return VT_OP_DEVICE_ERR;
    }

#ifdef __ZMSP_DEBUG__
    ++g_tVTVcConParam.uiWriteCount;
#endif

    return iRet;    
}

/**
 * ƣ VT_Voice_SetCodecParam 
 *  VT
 * ˵ (IN) 
 *   ֵ ɹDCAMERA_OP_SUCCESS
 * ˵ ˽ӿڱ
 */
DCAMERA_RETURN_VALUE_E VT_Voice_SetCodecParam(VT_VOICE_AMRINFO_T *pVoiceInfo)
{
    if(g_tCurState.eVoiceState != VT_VOICE_STATE_OPEN
       || g_tCurState.eVoiceState != VT_VOICE_STATE_WORKING)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;    
}

/**
 * ƣ VT_Video_Open 
 *  VTƵͨ
 * ˵ 
 *   ֵ ɹDCAMERA_OP_SUCCESS
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E VT_Video_Open(VOID)
{
    SINT32  iRet = -1;

    if(g_tCurState.eVideoState != VT_VIDEO_STATE_IDLE)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }    

    /* ʼȫֱ */
    g_ErrorCode = VT_OP_SUCCESS;
    zOss_Memset(&g_tVTVdConParam, 0, sizeof(T_VT_VdConParam));
    zOss_Memset(&g_tVTVdDisParam, 0, sizeof(T_VT_VdDisParam));
    
    /* ͬԴ */
    iRet = VT_VideoCreateSemAndMutexs();
    if(iRet != VT_OP_SUCCESS)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;        
    }
    
    /* 豸 */
    iRet = VT_VideoOpenDev();
    if(iRet != VT_OP_SUCCESS)
    {   
        /* ͷŻͬԴ */
        VT_VideoDestroySemAndMutexs();
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR; 
    }

    /* ʼƵ֡ */
    #ifdef VT_USE_VIDEOFRAMEBUFFER
    iRet = VT_Video_InitFrameBuf();
    if(iRet != VT_OP_SUCCESS)
    {   
        VT_VideoCloseDev();
        VT_VideoDestroySemAndMutexs();
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR; 
    }
    #endif

    /* VTƵ״̬ */
    g_tCurState.eVideoState = VT_VIDEO_STATE_OPEN;
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ VT_Video_Close 
 *  رVTƵͨ
 * ˵ 
 *   ֵ ɹDCAMERA_OP_SUCCESS
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E VT_Video_Close(VOID)
{    
    if(g_tCurState.eVideoState != VT_VIDEO_STATE_OPEN)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    /* Ƶ֡ */
    #ifdef VT_USE_VIDEOFRAMEBUFFER
    VT_Video_UnInitFrameBuf();
    #endif
    
    /* ر豸 */
    VT_VideoCloseDev();
    
    /* ٻͬԴ */
    VT_VideoDestroySemAndMutexs();

    g_tCurState.eVideoState = VT_VIDEO_STATE_IDLE;
    
    #ifdef __ZMSP_DEBUG__
    zOss_Printf(SUBMDL_MMBASE, PRINT_LEVEL_ALLWAYS, "MSP VT Video Dec Total Count =%d, Err Count = %d", g_tVTVdConParam.uiWriteCount, g_tVTVdConParam.uiWErrCount);
    #endif
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ VT_Video_Init 
 *  ʼVTƵͨ
 * ˵ (IN) pVodieParam VTƵͨʼ
 *   ֵ ɹDCAMERA_OP_SUCCESS
 * ˵ Ŀǰֱ֧ΪH263ʽ֧QCIF(176 * 144)
 *            ʽͼ
 */
DCAMERA_RETURN_VALUE_E VT_Video_Init(VT_VIDEO_PARAM_T  *pCodecParam)
{
    SINT32  iRet        = -1;
    RECT_T  tLocalRect  = {0, };
    RECT_T  tRemoteRect = {0, };
    
    if(g_tCurState.eVideoState != VT_VIDEO_STATE_OPEN)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    /* 飬Ŀǰֻ֧H263QCIFʽ */
    iRet = VT_CheckVideoInitParam(pCodecParam);
    if(iRet != VT_OP_SUCCESS)    
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    /* ʾЧԼ鼰 */
    if(pCodecParam->tDisParam.tLocalRect.width != 0
       && pCodecParam->tDisParam.tLocalRect.height != 0)
    {
        iRet = zMspCom_VideoPlayRectModify(&tLocalRect, &(pCodecParam->tDisParam.tLocalRect), 
                                           pCodecParam->tEncParam.uiWidth, pCodecParam->tEncParam.uiHeight);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            zMspCom_Print();
            
            return DCAMERA_OP_ERROR;
        }        
    }
    else
    {
        tLocalRect = pCodecParam->tDisParam.tLocalRect;
    }

    /* ԶʾЧԼ鼰 */
    if(pCodecParam->tDisParam.tRemoteRect.width != 0
       && pCodecParam->tDisParam.tRemoteRect.height != 0)
    {
        iRet = zMspCom_VideoPlayRectModify(&tRemoteRect, &(pCodecParam->tDisParam.tRemoteRect), 
                                           pCodecParam->tDecParam.uiWidth, pCodecParam->tDecParam.uiHeight);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            zMspCom_Print();
            
            return DCAMERA_OP_ERROR;
        }
    }
    else
    {
        tRemoteRect = pCodecParam->tDisParam.tRemoteRect;
    }

    /* ±ͼƬYUVСıԶʾ */
    g_tVTVdConParam.tEncInSize.ySize                  = (pCodecParam->tEncParam.uiWidth) * (pCodecParam->tEncParam.uiHeight);
    g_tVTVdConParam.tEncInSize.uSize                  = (pCodecParam->tEncParam.uiWidth) * (pCodecParam->tEncParam.uiHeight) / 4;
    g_tVTVdConParam.tEncInSize.vSize                  = (pCodecParam->tEncParam.uiWidth) * (pCodecParam->tEncParam.uiHeight) / 4;
    g_tVTVdConParam.tVideoParam.tEncParam             = pCodecParam->tEncParam;
    g_tVTVdConParam.tVideoParam.tDecParam             = pCodecParam->tDecParam;
    g_tVTVdConParam.tVideoParam.tDisParam.tLocalRect  = tLocalRect;
    g_tVTVdConParam.tVideoParam.tDisParam.tRemoteRect = tRemoteRect;

    /* ºƫƼ */
    VT_RefreshYUVOffset();
    
    /* 豸 */
    iRet = VT_VideoInitDev();
    if(iRet != VT_OP_SUCCESS)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }
    
    /* ƵӴ߳ */
    g_tVTVdConParam.pVdProcThread = zOss_CreateThread(VT_VDPROC_THREAD, 
                                                      VT_VideoProcThreadEntry, 
                                                      0, 
                                                      VT_VDPROC_STACK, 
                                                      VT_VDPROC_PRIO, 
                                                      1, 
                                                      1);
    if(ZOSS_INVALID_THREAD_ID == g_tVTVdConParam.pVdProcThread)
    {
        VT_VideoReleaseDev();
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }
    
    g_tCurState.eVideoState = VT_VIDEO_STATE_WORKING;
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ VT_Video_Release 
 *  ͷVTƵͨ
 * ˵ (IN) 
 *   ֵ ɹDCAMERA_OP_SUCCESS
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E VT_Video_Release(VOID)
{
    SINT32  iRet = -1;
    
    if(g_tCurState.eVideoState != VT_VIDEO_STATE_WORKING)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    /* ֪ͨƵ߳̽ */
    iRet = zMspCom_PostMsg(g_tVTVdConParam.pVdProcThread, EV_VT_VIDEOPROC_QUIT_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    /* ͬȴƵ̲߳ */
    zOss_GetSemaphore(g_tVTVdConParam.pVTControlSem, ZOSS_WAIT_FOREVER);

    /* ˴ҪǷ(Ϊֹ֤ͣ豸Ȼִ) */

    /* ֹͣ豸 */
    VT_VideoReleaseDev();
    
    g_tCurState.eVideoState = VT_VIDEO_STATE_OPEN;
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ VT_Video_LocalOpen 
 *  ʾ
 * ˵ (IN) 
 *   ֵ ɹDCAMERA_OP_SUCCESS
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E VT_Video_LocalOpen(VOID)
{
    if(g_tCurState.eVideoState < VT_VIDEO_STATE_OPEN)
    {
        return DCAMERA_OP_ERROR;
    }

    g_tVTVdDisParam.bLocalHide = FALSE;
}

/**
 * ƣ VT_Video_LocalClose 
 *  ʾر
 * ˵ (IN) 
 *   ֵ ɹDCAMERA_OP_SUCCESS
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E VT_Video_LocalClose(VOID)
{
    if(g_tCurState.eVideoState < VT_VIDEO_STATE_OPEN)
    {
        return DCAMERA_OP_ERROR;
    }

    g_tVTVdDisParam.bLocalHide = TRUE;
}


/**
 * ƣ VT_Video_Read 
 *  VTƵݶȡ
 * ˵ (IN/OUT) pFrameBuf ŶȡƵͼ
 *            (IN)     uiBufLen  pFrameBufĳ
 *   ֵ ɹѶȡֽʧܷС0ֵ
 * ˵ 
 */
#if 0
SINT32 VT_Video_Read(CHAR *pFrameBuf, UINT32 uiBufLen)
{
    SINT32                iRet;
    T_ZDrv_CamDataInfo    tCamData;
    T_ZDrvVideo_BufInfo   tPpuOutBuf;
    T_ZDrvVideo_PpuInfo   tPpuInfo;
    
    if(g_tCurState.eVideoState != VT_VIDEO_STATE_WORKING)
    {
        zMspCom_Print();
        
        return VT_OP_ERROR;
    }

    /*  */
    if(NULL == pFrameBuf || 0 == uiBufLen)
    {
        zMspCom_Print();
        
        return VT_OP_PARAM_ERR;
    }

    /* SenSorɼƵ */
    iRet = zDrv_Ioctl(g_tVTVdConParam.uiCamraFd, IOCTL_CAM_GET_DATAINFO, &tCamData);
    if (iRet != DRV_SUCCESS)
    {
        zMspCom_Print();
        
        return VT_OP_DEVICE_ERR;
    }

    /*** for Test ****/
    #ifdef __ZMSP_DEBUG__
    if(tCamData.Width != 320 || tCamData.Height != 240)
    {
        zOss_Printf(SUBMDL_MMBASE, PRINT_LEVEL_ALLWAYS, "width = %u, height = %u", tCamData.Width, tCamData.Height);
    }
    #endif
    /*** for Test ****/

    /* ռ() */  
    tPpuOutBuf.bufType            = YUV_TYPE;
    tPpuOutBuf.bufSize.YuvBufSize = g_tVTVdConParam.tEncInSize;
 
    iRet = zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &tPpuOutBuf);
    if(iRet != DRV_SUCCESS)
    {   
        zDrv_Ioctl(g_tVTVdConParam.uiCamraFd, IOCTL_CAM_FREE_DATABUFFER, &tCamData);
        zMspCom_Print();
        
        return VT_OP_BUFFER_ERR;
    }             

    /* ͷɼͼ(320 * 240)ΪPPU */
    tPpuInfo.inputInfo.uiStartX     = 0;
    tPpuInfo.inputInfo.uiStartY     = 0;
    tPpuInfo.inputInfo.uiWidth      = tCamData.Width;
    tPpuInfo.inputInfo.uiHeight     = tCamData.Height;  
    tPpuInfo.inputInfo.uiStride     = tCamData.Width;
    tPpuInfo.inputInfo.tPixelFmt    = tCamData.pixeFmt;  
    tPpuInfo.inputInfo.pInPutbuffer = tCamData.dataBuf; 

    /* OSDʹ */
    tPpuInfo.osdInfo.bEnable = FALSE;

    tPpuInfo.outputInfo.uiWidth       = g_tVTVdConParam.tVideoParam.tEncParam.uiWidth;
    tPpuInfo.outputInfo.uiHeight      = g_tVTVdConParam.tVideoParam.tEncParam.uiHeight;
    tPpuInfo.outputInfo.uiStride      = g_tVTVdConParam.tVideoParam.tEncParam.uiWidth;
    tPpuInfo.outputInfo.tPixelFmt     = PIXEL_YCbCr420;
    tPpuInfo.outputInfo.pOutPutbuffer = tPpuOutBuf.pDataBuf;

    /* Ƶͷɼ320 * 240ͼûָıͼС */
    iRet = zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_POSTPROCESS, &tPpuInfo);
    if (iRet != DRV_SUCCESS)
    {
        zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER,   &tPpuOutBuf);
        zDrv_Ioctl(g_tVTVdConParam.uiCamraFd, IOCTL_CAM_FREE_DATABUFFER, &tCamData);
        zMspCom_Print();

        return VT_OP_POSTPPU_ERR;
    }

    /* ͷsensorɼ */
    zDrv_Ioctl(g_tVTVdConParam.uiCamraFd, IOCTL_CAM_FREE_DATABUFFER, &tCamData);

    /* һ򿪱 */
    if(!(g_tVTVdConParam.bEncOpen))
    {
        g_tVTVdConParam.pEncHandle = VT_Video_OpenEncoder(g_tVTVdConParam.tVideoParam.tEncParam.tVideoFormat, 
                                                          tPpuInfo.outputInfo.tPixelFmt, 
                                                          tPpuInfo.outputInfo.uiWidth, 
                                                          tPpuInfo.outputInfo.uiHeight, 
                                                          tPpuInfo.outputInfo.uiWidth);
        if(NULL == g_tVTVdConParam.pEncHandle)
        {
            zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &tPpuOutBuf);
            zMspCom_Print();

            return VT_OP_ENCCODE_ERR;
        }

        /* ± */
        g_tVTVdConParam.bEncOpen = TRUE;
    }

    /* 벢ûռ */
    iRet = VT_Video_EnCodeData(&tPpuOutBuf.pDataBuf, pFrameBuf, uiBufLen);
    if(iRet < 0)
    {
        zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &tPpuOutBuf);
        zMspCom_Print();

        return iRet;
    }

    /* Ƶıͼ */
    VT_VideoUpdateLocalImage(&(tPpuOutBuf.pDataBuf), 
                             tPpuInfo.outputInfo.uiWidth, 
                             tPpuInfo.outputInfo.uiHeight,
                             &(tPpuOutBuf.bufSize.YuvBufSize));
    
    #ifdef __ZMSP_DEBUG__
    ++g_tVTVdConParam.uiReadCount;
    #endif

    return iRet;
}
#endif

SINT32 VT_Video_Read(CHAR *pFrameBuf, UINT32 uiBufLen)
{
    SINT32                iRet;
    T_ZDrv_CamDataInfo    tCamData;
    T_ZDrvVideo_BufInfo   tPpuOutBuf;
    T_ZDrvVideo_PpuInfo   tPpuInfo;
    
    if(g_tCurState.eVideoState != VT_VIDEO_STATE_WORKING)
    {
        zMspCom_Print();
        
        return VT_OP_ERROR;
    }

    /*  */
    if(NULL == pFrameBuf || 0 == uiBufLen)
    {
        zMspCom_Print();
        
        return VT_OP_PARAM_ERR;
    }

    #ifdef VT_USE_VIDEOFRAMEBUFFER  /* ʹ֡ģʽ */

    /* ϴ */
    if(g_tVTVideoRFrameBuf.uiUsedLen > 0)
    {
        /* ݳûݳ */
        if(g_tVTVideoRFrameBuf.uiUsedLen > uiBufLen)
        {
            zOss_Memcpy(pFrameBuf, g_tVTVideoRFrameBuf.pCurPos, uiBufLen);
            g_tVTVideoRFrameBuf.uiUsedLen = g_tVTVideoRFrameBuf.uiUsedLen - uiBufLen;
            g_tVTVideoRFrameBuf.pCurPos   = g_tVTVideoRFrameBuf.pCurPos +  uiBufLen;

            return uiBufLen;
        }
        else
        {
            SINT32 iReadLen = 0;
            
            zOss_Memcpy(pFrameBuf, g_tVTVideoRFrameBuf.pCurPos, g_tVTVideoRFrameBuf.uiUsedLen);
            iReadLen                      = g_tVTVideoRFrameBuf.uiUsedLen;
            g_tVTVideoRFrameBuf.uiUsedLen = 0;
            g_tVTVideoRFrameBuf.pCurPos   = g_tVTVideoRFrameBuf.pFrameBuffer;

            return iReadLen;
        }
    }

    #endif

    /* SenSorɼƵ */
    iRet = zDrv_Ioctl(g_tVTVdConParam.uiCamraFd, IOCTL_CAM_GET_DATAINFO, &tCamData);
    if (iRet != DRV_SUCCESS)
    {
        zMspCom_Print();
        
        return VT_OP_DEVICE_ERR;
    }

    /*** for Test ****/
    #ifdef __ZMSP_DEBUG__
    if(tCamData.Width != 320 || tCamData.Height != 240)
    {
        zOss_Printf(SUBMDL_MMBASE, PRINT_LEVEL_ALLWAYS, "width = %u, height = %u", tCamData.Width, tCamData.Height);
    }
    #endif
    /*** for Test ****/

    /* ռ() */  
    tPpuOutBuf.bufType            = YUV_TYPE;
    tPpuOutBuf.bufSize.YuvBufSize = g_tVTVdConParam.tEncInSize;
 
    iRet = zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &tPpuOutBuf);
    if(iRet != DRV_SUCCESS)
    {   
        zDrv_Ioctl(g_tVTVdConParam.uiCamraFd, IOCTL_CAM_FREE_DATABUFFER, &tCamData);
        zMspCom_Print();
        
        return VT_OP_BUFFER_ERR;
    }             

    /* ͷɼͼ(320 * 240)ΪPPU */
    tPpuInfo.inputInfo.uiStartX     = 0;
    tPpuInfo.inputInfo.uiStartY     = 0;
    tPpuInfo.inputInfo.uiWidth      = tCamData.Width;
    tPpuInfo.inputInfo.uiHeight     = tCamData.Height;  
    tPpuInfo.inputInfo.uiStride     = tCamData.Width;
    tPpuInfo.inputInfo.tPixelFmt    = tCamData.pixeFmt;  
    tPpuInfo.inputInfo.pInPutbuffer = tCamData.dataBuf; 
    tPpuInfo.tMirror  = MIR_NONE;
    tPpuInfo.tRotate = ROT_0;

    /* OSDʹ */
    tPpuInfo.osdInfo.bEnable = FALSE;

    tPpuInfo.outputInfo.uiWidth       = g_tVTVdConParam.tVideoParam.tEncParam.uiWidth;
    tPpuInfo.outputInfo.uiHeight      = g_tVTVdConParam.tVideoParam.tEncParam.uiHeight;
    tPpuInfo.outputInfo.uiStride      = g_tVTVdConParam.tVideoParam.tEncParam.uiWidth;
    tPpuInfo.outputInfo.tPixelFmt     = PIXEL_YCbCr420;
    tPpuInfo.outputInfo.pOutPutbuffer = tPpuOutBuf.pDataBuf;

    /* Ƶͷɼ320 * 240ͼûָıͼС */
    iRet = zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_POSTPROCESS, &tPpuInfo);
    if (iRet != DRV_SUCCESS)
    {
        zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER,   &tPpuOutBuf);
        zDrv_Ioctl(g_tVTVdConParam.uiCamraFd, IOCTL_CAM_FREE_DATABUFFER, &tCamData);
        zMspCom_Print();

        return VT_OP_POSTPPU_ERR;
    }

    /* ͷsensorɼ */
    zDrv_Ioctl(g_tVTVdConParam.uiCamraFd, IOCTL_CAM_FREE_DATABUFFER, &tCamData);

    /* һ򿪱 */
    if(!(g_tVTVdConParam.bEncOpen))
    {
        g_tVTVdConParam.pEncHandle = VT_Video_OpenEncoder(g_tVTVdConParam.tVideoParam.tEncParam.tVideoFormat, 
                                                          tPpuInfo.outputInfo.tPixelFmt, 
                                                          tPpuInfo.outputInfo.uiWidth, 
                                                          tPpuInfo.outputInfo.uiHeight, 
                                                          tPpuInfo.outputInfo.uiWidth);
        if(NULL == g_tVTVdConParam.pEncHandle)
        {
            zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &tPpuOutBuf);
            zMspCom_Print();

            return VT_OP_ENCCODE_ERR;
        }

        /* ± */
        g_tVTVdConParam.bEncOpen = TRUE;
    }

    /* 벢ûռ */
    #ifdef VT_USE_VIDEOFRAMEBUFFER
    iRet = VT_Video_EnCodeData(&tPpuOutBuf.pDataBuf, 
                               g_tVTVideoRFrameBuf.pFrameBuffer, 
                               g_tVTVideoRFrameBuf.uiMaxLen);
    #else
    iRet = VT_Video_EnCodeData(&tPpuOutBuf.pDataBuf, pFrameBuf, uiBufLen);
    #endif
    
    if(iRet < 0)
    {
        zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &tPpuOutBuf);
        zMspCom_Print();

        return iRet;
    }

    #ifdef VT_USE_VIDEOFRAMEBUFFER

    /* »Ч֡ݳȼȡλ */
    g_tVTVideoRFrameBuf.uiUsedLen = iRet;
    g_tVTVideoRFrameBuf.pCurPos   = g_tVTVideoRFrameBuf.pFrameBuffer;
    
    /* ϴ */
    if(g_tVTVideoRFrameBuf.uiUsedLen > 0)
    {
        /* ݳûݳ */
        if(g_tVTVideoRFrameBuf.uiUsedLen > uiBufLen)
        {
            zOss_Memcpy(pFrameBuf, g_tVTVideoRFrameBuf.pCurPos, uiBufLen);
            g_tVTVideoRFrameBuf.uiUsedLen = g_tVTVideoRFrameBuf.uiUsedLen - uiBufLen;
            g_tVTVideoRFrameBuf.pCurPos   = g_tVTVideoRFrameBuf.pCurPos +  uiBufLen;
            
            /* ûݳ */
            iRet                          = uiBufLen;            
        }
        else
        {
            zOss_Memcpy(pFrameBuf, g_tVTVideoRFrameBuf.pCurPos, g_tVTVideoRFrameBuf.uiUsedLen);
            /* ûݳ */
            iRet                          = g_tVTVideoRFrameBuf.uiUsedLen;            
            g_tVTVideoRFrameBuf.uiUsedLen = 0;
            g_tVTVideoRFrameBuf.pCurPos   = g_tVTVideoRFrameBuf.pFrameBuffer;                      
        }
    }    
    #endif

    /* Ƶıͼ */
    VT_VideoUpdateLocalImage(&(tPpuOutBuf.pDataBuf), 
                             tPpuInfo.outputInfo.uiWidth, 
                             tPpuInfo.outputInfo.uiHeight,
                             &(tPpuOutBuf.bufSize.YuvBufSize));
    
    #ifdef __ZMSP_DEBUG__
    ++g_tVTVdConParam.uiReadCount;
    #endif

    return iRet;
}

/**
 * ƣ VT_Video_Write 
 *  VTƵ
 * ˵ (IN) pFrameBuf Ƶͼݵַ
 *            (IN) uiBufLen  Ƶͼݳ
 *   ֵ ɹֽʧܷС0ֵ
 * ˵ 
 */
SINT32 VT_Video_Write(CHAR *pFrameBuf, UINT32 uiBufLen)
{
    CHAR                 *pTmpFrameBuf  = NULL;
    CHAR                 *pNewFrameAdd  = NULL;
    UINT32                uiNewBufLen   = 0;
    UINT32                uiTmpBufLen   = 0;
    SINT32                iRet          = -1;
    SINT32                iSaveRet      = -1;
    T_ZDrvVideo_DecCfg   *pDecCfg       = NULL;    
    T_ZDrvVideo_BufInfo   tDecOutBuf;
    
    if(g_tCurState.eVideoState != VT_VIDEO_STATE_WORKING)
    {
        zMspCom_Print();
        
        return VT_OP_ERROR;
    }

    if(NULL == pFrameBuf || 0 == uiBufLen)
    {
        zMspCom_Print();
        
        return VT_OP_PARAM_ERR;
    }

    #ifdef VT_USE_VIDEOFRAMEBUFFER
    iSaveRet = VT_Video_SaveFrame(pFrameBuf, uiBufLen, &pNewFrameAdd, &uiNewBufLen);  
    if(iSaveRet != VT_OP_GO_DECODE
       && iSaveRet != VT_OP_SUCCESS
       && iSaveRet != VT_OP_ALREADY_FRAME)
    {
        zMspCom_Print();
        
        return iSaveRet;
    }
    else if(VT_OP_SUCCESS == iSaveRet)
    {
        return uiBufLen;
    }    
    #endif

    /* Ƶ֡ģʽ */
    #ifdef VT_USE_VIDEOFRAMEBUFFER
    pTmpFrameBuf = g_tVTVideoWFrameBuf.pFrameBuffer;
    uiTmpBufLen  = g_tVTVideoWFrameBuf.uiUsedLen;   
    #else
    pTmpFrameBuf = pFrameBuf;
    uiTmpBufLen  = uiBufLen;
    #endif
    
    /* һ򿪽 */
    if(!(g_tVTVdConParam.bDecOpen))
    {        
        g_tVTVdConParam.pDecHandle = VT_Video_OpenDecoder(g_tVTVdConParam.tVideoParam.tDecParam.tVideoFormat, 
                                                          pTmpFrameBuf, 
                                                          uiTmpBufLen);
        if(NULL == g_tVTVdConParam.pDecHandle)
        {
            zMspCom_Print();

            return VT_OP_ERROR;
        }

        /* VideoѴ */
        g_tVTVdConParam.bDecOpen   = TRUE;

        /* ĬϵYUVֵ(ظ) */
        pDecCfg = (T_ZDrvVideo_DecCfg *)g_tVTVdConParam.pDecHandle;        
        g_tVTVdConParam.tDecOutSize.ySize = (pDecCfg->tOutput.uiWidth) * (pDecCfg->tOutput.uiHeight);
        g_tVTVdConParam.tDecOutSize.uSize = (pDecCfg->tOutput.uiWidth) * (pDecCfg->tOutput.uiHeight) / 4;
        g_tVTVdConParam.tDecOutSize.vSize = (pDecCfg->tOutput.uiWidth) * (pDecCfg->tOutput.uiHeight) / 4;
    }

    /* ռ */
    tDecOutBuf.bufType                  = YUV_TYPE;
    tDecOutBuf.bufSize.YuvBufSize.ySize = g_tVTVdConParam.tDecOutSize.ySize;
    tDecOutBuf.bufSize.YuvBufSize.uSize = g_tVTVdConParam.tDecOutSize.uSize;
    tDecOutBuf.bufSize.YuvBufSize.vSize = g_tVTVdConParam.tDecOutSize.vSize;
    iRet = zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &tDecOutBuf);
    if(iRet != DRV_SUCCESS)
    {
        zMspCom_Print();
        
        return VT_OP_BUFFER_ERR;
    }

    /* һ֡ͼ */
    iRet = VT_Video_DecodeData(&tDecOutBuf.pDataBuf, pTmpFrameBuf, uiTmpBufLen);
    if(iRet < 0)
    {
        /* ͷŽBuffer */
        zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &tDecOutBuf);        

        /* Ƶݿ뻺 */
        VT_VideoRefreshFrame(iSaveRet, pFrameBuf, uiBufLen, pNewFrameAdd, uiNewBufLen);        
        zMspCom_Print();

        #ifdef __ZMSP_DEBUG__
        ++g_tVTVdConParam.uiWErrCount;
        #endif

        return VT_OP_DECODE_ERR;
    }

    /* ƵĶԶͼ */
    pDecCfg = (T_ZDrvVideo_DecCfg *)g_tVTVdConParam.pDecHandle; 
    VT_VideoUpdateRemoteImage(&(tDecOutBuf.pDataBuf), 
                              pDecCfg->tOutput.uiWidth, 
                              pDecCfg->tOutput.uiHeight,
                              &(tDecOutBuf.bufSize.YuvBufSize));

    #ifdef __ZMSP_DEBUG__
    ++g_tVTVdConParam.uiWriteCount;
    #endif

    #ifdef VT_USE_VIDEOFRAMEBUFFER
    iRet = VT_VideoRefreshFrame(iSaveRet, pFrameBuf, uiBufLen, pNewFrameAdd, uiNewBufLen);
    #endif    

    return iRet;
}

/**
 * ƣ VT_VideoRefreshFrame 
 *  »еƵ
 * ˵ (IN) iSaveRet      ֡ĸģʽ
 *            (IN) pFrameBuf     
 *            (IN) uiBufLen      ݳ
 *            (IN) pNewFrameAdd  ֡
 *            (IN) uiNewBufLen   pNewFrameAddĳ
 *   ֵ ˽ӿVT_Video_SaveFrameӿʹ
 * ˵ ˽ӿΪڻģʽǽûȫд뻺(
 *            ԭڵΪһ֡)ȻǷ񻺳
 *            µһ֡µһ֡룬Ȼ󽫻
 *            µ
 */
static SINT32 VT_VideoRefreshFrame(SINT32  iSaveRet,     
                                   CHAR   *pFrameBuf,    UINT32 uiBufLen,
                                   CHAR   *pNewFrameAdd, UINT32 uiNewBufLen)
{
    SINT32 iRet = -1;
    
    if(iSaveRet != VT_OP_ALREADY_FRAME)
    {
        g_tVTVideoWFrameBuf.pCurPos   = g_tVTVideoWFrameBuf.pFrameBuffer;
        g_tVTVideoWFrameBuf.uiUsedLen = 0;
        iRet = VT_Video_SaveFrame(pFrameBuf, uiBufLen, NULL, NULL);
        if(iRet != VT_OP_SUCCESS)
        {
            zMspCom_Print();
            
            return iRet;
        }
    }
    else
    {
        /* ֱӿʹڴ潻п */
        if(pNewFrameAdd - g_tVTVideoWFrameBuf.pFrameBuffer > (SINT32)uiNewBufLen)
        {
            zOss_Memcpy(g_tVTVideoWFrameBuf.pFrameBuffer, pNewFrameAdd, uiNewBufLen);
        }
        else
        {
            VOID *pTempMem = NULL;

            pTempMem = zOss_Malloc(uiNewBufLen);
            if(NULL == pTempMem)
            {
                zMspCom_Print();
                return VT_OP_MEM_ERR;
            }
            zOss_Memcpy(pTempMem, pNewFrameAdd, uiNewBufLen);
            zOss_Memcpy(g_tVTVideoWFrameBuf.pFrameBuffer, pTempMem, uiNewBufLen);
            zOss_Free(pTempMem);

        }

        g_tVTVideoWFrameBuf.pCurPos   = g_tVTVideoWFrameBuf.pFrameBuffer + uiNewBufLen;
        g_tVTVideoWFrameBuf.uiUsedLen = uiNewBufLen;
        g_tVTVideoWFrameBuf.pCheckPos = g_tVTVideoWFrameBuf.pFrameBuffer + 3;     /* H263֡ͷ */
    }
    
    /* 볤 */
    iRet = uiBufLen;

    return iRet;
}



/**
 * ƣ VT_Video_SetDisplayParam 
 *  VTƵʾ
 * ˵ (IN) pDisplayParam VTƵԶͼʾ
 *   ֵ ɹDCAMERA_OP_SUCCESS
 * ˵ ӿڱVT_Video_Init
 */
DCAMERA_RETURN_VALUE_E VT_Video_SetDisplayParam(VT_VIDEO_DISPARAM_T *pDisplayParam)
{
    SINT32  iRet   = -1;
    RECT_T *pLRect = NULL;
    RECT_T *pRRect = NULL;
    
    if(g_tCurState.eVideoState != VT_VIDEO_STATE_WORKING)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    if(NULL == pDisplayParam)
    {
        zMspCom_Print();

        return DCAMERA_OP_ERROR;
    }
    
    pLRect = &(pDisplayParam->tLocalRect);
    pRRect = &(pDisplayParam->tRemoteRect);
    
    /* ʾЧԼ */
    if(pLRect->sx + pLRect->width > g_uiScreenWidth
       || pLRect->sy + pLRect->height > g_uiScreenHeight)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }  
    if(pRRect->sx + pRRect->width > g_uiScreenWidth
       || pRRect->sy + pRRect->height > g_uiScreenHeight)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }
    
    /* ʾ */
    if(pLRect->width != 0
       && pLRect->height != 0)
    {
        iRet = zMspCom_VideoPlayRectModify(&(g_tVTVdConParam.tLocalRect), 
                                           pLRect, 
                                           g_tVTVdConParam.tVideoParam.tEncParam.uiWidth, 
                                           g_tVTVdConParam.tVideoParam.tEncParam.uiHeight);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            zMspCom_Print();
            
            return DCAMERA_OP_ERROR;
        }
    }
    else
    {
        g_tVTVdConParam.tLocalRect = *pLRect;
    }

    /* Զʾ */
    if(pRRect->width != 0
       && pRRect->height != 0)
    {    
        iRet = zMspCom_VideoPlayRectModify(&(g_tVTVdConParam.tRemoteRect), 
                                           pRRect, 
                                           g_tVTVdConParam.tVideoParam.tDecParam.uiWidth, 
                                           g_tVTVdConParam.tVideoParam.tDecParam.uiHeight);

        if(iRet != MSP_COM_OP_SUCCESS)
        {
            zMspCom_Print();
            
            return DCAMERA_OP_ERROR;
        }
    }
    else
    {
        g_tVTVdConParam.tRemoteRect = *pRRect;
    }

    /* ֪ͨƵ߳ʾ */
    iRet = zMspCom_PostMsg(g_tVTVdConParam.pVdProcThread, EV_VT_VIDEOPROC_SETPARAM_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    /* ͬȴƵ̲߳ */
    zOss_GetSemaphore(g_tVTVdConParam.pVTControlSem, ZOSS_WAIT_FOREVER);

    /* Ƶ̴߳Ƿ */
    if(g_ErrorCode != VT_OP_SUCCESS)
    {
        /* λ־ */
        g_ErrorCode = VT_OP_SUCCESS;
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;    
}

/**************************************************************************
 *                      ֲʵ                                      *
 **************************************************************************/
/**
 * ƣ VT_Video_InitFrameBuf 
 *  ӵ绰Ƶʼ
 * ˵ (IN) 
 *   ֵ ɹVT_OP_SUCCESS
 * ˵ 
 */
static SINT32 VT_Video_InitFrameBuf(VOID)
{
    /* Ƶ֡ */
    zOss_Memset(&g_tVTVideoRFrameBuf, 0, sizeof(T_VT_VideoFrameBuf));
    g_tVTVideoRFrameBuf.pFrameBuffer = zOss_Malloc(VT_VIDEO_FRAMEBUFLEN);
    if(NULL == g_tVTVideoRFrameBuf.pFrameBuffer)
    {
        return VT_OP_ERROR;
    }

    g_tVTVideoRFrameBuf.pCurPos   = g_tVTVideoRFrameBuf.pFrameBuffer;
    g_tVTVideoRFrameBuf.uiMaxLen  = VT_VIDEO_FRAMEBUFLEN;
    g_tVTVideoRFrameBuf.uiUsedLen = 0;

    /* Ƶд֡ */
    zOss_Memset(&g_tVTVideoWFrameBuf, 0, sizeof(T_VT_VideoFrameBuf));
    g_tVTVideoWFrameBuf.pFrameBuffer = zOss_Malloc(VT_VIDEO_FRAMEBUFLEN);
    if(NULL == g_tVTVideoWFrameBuf.pFrameBuffer)
    {
        zOss_Free(g_tVTVideoRFrameBuf.pFrameBuffer);
        zOss_Memset(&g_tVTVideoRFrameBuf, 0, sizeof(T_VT_VideoFrameBuf));
        return VT_OP_ERROR;
    }

    g_tVTVideoWFrameBuf.pCurPos   = g_tVTVideoWFrameBuf.pFrameBuffer;
    g_tVTVideoWFrameBuf.uiMaxLen  = VT_VIDEO_FRAMEBUFLEN;
    g_tVTVideoWFrameBuf.uiUsedLen = 0;

    return VT_OP_SUCCESS;
}

/**
 * ƣ VT_Video_UnInitFrameBuf 
 *  ӵ绰Ƶע
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID VT_Video_UnInitFrameBuf(VOID)
{
    /* ͷ */
    if(g_tVTVideoRFrameBuf.pFrameBuffer != NULL)
    {
        zOss_Free(g_tVTVideoRFrameBuf.pFrameBuffer);
    }
    zOss_Memset(&g_tVTVideoRFrameBuf, 0, sizeof(T_VT_VideoFrameBuf));

    /* дͷ */
    if(g_tVTVideoWFrameBuf.pFrameBuffer != NULL)
    {
        zOss_Free(g_tVTVideoWFrameBuf.pFrameBuffer);
    }
    zOss_Memset(&g_tVTVideoWFrameBuf, 0, sizeof(T_VT_VideoFrameBuf));

    return;    
}

/**
 * ƣ VT_Video_SaveFrame 
 *  VTƵģʽд뻺
 * ˵ (IN) pFrameBuf  Ƶͼݵַ
 *            (IN) uiBufLen   Ƶͼݳ
 *            (OUT) pNewFrame ֡ͷλ(˿ռǻڲַ)
 *            (OUT) uiBufLen  µʹλ
 *   ֵ VT_OP_GO_DECODE: һ֡Խк
 *            VT_OP_SUCCESS:   ûµһ֡д뻺
 *            ֵʾɹΪʧ
 * ˵ 
 */
static SINT32 VT_Video_SaveFrame(CHAR *pFrameBuf,  UINT32 uiBufLen,
                                 CHAR **pNewFrame, UINT32 *pBufLen)
{
    UINT8 *pTempPos = NULL;

    /* ˴3H263֡ͷȣС3˵һ֡֡β */
    if(uiBufLen < 3)
    {
        /* ûпռ */
        if(g_tVTVideoWFrameBuf.uiMaxLen - g_tVTVideoWFrameBuf.uiUsedLen < uiBufLen)
        {
            zMspCom_Print();
            
            return VT_OP_MEM_ERR;
        }
        else  /* µһ֡뻺 */
        {
            zOss_Memcpy(g_tVTVideoWFrameBuf.pCurPos, pFrameBuf, uiBufLen);
            g_tVTVideoWFrameBuf.pCurPos   = g_tVTVideoWFrameBuf.pCurPos   + uiBufLen;
            g_tVTVideoWFrameBuf.uiUsedLen = g_tVTVideoWFrameBuf.uiUsedLen + uiBufLen;

            return VT_OP_SUCCESS;
        }        
    }
    
    pTempPos = (UINT8 *)pFrameBuf;

    /*  */
    if(g_tVTVideoWFrameBuf.uiUsedLen > 0)
    {
        /* ǷΪµһ֡ */
        if(pTempPos[0] == 0x00 && pTempPos[1] == 0x00 && (pTempPos[2] >= 0x80) && (pTempPos[2] <= 0x83)) /* H.263 PSC*/
        {
            return VT_OP_GO_DECODE;
        }
        else
        {
            /* ûпռ */
            if(g_tVTVideoWFrameBuf.uiMaxLen - g_tVTVideoWFrameBuf.uiUsedLen < uiBufLen)
            {
                zMspCom_Print();
                
                return VT_OP_MEM_ERR;
            }
            else  /* µһ֡뻺 */
            {
                CHAR   *pHead;
                UINT32  uiHeadOffset;
                
                zOss_Memcpy(g_tVTVideoWFrameBuf.pCurPos, pFrameBuf, uiBufLen);
                g_tVTVideoWFrameBuf.pCurPos   = g_tVTVideoWFrameBuf.pCurPos   + uiBufLen;
                g_tVTVideoWFrameBuf.uiUsedLen = g_tVTVideoWFrameBuf.uiUsedLen + uiBufLen;

                if(NULL == pNewFrame)
                {
                    return VT_OP_SUCCESS;
                }
                
                /* µһ֡󻺳Ƿ֡ */
                VT_Video_CheckFrame(g_tVTVideoWFrameBuf.pCheckPos, 
                                    g_tVTVideoWFrameBuf.uiUsedLen - (g_tVTVideoWFrameBuf.pCheckPos - g_tVTVideoWFrameBuf.pFrameBuffer),
                                    &pHead,
                                    &uiHeadOffset);
                if(NULL == pHead)
                {
                    g_tVTVideoWFrameBuf.pCheckPos = g_tVTVideoWFrameBuf.pCurPos - 2;
                    return VT_OP_SUCCESS;
                }
                else
                {
                    *pNewFrame = pHead;
                    *pBufLen   = g_tVTVideoWFrameBuf.uiUsedLen - (pHead - g_tVTVideoWFrameBuf.pFrameBuffer);

                    g_tVTVideoWFrameBuf.uiUsedLen = pHead - g_tVTVideoWFrameBuf.pFrameBuffer;
                    
                    return VT_OP_ALREADY_FRAME;
                }
            }            
        }        
    }
    else  /* ûֱӴ뻺 */
    {
        /* ǷΪµһ֡Һ֡ͷ */
        if(pTempPos[0] == 0x00 && pTempPos[1] == 0x00 && (pTempPos[2] >= 0x80) && (pTempPos[2] <= 0x83)) /* H.263 PSC*/
        {
            /* ռ䲻 */
            if(g_tVTVideoWFrameBuf.uiMaxLen < uiBufLen)
            {
                zMspCom_Print();
                
                return VT_OP_MEM_ERR;
            }
            zOss_Memcpy(g_tVTVideoWFrameBuf.pCurPos, pFrameBuf, uiBufLen);
            g_tVTVideoWFrameBuf.pCurPos   = g_tVTVideoWFrameBuf.pCurPos  + uiBufLen;
            g_tVTVideoWFrameBuf.uiUsedLen = g_tVTVideoWFrameBuf.uiUsedLen + uiBufLen;
            g_tVTVideoWFrameBuf.pCheckPos = g_tVTVideoWFrameBuf.pFrameBuffer + 3;     /* H263֡ͷ */
        }
        else
        {
            zMspCom_Print();
            
            return VT_OP_PARAM_ERR;
        }        
    }

    return VT_OP_SUCCESS;
}

/**
 * ƣ VT_Video_CheckFrame 
 *  һǷH263MPEG4֡ͷȷ֡ͷλ
 * ˵ (IN)  pFrameBuf Ƶͼݵַ
 *            (IN)  uiBufLen  Ƶͼݳ
 *            (OUT) pHead     H263֡ͷʼλ
 *            (OUT) uiOffset  ֡ͷʼλpFrameBufƫ
 *   ֵ 
 * ˵ 
 */
static VOID VT_Video_CheckFrame(CHAR *pFrameBuf,  UINT32  uiBufLen,
                                CHAR **pHead,     UINT32 *uiOffset)
{
    UINT8  *pTempPos = NULL;
    UINT32  i;

    if(uiBufLen < 3)
    {
        *pHead    = NULL;
        *uiOffset = 0;

        return; 
    }
    
    pTempPos = (UINT8 *)pFrameBuf;

    if(g_tVTVdConParam.tVideoParam.tDecParam.tVideoFormat == VT_VIDEO_H263)
    {
    for(i = 0; i < uiBufLen - 2; i++)
    {
        if(pTempPos[i] == 0x00 && pTempPos[i + 1] == 0x00 && ((pTempPos[i + 2] & 0xFC) == 0x80)) /* H.263 PSC*/
        {
            *pHead    = pFrameBuf + i;
            *uiOffset = i;
            return;
        }
    }
    }
    else if(g_tVTVdConParam.tVideoParam.tDecParam.tVideoFormat == VT_VIDEO_MP4)
    {
        for(i = 0; i < uiBufLen -3; i++)
        {
            if(pTempPos[i] == 0x00 && pTempPos[i + 1] == 0x00 && pTempPos[i + 2] == 0x01
		  && (pTempPos[i + 3] == 0xB0 || pTempPos[i + 3] == 0xB3 || pTempPos[i + 3] == 0xB5))/* MPEG4 PSC */
            {
                *pHead    = pFrameBuf + i;
                *uiOffset = i;
                return;
            }
        }
    }

    *pHead    = NULL;
    *uiOffset = 0;

    return; 
}

/**
 * ƣ VT_VoiceConvertParam 
 *  ӵ绰ת
 * ˵ (OUT) pAmrInfo     ַ(ĿĲ)
 *            (IN)  pVoiceParam  ӵ绰ַ(Դ)
 *   ֵ ɹVT_OP_SUCCESS
 * ˵ 
 */
static VOID VT_VoiceConvertParam(T_ZDrvVoice_AmrInfo *pAmrInfo, VT_VOICE_PARAM_T *pVoiceParam)
{
    if(NULL == pAmrInfo || NULL == pVoiceParam)
    {
        return;
    }
    
    /* ƥת */
    switch(pVoiceParam->tVoiceInfo.amrif)
    {
        case VT_VOICE_AMR_IF2:
        {
            pAmrInfo->amrif = VOICE_AMR_IF2;
            break;
        }

        case VT_VOICE_AMR_IF1:
        {
            pAmrInfo->amrif = VOICE_AMR_IF1;
            break;
        }

        default:
        {
            pAmrInfo->amrif = VOICE_AMR_IF2;
            break;
        }
    }
    switch(pVoiceParam->tVoiceInfo.frametype)
    {
        case VT_VOICE_FRAME_MR475:
        {
            pAmrInfo->frametype = VOICE_FRAME_MR475;
            break;
        }
        case VT_VOICE_FRAME_MR515:
        {
            pAmrInfo->frametype = VOICE_FRAME_MR515;
            break;
        }
        case VT_VOICE_FRAME_MR59:
        {
            pAmrInfo->frametype = VOICE_FRAME_MR59;
            break;
        }
        case VT_VOICE_FRAME_MR67:
        {
            pAmrInfo->frametype = VOICE_FRAME_MR67;
            break;
        }
        case VT_VOICE_FRAME_MR74:
        {
            pAmrInfo->frametype = VOICE_FRAME_MR74;
            break;
        }
        case VT_VOICE_FRAME_MR795:
        {
            pAmrInfo->frametype = VOICE_FRAME_MR795;
            break;
        }
        case VT_VOICE_FRAME_MR102:
        {
            pAmrInfo->frametype = VOICE_FRAME_MR102;
            break;
        }
        case VT_VOICE_FRAME_MR122:
        {
            pAmrInfo->frametype = VOICE_FRAME_MR122;
            break;
        }        
        default:
        {
            pAmrInfo->frametype = VOICE_FRAME_MR122;
            break;
        }
    }

    return;    
}

/**
 * ƣ VT_VideoCreateSemAndMutexs 
 *  VTƵ߳ź뻥
 * ˵ (IN) 
 *   ֵ ɹVT_OP_SUCCESS
 * ˵ 
 */
static SINT32 VT_VideoCreateSemAndMutexs(VOID)
{
    /* Ƶͬź */
    g_tVTVdConParam.pVTControlSem = zOss_CreateSemaphore(VT_VDPROC_SEM, 0);
    if(ZOSS_NULL == g_tVTVdConParam.pVTControlSem)
    {
        return VT_OP_ERROR;
    }

    /* Ƶ */
    g_tVTVdConParam.pVTLocalMutex = zOss_CreateMutex(VT_VDLOCAL_MUTEX, ZOSS_NO_INHERIT);
    if(ZOSS_NULL == g_tVTVdConParam.pVTLocalMutex)
    {
        zOss_DeleteSemaphore(g_tVTVdConParam.pVTControlSem);
        g_tVTVdConParam.pVTControlSem = NULL;
        
        return VT_OP_ERROR;
    }

    /* ԶƵ */
    g_tVTVdConParam.pVTRemoteMutex = zOss_CreateMutex(VT_VDREMOTE_MUTEX, ZOSS_NO_INHERIT);
    if(ZOSS_NULL == g_tVTVdConParam.pVTRemoteMutex)
    {
        zOss_DeleteMutex(g_tVTVdConParam.pVTLocalMutex);
        zOss_DeleteSemaphore(g_tVTVdConParam.pVTControlSem);

        g_tVTVdConParam.pVTLocalMutex = NULL;
        g_tVTVdConParam.pVTControlSem = NULL;
        
        return VT_OP_ERROR;
    }

    return VT_OP_SUCCESS;
}

/**
 * ƣ VT_VideoDestroySemAndMutexs 
 *  VTƵ߳ź뻥
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID VT_VideoDestroySemAndMutexs(VOID)
{
    if(g_tVTVdConParam.pVTRemoteMutex != NULL)
    {
        zOss_DeleteMutex(g_tVTVdConParam.pVTRemoteMutex);
    }
    if(g_tVTVdConParam.pVTLocalMutex != NULL)
    {
        zOss_DeleteMutex(g_tVTVdConParam.pVTLocalMutex);
    }
    if(g_tVTVdConParam.pVTControlSem != NULL)
    {
        zOss_DeleteSemaphore(g_tVTVdConParam.pVTControlSem);
    }

    g_tVTVdConParam.pVTRemoteMutex = NULL;
    g_tVTVdConParam.pVTLocalMutex  = NULL;
    g_tVTVdConParam.pVTControlSem  = NULL;

    return;
}

/**
 * ƣ VT_VideoGetFps 
 *  ȡVTҵеƵ֡
 * ˵ (IN)  tCamFps  Ƶ֡
 *            (OUT) pFrames  Ƶ֡
 *   ֵ 
 * ˵ 
 */
static VOID VT_VideoGetFps(T_ZDrv_CamFps tCamFps, UINT32 *pFrames)
{
    if(NULL == pFrames)
    {
        return;
    }
    
    switch(tCamFps)
    {
        case Fps15:
        {
            *pFrames = 15;
            break;
        }

        case Fps25:
        {
            *pFrames = 25;
            break;
        }   

        default:
        {
            *pFrames = 15;
            break;
        }
    }

    return;
}

/**
 * ƣ VT_VideoDestroySemAndMutexs 
 *  VTƵ߳ź뻥
 * ˵ (IN) 
 *   ֵ ɹVT_OP_SUCCESS
 * ˵ 
 */
static SINT32 VT_VideoOpenDev(VOID)
{
    SINT32            iRet      = -1;
    SINT32            iDevFd    = -1;
    UINT32            uiFrames  = 15;
    T_MSP_CAM_SENSOR  tSensorId = VT_DEFAULT_SENSOR;
    
    /* ͷ */
    iDevFd = zMspCom_CamOpen(tSensorId);
    if(iDevFd < 0)
    {
        zMspCom_Print();
        
        return VT_OP_DEVICE_ERR;
    }      

    g_tVTVdConParam.uiCamraFd = (UINT32)iDevFd;

    /* video豸 */
    iDevFd = zMspCom_VideoOpen();
    if (iDevFd < 0)
    {
        zMspCom_CamClose();  
        g_tVTVdConParam.uiCamraFd = 0;
        
        zMspCom_Print();
        
        return VT_OP_DEVICE_ERR; 
    }
    g_tVTVdConParam.uiVideoFd = (UINT32)iDevFd;

    /* ʼOSD */
    VT_VideoGetFps(VT_DEFAULT_FPS, &uiFrames);
    iRet = Zte_OsdInit(g_tVTVdConParam.uiVideoFd, uiFrames);
    if (iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_VideoClose();   
        zMspCom_CamClose(); 
        g_tVTVdConParam.uiVideoFd = 0;
        g_tVTVdConParam.uiCamraFd = 0;
        
        zMspCom_Print();
        
        return VT_OP_DEVICE_ERR;
    }
    
    zMspOsd_SetUseDefTransColor(TRUE);

    return VT_OP_SUCCESS;
}

/**
 * ƣ VT_VideoCloseDev 
 *  رVTƵ߳򿪵豸
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID VT_VideoCloseDev(VOID)
{
    /* OSDͷ */
    Zte_OsdUnInit();

    /* رVideo豸 */
    zMspCom_VideoClose();   
    g_tVTVdConParam.uiVideoFd = 0;

    /* رͷ豸 */
    zMspCom_CamClose(); 
    g_tVTVdConParam.uiCamraFd = 0;

    return;    
}

/**
 * ƣ VT_CheckVideoInitParam 
 *  VTƵʼ
 * ˵ (IN) pCodecParam Ƶͨʼ
 *   ֵ ɹVT_OP_SUCCESS
 * ˵ 
 */
static SINT32 VT_CheckVideoInitParam(VT_VIDEO_PARAM_T  *pCodecParam)
{
    RECT_T  *pLRect = NULL;
    RECT_T  *pRRect = NULL;

    if(NULL == pCodecParam)
    {
        return VT_OP_PARAM_ERR;
    }

    #if 0
    /* Ŀǰ֧H263ı */
    if(pCodecParam->tEncParam.tVideoFormat != VT_VIDEO_H263
       || pCodecParam->tDecParam.tVideoFormat != VT_VIDEO_H263)
    {
        return VT_OP_PARAM_ERR;
    }
    #endif
    
    /* Ƶ֧QCIFʽ */
    if(pCodecParam->tEncParam.uiWidth != VT_DFT_ENC_WIDTH
       || pCodecParam->tEncParam.uiHeight != VT_DFT_ENC_HEIGHT)
    {
        return VT_OP_PARAM_ERR;
    }

    /* ȡԶͼʾ */
    pLRect = &(pCodecParam->tDisParam.tLocalRect);
    pRRect = &(pCodecParam->tDisParam.tRemoteRect);
    
    /* ʾЧԼ */
    if(pLRect->sx + pLRect->width > g_uiScreenWidth
       || pLRect->sy + pLRect->height > g_uiScreenHeight)
    {
        return VT_OP_PARAM_ERR;
    }  
    if(pRRect->sx + pRRect->width > g_uiScreenWidth
       || pRRect->sy + pRRect->height > g_uiScreenHeight)
    {
        return VT_OP_PARAM_ERR;
    } 

    return VT_OP_SUCCESS;
}

/**
 * ƣ VT_VideoInitDev 
 *  ʼƵ豸
 * ˵ (IN) 
 *   ֵ ɹVT_OP_SUCCESS
 * ˵ 
 */
static SINT32 VT_VideoInitDev(VOID)
{
    SINT32               iRet           = -1;
    /* T_ZDrv_CamFps     tCamFps        = VT_DEFAULT_FPS; */
    T_ZDrv_CamOutputSize tCamOutputSize = VT_DEFAULT_IMGSIZE;

    /* ͼС */
    iRet = zDrv_Ioctl(g_tVTVdConParam.uiCamraFd, IOCTL_CAM_SENSOR_OUTSIZE, &tCamOutputSize);
    if (iRet != DRV_SUCCESS)
    {
        zMspCom_Print();
        
        return VT_OP_DEVICE_ERR;
    }

    #if 0
    /* òɼͼ֡ */
    iRet = zDrv_Ioctl(g_tVTVdConParam.uiCamraFd, IOCTL_CAM_SENSOR_FRAMERATE, &tCamFps);
    if (iRet != DRV_SUCCESS)
    {
        zMspCom_Print();
        
        return VT_OP_DEVICE_ERR;
    }
    #endif

    /* ʼɼ */
    iRet = zDrv_Ioctl(g_tVTVdConParam.uiCamraFd, IOCTL_CAM_START, NULL);
    if (iRet != DRV_SUCCESS)
	{
        zMspCom_Print();
        
	    return VT_OP_DEVICE_ERR;
	}
    
    return VT_OP_SUCCESS;
}

/**
 * ƣ VT_VideoReleaseDev 
 *  ʼƵ豸
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID VT_VideoReleaseDev(VOID)
{
    /* ֹͣ */
    if(g_tVTVdConParam.pEncHandle != NULL)
    {
        VT_Video_CloseEncoder(g_tVTVdConParam.pEncHandle);
        
        g_tVTVdConParam.pEncHandle = NULL;
        g_tVTVdConParam.bEncOpen   = FALSE;
    }
    
    /* ֹͣ */
    if(g_tVTVdConParam.pDecHandle != NULL)
    {
        VT_Video_CloseDecoder(g_tVTVdConParam.pDecHandle);
        
        g_tVTVdConParam.pDecHandle = NULL;
        g_tVTVdConParam.bDecOpen   = FALSE;
    }    

    /* ֹͣݲɼ */
    zDrv_Ioctl(g_tVTVdConParam.uiCamraFd, IOCTL_CAM_STOP, NULL);

    return;
}

/**
 * ƣ VT_VideoDisplayInit 
 *  ʼƵӴԴ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID VT_VideoDisplayInit(VOID)
{
    /* ±ͼȫϢ */
    g_tVTVdDisParam.bLImgNew       = FALSE;
    g_tVTVdDisParam.uiLImgInWidth  = 0;

    /* ¶ԶͼȫϢ */   
    g_tVTVdDisParam.bRImgNew       = FALSE;
    g_tVTVdDisParam.uiRImgInWidth  = 0;
    
    return;
}

/**
 * ƣ VT_VideoDisplayRelease 
 *  ͷVTʼƵӴԴ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID VT_VideoDisplayRelease(VOID)
{
    T_ZDrvVideo_BufInfo  tLBufInfo;
    T_ZDrvVideo_BufInfo  tRBufInfo;

    if(g_tVTVdDisParam.uiLImgInWidth != 0)    
    {
        tLBufInfo.bufType            = YUV_TYPE;
        tLBufInfo.bufSize.YuvBufSize = g_tVTVdDisParam.tLImgYUVSize;
        tLBufInfo.pDataBuf           = g_tVTVdDisParam.tLImgInData;
        
        zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &tLBufInfo);

        g_tVTVdDisParam.uiLImgInWidth = 0;
    }

    if(g_tVTVdDisParam.uiRImgInWidth != 0)    
    {
        tRBufInfo.bufType            = YUV_TYPE;
        tRBufInfo.bufSize.YuvBufSize = g_tVTVdDisParam.tRImgYUVSize;
        tRBufInfo.pDataBuf           = g_tVTVdDisParam.tRImgInData;
       
        zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &tRBufInfo);

        g_tVTVdDisParam.uiRImgInWidth = 0;
    }

    return;
}

/**
 * ƣ VT_VideoUpdateLocalImage 
 *  VTƵи±Ƶ
 * ˵ (IN) pLVideoImage  Ƶͼ
 *            (IN) uiWidth       Ƶͼ
 *            (IN) uiHeight      Ƶͼ߶
 *            (IN) pLYuvSize     ƵYUVС
 *   ֵ 
 * ˵ 
 */
static VOID VT_VideoUpdateLocalImage(T_ZDrv_ImageDataBuf *pLVideoImage, 
                                     UINT32 uiWidth, UINT32 uiHeight,
                                     T_ZDrv_YuvBufSize   *pLYuvSize)
                                     
{
    T_ZDrvVideo_BufInfo tLBufInfo;
    
    zOss_GetMutex(g_tVTVdConParam.pVTLocalMutex, ZOSS_WAIT_FOREVER);

    /* ͷŵϴεıƵͼ */
    if(g_tVTVdDisParam.uiLImgInWidth != 0)    
    {
        tLBufInfo.bufType            = YUV_TYPE;
        tLBufInfo.pDataBuf           = g_tVTVdDisParam.tLImgInData;
        tLBufInfo.bufSize.YuvBufSize = g_tVTVdDisParam.tLImgYUVSize;
        
        zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &tLBufInfo);

        g_tVTVdDisParam.uiLImgInWidth = 0;
    }

    /* ıƵͼϢ */
    g_tVTVdDisParam.tLImgInData    = *pLVideoImage;
    g_tVTVdDisParam.tLImgYUVSize   = *pLYuvSize;    
    g_tVTVdDisParam.uiLImgInWidth  = uiWidth;
    g_tVTVdDisParam.uiLImgInHeight = uiHeight;
    g_tVTVdDisParam.bLImgNew       = TRUE;

    zOss_PutMutex(g_tVTVdConParam.pVTLocalMutex);

    return;
}

/**
 * ƣ VT_VideoUpdateRemoteImage 
 *  VTƵи¶ԶƵ
 * ˵ (IN) pRVideoImage  ԶƵͼ
 *            (IN) uiWidth       ԶƵͼ
 *            (IN) uiHeight      ԶƵͼ߶
 *            (IN) pRYuvSize     ԶƵYUVС
 *   ֵ 
 * ˵ 
 */
static VOID VT_VideoUpdateRemoteImage(T_ZDrv_ImageDataBuf *pRVideoImage, 
                                      UINT32 uiWidth, UINT32 uiHeight,
                                      T_ZDrv_YuvBufSize   *pRYuvSize)
                                     
{
    T_ZDrvVideo_BufInfo tRBufInfo;
    
    zOss_GetMutex(g_tVTVdConParam.pVTRemoteMutex, ZOSS_WAIT_FOREVER);

    /* ͷŵϴεıƵͼ */
    if(g_tVTVdDisParam.uiRImgInWidth != 0)    
    {
        tRBufInfo.bufType            = YUV_TYPE;
        tRBufInfo.pDataBuf           = g_tVTVdDisParam.tRImgInData;
        tRBufInfo.bufSize.YuvBufSize = g_tVTVdDisParam.tRImgYUVSize;
        
        zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &tRBufInfo);

        g_tVTVdDisParam.uiRImgInWidth = 0;
    }

    /* ıƵͼϢ */
    g_tVTVdDisParam.tRImgInData    = *pRVideoImage;
    g_tVTVdDisParam.tRImgYUVSize   = *pRYuvSize;    
    g_tVTVdDisParam.uiRImgInWidth  = uiWidth;
    g_tVTVdDisParam.uiRImgInHeight = uiHeight;
    g_tVTVdDisParam.bRImgNew       = TRUE;

    zOss_PutMutex(g_tVTVdConParam.pVTRemoteMutex);
    
    return;
}

/**
 * ƣ VT_RefreshYUVOffset 
 *  Ƶĺʱƫ
 * ˵ (IN) 
 *   ֵ 
 * ˵ ΪЧʹ
 */
static VOID VT_RefreshYUVOffset(VOID)
{
    UINT32  uiXpos = 0;
    UINT32  uiYpos = 0;

    /* 㱾ƵͼƬYUVƫ */            
    uiXpos = g_tVTVdConParam.tVideoParam.tDisParam.tLocalRect.sx;
    uiYpos = g_tVTVdConParam.tVideoParam.tDisParam.tLocalRect.sy;

    /* עYUVΪPhyAddr *ָͣӷʱ1ڼ4 */
    g_tVTVdConParam.tLocalOffset.uiYOffset = g_uiScreenWidth * uiYpos + uiXpos;
    g_tVTVdConParam.tLocalOffset.uiUOffset = g_uiScreenWidth * uiYpos / 4 + uiXpos / 2;
    g_tVTVdConParam.tLocalOffset.uiVOffset = g_uiScreenWidth * uiYpos / 4 + uiXpos / 2;

    /* ԶƵͼƬYUVƫ */            
    uiXpos = g_tVTVdConParam.tVideoParam.tDisParam.tRemoteRect.sx;
    uiYpos = g_tVTVdConParam.tVideoParam.tDisParam.tRemoteRect.sy;

    /* עYUVΪPhyAddr *ָͣӷʱ1ڼ4 */
    g_tVTVdConParam.tRemoteOffset.uiYOffset = g_uiScreenWidth * uiYpos + uiXpos;
    g_tVTVdConParam.tRemoteOffset.uiUOffset = g_uiScreenWidth * uiYpos / 4 + uiXpos / 2;
    g_tVTVdConParam.tRemoteOffset.uiVOffset = g_uiScreenWidth * uiYpos / 4 + uiXpos / 2;

    return;    
}

/**
 * ƣ VT_Video_OpenEncoder 
 *  Ƶ
 * ˵ (IN) tVideoFormat  
 *            (IN) tPixelFmt     ͼƬظʽ
 *            (IN) uiWidth       ͼƬ
 *            (IN) uiHeight      ͼƬ߶
 *            (IN) uiHeight      ͼƬ
 *   ֵ ɹش򿪵ı
 * ˵ 
 */
static EncHandle VT_Video_OpenEncoder(VT_VIDEO_FORMAT tVideoFormat, T_ZDrv_PixelFmt tPixelFmt,
                                      UINT32 uiWidth, UINT32 uiHeight, UINT32 uiStride)
{
    T_VideoEncInstParam   *pVideoEncHandle = NULL;
    T_VideoEncInitParam    tEncInitParam   = {0};
    T_ZDrvVideo_CodecStandard  tCodecStandard;

    if(VT_VIDEO_H263 == tVideoFormat)
    {
        tCodecStandard = VIDEO_CODEC_STD_H263;
    }
    else if(VT_VIDEO_MP4 == tVideoFormat)
    {
        tCodecStandard = VIDEO_CODEC_STD_MPEG4;
    }
    else
    {
        return NULL;
    }
      
    /* ñ뿪ʼ */
    tEncInitParam.tCodecStd    = tCodecStandard;
    tEncInitParam.tMirror      = MIR_NONE;
    tEncInitParam.tPixelFmt    = tPixelFmt;
    tEncInitParam.tRotate      = ROT_0;
    tEncInitParam.uiBitrate    = g_tVTVdConParam.tVideoParam.tEncParam.uiBitrate;
    tEncInitParam.uiFrameRate  = g_tVTVdConParam.tVideoParam.tEncParam.uiFramerate;
    tEncInitParam.uiHeight     = uiHeight;
    tEncInitParam.uiStride     = uiWidth;
    tEncInitParam.uiVideoFd    = g_tVTVdConParam.uiVideoFd;
    tEncInitParam.uiWidth      = uiWidth;
        
    /* ʼ */
    pVideoEncHandle = zMspCom_OpenVideoEncoder(&tEncInitParam);
    if (NULL == pVideoEncHandle)
    {
        zMspCom_Print();

        return NULL;            
    }

    return (EncHandle)pVideoEncHandle;
}

/**
 * ƣ VT_Video_EnCodeData 
 *  һ֡ͼ
 * ˵ (IN)  pSrcData   Դͼ
 *            (OUT) pFrameBuf  ͼ
 *            (IN)  uiBufLen   pFrameBufĳ
 *   ֵ ɹرͼݳ
 * ˵ 
 */
static SINT32 VT_Video_EnCodeData(T_ZDrv_ImageDataBuf *pSrcData, CHAR *pFrameBuf, UINT32 uiBufLen)
{
    SINT32                iRet;
    T_VideoEncInstParam   *pVideoEncHandle = NULL;
    T_VideoEncParam        tVideoEncParam  = {0};
   
    /* һ֡Ƶͼ */
    pVideoEncHandle               = (T_VideoEncInstParam *)g_tVTVdConParam.pEncHandle;
    tVideoEncParam.bIsBufferValid = TRUE;
    tVideoEncParam.pDataIn        = *pSrcData;
    tVideoEncParam.pDataOut       = (UINT8 *)pFrameBuf;
    tVideoEncParam.uiLenOut       = uiBufLen;
    
    iRet = zMspCom_VideoEncode(pVideoEncHandle, &tVideoEncParam);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();

        return VT_OP_ENCCODE_ERR;
    }

    return (SINT32)tVideoEncParam.uiLenOut;    
}

/**
 * ƣ VT_Video_CloseEncoder 
 *  رձ
 * ˵ (IN)  pEncHandle   
 *   ֵ 
 * ˵ 
 */
static VOID VT_Video_CloseEncoder(EncHandle pEncHandle)
{
    T_VideoEncInstParam   *pVideoEncHandle = NULL;
    if(NULL == pEncHandle)
    {
        zMspCom_Print();
        
        return;
    }
    
    pVideoEncHandle = (T_VideoEncInstParam *)pEncHandle;
    zMspCom_CloseVideoEncoder(pVideoEncHandle);

    return;
}

/**
 * ƣ VT_Video_OpenDecoder 
 *  VTƵ
 * ˵ (IN) tVideoFormat  ʽ
 *            (IN) pFrameBuf     ͼ
 *            (IN) uiBufLen      pFrameBufĳ
 *   ֵ 򿪳ɹؽʧܷNULL
 * ˵ 
 */
static DecHandle VT_Video_OpenDecoder(VT_VIDEO_FORMAT tVideoFormat, CHAR *pFrameBuf, UINT32 uiBufLen)
{
    SINT32                      iRet;
    T_ZDrvVideo_DecCfg         *pDecCfg;    
    T_ZDrvVideo_BufInfo         tDecInBuf;
    T_ZDrvVideo_CodecStandard   tCodecStandard;

    if(VT_VIDEO_H263 == tVideoFormat)
    {
        tCodecStandard = VIDEO_CODEC_STD_H263;
    }
    else if(VT_VIDEO_MP4 == tVideoFormat)
    {
        tCodecStandard = VIDEO_CODEC_STD_MPEG4;
    }
    else
    {
        zMspCom_Print();

        return NULL;
    }

    if(NULL == pFrameBuf)
    {
        zMspCom_Print();

        return NULL;
    }

    /* Buffer */
    tDecInBuf.bufType                = STREAM_TYPE;
    tDecInBuf.bufSize.streamBufSize  = uiBufLen;
    tDecInBuf.pDataBuf.streamDataBuf = NULL;
    iRet = zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &tDecInBuf);
    if(iRet != DRV_SUCCESS || NULL == tDecInBuf.pDataBuf.streamDataBuf)
    {
        zMspCom_Print();
        
        return NULL;
    }    
    
    /* ƵݿBuffer */
    zOss_Memcpy(tDecInBuf.pDataBuf.streamDataBuf, pFrameBuf, uiBufLen);
    
    pDecCfg = (T_ZDrvVideo_DecCfg *)zOss_Malloc(sizeof(T_ZDrvVideo_DecCfg));
    if(NULL == pDecCfg)
    {
        zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &tDecInBuf);
        zMspCom_Print();
        
        return NULL;
    }
    zOss_Memset(pDecCfg, 0, sizeof(T_ZDrvVideo_DecCfg));

    /* ý */
    pDecCfg->tInput.tCodecStd   = tCodecStandard;
    pDecCfg->tInput.pEncHeader  = tDecInBuf.pDataBuf.streamDataBuf;
    pDecCfg->tInput.headerLenth = tDecInBuf.bufSize.streamBufSize;
    pDecCfg->tRotate            = ROT_0;
    pDecCfg->tMirror            = MIR_NONE;
    pDecCfg->tOutput.tPixelFmt  = PIXEL_YCbCr420;

    /* ʼbufferֶͷţͷ */
    iRet = zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_DECSTART, pDecCfg);
    if(iRet != DRV_SUCCESS)
    {
        zOss_Free(pDecCfg); 
        zMspCom_Print();
        
        return NULL;
    }

    pDecCfg->tInput.pEncHeader  = NULL;
    pDecCfg->tInput.headerLenth = 0;   

    return (DecHandle)pDecCfg;
}

/**
 * ƣ VT_Video_DecodeData 
 *  VTƵһ֡
 * ˵ (OUT) pDataOut   
 *            (IN)  pFrameBuf  ͼ
 *            (IN)  uiBufLen   pFrameBufĳ
 *   ֵ ɹѽݳȣ򷵻س
 * ˵ ĿǰֻH263Ľ
 */
static SINT32 VT_Video_DecodeData(T_ZDrv_ImageDataBuf *pDataOut, CHAR *pFrameBuf, UINT32 uiBufLen)
{
    SINT32                iRet;
    UINT32                uiVideoInst;
    T_ZDrvVideo_DecCfg   *pDecCfg;
    T_ZDrvVideo_BufInfo   tDecInBuf;
    T_ZDrvVideo_DecParam  tDecParam; 
    
    /* Buffer */
    tDecInBuf.bufType                = STREAM_TYPE;
    tDecInBuf.bufSize.streamBufSize  = uiBufLen;
    tDecInBuf.pDataBuf.streamDataBuf = NULL;
    iRet = zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &tDecInBuf);
    if(iRet != DRV_SUCCESS || NULL == tDecInBuf.pDataBuf.streamDataBuf)
    {
        zMspCom_Print();
        
        return VT_OP_BUFFER_ERR;
    }    
    
    /* ƵݿBuffer */
    zOss_Memcpy(tDecInBuf.pDataBuf.streamDataBuf, pFrameBuf, uiBufLen);
    
    /* ȡƵ */
    pDecCfg = (T_ZDrvVideo_DecCfg *)g_tVTVdConParam.pDecHandle;
    uiVideoInst = pDecCfg->uiVideoInst;

    /* һ֡Ƶ IOCTL_VIDEO_DECONEFRAMEStride */
    tDecParam.uiVideoInst = uiVideoInst;
    tDecParam.pDataIn     = tDecInBuf.pDataBuf.streamDataBuf;
    tDecParam.uiLenIn     = tDecInBuf.bufSize.streamBufSize;
    tDecParam.hasDecdata  = TRUE;
    tDecParam.uiStride    = pDecCfg->tOutput.uiWidth;
    tDecParam.pDataOut    = *pDataOut;

    /* Bufferڵӿʱͷ */
    iRet = zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_DECONEFRAME, &tDecParam);    
    if(iRet != DRV_SUCCESS)
    {
        zMspCom_Print();
        zOss_Printf(SUBMDL_MMBASE, PRINT_LEVEL_ALLWAYS, "VT_Video Total DecCount = %d", g_tVTVdConParam.uiWriteCount);
        
        return VT_OP_DECODE_ERR;
    }

    /* FIXME: ӦötDecParam.outputtypeжϣH263
     * Լ򵥣˴ûϸǣԺҪд
     */
    {
        
    }

    return (SINT32)uiBufLen;
}

/**
 * ƣ VT_Video_CloseDecoder 
 *  رս
 * ˵ (IN)  pDecHandle   
 *   ֵ 
 * ˵ 
 */
static VOID VT_Video_CloseDecoder(DecHandle pDecHandle)
{
    T_ZDrvVideo_DecCfg *pDecCfg = NULL;
    
    if(NULL == pDecHandle)
    {
        zMspCom_Print();
        
        return;
    }
    
    pDecCfg = (T_ZDrvVideo_DecCfg *)pDecHandle;
    zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_DECSTOP, (VOID *)(&(pDecCfg->uiVideoInst)));
    zOss_Free(pDecCfg);

    return;
}

/**
 * ƣ VT_VideoProcSetParamMsg 
 *  VTƵ̴߳ʾϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID VT_VideoProcSetParamMsg(VOID)
{
    /* ת±Զʾ */
    g_tVTVdConParam.tVideoParam.tDisParam.tLocalRect  = g_tVTVdConParam.tLocalRect;
    g_tVTVdConParam.tVideoParam.tDisParam.tRemoteRect = g_tVTVdConParam.tRemoteRect;

    /* ±ԶͼƬYUVƫ */
    VT_RefreshYUVOffset();
    
    return;
}

/**
 * ƣ VT_VideoProcLRImages 
 *  VTƵ̴߳ԶͼӲ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID VT_VideoProcLRImages(VOID)
{
    SINT32               iRet;
    RECT_T               tVideoRect = {0, 0, 240, 320};
    T_ZDrv_YuvBuf        tTempYuvBuf; 
    T_ZDrvVideo_PpuInfo  tPpuInfo;    
    T_ZDrvVideo_BufInfo  tBKGroundBuf;  /* ȫռ */
    
    /* Զ֮һûи */
    if(!g_tVTVdDisParam.bLImgNew && !g_tVTVdDisParam.bRImgNew)
    {
        return;
    }

    tVideoRect.height = g_uiScreenHeight;
    tVideoRect.width  = g_uiScreenWidth;
   
    /* һȫͼƬ */
    tBKGroundBuf.bufType                  = YUV_TYPE;
    tBKGroundBuf.bufSize.YuvBufSize.ySize = g_uiDefaultYSize;
    tBKGroundBuf.bufSize.YuvBufSize.uSize = g_uiDefaultUSize;
    tBKGroundBuf.bufSize.YuvBufSize.vSize = g_uiDefaultVSize;

    iRet = zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &tBKGroundBuf);
    if(iRet < 0)
    {   
        zMspCom_Print();
        
        return;
    }          

    /* ɫ */
    zOss_Memset((VOID *)tBKGroundBuf.pDataBuf.YuvBuf.Y,  0,   tBKGroundBuf.bufSize.YuvBufSize.ySize);
    zOss_Memset((VOID *)tBKGroundBuf.pDataBuf.YuvBuf.Cb, 128, tBKGroundBuf.bufSize.YuvBufSize.uSize);
    zOss_Memset((VOID *)tBKGroundBuf.pDataBuf.YuvBuf.Cr, 128, tBKGroundBuf.bufSize.YuvBufSize.vSize);

    /* ppuͼƬϢ */
    tPpuInfo.outputInfo.uiStride  = g_uiScreenWidth;   /*  */
    tPpuInfo.outputInfo.tPixelFmt = PIXEL_YCbCr420; /* YUV420 */

    /* ͼƬɫ */
    zOss_GetMutex(g_tVTVdConParam.pVTLocalMutex, ZOSS_WAIT_FOREVER);

    /* ͼƬЧұԤ */
    if(g_tVTVdDisParam.uiLImgInWidth != 0 && !(g_tVTVdDisParam.bLocalHide))
    {
        /* ͼʾΪ0ʾ */
        if(g_tVTVdConParam.tVideoParam.tDisParam.tLocalRect.width != 0
           && g_tVTVdConParam.tVideoParam.tDisParam.tLocalRect.height != 0)
        {
            /* עYUVΪPhyAddr *ָͣӷʱ1ڼ4 */
            tTempYuvBuf.Y  = (PhyAddr *)((UINT32)tBKGroundBuf.pDataBuf.YuvBuf.Y  + g_tVTVdConParam.tLocalOffset.uiYOffset);
            tTempYuvBuf.Cb = (PhyAddr *)((UINT32)tBKGroundBuf.pDataBuf.YuvBuf.Cb + g_tVTVdConParam.tLocalOffset.uiUOffset);
            tTempYuvBuf.Cr = (PhyAddr *)((UINT32)tBKGroundBuf.pDataBuf.YuvBuf.Cr + g_tVTVdConParam.tLocalOffset.uiVOffset);

            tPpuInfo.inputInfo.uiStartX       = 0;
            tPpuInfo.inputInfo.uiStartY       = 0;
            tPpuInfo.inputInfo.uiWidth        = g_tVTVdDisParam.uiLImgInWidth;
            tPpuInfo.inputInfo.uiHeight       = g_tVTVdDisParam.uiLImgInHeight;  
            tPpuInfo.inputInfo.uiStride       = g_tVTVdDisParam.uiLImgInWidth;    
            tPpuInfo.inputInfo.tPixelFmt      = PIXEL_YCbCr420;  
            tPpuInfo.inputInfo.pInPutbuffer   = g_tVTVdDisParam.tLImgInData;
            tPpuInfo.tMirror   = MIR_NONE;
            tPpuInfo.tRotate = ROT_0;

            /* OSDʹ */
            tPpuInfo.osdInfo.bEnable          = FALSE;

            /* ͼƬ߼ڱϵʼַ */
            tPpuInfo.outputInfo.uiWidth              = g_tVTVdConParam.tVideoParam.tDisParam.tLocalRect.width; 
            tPpuInfo.outputInfo.uiHeight             = g_tVTVdConParam.tVideoParam.tDisParam.tLocalRect.height;
            tPpuInfo.outputInfo.pOutPutbuffer.YuvBuf = tTempYuvBuf;
            
            /* ƵƵ */
            iRet = zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_POSTPROCESS, &tPpuInfo);
            if(iRet < 0)
            {
                zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&tBKGroundBuf);
                zMspCom_Print();

                /* Ƴ±Ƶͼ־ */
                g_tVTVdDisParam.bLImgNew = FALSE;

                zOss_PutMutex(g_tVTVdConParam.pVTLocalMutex);

                return;
            }           
        }
    }

    /* Ƴ±Ƶͼ־ */
    g_tVTVdDisParam.bLImgNew = FALSE;
    
    zOss_PutMutex(g_tVTVdConParam.pVTLocalMutex);


    /* ԶͼƬɫ */
    zOss_GetMutex(g_tVTVdConParam.pVTRemoteMutex, ZOSS_WAIT_FOREVER);

    /* ԶͼƬЧ */
    if(g_tVTVdDisParam.uiRImgInWidth != 0)
    {
        /* ԶͼʾΪ0ʾ */
        if(g_tVTVdConParam.tVideoParam.tDisParam.tRemoteRect.width != 0
           && g_tVTVdConParam.tVideoParam.tDisParam.tRemoteRect.height != 0)
        {
            /* עYUVΪPhyAddr *ָͣӷʱ1ڼ4 */
            tTempYuvBuf.Y  = (PhyAddr *)((UINT32)tBKGroundBuf.pDataBuf.YuvBuf.Y  + g_tVTVdConParam.tRemoteOffset.uiYOffset);
            tTempYuvBuf.Cb = (PhyAddr *)((UINT32)tBKGroundBuf.pDataBuf.YuvBuf.Cb + g_tVTVdConParam.tRemoteOffset.uiUOffset);
            tTempYuvBuf.Cr = (PhyAddr *)((UINT32)tBKGroundBuf.pDataBuf.YuvBuf.Cr + g_tVTVdConParam.tRemoteOffset.uiVOffset);

            tPpuInfo.inputInfo.uiStartX       = 0;
            tPpuInfo.inputInfo.uiStartY       = 0;
            tPpuInfo.inputInfo.uiWidth        = g_tVTVdDisParam.uiRImgInWidth;
            tPpuInfo.inputInfo.uiHeight       = g_tVTVdDisParam.uiRImgInHeight;  
            tPpuInfo.inputInfo.uiStride       = g_tVTVdDisParam.uiRImgInWidth;    
            tPpuInfo.inputInfo.tPixelFmt      = PIXEL_YCbCr420;  
            tPpuInfo.inputInfo.pInPutbuffer   = g_tVTVdDisParam.tRImgInData;

            /* OSDʹ */
            tPpuInfo.osdInfo.bEnable          = FALSE;

            /* ͼƬ߼ڱϵʼַ */
            tPpuInfo.outputInfo.uiWidth              = g_tVTVdConParam.tVideoParam.tDisParam.tRemoteRect.width; 
            tPpuInfo.outputInfo.uiHeight             = g_tVTVdConParam.tVideoParam.tDisParam.tRemoteRect.height;
            tPpuInfo.outputInfo.pOutPutbuffer.YuvBuf = tTempYuvBuf;

            /* ƵƵ */
            iRet = zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_POSTPROCESS, &tPpuInfo);
            if(iRet < 0)
            {
                zDrv_Ioctl(g_tVTVdConParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&tBKGroundBuf);
                zMspCom_Print();

                /* Ƴ¶ԶƵͼ־ */
                g_tVTVdDisParam.bRImgNew = FALSE;

                zOss_PutMutex(g_tVTVdConParam.pVTRemoteMutex);

                return;
            }
        }
    }

    /* Ƴ¶ԶƵͼ־ */
    g_tVTVdDisParam.bRImgNew = FALSE;
    
    zOss_PutMutex(g_tVTVdConParam.pVTRemoteMutex);
    
    /* OSDеƵ */
    Zte_OsdUpdateVideoInput(&(tBKGroundBuf.pDataBuf), FALSE, &tVideoRect);

    return;
}

/**
 * ƣ VT_VideoProcThreadLoop 
 *  VTƵ߳Ϣѭ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID VT_VideoProcThreadLoop(VOID)
{
    BOOL    bQuit  = FALSE;
    UINT32  uiMsg  = 0;
    SINT32  iRet   = -1;
    
    while(1)
    {
        /* Ϣ */
        iRet = zMspCom_RecvMsg(&uiMsg, VT_PROC_IMG_INTER);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            /* ʱƵӲ */
            VT_VideoProcLRImages();
            
            continue;
        }

        switch(uiMsg)
        {
            /* ƵʾϢ */
            case EV_VT_VIDEOPROC_SETPARAM_SYN:
            {
                VT_VideoProcSetParamMsg();

                /* ֪ͨûò */
                zOss_PutSemaphore(g_tVTVdConParam.pVTControlSem);
                
                break;
            }
            
            /* Ƶ߳ͷϢ */
            case EV_VT_VIDEOPROC_QUIT_SYN:
            {
                bQuit = TRUE;                

                break;
            }
            
            default:
            {
                break;
            }
        }

        /* ͷϢԴ */
        uiMsg = 0;

        if(bQuit)
        {
            break;
        }
    }

    /* ܻһЩĴ */    
    return;       
}

/**
 * ƣ VT_VideoProcThreadEntry 
 *  VTƵ߳ں
 * ˵ (IN) iArg ߳ں
 *   ֵ 
 * ˵ 
 */
static VOID VT_VideoProcThreadEntry(SINT32 iArg)
{   
    /* ʼƵʾԴ */
    VT_VideoDisplayInit();
    
    /* Ϣѭ */
    VT_VideoProcThreadLoop();

    /* ͷƵʾԴ */
    VT_VideoDisplayRelease();

    /* ֪ͨƵ߳̽ */
    zOss_PutSemaphore(g_tVTVdConParam.pVTControlSem);
    
    return;    
}

