/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:  This source file contains the external interface related functions of the UICC Handler.
 * Others:
 * Version:       v0.1
 * Author:        mtr
 * Date:          2007-03-28
 * History 1:      
 *     Date: 2011-12-19
 *     Version: 1.1
 *     Author: huangxing
 *     Modification: be compatible with chip 297502.
 * History 2:
  ********************************************************************************/

/****************************************************************************
*                                              Include files
****************************************************************************/
#include "drvs_general.h"
//#include "drvs_cfg.h"/*  for register base addr define  */
#include "drvs_int.h"

#include "uicc_stub.h"

#include "uicc.h"
#include "uicc_ctrl.h"
#include "uicc_access.h"
#include "uicc_trc.h"
#include "uicc_opcodes.h"
#include "uicc_ptest.h"
#include "uicc_msg_trace.h"
#include "uicc_drv.h"
#include "drvs_pcu.h"

#ifdef ENABLE_RUNTIME_SIM_SIMULATION
#include "msap_card_sim.h"
#endif

#ifdef ENABLE_RUNTIME_UICC_SIMULATION
#include "msap_uicc_sim.h"
#endif

#include "USIM_reg.h"
#include "oss_api.h"
#include "pub_debug_info.h"
//#include "os_ose.h"
#include "drvs_pow.h"
#include "drvs_ramlog.h"
//add by sunyunchen
#include "drvs_gpio.h"
#include "drvs_uicc_ref.h"
#include "drvs_uicc.h"
#include "drvs_sys.h"
#include "drvs_comm.h"

#include <linux/clk.h>
#ifndef SOC_USIM
extern void UICC_usim_in_or_out_lisr(void);
#else
 extern void UICC_socUsim_in_or_out_lisr(void);
#endif
extern UINT8 Vsim_Flag;
//end
/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
#ifdef UICC_ENABLE_IN_OUT_DETECTION
#define UICC_BEGIN_EXECUTE UICC_executing = UICC_EXECUTING
#define UICC_END_EXECUTE UICC_executing = UICC_NOT_EXECUTING
#define IO_RETURN(cause_) { UICC_END_EXECUTE; return(cause_); }
#else
#define UICC_BEGIN_EXECUTE
#define UICC_END_EXECUTE
#define IO_RETURN(cause_) return (cause_)
#endif
#ifdef UICC_MONITOR_ICCID
#define NOF_ICCID_BYTES 10
#endif

#define LOWEST_VOLTAGE_ALLOWED   UICC_CLASS_C   /* UICC_CLASS_D, UICC_CLASS_E are RFU */
/****************************************************************************
* 	                                           Local Types
****************************************************************************/
typedef ushort T_UICC_MODULE_TEST_CAUSE;

#ifdef UICC_MONITOR_ICCID
typedef enum {
    ICCID_READY,
    SELECTING_MF,
    SELECTING_ICCID,
    READING_ICCID,
    ICCID_READ
} T_ICCID_MONITOR_STATE;
#endif


/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Variables
****************************************************************************/
ubyte semaphore_created = FALSE;
static ZOSS_THREAD_ID uicc_power_up = NULL;
static ZOSS_THREAD_ID uicc_power_down = NULL;
static BOOL iscalledresetcard = FALSE;

#ifdef UICC_ENABLE_REALTIME_PRINT
static u32 curprintwindex = 0;	
static u32 curprintrindex = 0;	
#endif

//add by sunyunchen
//UINT32 g_testsiminorout = 0;// 1 means out,0 means in

/****************************************************************************
* 	                                           Local Function Prototypes
****************************************************************************/
#if defined(UICC_ENABLE_IN_OUT_DETECTION) 
static VOID UICC_in_out_highisr(SINT32 arg);
#endif

extern VOID UICC_PowerThread(SINT32 arg);

extern ZOSS_SEMAPHORE_ID UICC_power_sem;
T_Ring_Queue *UICC_power_msg_queue = NULL;
ZOSS_THREAD_ID UICC_power_thread = NULL;

#ifdef UICC_ENABLE_REALTIME_PRINT
ZOSS_THREAD_ID UICC_print_thread = NULL;
ZOSS_SEMAPHORE_ID UICC_print_sem = NULL;
#endif

#ifdef SOC_USIM
extern VOID zDrvUICC_ConfigForDetectSocSIM(VOID);
#endif

extern T_UICC_CARD_TYPE card_type_ctrl[3];
/****************************************************************************
* 	                                          Global Constants
****************************************************************************/

/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
#ifdef UICC_DEBUG_INF
UINT8 UICC_debug[200][3];
UINT16 UICC_debug_count;
UINT8 UICC_debug_t0[500][3];
UINT16 UICC_debug_count_t0;
#endif

#ifdef UICC_ENABLE_REALTIME_PRINT
static char uiccPrintfBuf[1024] = {0};
#endif

ZOSS_SEMAPHORE_ID   UICC_common_sem;/*NU_SEMAPHORE UICC_common_sem;*/
ZOSS_SEMAPHORE_ID   UICC_hotplug_sem;

ZOSS_SEMAPHORE_ID   UICC_release_sem_ptr;/*NU_SEMAPHORE *UICC_release_sem_ptr;*/
ZOSS_THREAD_ID      UICC_in_out_threadid = NULL;
ZOSS_SEMAPHORE_ID   UICC_in_out_sem = NULL;


#if (defined(UICC_ENABLE_IN_OUT_DETECTION) || defined(ENABLE_RUNTIME_SIM_SIMULATION) || defined(ENABLE_RUNTIME_UICC_SIMULATION))
/*static Mon_Msg_Def_SI_UICC_CALLBACK_EVENT *p_uicc_callback_event = (Mon_Msg_Def_SI_UICC_CALLBACK_EVENT *)&uicc_tracebuf;*/
;
#endif

#ifdef UICC_ENABLE_IN_OUT_DETECTION
T_UICC_EXECUTING UICC_executing = UICC_NOT_EXECUTING;
ubyte initiate_in_callback  = FALSE;
ubyte initiate_out_callback = FALSE;
#endif

#ifdef UICC_MODULE_TEST
T_UICC_SIMULATED_SIGNAL   UICC_simulated_signal =
    {
        {
            0
        }
        , {0}
    };
T_UICC_SIMULATED_HW_REG   UICC_simulated_hw_reg;
T_UICC_MODULE_TEST_STATE  UICC_module_test_state = UICC_MODULE_TEST_DISABLED;
T_UICC_SIMULATED_FUNCTION  UICC_simulated_function =
    {
        0, 0, 0
    };
ubyte                      UICC_hw_rx_store[UICC_HW_RX_STORE_MAX];
ubyte                      UICC_hw_tx_store[UICC_HW_TX_STORE_MAX];
#endif

#if (defined(ENABLE_RUNTIME_SIM_SIMULATION) || defined(ENABLE_RUNTIME_UICC_SIMULATION))
uicc_simul_state_type  UICC_simul_state = uicc_simul_inactive;
#endif

#ifndef UICC_NO_DEBUG
ubyte excp_already_logged = 0;
#endif

#ifdef UICC_MONITOR_ICCID
T_ICCID_MONITOR_STATE iccid_monitor_state;

ubyte iccid_store[NOF_ICCID_BYTES] =
    {
        0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11
    };
#endif



/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/
void(*card_detect_callback)(T_ZDrvUicc_CardAction, T_ZDrvUicc_CardSelector) = NULL;

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/
#ifdef UICC_MONITOR_ICCID
/*******************************************************************************
* Function:... selecting
*******************************************************************************/
static ubyte selecting(void)
{
    ubyte return_value = FALSE;

    if (UICC_apdu.header.ins == 0xA4)
        return_value = TRUE;
    return(return_value);
}

/*******************************************************************************
* Function:... mf_selection
*******************************************************************************/
static ubyte mf_selection(void)
{
    ubyte return_value = FALSE;

    if (selecting() && (UICC_apdu.payload_ptr[0] == 0x3F) && (UICC_apdu.payload_ptr[1] == 0x00))
        return_value = TRUE;
    return(return_value);
}

/*******************************************************************************
* Function:... iccid_selection
*******************************************************************************/
static ubyte iccid_selection(void)
{
    ubyte return_value = FALSE;

    if (selecting() && (UICC_apdu.payload_ptr[0] == 0x2F) && (UICC_apdu.payload_ptr[1] == 0xE2))
        return_value = TRUE;
    return(return_value);
}

/*******************************************************************************
* Function:... read_binary
*******************************************************************************/
static ubyte read_binary(void)
{
    ubyte return_value = FALSE;

    if (UICC_apdu.header.ins == 0xB0)
        return_value = TRUE;
    return(return_value);
}

/*******************************************************************************
* Function:... response_successfull
*******************************************************************************/
static ubyte response_successfull(void)
{
    ubyte return_value = FALSE;

    if ((UICC_transport_apdu_result == UICC_TRANSFER_SUCCEEDED) &&
            ((UICC_apdu.footer.sw1 == 0x90) || (UICC_apdu.footer.sw1 == 0x91) || (UICC_apdu.footer.sw1 == 0x9F)))
        return_value = TRUE;
    return(return_value);
}

/*******************************************************************************
* Function:... UICC_monitor_iccid
*******************************************************************************/
void UICC_monitor_iccid(T_CMD_ACTION event)
{
    switch (iccid_monitor_state)
    {
        /*----------------------*/
    case ICCID_READY:
        /*----------------------*/
        switch (event)
        {
        case CMD_REQ:
            if (mf_selection())
                iccid_monitor_state = SELECTING_MF;
            break;
        }
        break;

        /*----------------------*/
    case SELECTING_MF:
        /*----------------------*/
        switch (event)
        {
        case CMD_RESP:
            if (!response_successfull())
                iccid_monitor_state = ICCID_READY;
            break;

        case CMD_REQ:
            if (iccid_selection())
                iccid_monitor_state = SELECTING_ICCID;
            else if (mf_selection())
                ; /* Stay in this state-> iccid_monitor_state = SELECTING_MF; */
            else if (selecting())
                iccid_monitor_state = ICCID_READY;
            /* else stay in this state. */
            break;
        }
        break;

        /*----------------------*/
    case SELECTING_ICCID:
        /*----------------------*/
        switch (event)
        {
        case CMD_RESP:
            if (!response_successfull())
                iccid_monitor_state = SELECTING_MF;
            break;

        case CMD_REQ:
            if (read_binary())
                iccid_monitor_state = READING_ICCID;
            else if (mf_selection())
                iccid_monitor_state = SELECTING_MF;
            else if (selecting())
                iccid_monitor_state = ICCID_READY;
            /* else stay in this state. */
            break;
        }
        break;

        /*----------------------*/
    case READING_ICCID:
        /*----------------------*/
        switch (event)
        {
        case CMD_RESP:
            if (response_successfull())
            {
                memcpy(&iccid_store[0], UICC_apdu.payload_ptr, UICC_MIN(UICC_apdu.footer.luicc, NOF_ICCID_BYTES));
                iccid_monitor_state = ICCID_READ;
            }
            else
                iccid_monitor_state = SELECTING_ICCID;
            break;

        case CMD_REQ:
            /* Cannot occur. */
            break;
        }
        break;

        /*----------------------*/
    case ICCID_READ:
        /*----------------------*/
        /* ICCID has been read - stay here forever. */
        break;
    }
}

/*******************************************************************************
* Function:... send_cmd
*******************************************************************************/
static ubyte send_cmd(T_UICC_COMMAND_CASE command_case,
                      T_UICC_APDU_HEADER  c_apdu,
                      T_UICC_APDU_FOOTER  *r_apdu_ptr,
                      ubyte               *apdu_data_ptr)
{
    ubyte return_value = FALSE;

    if (UICC_TRANSFER_SUCCEEDED == UICC_transport_APDU(UICC_PRIMARY_CARD,  /* card_selector   */
            command_case,       /* command_case    */
            FALSE,              /* extended_length */
            c_apdu,
            r_apdu_ptr,
            apdu_data_ptr))
    {
        if ((r_apdu_ptr->sw1==0x90) || (r_apdu_ptr->sw1 == 0x91) || (r_apdu_ptr->sw1 == 0x9F))
            return_value = TRUE;
    }
    return(return_value);
}

/*******************************************************************************
* Function:... fetch_iccid
*******************************************************************************/
static ubyte fetch_iccid(void)
{
    ubyte                   data_store[50];
    T_UICC_VOLTAGE_CONTROL  voltage_control;
    ubyte                   nof_bytes;
    T_UICC_CHARACTERISTICS  characteristics;
    T_UICC_APDU_HEADER      c_apdu =
        {
            0x00, 0xA4, 0x00, 0x0C, 0x0002, 0x0000
        };
    T_UICC_APDU_FOOTER      r_apdu;

    iccid_monitor_state = ICCID_READY;

    if (UICC_ACTIVATION_SUCCEEDED != UICC_reset(UICC_PRIMARY_CARD,  /* card_selector      */
            UICC_COLD_RESET,    /* reset_mode         */
            UICC_CLASS_C,       /* activation_voltage */
            &voltage_control,
            &nof_bytes,
            &data_store[0],
            &characteristics /* *characteristics */))
    {
        UICC_close(UICC_PRIMARY_CARD);
        return(FALSE); /* Request failed. */
    }

    /* Select MF - 3G mode */
    data_store[0] = 0x3F;
    data_store[1] = 0x00;
    if (!send_cmd(UICC_CMD_CASE_3, c_apdu, &r_apdu, &data_store[0]))
    {
        /* Select MF - GSM mode */
        c_apdu.cla = 0xA0; /* GSM class */
        c_apdu.p2  = 0;
        if (!send_cmd(UICC_CMD_CASE_3, c_apdu, &r_apdu, &data_store[0]))
        {
            UICC_close(UICC_PRIMARY_CARD);
            return(FALSE); /* Request failed. */
        }
    }

    /* Select ICCID - based on previous detected mode */
    data_store[0] = 0x2F;
    data_store[1] = 0xE2;
    if (!send_cmd(UICC_CMD_CASE_3, c_apdu, &r_apdu, &data_store[0]))
    {
        UICC_close(UICC_PRIMARY_CARD);
        return(FALSE); /* Request failed. */
    }

    /* Reading ICCID - based on previous detected mode */
    c_apdu.ins = 0xB0; /* Read Binary */
    c_apdu.p2  = 0;
    c_apdu.lc  = 0;
    c_apdu.le  = 0x0A;
    if (!send_cmd(UICC_CMD_CASE_2, c_apdu, &r_apdu, &data_store[0]))
    {
        UICC_close(UICC_PRIMARY_CARD);
        return(FALSE); /* Request failed. */
    }

    UICC_close(UICC_PRIMARY_CARD);
    return(TRUE);
}
#endif

void invoke_callback(T_UICC_CARD_ACTION card_action, T_UICC_CARD_SELECTOR card_selector)
{
    if (card_detect_callback)
    {
        /* Invoke the callback function. */
        (*card_detect_callback)(card_action, card_selector);
    }
}

/*******************************************************************************
* Function:... UICC_create_semaphore
*
* Created:.... 04.10.01 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
ubyte UICC_create_semaphore(char *sem_name)
{

    if (semaphore_created)
    {
        return(TRUE);
    }
    else
    {
        UICC_common_sem  = zOss_CreateSemaphore((CHAR *)sem_name, 1);
        UICC_hotplug_sem  = zOss_CreateSemaphore((CHAR *)sem_name, 1);
		
        if (UICC_common_sem != NULL&& UICC_hotplug_sem!= NULL )
        {
            semaphore_created = TRUE;
            return(TRUE);
        }
        else
        {
#ifndef UICC_NO_DEBUG
            UICC_log_data_ptr[0] = UICC_card_ctrl_state[UICC_current_reader];
            UICC_log_data_ptr[1] = status;
            UICC_raise_exception(TRAP_UICC_IO, UICC_CREATE_SEMAPHOR_ERROR, 2);
#endif
            semaphore_created = FALSE;
            return(FALSE);
        }
    }

}

/*******************************************************************************
* Function:... UICC_obtain_semaphore
*
* Created:.... 04.10.01 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
ubyte UICC_obtain_semaphore(ZOSS_SEMAPHORE_ID semaphore)
{

    UINT32 status;

    zOss_ASSERT( NULL!= semaphore);

    status = zOss_GetSemaphore(semaphore, ZOSS_WAIT_FOREVER);

    if (status == ZOSS_SUCCESS)
    {
        return(TRUE);
    }
    else
    {
#ifndef UICC_NO_DEBUG
        UICC_log_data_ptr[0] = status;
        UICC_raise_exception(TRAP_UICC_IO, UICC_OBTAIN_SEMAPHOR_ERROR, 1);
#endif
        return(FALSE);
    }

}

/*******************************************************************************
* Function:... UICC_release_semaphore
*
* Created:.... 04.10.01 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_release_semaphore(ZOSS_SEMAPHORE_ID semaphore)
{
    UICC_release_sem_ptr = semaphore;

    /*   ûHISRĴڼʱ
         ֱͷźﴦ⣬ԺҪ */

    zOss_ASSERT( NULL!= semaphore);
    zOss_PutSemaphore(semaphore);
}

#if defined(UICC_ENABLE_IN_OUT_DETECTION)
void UICC_activate_inout_HISR(T_UICC_CARD_ACTION card_action)
{
    if (card_action == CARD_INSERTED)
        initiate_in_callback = TRUE;
    else
        initiate_out_callback = TRUE;

    zOss_PutSemaphore(UICC_in_out_sem);
}
#endif
/*******************************************************************************
* Function:... UICC_set_inout_callback
*
* Created:.... 17.03.04 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
T_UICC_SET_INOUT_CALLBACK UICC_set_inout_callback(void(*inout_call_back)(T_ZDrvUicc_CardAction card_action, T_ZDrvUicc_CardSelector card_selector))
{
    /* Store call back function pointer. */
    T_UICC_SET_INOUT_CALLBACK result = CALLBACK_NOT_AVAILABLE;

#if defined(UICC_ENABLE_IN_OUT_DETECTION) || defined(ENABLE_RUNTIME_SIM_SIMULATION) || defined(ENABLE_RUNTIME_UICC_SIMULATION)
    card_detect_callback = inout_call_back;
    if (UICC_in_out_sem == NULL)
    {
        UICC_in_out_sem = zOss_CreateSemaphore("UICC_in_out",1);
    }
    if (UICC_in_out_threadid == NULL)
    {
        UICC_in_out_threadid = zOss_CreateThread("zDrvUiccInOutHisr",UICC_in_out_highisr,0,512,2,1,1);
    }
    result = CALLBACK_FUNCTION_SET;
#else
    card_detect_callback = inout_call_back;
    result = CALLBACK_FUNCTION_SET;
#endif

#if defined _CHIP_ZX2960
    USIM_GPIO_SD &= 0xFFEFFFFFUL;
#endif
    return(result);
}

/*******************************************************************************
* Function:... UICC_uninstall_inout_callback
*
* Created:....
* Modified:...
*******************************************************************************/
T_UICC_SET_INOUT_CALLBACK UICC_uninstall_inout_callback(VOID)
{
    /* Store call back function pointer. */
    T_UICC_SET_INOUT_CALLBACK result = CALLBACK_NOT_AVAILABLE;

    //card_detect_callback = NULL;
    if (UICC_in_out_threadid != 0)
    {
        zOss_DeleteThread(UICC_in_out_threadid);
        UICC_in_out_threadid = NULL;
    }
    if (UICC_in_out_sem != 0)
    {
        zOss_DeleteSemaphore(UICC_in_out_sem);
        UICC_in_out_sem = NULL;
    }
    result = CALLBACK_NOT_AVAILABLE;

#if defined _CHIP_ZX2960
    USIM_GPIO_SD |= 0x100000UL;
#endif
    return(result);
}

#if defined(UICC_ENABLE_IN_OUT_DETECTION) 
static VOID UICC_in_out_highisr(SINT32 arg)
{


#if defined(UICC_ENABLE_IN_OUT_DETECTION)
    while (1)
    {
        zOss_GetSemaphore(UICC_in_out_sem,ZOSS_WAIT_FOREVER);
        if (initiate_in_callback)
        {
            initiate_in_callback = FALSE;
            invoke_callback(CARD_INSERTED, UICC_current_reader);
        }
        else if (initiate_out_callback)
        {
            initiate_out_callback = FALSE;
            invoke_callback(CARD_REMOVED, UICC_current_reader);
            UICC_deactivate_vcc(UICC_current_reader);
        }
        else
        {
        }
    }
#endif
}
#endif

void UICC_highisr(void)
{

}


/*******************************************************************************
* Function:... UICC_transport_APDU
*
* Created:.... 09.08.01 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modification note.
*******************************************************************************/
static UINT32 UiccApduCnt = 0;
extern ushort err_type_chtimeout;
T_UICC_APDU_RESULT UICC_transport_APDU(T_UICC_CARD_SELECTOR card_selector,
                                       T_UICC_COMMAND_CASE  command_case,
                                       BOOL                 extended_length,
                                       T_UICC_APDU_HEADER   c_apdu,
                                       T_UICC_APDU_FOOTER   *r_apdu_ptr,
                                       ubyte                *apdu_data_ptr)
{
    T_UICC_APDU_RESULT result;
	/* sync protocol stack abnormal recovery with reset command */
    if (err_type_chtimeout) {
      IO_RETURN(UICC_TRANSFER_FAILED);
	}
    UICC_BEGIN_EXECUTE;

#ifdef _USE_PSM
    zDrvPow_SetDevActive((UINT32)IDLE_FLAG_UICC);
#endif

#ifdef UICC_DEBUG_INF
    UICC_debug[UICC_debug_count][0] = 17;
    UICC_debug[UICC_debug_count][1] = (UINT8)card_selector;
    UICC_debug[UICC_debug_count][2] = (UINT8)command_case;
    UICC_debug_count = (UICC_debug_count+1) % 200;
#endif
UiccApduCnt++;
zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "------------UiccApduCnt=%d!--------------\n",UiccApduCnt);
zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "UICC_transport_APDU cla=%x,ins=%x,lc=%x,le=%x,p1=%x,p2=%x, command_case=%x\n",c_apdu.cla,c_apdu.ins,c_apdu.lc,c_apdu.le,c_apdu.p1,c_apdu.p2,command_case);
uiccramlog_Printf("------------UiccApduCnt0=%d!--------------\n",UiccApduCnt);
uiccramlog_Printf("UICC_transport_APDU cla=%x,ins=%x,lc=%x,le=%x,p1=%x,p2=%x, command_case=%x\n",c_apdu.cla,c_apdu.ins,c_apdu.lc,c_apdu.le,c_apdu.p1,c_apdu.p2,command_case);
//zDrvUiccRamlog_PRINTF(RAMLOG_MOD_UICC, "------------UiccApduCnt1=%d!--------------\n",UiccApduCnt);
//printk("------------UiccApduCnt=%d!--------------\n",UiccApduCnt);
//printk("UICC_transport_APDU cla=%x,ins=%x,lc=%x,le=%x,p1=%x,p2=%x, command_case=%x\n",c_apdu.cla,c_apdu.ins,c_apdu.lc,c_apdu.le,c_apdu.p1,c_apdu.p2,command_case);

#ifdef ENABLE_RUNTIME_UICC_SIMULATION
    if (UICC_simul_state == uicc_simul_active)
    { /* Simulation active - let's simulate that the connection towards the
                         simulated card is OK. */
        msap_simulate_uicc_apdu(command_case, c_apdu, r_apdu_ptr, apdu_data_ptr);

#ifdef _USE_PSM
        zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_UICC);
#endif

        IO_RETURN(UICC_TRANSFER_SUCCEEDED);
    }
#endif

    /* Request Semaphore */
    UICC_obtain_semaphore(UICC_TRANSPORT_APDU_SEM);

    /* Execute Command - but first check the validity of the received command data. */
    if ((card_selector >= UICC_SECONDARY_CARD_1)/* || (command_case > UICC_CMD_CASE_4)*/)
    {
#ifndef UICC_NO_DEBUG
        UICC_log_data_ptr[0] = UICC_NOF_CARD_SLOTS;
        UICC_log_data_ptr[1] = card_selector;
        UICC_log_data_ptr[2] = UICC_CMD_CASE_4;
        UICC_log_data_ptr[3] = command_case;
        UICC_raise_exception(TRAP_UICC_IO, UICC_TRANSPORT_APDU_PARAMETER_ERROR, 4);
#endif

        UICC_release_semaphore(UICC_TRANSPORT_APDU_SEM);

#ifdef _USE_PSM
        zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_UICC);
#endif
        IO_RETURN(UICC_TRANSFER_FAILED);
    }

    if ((UICC_card_ctrl_state[card_selector] != UICC_IDLE) && (UICC_card_ctrl_state[card_selector] != UICC_TESTMODE))
    {
#ifndef UICC_NO_DEBUG
        if (!excp_already_logged)
        {
            excp_already_logged = TRUE;
            UICC_log_data_ptr[0] = UICC_NOF_CARD_SLOTS;
            UICC_log_data_ptr[1] = card_selector;
            UICC_log_data_ptr[2] = UICC_card_ctrl_state[card_selector];
            UICC_raise_exception(TRAP_UICC_IO, UICC_WRONG_OPERATION_STATE_6, 3);
        }
#endif

        UICC_release_semaphore(UICC_TRANSPORT_APDU_SEM);
#ifdef _USE_PSM
        zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_UICC);
#endif

        IO_RETURN(UICC_TRANSFER_FAILED);
    }

    /* Check if the main state can allow the requested action. */
    if (!UICC_main_control(UICC_OPERATE_CARD, card_selector))
    {
#ifndef UICC_NO_DEBUG
        UICC_log_data_ptr[0] = UICC_NOF_CARD_SLOTS;
        UICC_log_data_ptr[1] = card_selector;
        UICC_raise_exception(TRAP_UICC_IO, UICC_WRONG_OPERATION_STATE, 2);
#endif

        UICC_release_semaphore(UICC_TRANSPORT_APDU_SEM);
#ifdef _USE_PSM
        zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_UICC);
#endif

        IO_RETURN(UICC_TRANSFER_FAILED);
    }

    UICC_current_reader       = card_selector;
    UICC_apdu.command_case    = command_case;
    UICC_apdu.extended_length = extended_length;

    memcpy(&UICC_apdu.header, &c_apdu, sizeof(T_UICC_APDU_HEADER));
    UICC_apdu.payload_ptr = apdu_data_ptr;

    if ((!extended_length) || (!UICC_Le_Lc_SUPPORTED))
    {
        /* If extended Le/Lc is NOT supported, check to see if the Tx/Rx sizes given are
           out-of-bounds. If that is the case, the size must be truncated. */
        if (UICC_apdu.header.le > 256)
        {
            UICC_apdu.header.le = 256;
        }

        if (UICC_apdu.header.lc > 255)
        {
            UICC_apdu.header.lc = 255;
        }
    }

#ifdef UICC_MONITOR_ICCID
    UICC_monitor_iccid(CMD_REQ);
#endif

    /* Initiate the instruction execution. */
    UICC_card_ctrl(UICC_INSTRUCTION_REQUESTED);

    /* WAIT FOR COMMAND TO BE EXECUTED */
    /* Re-request Semaphore - will hang here until the instruction execution releases the
       previous obtained semaphore. */
    UICC_obtain_semaphore(UICC_TRANSPORT_APDU_SEM);
    switch (UICC_transport_apdu_result)
    {
    case UICC_TRANSFER_SUCCEEDED:
        memcpy(r_apdu_ptr, &UICC_apdu.footer, sizeof(T_UICC_APDU_FOOTER));
        result = UICC_TRANSFER_SUCCEEDED;
        break;

    case UICC_TRANSFER_FAILED:
    default:
        result = UICC_TRANSFER_FAILED;
	 	zOss_DebugInfoRecord(MODULE_ID_PS_UICC, "[UICC%d]UICC_transport_APDU.UICC_transport_apdu_result= %d\n!",card_selector, UICC_transport_apdu_result);
        break;
    }
	
zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "UICC_transport_APDU cla=%x,ins=%x,lc=%x,le=%x,p1=%x,p2=%x,sw1=%x,sw2=%x\n",c_apdu.cla,c_apdu.ins,c_apdu.lc,c_apdu.le,c_apdu.p1,c_apdu.p2,r_apdu_ptr->sw1,r_apdu_ptr->sw2);
uiccramlog_Printf("UICC_transport_APDU cla=%x,ins=%x,lc=%x,le=%x,p1=%x,p2=%x,sw1=%x,sw2=%x\n",c_apdu.cla,c_apdu.ins,c_apdu.lc,c_apdu.le,c_apdu.p1,c_apdu.p2,r_apdu_ptr->sw1,r_apdu_ptr->sw2);

#ifdef UICC_MONITOR_ICCID
    UICC_monitor_iccid(CMD_RESP);
#endif

    if (!UICC_main_control(UICC_OPERATION_ENDED, UICC_current_reader))
    {
#ifndef UICC_NO_DEBUG
        UICC_log_data_ptr[0] = UICC_NOF_CARD_SLOTS;
        UICC_log_data_ptr[1] = UICC_current_reader;
        UICC_log_data_ptr[2] = result;
        UICC_raise_exception(TRAP_UICC_IO, UICC_WRONG_OPERATION_STATE_1, 3);
#endif
        result = 	UICC_TRANSFER_FAILED;
    }


    UICC_release_semaphore(UICC_TRANSPORT_APDU_SEM);

    UICC_stop_timer();
#ifdef _USE_PSM
    zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_UICC);
#endif

    IO_RETURN(result);
}
//end

static simStatuCallback_func getSimStatuCallback = NULL;

void uicc_getSimStatu_callback(simStatuCallback_func func)
{
	getSimStatuCallback = func;
}

static simSwitchCallback_fun s_simSwitchCallback = NULL;

void uicc_setUsimSwitch_callback(simSwitchCallback_fun func)
{
	s_simSwitchCallback = func;
}


/*******************************************************************************
 * Function: UICC_ResetCard
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
T_UICC_RESET_RESULT UICC_ResetCard(T_UICC_CARD_SELECTOR  card_selector)
{
    T_UICC_RESET_RESULT reset_result;
    T_UICC_VOLTAGE_CONTROL voltage_ctrl = {UICC_CLASS_A, FALSE};
    UINT8                   num_hist_bytes = 0;
    UINT8                   hist_bytes[15];
    T_UICC_CHARACTERISTICS characteristics;
    T_UICC_RESET_MODE	   reset_mode;
    T_UICC_VOLTAGE_CLASS   voltage_class;
	static UINT8 s_usim_switch_flag = 0;
    
#ifdef _USE_PSM
    zDrvPow_SetDevActive((UINT32)IDLE_FLAG_UICC);
#endif
    
    reset_result = UICC_ACTIVATION_FAILED; /* init reset result in case no voltages are supported */    
    reset_mode = UICC_COLD_RESET; /* first reset is cold */
    voltage_class = LOWEST_VOLTAGE_ALLOWED; /*sim vol*/

    /*usim hot plug*/
    if(iscalledresetcard ==FALSE)
    {
#ifndef SOC_USIM
        zDrvUICC_ConfigForDetectSIM();
#else
        zDrvUICC_ConfigForDetectSocSIM();
#endif
        iscalledresetcard =TRUE;
    }
#if 0
	/*install uicc isr*/
#ifndef SOC_USIM
	UICC_InstallIsr((VOID *)UICC_ISR_Process,GSM_USIM_INT);
#else
	UICC_InstallIsr((VOID *)UICC_ISR_Process,USIM1_INT);
#endif
#endif
	/*install uicc isr*/
	if (UICC_ESIM_CARD == card_type_ctrl[card_selector])
	{
		 UICC_InstallIsr((VOID *)UICC_ISR_Process, USIM1_INT);
	}
	else
	{
	 	UICC_InstallIsr((VOID *)UICC_ISR_Process,	GSM_USIM_INT);
	}
    /*reset sim card*/
    reset_result = UICC_reset(
                       card_selector,
                       reset_mode,
                       voltage_class,
                       &voltage_ctrl,
                       &num_hist_bytes,
                       hist_bytes,
                       &characteristics);

	UICC_stop_timer();
#ifdef _USE_PSM
    zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_UICC);
#endif

	if((UICC_ACTIVATION_FAILED == reset_result) && (!s_usim_switch_flag)){
		if(s_simSwitchCallback)
			s_simSwitchCallback();
	}else{
		s_usim_switch_flag = 1;
	}


#if 0
	if(getSimStatuCallback){
		if((UICC_ACTIVATION_FAILED == reset_result)
			&& (getSimStatuCallback() == UICC_SIM_PLUGIN))
		 zDrv_Soft_Reset(RESET_TO_NORMAL);
	}
#endif
    return reset_result;
}
/*******************************************************************************
* Function:... UICC_reset
*
* Created:.... 09.08.01 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/

T_UICC_RESET_RESULT UICC_reset(T_UICC_CARD_SELECTOR   card_selector,
                               T_UICC_RESET_MODE      reset_mode,
                               T_UICC_VOLTAGE_CLASS   activation_voltage,
                               T_UICC_VOLTAGE_CONTROL *voltage_control,
                               ubyte                  *nof_hist_characters,
                               void                   *hist_characters,
                               T_UICC_CHARACTERISTICS *characteristics)
{
    T_UICC_RESET_RESULT result = UICC_ACTIVATION_FAILED;
	/* sync protocol stack abnormal recovery with reset command */
    if (err_type_chtimeout) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),UICC_reset chtimeout \n",zOss_GetTickCount());
        return result;
	}
	//zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),UICC_reset enter \n",zOss_GetTickCount());
#ifdef UICC_DEBUG_INF
    memset(UICC_debug,0,600);
    UICC_debug_count = 0;
    memset(UICC_debug_t0,0,1500);
    UICC_debug_count_t0= 0;
#endif
    UICC_BEGIN_EXECUTE;

    UICC_validate_state();

    UICC_card_profile[UICC_current_reader].protocol_mode = UICC_AUTOMATIC_PROTOCOL_SELECTION;

#if (defined(ENABLE_RUNTIME_SIM_SIMULATION) || defined(ENABLE_RUNTIME_UICC_SIMULATION))
    if (UICC_simul_state == uicc_simul_active)
    { /* Simulation active - let's simulate that the connection towards the
                         simulated card is OK. */

        voltage_control->used_voltage    = activation_voltage;
        voltage_control->voltage_settled = TRUE;

        *nof_hist_characters           = UICC_atr_characters[1] & 0x0F;
        if (*nof_hist_characters)
        {
            memcpy(hist_characters,
                   &UICC_atr_characters[UICC_get_atr_historical_offset(&UICC_atr_characters[0], UICC_nof_atr_characters)],
                   *nof_hist_characters);
        }

        characteristics->protocol        = UICC_T_0;
        characteristics->f_used          = UICC_F_DEFAULT;
        characteristics->d_used          = UICC_D_DEFAULT;
        characteristics->f_offered       = UICC_F_DEFAULT;
        characteristics->d_offered       = UICC_D_DEFAULT;
        characteristics->com_convention  = UICC_DIRECT;

        IO_RETURN(UICC_ACTIVATION_SUCCEEDED);
    }
#endif


    /*  ʵʹһź
     ΪǴеģ϶
     ｫʼźΪʼźģ
     Ըֱ */

    UICC_create_semaphore(UICC_ACTIVATION_TAG);
    /* end of UICC_Driver_2007_10_30_dcm */

    /*=============================*/
    /* PREPARE THE RESET EXECUTION */
    /*=============================*/
    /* Request Semaphore */
    UICC_obtain_semaphore(UICC_ACTIVATION_SEM);

    /* Check the validity of the input data. */
    if ((card_selector >= UICC_SECONDARY_CARD_1) ||
            (activation_voltage > UICC_lower_supported_voltage_level()) ||
            (activation_voltage < UICC_higher_supported_voltage_level()) ||
            (UICC_card_profile[UICC_current_reader].protocol_mode > UICC_T1_PROTOCOL_SELECTION))
    {
#ifndef UICC_NO_DEBUG
        UICC_log_data_ptr[0] = UICC_NOF_CARD_SLOTS;
        UICC_log_data_ptr[1] = card_selector;
        UICC_log_data_ptr[2] = UICC_lower_supported_voltage_level();
        UICC_log_data_ptr[3] = UICC_higher_supported_voltage_level();
        UICC_log_data_ptr[4] = activation_voltage;
        UICC_log_data_ptr[5] = UICC_card_profile[UICC_current_reader].protocol_mode;
        UICC_raise_exception(TRAP_UICC_IO, UICC_RESET_PARAMETER_ERROR, 6);
#endif

        UICC_release_semaphore(UICC_ACTIVATION_SEM);
#ifdef MTNET
	zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "Check the validity of the input data UICC_ACTIVATION_FAILED\n");	
	uiccramlog_Printf("Check the validity of the input data UICC_ACTIVATION_FAILED\n");
#endif
        IO_RETURN(UICC_ACTIVATION_FAILED);
    }

    /* Check if the main state can allow the requested action. */
    if (!UICC_main_control(UICC_OPERATE_CARD, card_selector))
    {
#ifndef UICC_NO_DEBUG
        UICC_log_data_ptr[0] = UICC_NOF_CARD_SLOTS;
        UICC_log_data_ptr[1] = card_selector;
        UICC_raise_exception(TRAP_UICC_IO, UICC_WRONG_OPERATION_STATE_2, 2);
#endif

        UICC_release_semaphore(UICC_ACTIVATION_SEM);
#ifdef MTNET
	zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "Check if the main state can allow the requested action UICC_ACTIVATION_FAILED\n");
	uiccramlog_Printf("Check if the main state can allow the requested action UICC_ACTIVATION_FAILED\n");
#endif
		
        IO_RETURN(UICC_ACTIVATION_FAILED);
    }

    UICC_current_reader = card_selector;
    UICC_card_profile[UICC_current_reader].suggested_voltage = activation_voltage;

    /* Carry out the actual reset action. */
    switch (reset_mode)
    {
    case UICC_COLD_RESET:
        UICC_card_ctrl(UICC_COLD_RESET_REQUESTED);
        break;

    case UICC_WARM_RESET:
        UICC_card_ctrl(UICC_WARM_RESET_REQUESTED);
        break;

    default:
#ifndef UICC_NO_DEBUG
        UICC_log_data_ptr[0] = reset_mode;
        UICC_log_data_ptr[1] = card_selector;
        UICC_log_data_ptr[2] = activation_voltage;
        UICC_raise_exception(TRAP_UICC_IO, UICC_FAULTY_RESET_MODE, 3);
#endif

        UICC_card_ctrl(UICC_COLD_RESET_REQUESTED);
        break;
    }

    /*==========================================*/
    /* AWAIT THE OUTCOME OF THE RESET EXECUTION */
    /*==========================================*/
    /* Re-request Semaphore - will hang here until the reset execution releases the
       previous obtained semaphore. */
    //UICC_obtain_semaphore(&UICC_ACTIVATION_SEM);
    UICC_obtain_semaphore(UICC_ACTIVATION_SEM);

#ifdef UICC_DEBUG_INF
    UICC_debug[UICC_debug_count][0] = 6;
    UICC_debug[UICC_debug_count][1] = UICC_activation_result;
    UICC_debug[UICC_debug_count][2] = 0;
    UICC_debug_count = (UICC_debug_count+1) % 200;
#endif
    /* The following actions will depend on the outcome of the activation: */
    switch (UICC_activation_result)
    {
    case UICC_ACTIVATION_SUCCEEDED:
    {
        /* The activation has been successfull, gather the response data. */
        voltage_control->used_voltage    = UICC_card_profile[UICC_current_reader].used_voltage;
        voltage_control->voltage_settled = UICC_card_profile[UICC_current_reader].voltage_settled;

        *nof_hist_characters           = UICC_atr_characters[1] & 0x0F;
        if (*nof_hist_characters)
        {
            memcpy(hist_characters,
                   &UICC_atr_characters[UICC_get_atr_historical_offset(&UICC_atr_characters[0], UICC_nof_atr_characters)],
                   *nof_hist_characters);
        }

        characteristics->protocol        = UICC_card_profile[UICC_current_reader].T_used;
        characteristics->f_used          = UICC_card_profile[UICC_current_reader].f_used;
        characteristics->d_used          = UICC_card_profile[UICC_current_reader].d_used;
        characteristics->f_offered       = UICC_card_profile[UICC_current_reader].fi;
        characteristics->d_offered       = UICC_card_profile[UICC_current_reader].di;
        characteristics->com_convention  = UICC_card_profile[UICC_current_reader].convention;

        result = UICC_ACTIVATION_SUCCEEDED;
        break;
    }

    case UICC_ACTIVATION_FAILED:
    default:
    {
        /* The activation has been unsuccessfull, gather the response data. */
        voltage_control->used_voltage    = UICC_card_profile[UICC_current_reader].used_voltage;
        voltage_control->voltage_settled = UICC_card_profile[UICC_current_reader].voltage_settled;

        result = UICC_ACTIVATION_FAILED;
	    zOss_DebugInfoRecord(MODULE_ID_PS_UICC, "[UICC%d]zDrvUicc_ResetCard.UICC_activation_result= %d\n!",card_selector, UICC_activation_result);
        break;
    }
    }

    if (!UICC_main_control(UICC_OPERATION_ENDED, UICC_current_reader))
    {
#ifndef UICC_NO_DEBUG
        UICC_log_data_ptr[0] = UICC_NOF_CARD_SLOTS;
        UICC_log_data_ptr[1] = UICC_current_reader;
        UICC_log_data_ptr[2] = result;
        UICC_raise_exception(TRAP_UICC_IO, UICC_WRONG_OPERATION_STATE_3, 3);
#endif
        result = UICC_ACTIVATION_FAILED;
    }

    UICC_release_semaphore(UICC_ACTIVATION_SEM);

    IO_RETURN(result);
}


/*******************************************************************************
* Function:... UICC_close
*
* Created:.... 09.08.01 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
#ifdef UICC_ENABLE_IN_OUT_DETECTION
extern	UINT8 is_hp_notsupported;
#endif
T_UICC_CLOSE_RESULT UICC_close(T_UICC_CARD_SELECTOR card_selector)
{
    UICC_BEGIN_EXECUTE;

#ifdef _USE_PSM
    zDrvPow_SetDevActive((UINT32)IDLE_FLAG_UICC);
#endif

#if (defined(ENABLE_RUNTIME_SIM_SIMULATION) || defined(ENABLE_RUNTIME_UICC_SIMULATION))
    if (UICC_simul_state == uicc_simul_active)
    { /* Simulation active - let's simulate that the card is sucessfully closed. */
#ifdef _USE_PSM
        zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_UICC);
#endif
        IO_RETURN(UICC_DEACTIVATION_SUCCEEDED);
    }
#endif

    /* Request Semaphore */
    UICC_obtain_semaphore(UICC_DEACTIVATION_SEM);

    /* Check the validity of the input data. */
    if (card_selector >= UICC_SECONDARY_CARD_1)
    {
#ifndef UICC_NO_DEBUG
        UICC_log_data_ptr[0] = UICC_NOF_CARD_SLOTS;
        UICC_log_data_ptr[1] = card_selector;
        UICC_raise_exception(TRAP_UICC_IO, UICC_CLOSE_ERROR, 2);
#endif

        UICC_release_semaphore(UICC_DEACTIVATION_SEM);
#ifdef _USE_PSM
        zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_UICC);
#endif

        IO_RETURN(UICC_DEACTIVATION_FAILED);
    }

    /* Check if the main state can allow the requested action. */
    if (!UICC_main_control(UICC_OPERATE_CARD, card_selector))
    {
#ifndef UICC_NO_DEBUG
        UICC_log_data_ptr[0] = UICC_NOF_CARD_SLOTS;
        UICC_log_data_ptr[1] = card_selector;
        UICC_raise_exception(TRAP_UICC_IO, UICC_WRONG_OPERATION_STATE_4, 2);
#endif

        UICC_release_semaphore(UICC_DEACTIVATION_SEM);
#ifdef _USE_PSM
        zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_UICC);
#endif

        IO_RETURN(UICC_DEACTIVATION_FAILED);
    }

    UICC_current_reader = card_selector;

    /* Initiate the deactivation. */
    UICC_card_ctrl(UICC_DEACTIVATION_REQUESTED);

    /* Re-request Semaphore - will hang here until the reset execution releases the
       previous obtained semaphore. */
    UICC_obtain_semaphore(UICC_DEACTIVATION_SEM);

    if (!UICC_main_control(UICC_OPERATION_ENDED, UICC_current_reader))
    {
#ifndef UICC_NO_DEBUG
        UICC_log_data_ptr[0] = UICC_NOF_CARD_SLOTS;
        UICC_log_data_ptr[1] = UICC_current_reader;
        UICC_raise_exception(TRAP_UICC_IO, UICC_WRONG_OPERATION_STATE_5, 2);
#endif
    }

    /* Request Semaphore */
    UICC_release_semaphore(UICC_DEACTIVATION_SEM);
    /* NOTE KNM: Deactivation cause in UICC_deactivation_result. */

    /*power down & uninstall isr*/
    UICC_PowerDown();

    //UICC_UninstallIsr(USIM_INT);
#if 0
#ifndef SOC_USIM
	UICC_UninstallIsr(GSM_USIM_INT);
#else
	UICC_UninstallIsr(USIM_INT);
#endif
#endif

	/*install uicc isr*/
	if (UICC_ESIM_CARD == card_type_ctrl[card_selector])
	{
		UICC_UninstallIsr(USIM1_INT);
	}
	else
	{
		UICC_UninstallIsr(GSM_USIM_INT);
	}
#if defined(UICC_ENABLE_IN_OUT_DETECTION)
	if (is_hp_notsupported == 0) {
	}
#endif
    UICC_uninstall_inout_callback();
#ifdef _USE_PSM
    zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_UICC);
#endif

    IO_RETURN(UICC_DEACTIVATION_SUCCEEDED);
}


/*******************************************************************************
* Function:... UICC_card_characteristics
*
* Created:.... 09.08.01 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_card_characteristics(T_UICC_CARD_SELECTOR   card_selector,
                               T_UICC_CLOCK_STOP_MODE clock_stop_mode,
                               ubyte                  min_clock_freq)
{
#if (defined(ENABLE_RUNTIME_SIM_SIMULATION) || defined(ENABLE_RUNTIME_UICC_SIMULATION))
    if (UICC_simul_state == uicc_simul_active)
    { /* Simulation active. */
        return;
    }
#endif

    /* First check that the received characteristics are within the supported card slot range. */
    if (card_selector < UICC_SECONDARY_CARD_1)
    {
        /* The received information will only be used if the clock stop information was not
           already part of the ATR characters. */
        if (!UICC_card_profile[UICC_current_reader].class_clock)
        {
            UICC_card_profile[UICC_current_reader].used_clock_stop_mode = clock_stop_mode;
        }

        min_clock_freq = min_clock_freq; /* currently not used since the HW platform only
                                                        supports on clockfrequency (3.25MHz). */
    }
}

/*******************************************************************************
* Function:... UICC_hw_profile
*
* Created:.... 09.08.01 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
T_UICC_HW_PROFILE UICC_hw_profile(void)
{
    ubyte i;
    T_UICC_HW_PROFILE hw_profile =
        { /* nof_card_slots_supported UICC_NOF_CARD_SLOTS */ 1,
                                         /* protocol_supported       */ 0x01, /* Initially only T=0 supported. */
                                         /* electrical_profile: */
                                         /* UICC_CLASS_A */           {{FALSE, CLASS_A_VOLTAGE, CLASS_A_MAX_CURRENT},
                                                                       /* UICC_CLASS_B */            {FALSE, CLASS_B_VOLTAGE, CLASS_B_MAX_CURRENT},
                                                                       /* UICC_CLASS_C */            {FALSE, CLASS_C_VOLTAGE, CLASS_C_MAX_CURRENT},
                                                                       /* UICC_CLASS_D */            {FALSE, CLASS_D_VOLTAGE, CLASS_D_MAX_CURRENT},
                                                                       /* UICC_CLASS_E */            {FALSE, CLASS_E_VOLTAGE, CLASS_E_MAX_CURRENT}},
                                         /* clock_profile: */              {UICC_MIN_CLOCK_FREQ, UICC_MAX_CLOCK_FREQ},
                                         /* extended_length */            FALSE
        };


    if (UICC_T_1_SUPPORTED)
        hw_profile.protocol_supported |= 0x02; /* T=1 also supported. */

    hw_profile.extended_length = UICC_Le_Lc_SUPPORTED ? TRUE : FALSE;

    /* Fill in the supported voltage levels. */

    for (i=UICC_higher_supported_voltage_level(); i<=UICC_lower_supported_voltage_level(); i++)
    {
        /* Voltage level supported (level within the suported range). */
        hw_profile.electrical_profile[i].class_supported = TRUE;
    }

    return(hw_profile);
}

/*******************************************************************************
* Function:... UICC_get_atr
* Parameters:. Pointer to the store in which the ATR string should be located.
* Returns:.... Number of ATR characters.
* Description: Function used to obtain the ATR string of the current operated
*              card. If no card is active (or if data is not available) the number
*              of characters returned will be set to zero.
* Created:.... 15.08.05 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
ubyte UICC_get_atr(ubyte *atr)
{
    ubyte return_value = 0;

    switch (UICC_card_ctrl_state[UICC_current_reader])
    {
#if (defined(ENABLE_RUNTIME_SIM_SIMULATION) || defined(ENABLE_RUNTIME_UICC_SIMULATION))
    case UICC_INACTIVE:
    case UICC_CARD_NONE:
        if (UICC_simul_state != uicc_simul_active)
        {
            break;
        }
        /*else: intentionally fall through.... */
#endif
    case UICC_IDLE:
    case UICC_BUSY:
    case UICC_TESTMODE:
        if (UICC_nof_atr_characters)
        {
            memcpy(atr, &UICC_atr_characters[0], UICC_nof_atr_characters);
            return_value = UICC_nof_atr_characters;
        }
        break;

    default:
        break;
    }
    return(return_value);
}


/********************************Add new function v5.1***********************************************
* Function:... UICC_interprete_atr_string
*
* Created:.... 23.04.07 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
ubyte UICC_interprete_atr_string(ubyte    nof_atr_characters,
                                 void        *atr_characters,
                                 ubyte       *nof_hist_characters,
                                 void        *hist_characters,
                                 ushort      *protocol_supported)
{
    ubyte *atr   = (ubyte *)atr_characters;

    /* Find number of historical characters by evaluating the k part of format byte T0 */
    *nof_hist_characters = atr[1] & 0x0F;

    if (*nof_hist_characters)
    {
        memcpy(hist_characters,
               (&atr[UICC_get_atr_historical_offset(atr, nof_atr_characters)]),
               *nof_hist_characters);
    }
    *protocol_supported = UICC_get_atr_protocols(atr, nof_atr_characters);
    return(TRUE);
}

/*******************************************************************************
* Function:... SIM_ptst_verify_sim_connection
* Parameters:. reset_card: Indicates whether (TRUE) or not (FALSE) the card should
*                          be reset prior to the card status enquiry.
*                          IMPORTANT: The reset should only be requested when no
*                                     normal SIM activity is ongoing i.e. shold not
*                                     be requested in normal mode of operation hence
*                                     a restart of the SIM will disturb an already
*                                     ongoing session.
* Returns:.... - TRUE:  SIM connection is established.
*              - FALSE: NO SIM connection is established.
* Description: This function is used by ATCPTEST to verify the connection towards
*              the SIM.
*******************************************************************************/
ubyte SIM_ptst_verify_sim_connection(ubyte reset_card)
{
#if (defined(ENABLE_RUNTIME_SIM_SIMULATION) || defined(ENABLE_RUNTIME_UICC_SIMULATION))
    if (UICC_simul_state == uicc_simul_active)
    { /* Simulation active - let's simulate that the connection towards the
                simulated card is OK. */
        return(TRUE);
    }
#endif

    UICC_validate_state();  /* Validate the no-clear states.... */

    if ((reset_card) || (UICC_card_ctrl_state[UICC_PRIMARY_CARD] == UICC_CARD_NONE) || (UICC_card_ctrl_state[UICC_PRIMARY_CARD] == UICC_INACTIVE))
    { /* Reset of the card is requested. */
        T_UICC_VOLTAGE_CONTROL voltage_control;
        ubyte                  nof_bytes;
        ubyte                  data_store[50];
        T_UICC_CHARACTERISTICS characteristics;
        ubyte deactivate_again = FALSE;
        ubyte return_value = FALSE;

        if ((UICC_card_ctrl_state[UICC_PRIMARY_CARD] == UICC_CARD_NONE) || (UICC_card_ctrl_state[UICC_PRIMARY_CARD] == UICC_INACTIVE))
            deactivate_again = TRUE;

        if (UICC_ACTIVATION_SUCCEEDED == UICC_reset(UICC_PRIMARY_CARD,
                UICC_COLD_RESET,
                UICC_lower_supported_voltage_level(),
                &voltage_control,
                &nof_bytes,
                &data_store[0],
                &characteristics))
        {
            return_value = TRUE;
        }

        if (deactivate_again)
            UICC_close(UICC_PRIMARY_CARD);
        return(return_value);
    }
    else
    {
        if ((UICC_card_ctrl_state[UICC_PRIMARY_CARD] == UICC_IDLE) ||
                (UICC_card_ctrl_state[UICC_PRIMARY_CARD] == UICC_BUSY))
        {
            return(TRUE);
        }
        else
        {
            return(FALSE);
        }
    }
}

SINT32 uiccramlog_Printf( const VOID *pFormat, ... )
{
#ifdef UICC_ENABLE_REALTIME_PRINT
	va_list ap;
	UINT8 printfCnt;

	/**/
	if (NULL == pFormat)
	{
		return DRV_ERR_INVALID_PARAM;
	}
		
	va_start(ap,pFormat);
	/*12ֽ,10ֽڴindex,2ֽڴűǷ*/
	//printfCnt = vsnformat(uiccPrintfBuf+curprintwindex*256, 224, pFormat, ap);
	vsprintf(uiccPrintfBuf + curprintwindex*128, pFormat, ap);
	va_end(ap);

	curprintwindex++;
	curprintwindex %= 8;

	zOss_PutSemaphore(UICC_print_sem);

#endif
	return DRV_SUCCESS;
}

VOID UICC_PrintThread(SINT32 arg)
{
#ifdef UICC_ENABLE_REALTIME_PRINT
    while (1)
    {
		zOss_GetSemaphore(UICC_print_sem, ZOSS_WAIT_FOREVER);
		//HAL_ERR_TRACE("%s",uiccPrintfBuf);
		zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_ABNORMAL, "%s", uiccPrintfBuf + curprintrindex * 128);
		curprintrindex++;
		curprintrindex %= 8;
    }
#endif
}

/*******************************************************************************
* Function:... SIM_ptst_verify_sim_connection
* Parameters:. zDrvUICC_Initiate: Indicates whether (TRUE) or not (FALSE) the card should
*                          be reset prior to the card status enquiry.
*                          IMPORTANT: The reset should only be requested when no
*                                     normal SIM activity is ongoing i.e. shold not
*                                     be requested in normal mode of operation hence
*                                     a restart of the SIM will disturb an already
*                                     ongoing session.
* Returns:.... - TRUE:  SIM connection is established.
*              - FALSE: NO SIM connection is established.
* Description: This function is used by ATCPTEST to verify the connection towards
*              the SIM.
*******************************************************************************/
SINT32 zDrvUICC_Initiate(VOID)
{   
   // volatile UINT32 count = 10000;
	struct clk *usim1_pclk = NULL;
	struct clk *usim1_wclk = NULL;
    
	{
		 Vsim_Initiate();
	}
	
#if 0
#ifdef SOC_USIM	
    *(volatile UINT32 *)0x13B050 |= 0x80000000; /*APB4Ƶ,soc uiccĴʧܣܷ*/ 

    zDrvSysClk_SetGate(CLK_USIM_PCLK,SYSCLK_ENABLE);
    zDrvSysClk_SetGate(CLK_USIM_WCLK,SYSCLK_ENABLE);
	
	//zDrvSysClk_SetGate(CLK_USIM_PCLK,SYSCLK_AUTO);
    //zDrvSysClk_SetGate(CLK_USIM_WCLK,SYSCLK_AUTO);
    //SIM_CLC = 0x100;        /*set USIM clock*/
#endif   
#endif   
	usim1_pclk = timer_get_clk("zx29_usim1.0", "apb_clk");
	clk_prepare_enable(usim1_pclk);
	usim1_wclk = timer_get_clk("zx29_usim1.0", "work_clk");
	clk_prepare_enable(usim1_wclk);

#ifdef UICC_ENABLE_REALTIME_PRINT
	if (UICC_print_sem == NULL)
	{
		UICC_print_sem = zOss_CreateSemaphore("UICC_PRINT_SEM",0);
	}
	
	if (UICC_print_thread == NULL)
	{       
		UICC_print_thread = zOss_CreateThread("UICC_PRINT_THREAD", UICC_PrintThread, 0, 512, 25, 1, 1);//25
	}
#endif

     //SIM_CLC = 0x100;       /*set USIM clock*/
    // while(count--);    /*ʱرsoc usimҪŵAPB 4Ƶ֮ǰִ*/

    return DRV_SUCCESS;
}

