#!/bin/sh

cd ../../..
SRC_PATH=`pwd`
KEYS_PATH=$SRC_PATH/../tools/SignImage

cd $SRC_PATH/common/src/loader

make mrproper
rm -f ./z-load*

is_ok=0

if 
	make "$chip"_zloader_dloff_config;
then
	if	make platform; then
		if make together; then
			is_ok=1
		fi		
	fi
fi

if [ $is_ok -eq 1 ];then	
	echo "";
	echo "Configuring ["$chip"_"$board"_zloader_dloff_config] for ["$chip" "$board" "$key_path"] board ...";
	
		cp z-load.bin $SRC_PATH/common/scripts/tools;
		cd $SRC_PATH/common/scripts/tools;
		./expand z-load.bin;

		mkdir -p $KEYS_PATH/Input
		mkdir -p $KEYS_PATH/Output
		chmod -R 777 $SRC_PATH/
		mv z-load.bin $KEYS_PATH/Input/zloader.bin
		cd $KEYS_PATH
		./SignImage -z ./Input/zloader.bin ./test_key/$key_path/private.k
		cp ./Input/zloader.bin $SRC_PATH/prj/$chip/$board/bin/dl_off/zloader.bin
		rm -rf Input
		rm -rf Output

		echo "--Finished build [zloader.bin] ...";
		echo "................................................OK....";	
		echo "";
fi
