/*******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:	hal_led.c
 * File Mark:
 * Description:	 This file contains the hal layer routines for i2c driver.
 * Others:
 * Version:		  V1.0
 * Author:		  yx
 * Date:		  2014-07-03
 * History 1:
 *	   Date:
 *	   Version:
 *	   Author:
 *	   Modification:
 * History 2:
  ******************************************************************************/

/****************************************************************************
*								   Include files
****************************************************************************/

#include <common.h>
//#include "drvs_general.h"
//#include "drvs_i2c.h"
#include <linux/types.h>
#include <power.h>
#include <zx234290.h>
#include <led.h>
#include <lcd.h>
//#include <lcd_blg.h>
#include <charge.h>
//#include <zx234502.h>
#include <partition_table.h>
#include <linux/mtd/compat.h>
/****************************************************************************
*											   Local Macros
****************************************************************************/
#define CHARGER_EN_GPIO		GPIO131
#define CHARGER_EN_GPIO_FUN GPIO131_GPIO131
/****************************************************************************
*											   Local Types
****************************************************************************/

/****************************************************************************
*											   Local Constants
****************************************************************************/


/****************************************************************************
 * Function:	peripheral_init
 * Description: init the peripheral include pmu\charger\led\lcd etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int peripheral_init(void)
{
	int ret = 0;
	ret = power_init();
/*led*/
	zx29_led_init();
/*lcd*/
	//ret |= zDrvLcd_Initiate();
#if 0
	usb_charger_init();
#endif
	//zx234502_charger_enable();
	/*charger enable*/
	zDrvGpio_SetFunc(CHARGER_EN_GPIO,CHARGER_EN_GPIO_FUN);
	zDrvGpio_SetDirection(CHARGER_EN_GPIO,GPIO_OUT);
	zDrvGpio_SetOutputValue(CHARGER_EN_GPIO,GPIO_LOW);

	/* jtag */
#if 0
	jtag_init();
#endif

	return ret ;
}

/****************************************************************************
 * Function:	Show_UpdateWait
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int Show_UpdateWait(void)
{
	int ret = 0;
/*led*/

/*lcd*/
	;
	return ret;
}

/****************************************************************************
 * Function:	Show_UpdateSucc
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int Show_UpdateSucc(void)
{
	int ret = 0;
/*led*/

/*lcd*/
	;
	return ret;
}

/****************************************************************************
 * Function:	Show_UpdateFail
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int Show_UpdateFail(void)
{
	int ret = 0;
/*led*/

/*lcd*/
	;
	return ret;
}

/****************************************************************************
 * Function:	Show_LowPower
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int Show_LowPower(void)
{
	int ret = 0;

/*led*/
	zx29_led_PowerOnLedOn();
/*lcd*/
#ifdef CONFIG_ZX297520V3_AIC8800
    zDrvLcd_ShowLowBattery();
#endif
	udelay(300);
#ifdef CONFIG_ZX297520V3_AIC8800
	zDrvLcd_TurnBacklightOnOff(1);
#endif
/*led*/
	zx29_led_PowerOnLedOff();

	return ret;
}

/****************************************************************************
 * Function:	Show_No_Battery
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int Show_No_Battery(void)
{
	int ret = 0;
/*led*/
	zx29_led_PowerOnLedOn();
/*lcd*/
#ifdef CONFIG_ZX297520V3_AIC8800
	zDrvLcd_ShowNoBattery();
#endif
	udelay(300);
#ifdef CONFIG_ZX297520V3_AIC8800
	zDrvLcd_TurnBacklightOnOff(1);
#endif
/*led*/
	zx29_led_PowerOnLedOff();

	return ret;
}

/****************************************************************************
 * Function:	Show_PowerOn_Normal
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int Show_PowerOn_Normal(void)
{
	int ret = 0;

/*led*/
	zx29_led_PowerOnLedOn();
/*lcd*/
#ifdef CONFIG_ZX297520V3_AIC8800
	zDrvLcd_PowerOnLogo();
#endif
	udelay(300);
#ifdef CONFIG_ZX297520V3_AIC8800
	zDrvLcd_TurnBacklightOnOff(1);
#endif
/*led*/
	zx29_led_PowerOnLedOff();

	return ret;
}

/****************************************************************************
 * Function:	Show_PowerOn_Normal
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/

int Show_PowerOn_Fota(void)
{
	int ret = 0;

/*led*/
	zx29_led_PowerOnLedOn();

/*lcd*/
#ifdef CONFIG_ZX297520V3_AIC8800
	zDrvLcd_ShowUpdateWait();
#endif
	udelay(300);
#ifdef CONFIG_ZX297520V3_AIC8800
	zDrvLcd_TurnBacklightOnOff(1);
#endif
/*led*/
	zx29_led_PowerOnLedOff();

	return ret;
}


/****************************************************************************
 * Function:	Show_Charging
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int Show_Charging(void)
{
	int ret = 0;

/*led*/
	zx29_led_PowerOnLedOn();
/*lcd*/
#ifdef CONFIG_ZX297520V3_AIC8800
	zDrvLcd_ShowCharging();
#endif
	udelay(300);
#ifdef CONFIG_ZX297520V3_AIC8800
	zDrvLcd_TurnBacklightOnOff(1);
#endif
/*led*/
	zx29_led_PowerOnLedOff();

	return ret;
}

/****************************************************************************
 * Function:	zx_get_vbat_voltage
 * Description: .
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int zx_get_vbat_voltage(void)
{
   // int ret = 0;

	return zx234290_get_adc1_voltage();
}

/****************************************************************************
 * Function:	zx_get_battery_Status
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
unsigned int zx_get_battery_Status(void)
{
#if 0
    int ret = 0;
	int boost_flag = 1;

	zx234502_battery_status(&boost_flag);
	if(boost_flag){
		return 0;/*battery uninstall*/
	}
	else
		return 1;/*battery install*/
#else
    int ret = 0;
    int battery_status = 0;

    ret = zx234290_get_adc2_voltage();
    if (ret < 0)
    {
        printf("\t[zx234290_get_adc2_voltage] return [%d] in [%s]\n", ret, __FUNCTION__);
        return ret;
    }

    battery_status = (ret < 1770);

#if 0
    if (battery_status)
        printf("\t[%s] get %d and return battery connected\n", __FUNCTION__, ret);
    else
        printf("\t[%s] get %d and return battery disconnected\n", __FUNCTION__, ret);
#endif

    return battery_status;
#endif
}
