/*
 ***********************************************************	
 */

#include <common.h>
#include <asm/io.h>
#include <sdio.h>

#include "efuse.h"



void efuse_init(void)
{
	//start read efuse all 256bit
	while((REG32(SYS_EFUSE_BASE + 0x4) & 1) == 1);// bit0=1 ctl is busy
	REG32(SYS_EFUSE_BASE + 0x4) = 1;
	while((REG32(SYS_EFUSE_BASE + 0x14) & 2) == 0);//bit1=0 read not over
}

int get_ddr_flag(void)
{
	efuse_struct *psEfuseInfo = NULL;
	int ddr_flag = 0;


	psEfuseInfo = (efuse_struct*)EFUSE_RAM_BASE;

	/* get chip flag */
	if(((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_GW_WINBD_256M_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_ZW_WINBD_256M_DDR)		
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_GW_UNILC_256M_DDR)		
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_ZW_UNILC_256M_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_GW_APM_256M_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_ZW_APM_256M_DDR))
	{
		ddr_flag = CHIP_DDR_32M;
	}	
	else if(((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_GW_UNILC_512M_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_GW_APM_512M_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_GW_ESMT_512M_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_ZW_UNILC_512M_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_AZW_UNILC_512M_DDR)		
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_ZW_APM_512M_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_ZW_ESMT_512M_DDR))
	{
		ddr_flag = CHIP_DDR_64M;
	}
	else if((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECOSC_GW_NYC_2G_DDR)
	{
		ddr_flag = CHIP_DDR_256M;
	}
	else
	{
		ddr_flag = CHIP_DDR_128M;
	}

	return ddr_flag;
}

int get_secure_verify_status(void)
{
	u32 uiLen;
	efuse_struct *psEfuseInfo = NULL;

	if((REG32(EFUSE_BYPASS) & 1) == 1)   //Secure Verify. 1->Disable, 0->Enable.
	{
		return SECURE_VERIFY_DISABLE;
	}
	
	/*
	 * 0. secure flag0xFF˳ȫboot
	 */
	psEfuseInfo = (efuse_struct*)EFUSE_RAM_BASE;
	if((psEfuseInfo->secure_flag & 0xFF) != 0xFF)
	{
		return SECURE_VERIFY_DISABLE;
	}	
	
	/*
	 * 1.efuseжpuk_hash[127:0], жȫΪ0˳ȫboot
	 */
	for(uiLen = 0; uiLen < 4; uiLen++)
	{
		if(psEfuseInfo->puk_hash[uiLen] != 0)
		{
			break;
		}
		if(uiLen == 3)
		{
			return SECURE_VERIFY_DISABLE;
		}
	}
	printf("SecureVerify->enable.\n");
	
	return SECURE_VERIFY_ENABLE;
}



