/*******************************************************************************
 * Copyright by ZTE Corporation.
 *
 * File Name:    uicc_agt_local.c
 * File Mark:    
 * Description:  uicc ߳
 * Others:        
 * Version:       V1.0
 * Author:        
 * Date:          
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
********************************************************************************/
 /****************************************************************************
* 	                                           Include files
****************************************************************************/
#include "vsim.h"
#include <linux/uicc_agt_client.h>

/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
#define VSIM_BIN_AUTH_LEN 520

/****************************************************************************
* 	                                           Local Types
****************************************************************************/

/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Global Constants
****************************************************************************/

/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
int g_fd = -1;

/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/
int usim_reset_proc(T_UICC_RESET_REQ_MSG *reset_req)
{
	VSIM_MSG_BUF stMsg={0};
	int ret =0;
	T_UICC_RESET_RSP_MSG *reset_rsp = (T_UICC_RESET_RSP_MSG *)stMsg.aucDataBuf;
	reset_rsp->card_selector = reset_req->card_selector;
	reset_rsp->func_resp = zVcard_ResetCard(reset_req->card_selector);
	if(reset_rsp->func_resp){
		printf("@vsim@ usim_reset_proc err rsp=%d\n",reset_rsp->func_resp);
		system("cp -fp /etc_ro/vSim.bin /mnt/userdata/");
	}
	stMsg.usMsgCmd=MSG_CMD_USIM_RESET;
	stMsg.usDataLen=sizeof(T_UICC_RESET_RSP_MSG);
	ret = write(g_fd, &stMsg, sizeof(stMsg));
	printf("@vsim@ usim_reset_proc send %d\n",ret);
	return 1;
}

int usim_getatr_proc(T_UICC_ATR_REQ_MSG *atr_req)
{
	VSIM_MSG_BUF stMsg={0};
	int ret =0;
	T_UICC_ATR_RSP_MSG *atr_rsp = (T_UICC_ATR_RSP_MSG *)stMsg.aucDataBuf;
	atr_rsp->card_selector = atr_req->card_selector;
	atr_rsp->func_resp = zVcard_GetAtr(atr_req->card_selector,atr_rsp->atr_data);
	stMsg.usMsgCmd=MSG_CMD_USIM_GETATR;
	stMsg.usDataLen=sizeof(T_UICC_ATR_RSP_MSG);
	ret = write(g_fd, &stMsg, sizeof(stMsg));
	printf("@vsim@ usim_getatr_proc send %d\n",ret);
	return 1;
}

int usim_apdu_proc(T_UICC_TRANSPORT_APDU_REQ_MSG *apdu_req)
{
	VSIM_MSG_BUF stMsg={0};
	int ret =0;
	T_ZDrvUicc_ApduHeader tCApdu;
	T_UICC_TRANSPORT_APDU_RSP_MSG *apdu_rsp = (T_UICC_TRANSPORT_APDU_RSP_MSG *)stMsg.aucDataBuf;
	apdu_rsp->card_selector = apdu_req->card_selector;
	memcpy(&tCApdu, &apdu_req->c_apdu,sizeof(T_ZDrvUicc_ApduHeader));
	apdu_rsp->func_resp = zVcard_TransportApdu(apdu_req->card_selector, apdu_req->command_case, apdu_req->extended_length, tCApdu, &apdu_rsp->r_apdu_ptr,apdu_req->data_req);
	memcpy(apdu_rsp->data_rsp,apdu_req->data_req,apdu_rsp->r_apdu_ptr.luicc);
	stMsg.usMsgCmd=MSG_CMD_USIM_APDU;
	stMsg.usDataLen=sizeof(T_UICC_TRANSPORT_APDU_RSP_MSG);
	ret = write(g_fd, &stMsg, sizeof(stMsg));
	printf("@vsim@ usim_apdu_proc send %d\n",ret);
	return 1;
}

int usim_close_proc(T_UICC_CLOSE_REQ_MSG *close_req)
{
	VSIM_MSG_BUF stMsg={0};
	int ret =0;
	T_UICC_CLOSE_RSP_MSG *close_rsp = (T_UICC_CLOSE_RSP_MSG *)stMsg.aucDataBuf;
	close_rsp->card_selector = close_req->card_selector;
	close_rsp->func_resp = zVcard_CloseCard(close_req->card_selector);
	stMsg.usMsgCmd=MSG_CMD_USIM_CLOSE;
	stMsg.usDataLen=sizeof(T_UICC_CLOSE_RSP_MSG);
	ret = write(g_fd, &stMsg, sizeof(stMsg));
	printf("@vsim@ usim_close_proc send %d\n",ret);
	return 1;
}

int rcv_msg_proc(VSIM_MSG_BUF *msg_buf)
{
	switch (msg_buf->usMsgCmd)
    {
    case MSG_CMD_USIM_RESET:
		usim_reset_proc((T_UICC_RESET_REQ_MSG *)(msg_buf->aucDataBuf));
		break;
	case MSG_CMD_USIM_GETATR:
		usim_getatr_proc((T_UICC_ATR_REQ_MSG *)(msg_buf->aucDataBuf));
		break;
	case MSG_CMD_USIM_APDU:
		usim_apdu_proc((T_UICC_TRANSPORT_APDU_REQ_MSG *)(msg_buf->aucDataBuf));
		break;
	case MSG_CMD_USIM_CLOSE:
		usim_close_proc((T_UICC_CLOSE_REQ_MSG *)(msg_buf->aucDataBuf));
		break;
	default:
		printf("@vsim@ rcv_msg_proc msgid 0x%x\n",msg_buf->usMsgCmd);
		break;
	}
	return 0;
}

int check_vsim_bin(int fd)
{
	int fd_r = open("/etc_ro/vSim.bin",O_RDONLY);
	if(fd_r >= 0){
		unsigned char buf_r[VSIM_BIN_AUTH_LEN] = {0};
		unsigned char buf[VSIM_BIN_AUTH_LEN] = {0};
		int read_len = 0;
		int read_len_r = 0;
again1:
		read_len = read(fd, buf, sizeof(buf));
		if (read_len < 0) {
			if (errno == EINTR){
				printf("@vsim@ Read bin, interrupted!\n");
				goto again1;
			}else{
				printf("@vsim@ Read bin fail, error:[%d]%s\n", errno, strerror(errno));
				goto err_out;
			}
		}else if(read_len != sizeof(buf)){
			printf("@vsim@ Read bin len=%d err\n", read_len);
			goto err_out;
		}
again2:
		read_len_r = read(fd_r, buf_r, sizeof(buf_r));
		if (read_len_r < 0) {
			if (errno == EINTR){
				printf("@vsim@ Read bin_ro, interrupted!\n");
				goto again2;
			}else{
				printf("@vsim@ Read bin_ro fail, error:[%d]%s\n", errno, strerror(errno));
				goto err_out;
			}
		}else if(read_len_r != sizeof(buf_r)){
			printf("@vsim@ Read bin_ro len=%d err\n", read_len_r);
			goto err_out;
		}
		close(fd_r);
		return memcmp(buf_r, buf, sizeof(buf_r));
	} else {
		printf("@vsim@ open vsim_ro fail, error:[%d]%s", errno, strerror(errno));
		return -1;
	}

err_out:
	close(fd_r);
	return -1;
}

int main(int argc, char* argv[])
{
	VSIM_MSG_BUF stMsg;
	int iRet = 0;
	g_fd = open("/dev/rpm0",O_RDWR);
	printf("@vsim@ open rpm0 fd: %d er_no: %d\n", g_fd, errno);
	//assert(g_fd >= 0);
	if(g_fd < 0)
	{
		exit(0);
	}
	{
		int fd = open("/mnt/userdata/vSim.bin",O_RDONLY);
		printf("@vsim@ open userdata/vSim.bin fd: %d er_no: %d\n", fd, errno);
		if(fd >= 0)
		{
			if(check_vsim_bin(fd)){
				printf("@vsim@ check_vsim_bin fail copy form ro\n");
				system("cp -fp /etc_ro/vSim.bin /mnt/userdata/");
			}
			close(fd);
		}
		else
			system("cp -fp /etc_ro/vSim.bin /mnt/userdata/");
	}
	while(1)
    {
        memset(&stMsg, 0x00, sizeof(VSIM_MSG_BUF));

		iRet = read(g_fd, &stMsg, sizeof(stMsg));
        if (iRet >= 0)
        {
            rcv_msg_proc(&stMsg);            
        }
        else
        {
            if(errno != EINTR)
                printf("errno = %d, errmsg = %s\n", errno,strerror(errno));
        }
    }
	
}

