/*****************************************************************************
 *  汾 (C)2010ͨѶɷ޹˾
 *
 *  ģ  
 *  ļ  l1_count_latch.h
 *  ļʶ
 *  ļ
 *  ʵֹܣ
 *      
 *  汾    
 *  ڣ
 *  ˵½
 *
 *****************************************************************************/


#ifndef	_L1_COUNT_LATCH_H
#define	_L1_COUNT_LATCH_H


/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
/* ׼ͷļ */
#include "oss_api.h"

#ifdef  DDR_BASE_ADDR_LINUX_VA
#include <mach/iomap.h>
#endif

/* Ǳ׼ͷļ */


/**************************************************************************
 *                                                                    *
 **************************************************************************/

/**************************************************************************
 *                         ȫֺ궨                                         *
 **************************************************************************/
//Ĵ8'h15 (0x6d80_1054)ģcount latchƼĴ
/*
4.4.1.22	Ĵ8'h15 (0x6d80_1054)ģcount latchƼĴ
Bit[31:14]	R		0
Bit[13]	W/R	Gsm_clk_gsm_en_sel	0
Bit[12]	W/R	Gsm_clk_gsm_reg	0
Bit[11:9]	R		0
Bit[8]	W/R	Gsm_pwr_en	0
Bit[7:3]	R		0
Bit[2]	WR	latch_top_en	0
Bit[1]	WR	gsm_gsictrl1	0
Bit[0]	WR	gsm_gsictrl0	0
*/
/*ֵЧֻΪͨ zhangpei*/
/**************************************************************************
 *                         ȫͶ                                       *
 **************************************************************************/

typedef  struct
{
    UINT32                       wTick;/*0~9999*/
    UINT32                       wFrame;/*0~2715647*/
}T_zPHY_GSM_Tstamp;
typedef  struct
{
     UINT32                       wChip;                       /*0~6399 chip*/
     UINT32                       wSubFrame;                 /* ֡ţ Χ 0 - 8191*/
}T_zPHY_TD_Tstamp;
typedef  struct
{
    UINT32                         wTs;              /*ʱϢλTS*/
    UINT32                         wSubFrame;  /*ʱϢ֡*/
    UINT32                         wFrame;  /*ʱϢ֡*/

}T_zPHY_LTE_Tstamp;
typedef  struct
{
    UINT32                         wFrame;  /*ʱϢ֡*/
    UINT32                         wChip;  /*ʱϢ֡*/
}T_zPHY_W_Tstamp;

typedef struct
{
    T_zPHY_LTE_Tstamp                tLteTstamp;    //LTE ʱ䣨ʱ䣩
    T_zPHY_TD_Tstamp                 tTDTstamp; //TD ʱ䣨ʱ䣩
    T_zPHY_W_Tstamp                  tWTstamp; //W ʱ䣨ʱ䣩
    T_zPHY_GSM_Tstamp                tGsmTstamp; // GSM ʱ䣨ʱ䣩
}T_zMULM_Timing_Stamp;


/* MRTRտƼĴ */
typedef struct
{
	UINT32 latch_signal   : 1;   /* ź -w */
	UINT32 Reserve_0      : 15;
	UINT32 latch_flag_done : 1; /* ɱ־ -rd */
	UINT32 Reserve_1       : 15;
}T_COUNT_LATCH_LPM_CTRL_REG;


/*MrtrĴ*/
/***************************************************************************
  BIT      |31 30 |29 28 27 26 25 24 23 22 21 20 19 18 | 17 16 15 14 | 13 12 11 10 | 9 8 7 6 5 4 3 2 | 1 0 |
 ---------------------------------------------------------------------------
  Function |reserv|                 RadioFrame         |   slot      |  symobol    |     chip        |smple|
****************************************************************************/
typedef struct{
    UINT32       dSample     :2;
    UINT32       dChip          :8;
    UINT32       dSymbol     :4;
    UINT32       dSlot           :4;
    UINT32       dFrame       :12;
    UINT32       dReserved  :2;
}T_regWLpmLatchCnt;

/*TD*/
/***************************************************************************
  BIT      | 15 14 13 | 12 11 10 9 8 7 6 5 4 3 2 1 0  						|
 ---------------------------------------------------------------------------
  Function | Reserved | Sub-frame Cnt (nt sub-frame sync)(0~8191)		 	|
****************************************************************************/
typedef struct{
					UINT32       wNtSubFrmValue1        :13;
					UINT32       wReserved              :19;
}T_regTdLpmLatchSfn;
/***************************************************************************
  BIT      | 15       | 14 13 12 11 10 9 8 7 6 5 4 3 2 | 1 0  				|
 ---------------------------------------------------------------------------
  Function | Reserved | Chip Cnt(0~6399)(sync nt sub-frame)| Sample cnt(0~3)|
****************************************************************************/
typedef struct{
					UINT32       wSyncSamcntValue0      :3;  
					UINT32       wSyncChipcntValue0     :13;
					UINT32       wReserved              :16;
}T_regTdLpmLatchChip;


/**************************************************************************
 *                         ȫֱ                                    *
 **************************************************************************/

/**************************************************************************
 *                        ȫֺԭ                                     *
 **************************************************************************/
/*****************************************************************************
 *			
 *			
 *		
 *		
 *	ֵ˵  
 *	˵	
 *****************************************************************************/
extern void zPHY_emulm_GetMulmTimingStamp(T_zMULM_Timing_Stamp *ptMulmTimingStamp);
extern void zPHY_emulm_GetMulmMrtrStamp(T_zMULM_Timing_Stamp *ptMulmTimingStamp);

// cym_start: ӻȡʽʱյĹܺ 2016-2-1
void zPHY_emulm_GetMulmLocalStamp(T_zMULM_Timing_Stamp *ptMulmTimingStamp);
// cym_end	

/* ȡbitֵval=0B'01010101, BIT_GET(val, 2)  = 0B'1*/
#define BIT_GET(name, bit)      (( (name) >> (bit)) & 0x01)

#if (defined _CHIP_ZX297520)
#define REG_GSM_LPM_BASE           (0x0013F000)
#elif (defined _CHIP_ZX297520V2) || (defined _CHIP_ZX297520V3)
#ifdef  DDR_BASE_ADDR_LINUX_VA
#define REG_GSM_LPM_BASE           ((unsigned long)ZX_LPM_BASE)
#else
#define REG_GSM_LPM_BASE           (0x00134000)
#endif
#else
#define REG_GSM_LPM_BASE           (0x0013F000)
#endif

#define REG_LPM_LATCH_ENABLE                (*(volatile WORD32*)((REG_GSM_LPM_BASE + 0x60*4)>>CPU_SHIFT))
#define REG_COUNTER32K_LATCH_T1             (*(volatile WORD32*)((REG_GSM_LPM_BASE + 0x31*4)>>CPU_SHIFT))
#define REG_COUNTER32K_LATCH_T2             (*(volatile WORD32*)((REG_GSM_LPM_BASE + 0x32*4)>>CPU_SHIFT))
#define REG_COUNTER32K_LATCH_RESET          (*(volatile WORD32*)((REG_GSM_LPM_BASE + 0x33*4)>>CPU_SHIFT))

#define REG_COUNTER32K_LATCH_FLAG           (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x34*4)>>CPU_SHIFT))
#define REG_LTE_MRTR_LATCH1                 (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x48*4)>>CPU_SHIFT))
#define REG_LTE_LOCAL_MRTR_LATCH1           (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x49*4)>>CPU_SHIFT))
#define REG_LTE_MRTR_LATCH2                 (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x58*4)>>CPU_SHIFT))
#define REG_LTE_LOCAL_MRTR_LATCH2           (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x59*4)>>CPU_SHIFT))
#define REG_W_MRTR_LATCH1                   (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x46*4)>>CPU_SHIFT))
#define REG_W_LOCAL_MRTR_LATCH1             (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x47*4)>>CPU_SHIFT))
#define REG_W_MRTR_LATCH2                   (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x56*4)>>CPU_SHIFT))
#define REG_W_LOCAL_MRTR_LATCH2             (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x57*4)>>CPU_SHIFT))

#define REG_TD_RTSFN_MRTR_LATCH1            (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x4a*4)>>CPU_SHIFT))
#define REG_TD_RTCHIP_MRTR_LATCH1           (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x4b*4)>>CPU_SHIFT))
#define REG_TD_NTSFN_MRTR_LATCH1            (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x4c*4)>>CPU_SHIFT))
#define REG_TD_NTCHIP_MRTR_LATCH1           (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x4d*4)>>CPU_SHIFT))

#define REG_TD_RTSFN_MRTR_LATCH2            (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x5a*4)>>CPU_SHIFT))
#define REG_TD_RTCHIP_MRTR_LATCH2           (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x5b*4)>>CPU_SHIFT))
#define REG_TD_NTSFN_MRTR_LATCH2            (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x5c*4)>>CPU_SHIFT))
#define REG_TD_NTCHIP_MRTR_LATCH2           (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x5d*4)>>CPU_SHIFT))

#define REG_GSM_RTFRAME_MRTR_LATCH1         (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x44*4)>>CPU_SHIFT))
#define REG_GSM_RTTICK_MRTR_LATCH1          (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x45*4)>>CPU_SHIFT))
#define REG_GSM_RTFRAME_MRTR_LATCH2         (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x54*4)>>CPU_SHIFT))
#define REG_GSM_RTTICK_MRTR_LATCH2          (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x55*4)>>CPU_SHIFT))

#define REG_GSM_NTFRAME_MRTR_LATCH1         (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x40*4)>>CPU_SHIFT))
#define REG_GSM_NTTICK_MRTR_LATCH1          (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x41*4)>>CPU_SHIFT))
#define REG_GSM_NTFRAME_MRTR_LATCH2         (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x50*4)>>CPU_SHIFT))
#define REG_GSM_NTTICK_MRTR_LATCH2          (*(volatile UINT32*)((REG_GSM_LPM_BASE + 0x51*4)>>CPU_SHIFT))

#endif  /* _ZX297500_L1_COUNT_LATCH_H */


