#include <common.h>
#include <command.h>
#include <net.h>
#include <jffs2/load_kernel.h>
#include <common.h>
#include <asm/arch/hardware.h>
#include <asm/arch/uart.h>
#include <asm/arch/lsp_crpm.h>
#include "errno.h"
#include <config.h>
#include <drvs_gpio.h>


#if CONFIG_HARDWARE_TEST

#define DDR_START 0x20000000
#define DDR_END     0x27800000

void led_init(void)
{
    int32_t reg = 0;

    reg = __REG(0x10d440);  /*  */
    reg |= (0x1 << 24);
    __REG(0x10d440)=reg;
  
    reg = __REG(0x10dC04);  /* config OUT */
    reg &= (~(0x1<<9));
    __REG(0x10dC04)=reg;

    #if 1
    reg = __REG(0x10dC08);  
    reg |= (0x1<<9);     
    __REG(0x10dC08)=reg;
    #endif
}

void led_on(void)
{
    int32_t reg = __REG(0x10dC08);  
    reg |= (0x1<<9);    
    __REG(0x10dC08)=reg;
}

void led_off(void)
{
    int32_t reg = __REG(0x10dC08);  
    reg &= ~(0x1<<9);     
    __REG(0x10dC08)=reg;
}


int do_test_ddr(void) 
{
	volatile unsigned char *test_count = 0;
	static int test_cnt = 0;
	unsigned int cnt = 0;
	volatile unsigned int state = 0;
	int ret = 0;
	test_cnt++;
    printf("single byte test round:%d\n",test_cnt);
	for(test_count = (unsigned char *)DDR_START; test_count < (unsigned char *)DDR_END; test_count++)
	{
		*test_count = 0x55;
		if(*test_count != 0x55)
		{
			break;
			ret = -1;
		}
		*test_count = 0xAA;
		if(*test_count != 0xAA)
		{
			break;
			ret = -1;
		}
		
		cnt++;
		if(cnt%2000000 == 0)
		{
			if(state==0)
			{
				zDrvGpio_SetOutputValue(GPIO32,GPIO_HIGH);
				printf("single byte test round:%d\n",cnt);
				state = 1;
			}
			else
			{
				 zDrvGpio_SetOutputValue(GPIO32,GPIO_LOW);
				 printf("single byte test round:%d\n",cnt);
				state = 0;
			}
		}
			
		
	}
	if(test_count != (unsigned char *)DDR_END)
	{	
		printf("test ddr faile\n");
		ret = -1;
	}
	else
	{
		printf("test ddr success\n");
	}

	if(ret == -1)
	{
		zDrvGpio_SetOutputValue(GPIO70,GPIO_HIGH);
		while(1);
	}
	printf("memset test round:%d\n",test_cnt);
	memset(DDR_START,0x5a,DDR_END-DDR_START);
	printf("check memset\n");
	for(test_count = (unsigned char *)DDR_START; test_count < (unsigned char *)DDR_END; test_count++)
	{
		if(*test_count != 0x5a)
		{
			break;
			ret = -1;
		}
        cnt++;
		if(cnt%2000000 == 0)
		{
			if(state==0)
			{
				zDrvGpio_SetOutputValue(GPIO32,GPIO_HIGH);
				state = 1;
			}
			else
			{
				zDrvGpio_SetOutputValue(GPIO32,GPIO_LOW);
				state = 0;
			}
		}
	}		
	if(test_count != (unsigned char *)DDR_END)
	{	
		printf("test ddr faile\n");
		ret = -1;
	}
	else
	{
		printf("test ddr success\n");
	}
	
	if(ret == -1)
	{
		zDrvGpio_SetOutputValue(GPIO70,GPIO_HIGH);
		while(1);
	}
	return 0;
}

U_BOOT_CMD(
	test_ddr, CONFIG_SYS_MAXARGS, 0, do_test_ddr,
	"test_ddr: test_ddr ",
	""
);

#endif

