/*
 * (C) Copyright 2016, ZIXC Corporation.
 *
 */

#ifndef __BOOT_CHARGE__
#define __BOOT_CHARGE__

#include "common.h"

enum charger_current
{
	CHG_CURRENT_100 	= 0,	 // 000  IUSB3 IUSB2 IUSB1
	CHG_CURRENT_500 	= 1, 	 // 001
	CHG_CURRENT_1500,		     // 010
	CHG_CURRENT_USB_SUSPEND,     // 011
	CHG_CURRENT_150,		     // 100
	CHG_CURRENT_900,		     // 101
	CHG_CURRENT_800,		     // 110
	CHG_CURRENT_HIGH_IMPEDANCE,  // 111
	MAX_CURRENT_SET              /* 12 */
};

enum charger_mode
{
	CHG_MODE_NORMAL	= 0,
	CHG_MODE_HALF_CURRENT,	//
	CHG_MODE_VBAT_4_06,		//
	CHG_MODE_SUSPENDED,
	MAX_CHG_MODE
};


int low_battery_charging(uint32_t *is_start);
int power_off_battery_charging(void);

//жϵǰǷڳ
int charger_is_sustained(void);

//óС
int32_t	charger_set_usb_current(enum charger_current cur);

//óģʽ
int32_t	set_charger_mod(enum charger_mode mode);

//жϵǰǷPC USB   Ƿ
int detect_usb_online(void);

//ʼоƬ趨С
void usb_charger_init(void);

//ͣ
void usb_charger_suspend(void);



#endif	/* __BOOT_CHARGE__ */
