
#ifndef _ZLIB_H
#define _ZLIB_H

#include "zconf.h"

#ifdef __cplusplus
extern "C" {
#endif

#define ZLIB_VERSION "1.1.4"

#ifdef QT_MAKEDLL
//#define  Q_ZEXPORT __declspec(dllexport)//liuchunhua gzip
#else
#if defined(QT_DLL) && !defined(QT_PLUGIN)
//#define  Q_ZEXPORT __declspec(dllimport)//liuchunhua gzip
#else
//#define Q_ZEXPORT  ZEXPORT//liuchunhua gzip
#endif
#endif
#ifdef Q_OS_TEMP
#include <qfunctions_wce.h>
#endif

typedef voidpf (*alloc_func) OF((voidpf opaque, uInt items, uInt size));
typedef void   (*free_func)  OF((voidpf opaque, voidpf address));

struct internal_state;

typedef struct z_stream_s {
    Bytef    *next_in;  /* next input byte */
    uInt     avail_in;  /* number of bytes available at next_in */
    uLong    total_in;  /* total nb of input bytes read so far */

    Bytef    *next_out; /* next output byte should be put there */
    uInt     avail_out; /* remaining free space at next_out */
    uLong    total_out; /* total nb of bytes output so far */

    char     *msg;      /* last error message, NULL if no error */
    struct internal_state FAR *state; /* not visible by applications */

    alloc_func zalloc;  /* used to allocate the internal state */
    free_func  zfree;   /* used to free the internal state */
    voidpf     opaque;  /* private data object passed to zalloc and zfree */

    int     data_type;  /* best guess about the data type: ascii or binary */
    uLong   adler;      /* adler32 value of the uncompressed data */
    uLong   reserved;   /* reserved for future use */
} z_stream;

typedef z_stream FAR *z_streamp;


                        /* constants */

#define Z_NO_FLUSH      0
#define Z_PARTIAL_FLUSH 1 /* will be removed, use Z_SYNC_FLUSH instead */
#define Z_SYNC_FLUSH    2
#define Z_FULL_FLUSH    3
#define Z_FINISH        4
/* Allowed flush values; see deflate() below for details */

#define Z_OK            0
#define Z_STREAM_END    1
#define Z_NEED_DICT     2
#define Z_ERRNO        (-1)
#define Z_STREAM_ERROR (-2)
#define Z_DATA_ERROR   (-3)
#define Z_MEM_ERROR    (-4)
#define Z_BUF_ERROR    (-5)
#define Z_VERSION_ERROR (-6)
/* Return codes for the compression/decompression functions. Negative
 * values are errors, positive values are used for special but normal events.
 */

#define Z_NO_COMPRESSION         0
#define Z_BEST_SPEED             1
#define Z_BEST_COMPRESSION       9
#define Z_DEFAULT_COMPRESSION  (-1)
/* compression levels */

#define Z_FILTERED            1
#define Z_HUFFMAN_ONLY        2
#define Z_DEFAULT_STRATEGY    0
/* compression strategy; see deflateInit2() below for details */

#define Z_BINARY   0
#define Z_ASCII    1
#define Z_UNKNOWN  2
/* Possible values of the data_type field */

#define Z_DEFLATED   8
/* The deflate compression method (the only one supported in this version) */

#define Z_NULL  0  /* for initializing zalloc, zfree, opaque */

#define zlib_version zlibVersion()
/* for compatibility with versions < 1.0.2 */

                        /* basic functions */

ZEXTERN   const char * zlibVersion OF((void));

ZEXTERN int   deflate OF((z_streamp strm, int flush));

ZEXTERN int   deflateEnd OF((z_streamp strm));

ZEXTERN int   inflate OF((z_streamp strm, int flush));

ZEXTERN int   inflateEnd OF((z_streamp strm));
                            
ZEXTERN int   deflateSetDictionary OF((z_streamp strm,
                                             const Bytef *dictionary,
                                             uInt  dictLength));

ZEXTERN int   deflateCopy OF((z_streamp dest,
                                    z_streamp source));

ZEXTERN int   deflateReset OF((z_streamp strm));

ZEXTERN int   deflateParams OF((z_streamp strm,
				      int level,
				      int strategy));

ZEXTERN int   inflateSetDictionary OF((z_streamp strm,
                                             const Bytef *dictionary,
                                             uInt  dictLength));

ZEXTERN int   inflateSync OF((z_streamp strm));

ZEXTERN int   inflateReset OF((z_streamp strm));

ZEXTERN int   compress OF((Bytef *dest,   uLongf *destLen,
                                 const Bytef *source, uLong sourceLen));

ZEXTERN int   compress2 OF((Bytef *dest,   uLongf *destLen,
                                  const Bytef *source, uLong sourceLen,
                                  int level));

ZEXTERN int   uncompress OF((Bytef *dest,   uLongf *destLen,
                                   const Bytef *source, uLong sourceLen));

typedef voidp gzFile;

ZEXTERN gzFile   gzopen  OF((const char *path, const char *mode));

ZEXTERN gzFile   gzdopen  OF((int fd, const char *mode));

ZEXTERN int   gzsetparams OF((gzFile file, int level, int strategy));

ZEXTERN int    gzread  OF((gzFile file, voidp buf, unsigned len));

ZEXTERN int      gzwrite OF((gzFile file, 
				   const voidp buf, unsigned len));
/*
     Writes the given number of uncompressed bytes into the compressed file.
   gzwrite returns the number of uncompressed bytes actually written
   (0 in case of error).
*/

ZEXTERN int ZEXPORTVA   gzprintf OF((gzFile file, const char *format, ...));

ZEXTERN int   gzputs OF((gzFile file, const char *s));

ZEXTERN   char *gzgets OF((gzFile file, char *buf, int len));

ZEXTERN int      gzputc OF((gzFile file, int c));

ZEXTERN int      gzgetc OF((gzFile file));


ZEXTERN int      gzflush OF((gzFile file, int flush));

ZEXTERN z_off_t      gzseek OF((gzFile file,
				      z_off_t offset, int whence));

ZEXTERN int      gzrewind OF((gzFile file));

ZEXTERN z_off_t      gztell OF((gzFile file));

ZEXTERN int   gzeof OF((gzFile file));
/*
     Returns 1 when EOF has previously been detected reading the given
   input stream, otherwise zero.
*/

ZEXTERN int    gzclose OF((gzFile file));
/*
     Flushes all pending output if necessary, closes the compressed file
   and deallocates all the (de)compression state. The return value is the zlib
   error number (see function gzerror below).
*/

ZEXTERN   const char *gzerror OF((gzFile file, int *errnum));

ZEXTERN uLong   adler32 OF((uLong adler, const Bytef *buf, uInt len));


ZEXTERN uLong   crc32   OF((uLong crc, const Bytef *buf, uInt len));

ZEXTERN int   deflateInit_ OF((z_streamp strm, int level,
                                     const char *version, int stream_size));
ZEXTERN int   inflateInit_ OF((z_streamp strm,
                                     const char *version, int stream_size));
ZEXTERN int   deflateInit2_ OF((z_streamp strm, int  level, int  method,
                                      int windowBits, int memLevel,
                                      int strategy, const char *version,
                                      int stream_size));
ZEXTERN int   inflateInit2_ OF((z_streamp strm, int  windowBits,
                                      const char *version, int stream_size));
#define deflateInit(strm, level) \
        deflateInit_((strm), (level),       ZLIB_VERSION, sizeof(z_stream))
#define inflateInit(strm) \
        inflateInit_((strm),                ZLIB_VERSION, sizeof(z_stream))
#define deflateInit2(strm, level, method, windowBits, memLevel, strategy) \
        deflateInit2_((strm),(level),(method),(windowBits),(memLevel),\
                      (strategy),           ZLIB_VERSION, sizeof(z_stream))
#define inflateInit2(strm, windowBits) \
        inflateInit2_((strm), (windowBits), ZLIB_VERSION, sizeof(z_stream))


#if !defined(_Z_UTIL_H) && !defined(NO_DUMMY_DECL)
    struct internal_state {int dummy;}; /* hack for buggy compilers */
#endif

ZEXTERN   const char   * zError           OF((int err));
ZEXTERN int              inflateSyncPoint OF((z_streamp z));
ZEXTERN   const uLongf *get_crc_table    OF((void));

#ifdef __cplusplus
}
#endif

#endif /* _ZLIB_H */
