#ifndef _ZCORE_EDIT_IMPL_H_
#define _ZCORE_EDIT_IMPL_H_
#include "zcore_type.h"
#ifdef  __cplusplus
extern  "C" {
#endif
/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include "text.h"

/**************************************************************************
 *                                                                    *
 **************************************************************************/
#ifdef _FLAT_WINDOW_STYLE
#define WIDTH_EDIT_BORDER      1
#else
#define WIDTH_EDIT_BORDER      2
#endif

#define MARGIN_EDIT_LEFT       1
#define MARGIN_EDIT_TOP        1
#define MARGIN_EDIT_RIGHT      2
#define MARGIN_EDIT_BOTTOM     1

#define EST_FOCUSED     0x00000001L
#define EST_MODIFY      0x00000002L
#define EST_TMP         0x00000004L
#define EST_REPLACE     	0x00000008L
#define EST_PWD         	0x00000010L
#define EST_MOUSELONGPRESS  0x00000020L

#define EDIT_OP_NONE    	0x00
#define EDIT_OP_DELETE  	0x01
#define EDIT_OP_INSERT  	0x02
#define EDIT_OP_REPLACE 0x03

                                               
#define EDIT_HITHSCROLL_WIDTH 	25
#define EDIT_HITHSCROLL_INTER 	0

#define DEF_LINE_BUFFER_SIZE    128
#define DEF_LINE_BLOCK_SIZE     32
#define DEF_TIP_LEN             63

#define LEN_SLEDIT_UNDOBUFFER   256

/**************************************************************************
 *                                                                 *
 **************************************************************************/
typedef enum
{
    ES_HITHSCROLL_NONE = 0,
	ES_HITHSCROLL_LEFT, 
	ES_HITHSCROLL_RIGHT, 
} HitHScrollDir;

typedef struct tagHitHScrollData
{
   	BITMAP* 		left_arrow_bitmap;
    BITMAP* 		left_arrow_bitmap_hit;
    BITMAP* 		right_arrow_bitmap;
    BITMAP* 		right_arrow_bitmap_hit;
    ZSINT32 		hit_h_arrow_width;/*ͷ*/
    ZSINT32 		hit_h_arrow_inter;/*ͷ ĬΪ 0*/
}HitHScrollData;

typedef struct tagSLEDITDATA
{   
	ZDWORD	 		status;	
	ZSINT32			editPos;/* ǰֽλãıֱֽϣԵһַΪֽڼ*/
	ZSINT32			selStart;/*ѡıʼֽλãͬeditPos*/
	ZSINT32			selEnd;	/* ѡıĽֽλãͬeditPos*/

	ZSINT32     	leftMargin;     
	ZSINT32     	topMargin;      
	ZSINT32     	rightMargin;    
	ZSINT32     	bottomMargin;   

	ZSINT32			nContX;/*ıĵһַΪ㣬һַX*/
						/*һһַΪһȣΪλ*/
						/*һַĿǰΪ16ؿַֽΪ8ؿ	*/
	ZSINT32			nContW;/* ıӵһַһַ֮ȣΪλ*/

	RECT 	 		rcVis;/*ıʾıɼȥұ߿հ,Ϊλ*/
	ZSINT32			nVisW;/* ıݵıɼ,Ϊλ*/
							/*(ؼʱĿȥұ߿հ׿ȺĿ)*/

	ZSINT32			startx;/* ıɼģıһַʼX*/
	ZSINT32			starty;/* ıɼģıһַʼY*/
	   
	StrBuffer 		content;/* ı buffer   */
	ZSINT32			curCharLen;/*ıǰַ*/
	ZSINT32    		hardLimit;/* ıֽ*/
	ZSINT32			charLimit;/*ıַ*/
	ZSINT32      limitMode;/*ģʽ*/
	ZSINT32 		nBlockSize;   
    gal_pixel   	unFocusSelBkColor;
    gal_pixel   	FocusSelBkColor;
	
	ZSINT32     	passwdChar;/* 滻ַĬΪ'*'*/
	ZSINT32     	input_chars_len;				
	ZBOOL     		have_paint_rawpasswd;/*ǷѾתַ*:TRUEʾǰΪֱӰıʶFALSEΪĺıʶ*/

	ZSINT32     	changed;          	
	ZBOOL 			is_hitting;
	BITMAP* 		left_arrow_bitmap_hit;
	BITMAP* 		left_arrow_bitmap;
	ZBOOL 			is_left_visible;
	BITMAP* 		right_arrow_bitmap_hit;
	BITMAP* 		right_arrow_bitmap;
	ZBOOL			is_right_visible;
	HitHScrollDir 	scroll_dir;
	ZSINT32 		hit_h_arrow_width;
	ZSINT32 		hit_h_arrow_inter;
}SLEDITDATA;
typedef SLEDITDATA* PSLEDITDATA;

/**************************************************************************
 *                         ȫֱ                                    *
 **************************************************************************/
 /**************************************************************************
 *                        ȫֺԭ                                     *
 **************************************************************************/
/**
 * ƣ RegisterSLEditControl
 *  עؼ
 * ˵ 
 *   ֵ 0
 * ˵ 
 */
ZBOOL RegisterSLEditControl (ZVOID);

/**
 * ƣ SLEditControlCleanup
 *  ٿؼ
 * ˵ 
 *   ֵ 0
 * ˵ ˽ӿûʵ
 */
ZVOID SLEditControlCleanup (ZVOID);

#ifdef __cplusplus
}
#endif

#endif /* _ZCORE_EDIT_IMPL_H_ */

