#ifndef _ZCORE_CTRL_SCROLLED_H_
#define _ZCORE_CTRL_SCROLLED_H_
#include "zcore_type.h"
#include "ctrl/ctrlhelper.h"
#ifdef __cplusplus
extern "C"
{
#endif


/* default size and position values */
#define HSCROLL                 5   // h scroll value
#define VSCROLL                 15  // v scroll value

typedef struct _scrdata
{
    ZUINT16 hScrollVal;
    ZUINT16 vScrollVal;
    ZUINT16 hScrollPageVal;
    ZUINT16 vScrollPageVal;

    /* scroll offset */
    ZSINT32 nContX;
    ZSINT32 nContY;
    
    /* content range */
    ZSINT32 nContWidth;
    ZSINT32 nContHeight;
    
    /* visible content range */
    ZUINT16 visibleWidth;
    ZUINT16 visibleHeight;

    /* content margins */
    ZUINT16 leftMargin;
    ZUINT16 topMargin;
    ZUINT16 rightMargin;
    ZUINT16 bottomMargin;

    HWND hSV;

    /* scrollbar mode */
    SBPolicyType sbPolicy;

    ZVOID (*move_content)(HWND, struct _scrdata *, ZBOOL);
    /* ıߴС͹ıݹܷ */
    ZVOID (*size_changed)(HWND, struct _scrdata *, ZBOOL);

    ZSINT32 iNeedNotifyPaint;
    ZSINT32  oldnContY;

    ZSINT32 real_height;
} SCRDATA;
typedef SCRDATA *PSCRDATA;

HWND scrolled_create_vscrollbar(HWND hWnd, PSCRDATA pscrdata);
ZBOOL scrolled_pt_in_scrollbar(HWND hWnd, ZSINT32 x, ZSINT32 y);
ZSINT32     DefaultScrolledProc (HWND hWnd, ZSINT32 message, WPARAM wParam, LPARAM lParam);
ZSINT32     scrolled_init (HWND hWnd, PSCRDATA pscrdata, ZSINT32 w, ZSINT32 h);
ZSINT32     scrolled_set_cont_height (HWND hWnd, PSCRDATA pscrdata, ZSINT32 cont_h);
ZSINT32     scrolled_set_cont_width (HWND hWnd, PSCRDATA pscrdata, ZSINT32 cont_w);
ZSINT32     scrolled_set_hscrollinfo (HWND hWnd, PSCRDATA pscrdata);
ZSINT32     scrolled_set_vscrollinfo (HWND hWnd, PSCRDATA pscrdata);
ZSINT32  scrolled_content_to_visible (PSCRDATA pscrdata, ZSINT32 *x, ZSINT32 *y);
ZSINT32  scrolled_visible_to_content (PSCRDATA pscrdata, ZSINT32 *x, ZSINT32 *y);
ZSINT32  scrolled_visible_to_window (PSCRDATA pscrdata, ZSINT32 *x, ZSINT32 *y);
ZSINT32  scrolled_window_to_visible (PSCRDATA pscrdata, ZSINT32 *x, ZSINT32 *y);
ZVOID    scrolled_content_to_window (PSCRDATA pscrdata, ZSINT32 *x, ZSINT32 *y);
ZVOID    scrolled_window_to_content (PSCRDATA pscrdata, ZSINT32 *x, ZSINT32 *y);
ZVOID    scrolled_init_contsize (HWND hWnd, PSCRDATA pscrdata);
ZVOID    scrolled_hscroll (HWND hWnd, PSCRDATA pscrdata, WPARAM wParam, LPARAM lParam);
ZVOID    scrolled_vscroll (HWND hWnd, PSCRDATA pscrdata, WPARAM wParam, LPARAM lParam);
ZVOID    scrolled_set_visible (HWND hWnd, PSCRDATA pscrdata);
ZVOID    scrolled_recalc_areas (HWND hWnd, PSCRDATA pscrdata, ZSINT32 new_w, ZSINT32 new_h);
ZVOID    scrolled_init_margins (PSCRDATA pscrdata, ZSINT32 left, ZSINT32 top,
                               ZSINT32 right, ZSINT32 bottom);
ZVOID    scrolled_refresh_rect (PSCRDATA pscrdata, RECT *rc);
ZVOID    scrolled_set_margins (PSCRDATA pscrdata, RECT *rc);
ZVOID    scrolled_set_scrollval (PSCRDATA pscrdata, ZSINT32 hval, ZSINT32 vval);
ZVOID    scrolled_set_scrollpageval (PSCRDATA pscrdata, ZSINT32 hval, ZSINT32 vval);
ZVOID    scrolled_destroy (PSCRDATA pscrdata);

ZBOOL  scrolled_set_cont_pos (HWND hWnd, PSCRDATA pscrdata, ZSINT32 cont_x, ZSINT32 cont_y);
ZBOOL  scrolled_make_pos_visible (HWND hWnd, PSCRDATA pscrdata, ZSINT32 pos_x, ZSINT32 pos_y);

ZSINT32   scrolled_get_contwidth (PSCRDATA pscrdata);
ZVOID scrolled_get_content_rect (PSCRDATA pscrdata, RECT *rc);
ZVOID scrolled_get_margins (PSCRDATA pscrdata, RECT *rc);
ZVOID scrolled_get_visible_rect (PSCRDATA pscrdata, RECT *rcVis);
ZVOID scrolled_set_content(HWND hWnd, PSCRDATA pscrdata, ZBOOL visChanged);
ZVOID scrolled_size_changed(HWND hWnd, PSCRDATA pscrdata, ZBOOL visChanged);
ZVOID scrolled_refresh_content (PSCRDATA pscrdata);
ZBOOL scrolled_is_pos_visible (PSCRDATA pscrdata, ZSINT32 x, ZSINT32 y);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif  /* _ZCORE_CTRL_SCROLLED_H_*/

