#ifndef _ZCORE_CTRL_TEXTEDIT_IMPL_H_
#define _ZCORE_CTRL_TEXTEDIT_IMPL_H_

#ifdef __cplusplus
extern "C"
{
#endif
/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
 #include "zcore_type.h"
#include "zcore_type.h"
#include "text.h"
#include "list.h"
#include "scrollview_impl.h"
#include "GuiTool_mem.h"

/**************************************************************************
 *                         궨                                         *
 **************************************************************************/
/* ---------------------- configuration options ----------------------- */
#ifndef _SELECT_SUPPORT
/* supports text selection */
#define _SELECT_SUPPORT
#endif

/* support title text */
#define _TITLE_SUPPORT          1

#define TES_BASELINE            ES_BASELINE
#define TES_AUTOWRAP            ES_AUTOWRAP
#define TES_TITLE               ES_TITLE

#define	CURSOR_DOWN             1
#define	CURSOR_UP               -1
/**************************************************************************
 *                                                                    *
 **************************************************************************/
//#define WORD_MAX 64

#define DEF_LINE_BASE_H         ( (GetWindowStyle(hWnd) & TES_BASELINE) ? 2 : 1 )
#define MIN_LINE_BASE_H         0
#define DEF_LINE_ABOVE_H        4
#define MIN_LINE_ABOVE_H        1
#define DEF_LINE_HEIGHT         ( GetWindowFont(hWnd)->size + DEF_LINE_BASE_H + \
                                 DEF_LINE_ABOVE_H )
#define DEF_LINE_BUFFER_SIZE    128
#define DEF_LINE_BLOCK_SIZE     32

#define DEF_LINESEP             '\n'
#define CH_RN                   "\r\n"

#define DEF_TITLE_LEN           63

#define TE_FORMAT  (DT_LEFT | DT_TOP | DT_NOCLIP | DT_EXPANDTABS) 

/* -------------------------------------------------------------------- */

/* internal status flags */
#define TEST_SELECT     0x0001
#define TEST_FOCUSED    0x0002
#define TEST_TMP        0x0004
#define TEST_REPLACE    0x0008
#define TEST_MOVE       0x0010
#define TEST_NOCARET    0x0020
#define TEST_EX_SETFOCUS   0x0040
#define TEST_EX_KILLFOCUS  0x0080
#define TEXTEDIT_FLG_BUTTONDOWN  0x0100
#define TEST_MOUSELONGPRESS 0x0200
#define TEST_TEXT_SELECTED  0x0400
#define TEST_THUMBTOUCH     0x0800

/**************************************************************************
 *                                                                *
 **************************************************************************/
	
typedef ZSINT32 (*ED_DRAWSEL_FUNC) (HWND, HDC, ZSINT32, ZSINT32, const ZCHAR*, ZSINT32, ZSINT32);

/* content type, reserved */
typedef enum
{
    CT_TEXT,
    CT_BMP,
    CT_ICON
} ContentType;

/* text format, reserved */
typedef enum 
{
    TF_PLAINTEXT,
    TF_RICHTEXT,
    TF_MEDIATEXT
} TextFormat;

typedef struct _textnode
{
    list_t    list;
    StrBuffer content;
    ZDWORD    addData;
    ZSINT32   curNodeCharLen;
} TextNode;

typedef struct _textmark
{
    ZSINT32    pos_lnOff;
    TextNode  *curNode;
} TextMark;

typedef struct _textdoc
{
    list_t    queue;       /* text line/node head */
    ZUINT8 lnsep;
    ZSINT32  nDefLineSize;
    ZSINT32  nBlockSize;
	ZBOOL         IsMaxLen;/*ıǷﵽ󳤶*/
    TextMark  insert;      /* cursor/insertion mark */
#ifdef _SELECT_SUPPORT
    TextMark  selection;   /* selection mark */
#endif

    /* ***********function field************ */
    ZVOID      (*init_fn)     (struct _textdoc *, TextNode *, TextNode *);
    ZVOID      (*change_fn)   (struct _textdoc *, ZBOOL bSel);
    ZVOID      (*change_cont) (struct _textdoc *, TextNode *node);
    ZVOID      (*del_fn)      (struct _textdoc *, TextNode *);
    ZVOID       *fn_data;
} TextDoc;

/* structure of textedit control data */
typedef struct _tedata
{
    /* ----------------- members ------------------- */
    SVDATA    svdata;       /* scrollview object */
    TextDoc   txtdoc;       /* text document object */

    StrBuffer tebuff;       /* temp text content */
    ZSINT32       nr_diff_line; /*first different line*/
    ZSINT32       w_nochanged; /*width not changed of first different line*/
    ZSINT32       w_lastline;  /* width of last line*/
    ZSINT32       hardLimit;    /* hard limit */
    ZSINT32       charLimit;    /* char limit */
    ZSINT32       curlen;       /* current tedata's len, not include char '\n' */
    ZSINT32       curCharlen;   /* current char's len, not include char '\n' */
	ZSINT32		  limitMode;   /*ıģʽ*/
    /* ----------------- properties ------------------- */

    ZSINT32       nLineHeight;  /* line height */
    ZSINT32       nLineAboveH;  /* height of above-line area */
    ZSINT32       nLineBaseH;   /* height of base-line area */
    ZUINT8 lnChar;   /* the char used to represent line seperator */
    ZUINT8 caretShape; /* shape of the caret */

    /* ----------------- status ----------------------- */
    ZDWORD     flags;        /* editor status */
    ZDWORD     ex_flags;     /* editor extends status */
    ZBOOL      cont_dirty;   /*content changed flags in text field*/

    ZSINT32       des_caret_x;  /* the destination caret x position, changed by mouse and <- , -> */

    ZSINT32       caret_x;      /* caret x position in the virtual content window */
    ZSINT32       caret_y;      /* caret y position in the virtual content window */
#ifdef _SELECT_SUPPORT
    ZSINT32       sel_x;        /* selection point x position in the virtual content window */
    ZSINT32       sel_y;        /* selection point y position in the virtual content window */
#endif
    TextNode  *maxNode;     /* node with the max length */
    ZSINT32       maxLen;   /* max line length */
    TextNode  *secNode;     /* node with the second max length */
    ZSINT32       secLen;       /* seconde max line length */

    ZSINT32       curItemY;     /* y position of the current insertion node */
#ifdef _SELECT_SUPPORT
    ZSINT32       selItemY;     /* y position of the selection node */
#endif
    ED_DRAWSEL_FUNC drawSelected;

    ZSINT32       (*getCaretWidth) (HWND hWnd, ZSINT32 def_width);

    scrollbar_pic_data    scroll_data;  /*the picture data of scrollbar*/
    gal_pixel   unFocusSelBkColor;
    gal_pixel   FocusSelBkColor;

    POINT pFirstPos;
} TEDATA;
typedef TEDATA* PTEDATA;

typedef struct _TEPARADATA
{
    HWND      hWnd;         /* the handle of the current window */
	PTEDATA   ptedata;      /* textedit control data */
	TextDoc   *txtdoc;      /* text document data */
	TextNode  *node;        /* structure of text node/line */
	TextMark  *mark;        /* structure of a text mark */

	HDC       hDC;          /* the HDC handle of current window */
	const ZCHAR* text;       /* the text used in the node*/    
	ZSINT32       indent;       /* indent of the text */
	ZSINT32       caret_x;      /* X position of caret */
	ZSINT32       caret_y;      /* Y position of caret */
} TEPARADATA;
typedef TEPARADATA* PTEPARADATA;

/**************************************************************************
 *                                                                  *
 **************************************************************************/
#define ptescr          (&(ptexteditdata->svdata.scrdata))

#define check_caret() \
            if (txtdoc->selection.curNode) \
            { \
                if (txtdoc->selection.curNode == txtdoc->insert.curNode && \
                      txtdoc->selection.pos_lnOff == txtdoc->insert.pos_lnOff) \
                    { \
                        ShowCaret (hWnd); \
                        txtdoc->selection.curNode = NULL; \
                    } \
                else \
                    HideCaret (hWnd); \
            } \
            else \
                ShowCaret (hWnd);

#define BE_WRAP(hWnd)     (GetWindowStyle(hWnd) & TES_AUTOWRAP)
#define BE_READONLY(hWnd) (GetWindowStyle(hWnd) & ES_READONLY)
#define BE_DISABLED(hWnd) (GetWindowStyle(hWnd) & WS_DISABLED)

#define CALC_LINE(newLine,newtxtlen,newfl) \
             DrawTextEx2 (hdc, (const ZCHAR*)newLine, newtxtlen, &rc, indent, \
				          TE_FORMAT | DT_WORDBREAK | DT_CALCRECT, &newfl); \
             if((newfl).iCharsNum <= 0) \
                  break; 

#define LOOP_CONTINUE(lineidx,newLine,newtxtlen,newfl) \
	    newLine += newfl.iCharsNum; \
	    newtxtlen -= newfl.iCharsNum; \
        lineidx ++;

#define BE_FIRST_NODE(node) \
           (node->list.prev == &txtdoc->queue)

#define BE_LAST_NODE(node) \
           (node->list.next == &txtdoc->queue)

#define FIRSTNODE(txtdoc) \
           (list_entry((txtdoc)->queue.next, TextNode, list))
#define LASTNODE(txtdoc) \
           (list_entry((txtdoc)->queue.prev, TextNode, list))

#define NODE_LINENR(node) \
        ( scrollview_get_item_height((HSVITEM)(node)->addData) / ptexteditdata->nLineHeight )

#define NODE_HEIGHT(node) \
        (scrollview_get_item_height((HSVITEM)(node)->addData))

#define NODE_INDEX(node) \
        (scrollview_get_item_index(hWnd, (HSVITEM)(node)->addData))

#define TXTNODE_NEXT(node) \
            ( ((node)->list.next == &txtdoc->queue) ? NULL : \
                list_entry((node)->list.next, TextNode, list) )

#define TXTNODE_PREV(node) \
            ( ((node)->list.prev == &txtdoc->queue) ? NULL : \
                list_entry((node)->list.prev, TextNode, list) )

#define myGetCaretPos(pt)  \
            ( (pt)->x = ptexteditdata->caret_x, \
              (pt)->y = ptexteditdata->caret_y )

#define myGetSelPos(pt) \
            ( (pt)->x = ptexteditdata->sel_x, \
              (pt)->y = ptexteditdata->sel_y )
#define mySetSelPos(x, y) \
        ( ptexteditdata->sel_x = x >= 0 ? x : ptexteditdata->sel_x, \
          ptexteditdata->sel_y = y >= 0 ? y : ptexteditdata->sel_y )

#define is_rn_sep(pIns) (txtdoc->lnsep == '\n' && *(pIns) == '\r' && *(pIns+1) == '\n')


#define REFRESH_NODE_EX(node, rcInv) \
            scrollview_refresh_item_ex(&ptexteditdata->svdata, \
                    (HSVITEM)(node)->addData, rcInv)

#define REFRESH_NODE(node) \
            scrollview_refresh_item(&ptexteditdata->svdata, (HSVITEM)(node)->addData)


#define GETMARK(cond)     ( (cond) ? (&txtdoc->selection) : \
                                  (&txtdoc->insert) )
#define SETITEMY(cond, item_y)    \
            if (cond) \
                ptexteditdata->selItemY = item_y; \
            else \
                ptexteditdata->curItemY = item_y;

#else
    #define GETMARK(cond)     ((cond)? NULL : &txtdoc->insert)
    #define SETITEMY(cond, item_y)    \
                if (!cond) \
                    ptexteditdata->curItemY = item_y;
#endif

/**************************************************************************
 *                         ȫֺ                                    *
 **************************************************************************/
ZSINT32  textedit_get_caretpos    (HWND hWnd, ZSINT32 *line_pos, ZSINT32 *char_pos);
ZSINT32  textedit_get_selpos      (HWND hWnd, ZSINT32 *line_pos, ZSINT32 *char_pos);


/**************************************************************************
*                        ȫֺԭ                                     *
**************************************************************************/
/**/

#ifdef __cplusplus
}
#endif  /* __cplusplus */

