#ifndef _EFFECT_WAVE_H
#define _EFFECT_WAVE_H

#include "zcore_type.h"
#include "EffectEngine.h"

#define DEFAULT_DAMP_FACTOR 3
#define DEFAULT_FRAME_RATE 2
#define DEFAULT_MOVE_BITS 2

#define MAX_DAMP_FACTOR 9
#define MIN_DAMP_FACTOR 1

#define MAX_FRAME_RATE 9
#define MIN_FRAME_RATE 1

#define MAX_MOVE_BITS 9
#define MIN_MOVE_BITS 0

#define STONE_RADIUS_MAX (50) //be sure change this two macros at the same time
#define STONE_RADIUS_SQUARE_MAX (2500)

typedef struct IWaveEffectInfo IWaveEffectInfo;

typedef enum 
{
    WAVE_READY = 0,
	WAVE_RUN,
	WAVE_PAUSE,
	WAVE_STOPPED
}WaveState;

typedef enum
{
    DAMP_FACTOR = 0,
	FRAME_RATE  ,
	STONE_STYLE ,
	MOVE_BITS,
	SWITCH_DAMP
}EProperty;

typedef enum
{
    LITTLE_STONE = 0,
	RUBBER_STONE,
	SMASH_STONE,
	RECTANGLE_STONE
}StoneStyle;
/*****************************************************************************
 *	  	EngineWaveEffectRender
 *	    	һ֡ˮͼ
 *		pEngineData:ݡpInstance:ʵ
 *		
 *	  ֵ	ENGINE_SUCCESS_BUT_DONT_REFRESH: ֡ȥˢĻ
 				  ENGINE_SUCCESS:				   ֡ҪˢĻ
 *	˵	
 *****************************************************************************/
EngineResult EngineWaveEffectRender(EngineData *pData,EngineInstance *pInstance);

/*****************************************************************************
 *	  	EngineWaveEffectRender
 *	    	
 *		pEngineData:
 *		
 *	  ֵ	ENGINE_SUCCESS  ɹ
  ENGINE_INVALID_PARAǷ
 *	˵	
 *****************************************************************************/
EngineResult EngineResetEnergyArray(EngineData *pData);

/*****************************************************************************
 *	  	EngineWaveEffectDestroy
 *	    	ˮЧ
 *		pEngineData:
 *		
 *	  ֵ	EngineResult
 *	˵	EngineWaveEffectInitɶԵãڴй©
 *****************************************************************************/
EngineResult EngineWaveEffectDestroy(EngineData *pEngineData);

/*****************************************************************************
 *	  	EngineWaveEffectInit
 *	    	ˮЧʼ
 *		pEngineData:ݡpInstance:ʵ
 *		
 *	  ֵ	EngineResult
 *	˵	
 *****************************************************************************/
EngineResult EngineWaveEffectInit(EngineData *pEngineData,EngineInstance *pInstance);

/*****************************************************************************
 *	  	EngineGetWaveState
 *	    	ȡǰε״̬
 *		pEngineData:
 *		pWaveState:
 *	  ֵ	Ƿɹ
 *	˵	
 *****************************************************************************/
EngineResult EngineGetWaveState(EngineData *pData,WaveState *pWaveState);

/*****************************************************************************
 *	  	EngineWaveEffectThrowStone
 *	    	ͶʯˮָλͶʯ
 *		x[in]           ͶʯĻԭx
                  y[in]           ͶʯĻԭy
radius[in]    ʯͷ뾶
height[in]      ʯͷ
                pData ָ
 *		
 *	  ֵ	Ƿɹ
 *	˵	
 *****************************************************************************/
EngineResult EngineWaveEffectThrowStone(EngineData *pData, ZSINT32 x,ZSINT32 y,ZSINT32 radius,ZSINT32 height);

/*****************************************************************************
 *	  	EngineWaveEffectSetProperty
 *	    	ˮ
 *		pEngineData:Чָ롡eParam:һԡnParam:ֵ
 *		
 *	  ֵ	Ƿɹ
 *	˵	
 *****************************************************************************/
EngineResult EngineWaveEffectSetProperty(EngineData *pEngineData,EProperty eParam ,ZUINT32 nParam);

#endif

