#ifndef _EFFECT_ZOOM_H
#define _EFFECT_ZOOM_H

#ifdef __cplusplus
extern "C"
{
#endif

/*******************************************************************************
*                                      ͷļ
*******************************************************************************/	
#include "EffectEngine.h"
#include "zcore_type.h"

/*******************************************************************************
*                                      
*******************************************************************************/
#define MAX_ZOOM_ALPHA (256)          // ALPHAֵ
#define MIN_ZOOM_ALPHA (64)          // СALPHAֵ

/*******************************************************************************
*                                      ݽṹ
*******************************************************************************/
typedef struct{
    EngineRect rect;
    ZSINT32 Alpha;
}T_ZoomRouteStation;    // ŵĵվϢ

typedef enum
{
    EFFECT_ZOOM_IN,
    EFFECT_ZOOM_OUT
}T_ZoomType;

typedef enum
{
    E_ZOOM_ATTACH_FADE,
    E_ZOOM_ATTACH_ICON_FLY,

    E_ZOOM_ATTACH_MAX
}E_ZOOMATTACH;

typedef struct
{
    EngineBool bIconFly;                    // zoomicon
    EngineBool bAlpha;                      // ǷҪ͸
    EngineRect restrict;                    // Լ
    EngineRect window;                      // Ч
    T_ZoomType zoomType;                    // ⣬
    ZSINT32 stepsTotal;                         // 
    T_ZoomRouteStation startStation;        // ʼվ
    T_ZoomRouteStation endStation;          // վ
    T_ZoomRouteStation *pRouteStation;      // ˶·վϢ
}T_ZoomRouteNature; // ·Ϣ

typedef struct
{
    ZCHAR *pSrc;             // Դ
    ZCHAR *pDst;             // Ŀ껭
    ZCHAR *pInstance;        // Դʵ
    ZSINT32 bpp;                // ÿֽ
    ZSINT32 pitch;              // ÿռֽ
    ZSINT32 width;              // 
    ZSINT32 height;             // ߶
}T_ZoomImageInfo; // ͼϢ

typedef struct
{           
    // Ϣ
    T_ZoomRouteNature routeNature;

    // Ϣ
    T_ZoomImageInfo imageInfo;
    
    // 
    EngineRect freshRect;
}T_EngineZoom;

/*******************************************************************************
*                                      ȫֺ
*******************************************************************************/
/*******************************************************************************
* : EngineZoomEffectInit
* : ʼЧʵ
* ˵: (IN)pStart: Чʼ
*           (IN)pEnd: Чյ
*           (IN/OUT)pData: ָ
*           (IN)pInstance: ʵָ
*           (IN)bAlpha: ǷҪ͸
* ֵ  : ENGINE_FALSE: ʧ
*           ENGINE_TRUE: ɹ
* ˵:
*******************************************************************************/
EngineBool EngineZoomEffectInit(EngineRect *pStart, EngineRect *pEnd, EngineData *pData, 
                                EngineInstance *pInstance, E_ZOOMATTACH attach);

/*******************************************************************************
* : EngineZoomEffectRender
* : ִЧʵ
* ˵: (IN)pData: ָ
*           (IN)pInstance: ʵָ
* ֵ  : ENGINE_FALSE: ʧ
*           ENGINE_TRUE: ɹ
* ˵:
*******************************************************************************/
EngineBool EngineZoomEffectRender(EngineData *pdata, EngineInstance *pInstance);

/*******************************************************************************
* : EngineZoomEffectDestory
* : Чʵ
* ˵: (IN)pData: ָ
* ֵ  : 
* ˵:
*******************************************************************************/
ZVOID EngineZoomEffectDestroy(EngineData *pData);

/*******************************************************************************
*                                      ȫֱ
*******************************************************************************/


#ifdef __cplusplus
}
#endif

#endif

