#ifndef _ZCORE_GUI_ELEMENT_H_
#define _ZCORE_GUI_ELEMENT_H_
#include "zcore_type.h"
#include "list.h"

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#define WET_METRICS         1   /* the metrics of element */
#define WET_COLOR           2   /* the color of element */

/* window element data struct */
typedef struct _wnd_element_data
{
    list_t      list;       /* list pointer */
    ZUINT16      type;       /* the item type */
    ZUINT16      item;       /* the item number */
    ZUINT32      data;       /* the data of the item */
} WND_ELEMENT_DATA;

#define WED_OK              0
#define WED_NEW_DATA        1
#define WED_NOT_CHANGED     2

#define WED_INVARG          -1
#define WED_NODEFINED       -2
#define WED_NOTFOUND        -3
#define WED_MEMERR          -4

extern ZSINT32 get_window_element_data (HWND hwnd, ZUINT16 type, ZUINT16 item, ZUINT32* data);
extern ZSINT32 set_window_element_data (HWND hwnd, ZUINT16 type, ZUINT16 item, ZUINT32 new_data, ZUINT32* old_data);
extern ZSINT32 free_window_element_data (HWND hwnd);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif  /* _ZCORE_GUI_ELEMENT_H_ */


