#ifndef _MGUI_GDI_H
#define _MGUI_GDI_H

#include "zcore_type.h"
#include "common.h"
#include "rect.h"
#include "zcore_region.h"
#include "zcore_text.h"
#include "gdi_e.h"
#include "zcore_sdev.h"
#include "zcore_dc.h"
#include "zcore_gal.h"
#include "zcore_bitmap_icon.h"

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

/*****************************************궨***************************************/


#define PIXEL_black2        0x00000001
/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
/***
#ifdef ZBOOL 
#undef ZBOOL
#endif
typedef ZSINT32 ZBOOL;
***/

#ifndef _HAVE_TYPE_UINT
#define _HAVE_TYPE_UINT
typedef ZUINT32    UINT;
#endif

#ifndef NULL
#define NULL ((ZVOID *)0)
#endif
/*******************************ṹ嶨*******************************/



/******************************************************************/

/*******************************궨*******************************/

//#define _ADV_2DAPI
#ifdef _ADV_2DAPI

#define DC_ATTR_PEN_TYPE        10
#define DC_ATTR_PEN_CAP_STYLE   11
#define DC_ATTR_PEN_JOIN_STYLE  12
#define DC_ATTR_PEN_WIDTH       13

#define DC_ATTR_BRUSH_TYPE      14

#define NR_DC_ATTRS             15

#else

#define NR_DC_ATTRS             10

#endif


typedef ZSINT32 (* ON_UPDATE_SECONDARYDC)(HWND hwnd, HDC secondary_dc, 
        HDC real_dc, const RECT* secondary_rc, const RECT* real_rc,
        const RECT* main_update_rc);
 
#define ON_UPDSECDC_DEFAULT     ((ON_UPDATE_SECONDARYDC)0)
#define ON_UPDSECDC_DONOTHING   ((ON_UPDATE_SECONDARYDC)0xFFFFFFFF)

/*******************************ṹ嶨*******************************/

extern	gal_pixel GetSysPixelIndex (ZSINT32 index);

#ifndef _TYPE_OS_MUTEX_ID
#define _TYPE_OS_MUTEX_ID
typedef UINT32 OS_MUTEX_ID;
#endif

#ifdef WIN32  //for Win32 sim
#ifndef _TYPE_OS_SEMA_ID
#define _TYPE_OS_SEMA_ID
typedef UINT32 OS_SEMA_ID;
#endif
#endif

typedef struct _DEVFONT DEVFONT;

/* Compatiblity definitions */
#define COLOR_invalid       	PIXEL_invalid
#define COLOR_transparent   	Pix_Transparent
#define COLOR_darkred       	Pix_DarkRed
#define COLOR_darkgreen     	Pix_DarkGreen
#define COLOR_darkyellow    	Pix_DarkYellow
#define COLOR_darkblue      	Pix_DarkBlue
#define COLOR_darkmagenta   	Pix_DarkMagenta
#define COLOR_darkcyan      	Pix_DarkCyan
#define COLOR_lightgray     	Pix_LightGray
#define COLOR_darkgray      	Pix_DarkGray
#define COLOR_red           	Pix_Red
#define COLOR_green         	Pix_Green
#define COLOR_yellow        	Pix_Yellow
#define COLOR_blue          	Pix_Blue
#define COLOR_magenta       	Pix_Magenta
#define COLOR_cyan          	Pix_Cyan
#define COLOR_lightwhite    	Pix_LightWhite
#define COLOR_black         	Pix_Black


/*******************************ԭ*******************************/


#define		EvaluateBoundRect(pRgn)						Region_EvaluateBoundRect ((PT_REGION_CLIPRGN) pRgn)


/***********************************궨*******************************/


struct _BITMAP;

#ifndef _TYPE_PBITMAP
#define _TYPE_PBITMAP
typedef BITMAP* PBITMAP;
#endif

struct _MYBITMAP;

#ifndef _TYPE_MYBITMAP
#define _TYPE_MYBITMAP
typedef struct _MYBITMAP MYBITMAP;
#endif

typedef struct _MYBITMAP* PMYBITMAP;


#ifdef _USE_NEWGAL
#define NULLREGION      0x00
#define SIMPLEREGION    0x01
#define COMPLEXREGION   0x02
#endif


#define HDC_SCREEN          0

#define HDC_INVALID         0

#define MEMDC_FLAG_NONE         0x00000000  /* None. */
#define MEMDC_FLAG_SWSURFACE    0x00000000  /* DC is in system memory */
#define MEMDC_FLAG_HWSURFACE    0x00000001  /* DC is in video memory */
#define MEMDC_FLAG_SRCCOLORKEY  0x00001000  /* Blit uses a source color key */
#define MEMDC_FLAG_SRCALPHA     0x00010000  /* Blit uses source alpha blending*/
#define MEMDC_FLAG_RLEACCEL     0x00004000  /* Surface is RLE encoded */



MG_EXPORT ZBOOL GUIAPI ConvertMemDC (HDC mem_dc, HDC ref_dc, DWORD flags);

MG_EXPORT ZBOOL GUIAPI SetMemDCAlpha (HDC mem_dc, DWORD flags, ZUINT8 alpha);


#define GAL_YV12_OVERLAY  0x32315659    /* Planar mode: Y + V + U  (3 planes) */
#define GAL_IYUV_OVERLAY  0x56555949    /* Planar mode: Y + U + V  (3 planes) */
#define GAL_YUY2_OVERLAY  0x32595559    /* Packed mode: Y0+U0+Y1+V0 (1 plane) */
#define GAL_UYVY_OVERLAY  0x59565955    /* Packed mode: U0+Y0+V0+Y1 (1 plane) */
#define GAL_YVYU_OVERLAY  0x55595659    /* Packed mode: Y0+V0+Y1+U0 (1 plane) */

typedef struct _GAL_Overlay {
    ZUINT32 format;
    ZSINT32 w;
    ZSINT32 h;
    ZSINT32 planes;
    ZUINT16 *pitches;
    ZUINT8 **pixels;

    struct private_yuvhwfuncs *hwfuncs;
    struct private_yuvhwdata *hwdata;

    ZUINT32 hw_overlay :1;
    ZUINT32 UnusedBits :31;
} GAL_Overlay;

MG_EXPORT GAL_Overlay* GUIAPI CreateYUVOverlay (ZSINT32 width, ZSINT32 height,
                ZUINT32 format, HDC hdc);

ZSINT32 GAL_LockYUVOverlay (GAL_Overlay *overlay);

ZVOID GAL_UnlockYUVOverlay (GAL_Overlay *overlay);

#define LockYUVOverlay GAL_LockYUVOverlay

#define UnlockYUVOverlay GAL_UnlockYUVOverlay

ZVOID GAL_FreeYUVOverlay (GAL_Overlay *overlay);

#define FreeYUVOverlay GAL_FreeYUVOverlay

MG_EXPORT ZVOID GUIAPI DisplayYUVOverlay (GAL_Overlay* overlay, 
                const RECT* dstrect);


ZSINT32 GAL_SetGamma (ZFLOAT32 red, ZFLOAT32 green, ZFLOAT32 blue);

#define SetGamma GAL_SetGamma

ZSINT32 GAL_SetGammaRamp (ZUINT16 *red, ZUINT16 *green, ZUINT16 *blue);

#define SetGammaRamp GAL_SetGammaRamp

ZSINT32 GAL_GetGammaRamp (ZUINT16 *red, ZUINT16 *green, ZUINT16 *blue);

#define GetGammaRamp GAL_GetGammaRamp




#ifdef _USE_NEWGAL

#ifdef _ADV_2DAPI

#define DC_ATTR_PEN_TYPE        10
#define DC_ATTR_PEN_CAP_STYLE   11
#define DC_ATTR_PEN_JOIN_STYLE  12
#define DC_ATTR_PEN_WIDTH       13

#define DC_ATTR_BRUSH_TYPE      14

#define NR_DC_ATTRS             15

#else

#define NR_DC_ATTRS             10

#endif

#define GetTabStop(hdc)     (ZSINT32) GetDCAttr (hdc, DC_ATTR_TAB_STOP)


#define SetTabStop(hdc, value)  \
                (ZSINT32) SetDCAttr (hdc, DC_ATTR_TAB_STOP, (ZDWORD) value)

#define ROP_SET         0
#define ROP_AND         1
#define ROP_OR          2
#define ROP_XOR         3

MG_EXPORT ZSINT32 GUIAPI GetRasterOperation (HDC hdc);

MG_EXPORT ZSINT32 GUIAPI SetRasterOperation (HDC hdc, ZSINT32 rop);


MG_EXPORT ZBOOL GUIAPI GetPalette (HDC hdc, ZSINT32 start, ZSINT32 len, GAL_Color* cmap);

MG_EXPORT ZBOOL GUIAPI SetColorfulPalette (HDC hdc);

MG_EXPORT HPALETTE GUIAPI CreatePalette (GAL_Palette* pal);

ZSINT32 GUIAPI GetPaletteEntries (HPALETTE hpal, 
                ZSINT32 start, ZSINT32 len, GAL_Color* cmap);


MG_EXPORT gal_pixel GUIAPI SetPixelRGB (HDC hdc, ZSINT32 x, ZSINT32 y, 
                ZUINT8 r, ZUINT8 g, ZUINT8 b);


MG_EXPORT gal_pixel GUIAPI SetPixelRGBA (HDC hdc, ZSINT32 x, ZSINT32 y, 
                ZUINT8 r, ZUINT8 g, ZUINT8 b, ZUINT8 a);

MG_EXPORT gal_pixel GUIAPI GetPixelRGB (HDC hdc, ZSINT32 x, ZSINT32 y, 
                ZUINT8* r, ZUINT8* g, ZUINT8* b);


MG_EXPORT gal_pixel GUIAPI GetPixelRGBA (HDC hdc, ZSINT32 x, ZSINT32 y, 
                ZUINT8* r, ZUINT8* g, ZUINT8* b, ZUINT8* a);


MG_EXPORT gal_pixel GUIAPI RGBA2Pixel (HDC hdc, 
                ZUINT8 r, ZUINT8 g, ZUINT8 b, ZUINT8 a);


MG_EXPORT ZVOID GUIAPI Pixel2RGB (HDC hdc, gal_pixel pixel, 
                ZUINT8* r, ZUINT8* g, ZUINT8* b);

MG_EXPORT ZVOID GUIAPI Pixel2RGBA (HDC hdc, gal_pixel pixel, 
                ZUINT8* r, ZUINT8* g, ZUINT8* b, ZUINT8* a);

MG_EXPORT ZVOID GUIAPI FocusRect (HDC hdc, ZSINT32 x0, ZSINT32 y0, ZSINT32 x1, ZSINT32 y1);



MG_EXPORT ZBOOL GUIAPI LineClipper (const RECT* cliprc, 
                ZSINT32 *_x0, ZSINT32 *_y0, ZSINT32 *_x1, ZSINT32 *_y1);

typedef ZVOID (* CB_LINE) (ZVOID* context, ZSINT32 stepx, ZSINT32 stepy);

MG_EXPORT ZVOID GUIAPI LineGenerator (ZVOID* context, 
                ZSINT32 x1, ZSINT32 y1, ZSINT32 x2, ZSINT32 y2, CB_LINE cb);

typedef ZVOID (* CB_CIRCLE) (ZVOID* context, ZSINT32 x1, ZSINT32 x2, ZSINT32 y);


MG_EXPORT ZVOID GUIAPI CircleGenerator (ZVOID* context, 
                ZSINT32 sx, ZSINT32 sy, ZSINT32 r, CB_CIRCLE cb);

typedef ZVOID (* CB_ELLIPSE) (ZVOID* context, ZSINT32 x1, ZSINT32 x2, ZSINT32 y);

MG_EXPORT ZVOID GUIAPI EllipseGenerator (ZVOID* context, 
                ZSINT32 sx, ZSINT32 sy, ZSINT32 rx, ZSINT32 ry, CB_ELLIPSE cb);

typedef ZVOID (* CB_ARC) (ZVOID* context, ZSINT32 x, ZSINT32 y);

MG_EXPORT ZVOID GUIAPI CircleArcGenerator (ZVOID* context, 
                ZSINT32 sx, ZSINT32 sy, ZSINT32 r, ZSINT32 ang1, ZSINT32 ang2, CB_ARC cb);

typedef ZVOID (* CB_POLYGON) (ZVOID* context, ZSINT32 x1, ZSINT32 x2, ZSINT32 y);

MG_EXPORT ZBOOL GUIAPI MonotoneVerticalPolygonGenerator (ZVOID* context, 
                const POINT* pts, ZSINT32 vertices, CB_POLYGON cb);

MG_EXPORT ZBOOL GUIAPI PolygonIsMonotoneVertical (const POINT* pts, 
                ZSINT32 vertices);

MG_EXPORT ZBOOL GUIAPI PolygonGenerator (ZVOID* context, 
                const POINT* pts, ZSINT32 vertices, CB_POLYGON cb);

typedef ZBOOL (* CB_EQUAL_PIXEL) (ZVOID* context, ZSINT32 x, ZSINT32 y);

typedef ZVOID (* CB_FLOOD_FILL) (ZVOID* context, ZSINT32 x1, ZSINT32 x2, ZSINT32 y);

MG_EXPORT ZBOOL GUIAPI FloodFillGenerator (ZVOID* context, 
                const RECT* src_rc, ZSINT32 x, ZSINT32 y, 
                CB_EQUAL_PIXEL cb_equal_pixel, CB_FLOOD_FILL cb_flood_fill);

typedef ZVOID* (* CB_GET_LINE_BUFF) (ZVOID* context, ZSINT32 y);

typedef ZVOID (* CB_LINE_SCALED) (ZVOID* context, const ZVOID* line, ZSINT32 y);

MG_EXPORT ZBOOL GUIAPI BitmapDDAScaler (ZVOID* context, 
                const BITMAP* src_bmp, ZSINT32 dst_w, ZSINT32 dst_h, 
                CB_GET_LINE_BUFF cb_get_line_buff, 
                CB_LINE_SCALED cb_line_scaled);


MG_EXPORT ZBOOL GUIAPI BitmapDDAScaler2 (ZVOID* context, 
                const BITMAP* src_bmp, ZSINT32 dst_w, ZSINT32 dst_h, 
                CB_GET_LINE_BUFF cb_get_line_buff, 
                CB_LINE_SCALED cb_line_scaled);

MG_EXPORT ZVOID GUIAPI PolyLineTo (HDC hdc, const POINT* pts, ZSINT32 vertices);


MG_EXPORT ZVOID GUIAPI SplineTo (HDC hdc, const POINT* pts);

MG_EXPORT ZVOID GUIAPI Circle (HDC hdc, ZSINT32 sx, ZSINT32 sy, ZSINT32 r);


MG_EXPORT ZVOID GUIAPI Ellipse (HDC hdc, ZSINT32 sx, ZSINT32 sy, ZSINT32 rx, ZSINT32 ry);

MG_EXPORT ZVOID GUIAPI CircleArc (HDC hdc, ZSINT32 sx, ZSINT32 sy, ZSINT32 r, 
                ZSINT32 ang1, ZSINT32 ang2);


MG_EXPORT ZVOID GUIAPI FillCircle (HDC hdc, ZSINT32 sx, ZSINT32 sy, ZSINT32 r);

MG_EXPORT ZVOID GUIAPI FillEllipse (HDC hdc, ZSINT32 sx, ZSINT32 sy, ZSINT32 rx, ZSINT32 ry);

MG_EXPORT ZBOOL GUIAPI FillPolygon (HDC hdc, const POINT* pts, ZSINT32 vertices);

MG_EXPORT ZBOOL GUIAPI FloodFill (HDC hdc, ZSINT32 x, ZSINT32 y);

#ifdef _ADV_2DAPI

#define GetPenType(hdc)                 \
                (PenType) GetDCAttr (hdc, DC_ATTR_PEN_TYPE)


MG_EXPORT ZVOID GUIAPI SetPenDashes (HDC hdc, ZSINT32 dash_offset, 
                const ZUINT8* dash_list, ZSINT32 n);


#define GetPenCapStyle(hdc)                 \
                (PTCapStyle) GetDCAttr (hdc, DC_ATTR_PEN_CAP_STYLE)

typedef enum
{
  BT_SOLID,
  BT_TILED,
  BT_STIPPLED,
  BT_OPAQUE_STIPPLED
} BrushType;

#define GetBrushType(hdc)               \
                (BrushType) GetDCAttr (hdc, DC_ATTR_BRUSH_TYPE)

#define SetBrushType(hdc, type)         \
                (BrushType) SetDCAttr (hdc, DC_ATTR_BRUSH_TYPE, (ZDWORD) type)

typedef struct _STIPPLE
{
    ZSINT32 width;
    ZSINT32 height;

    ZSINT32 pitch;

    size_t size;

    const ZUINT8* bits;
} STIPPLE;

MG_EXPORT ZVOID GUIAPI SetBrushInfo (HDC hdc, 
                const BITMAP* tile, const STIPPLE* stipple);

MG_EXPORT ZVOID GUIAPI SetBrushOrigin (HDC hdc, ZSINT32 x, ZSINT32 y);


MG_EXPORT ZVOID GUIAPI ArcEx (HDC hdc, ZSINT32 x, ZSINT32 y, ZSINT32 width, ZSINT32 height, 
                ZSINT32 ang1, ZSINT32 ang2);

MG_EXPORT ZVOID GUIAPI FillArcEx (HDC hdc, ZSINT32 x, ZSINT32 y, ZSINT32 width, ZSINT32 height, 
                ZSINT32 ang1, ZSINT32 ang2);

MG_EXPORT ZVOID GUIAPI PolyLineEx (HDC hdc, const POINT* pts, ZSINT32 nr_pts);

typedef struct _ARC
{
    ZSINT32 x;
    ZSINT32 y;

    ZSINT32 width;
    ZSINT32 height;

    ZSINT32 angle1;
    ZSINT32 angle2;
} ARC;

MG_EXPORT ZVOID GUIAPI PolyArcEx (HDC hdc, const ARC* arcs, ZSINT32 nr_arcs);

MG_EXPORT ZVOID GUIAPI PolyFillArcEx (HDC hdc, const ARC* arcs, ZSINT32 nr_arcs);

#endif


#define GetMapMode(hdc)         (ZSINT32)GetDCAttr (hdc, DC_ATTR_MAP_MODE)

#define SetMapMode(hdc, mapmode)        \
                (ZSINT32)SetDCAttr (hdc, DC_ATTR_MAP_MODE, (ZDWORD)mapmode)



MG_EXPORT ZVOID GUIAPI GetDCLCS (HDC hdc, ZSINT32 which, POINT* pt);

MG_EXPORT ZVOID GUIAPI SetDCLCS (HDC hdc, ZSINT32 which, const POINT* pt);

#define DC_LCS_VORG     0
#define DC_LCS_VEXT     1
#define DC_LCS_WORG     2
#define DC_LCS_WEXT     3
#define NR_DC_LCS_PTS   4

#define GetViewportOrg(hdc, pPt)    GetDCLCS(hdc, DC_LCS_VORG, pPt)

#define GetViewportExt(hdc, pPt)    GetDCLCS(hdc, DC_LCS_VEXT, pPt)

#define GetWindowOrg(hdc, pPt)      GetDCLCS(hdc, DC_LCS_WORG, pPt)

#define GetWindowExt(hdc, pPt)      GetDCLCS(hdc, DC_LCS_WEXT, pPt)

#define SetViewportOrg(hdc, pPt)    SetDCLCS(hdc, DC_LCS_VORG, pPt)

#define SetViewportExt(hdc, pPt)    SetDCLCS(hdc, DC_LCS_VEXT, pPt)

#define SetWindowOrg(hdc, pPt)      SetDCLCS(hdc, DC_LCS_WORG, pPt)

#define SetWindowExt(hdc, pPt)      SetDCLCS(hdc, DC_LCS_WEXT, pPt)



MG_EXPORT ZVOID GUIAPI DPtoLP (HDC hdc, POINT* pPt);

MG_EXPORT ZVOID GUIAPI LPtoDP (HDC hdc, POINT* pPt);

MG_EXPORT ZBOOL GUIAPI PtVisible (HDC hdc, ZSINT32 x, ZSINT32 y);


MG_EXPORT ZVOID GUIAPI StretchBlt (HDC hsdc, ZSINT32 sx, ZSINT32 sy, ZSINT32 sw, ZSINT32 sh, 
                HDC hddc, ZSINT32 dx, ZSINT32 dy, ZSINT32 dw, ZSINT32 dh, ZDWORD dwRop);


MG_EXPORT ZBOOL GUIAPI ScaleBitmap (BITMAP* dst, const BITMAP* src);


MG_EXPORT gal_pixel GUIAPI GetPixelInBitmap (const BITMAP* bmp, ZSINT32 x, ZSINT32 y);

MG_EXPORT ZBOOL GUIAPI SetPixelInBitmap (const BITMAP* bmp, 
                ZSINT32 x, ZSINT32 y, gal_pixel pixel);

#ifdef _MISC_SAVESCREEN

MG_EXPORT ZBOOL GUIAPI SaveMainWindowContent (HWND hWnd, const ZCHAR* filename);
#endif


MG_EXPORT HICON GUIAPI LoadIconFromFile (HDC hdc, const ZCHAR* filename, 
                ZSINT32 which);

MG_EXPORT HICON GUIAPI LoadIconFromMem (HDC hdc, const ZVOID* area, ZSINT32 which);


MG_EXPORT HICON GUIAPI CreateIcon (HDC hdc, ZSINT32 w, ZSINT32 h, 
                const ZUINT8* AndBits, const ZUINT8* XorBits, ZSINT32 colornum);

MG_EXPORT ZBOOL GUIAPI DestroyIcon (HICON hicon);

MG_EXPORT ZBOOL GUIAPI GetIconSize (HICON hicon, ZSINT32* w, ZSINT32* h);


MG_EXPORT ZVOID GUIAPI DrawIcon (HDC hdc, 
                ZSINT32 x, ZSINT32 y, ZSINT32 w, ZSINT32 h, HICON hicon);



MG_EXPORT ZBOOL GUIAPI UnionRect (RECT* pdrc, 
                const RECT* psrc1, const RECT* psrc2);




#define FONT_CHARSET_UTF16          "UTF-16"

#define MAX_LEN_MCHAR               4

typedef struct _CHARSETOPS
{
    ZSINT32 nr_chars;
    ZSINT32 bytes_per_char;
    ZSINT32 bytes_maxlen_char;
    const ZCHAR* name;
    ZCHAR def_char [MAX_LEN_MCHAR];

    ZSINT32 (*len_first_char) (const ZUINT8* mstr, ZSINT32 mstrlen);
    ZUINT32 (*char_offset) (const ZUINT8* mchar);

    ZSINT32 (*nr_chars_in_str) (const ZUINT8* mstr, ZSINT32 mstrlen);

    ZSINT32 (*is_this_charset) (const ZUINT8* charset);

    ZSINT32 (*len_first_substr) (const ZUINT8* mstr, ZSINT32 mstrlen);
    const ZUINT8* (*get_next_word) (const ZUINT8* mstr, 
                ZSINT32 strlen, WORDINFO* word_info);

    ZSINT32 (*pos_first_char) (const ZUINT8* mstr, ZSINT32 mstrlen);

#ifdef _UNICODE_SUPPORT
    ZUINT16 (*conv_to_uc16) (const ZUINT8* mchar, ZSINT32 len);
    ZSINT32 (*conv_from_uc16) (ZUINT16 wc, ZUINT8* mchar);
#endif /* LITE_VERSION */
} CHARSETOPS;

typedef struct _FONTOPS
{
    ZSINT32 (*get_char_width) (LOGFONT* plogfont, DEVFONT* pdevfont, 
            const ZUINT8* mchar, ZSINT32 len);
    ZSINT32 (*get_str_width) (LOGFONT* plogfont, DEVFONT* pdevfont, 
            const ZUINT8* mstr, ZSINT32 n, ZSINT32 cExtra);
    ZSINT32 (*get_ave_width) (LOGFONT* plogfont, DEVFONT* pdevfont);
    ZSINT32 (*get_max_width) (LOGFONT* plogfont, DEVFONT* pdevfont);
    ZSINT32 (*get_font_height) (LOGFONT* plogfont, DEVFONT* pdevfont);
    ZSINT32 (*get_font_size) (LOGFONT* plogfont, DEVFONT* pdevfont, ZSINT32 expect);
    ZSINT32 (*get_font_ascent) (LOGFONT* plogfont, DEVFONT* pdevfont);
    ZSINT32 (*get_font_descent) (LOGFONT* plogfont, DEVFONT* pdevfont);
    
    size_t (*char_bitmap_size) (LOGFONT* plogfont, DEVFONT* pdevfont, 
            const ZUINT8* mchar, ZSINT32 len);
    size_t (*max_bitmap_size) (LOGFONT* plogfont, DEVFONT* pdevfont);
    const ZVOID* (*get_char_bitmap) (LOGFONT* plogfont, DEVFONT* pdevfont, 
            const ZUINT8* mchar, ZSINT32 len);
    
    const ZVOID* (*get_char_pixmap) (LOGFONT* plogfont, DEVFONT* pdevfont, 
            const ZUINT8* mchar, ZSINT32 len, ZSINT32* pitch);

    ZVOID (*start_str_output) (LOGFONT* plogfont, DEVFONT* pdevfont);
    ZSINT32 (*get_char_bbox) (LOGFONT* plogfont, DEVFONT* pdevfont,
            const ZUINT8* mchar, ZSINT32 len,
            ZSINT32* px, ZSINT32* py, ZSINT32* pwidth, ZSINT32* pheight);
    ZVOID (*get_char_advance) (LOGFONT* plogfont, DEVFONT* pdevfont,
            const ZUINT8* mchar, ZSINT32 len, ZSINT32* px, ZSINT32* py);

    DEVFONT* (*new_instance) (LOGFONT* plogfont, DEVFONT* pdevfont, 
            ZBOOL need_sbc_font);
    ZVOID (*delete_instance) (DEVFONT* pdevfont);
} FONTOPS;
#define LEN_UNIDEVFONT_NAME 20 //wangdesuo
struct _DEVFONT
{
    ZCHAR             name [LEN_UNIDEVFONT_NAME + 1];
    ZDWORD            style;
    FONTOPS*         font_ops;
    CHARSETOPS*      charset_ops;
    struct _DEVFONT* sbc_next;
    struct _DEVFONT* mbc_next;
    ZVOID*            data;
};
/************ַṹSTART*************/

struct _WORDINFO;
#ifndef _TYPE_WORDINFO
#define _TYPE_WORDINFO
typedef struct _WORDINFO WORDINFO;
#endif

struct T_TXTMGT_DEVFONT;
typedef struct T_TXTMGT_DEVFONT TXTMGT_DEVFONT; //ظ


typedef struct T_TXTMGT_CHARSETOPRATE
{
    /*¼ַеַ*/
    ZSINT32 iCharsNum;
    /*¼ַеƽÿַռֽ*/	
    ZSINT32 iBytesPerChar;
    /*¼ַеÿַռֽ*/	
    ZSINT32 iBytesMaxlenChar;
    /*¼ַ*/		
    const ZCHAR* pcName;
    /*¼ַĬַ<ڲҲ>*/		
    ZUINT8 acDefineChar [MAX_LEN_MCHAR];
    /*ַеһַռֽ*/		
    ZSINT32 (*GetLenFirstChar) (const ZUINT8* mstr, ZSINT32 mstrlen);
    /*ݱʽַڱ뼯еƫ*/		
    ZUINT32 (*GetCharOffset) (const ZUINT8* mchar);
    /*ַеַڶȡַ*/		
    ZSINT32 (*GetCharsNumINStr) (const ZUINT8* mstr, ZSINT32 mstrlen);
    /*Ӧַ*/		
    ZSINT32 (*ISthisCharset) (const ZUINT8* charset);
    /*ַеַڶȡַ*/		
    ZSINT32 (*GetLenFirstSubstr) (const ZUINT8* mstr, ZSINT32 mstrlen);
    /*ȡַеһ*/		
    const ZUINT8* (*GetNextWord) (const ZUINT8* mstr, 
                ZSINT32 strlen, WORDINFO* word_info);
    /*ȡַеַڸַеĵһλ*/		
    ZSINT32 (*GetPosFirstChar) (const ZUINT8* mstr, ZSINT32 mstrlen);

    ZUINT16 (*ConvToUc16) (const ZUINT8* mchar, ZSINT32 len);
} TXTMGT_CHARSETOPRATE;

/*************ַṹEND}************/


/*{***********ṹSTART*************/

typedef struct T_TXTMGT_FONTOPRATE
{
    /*ȡַָĿ*/		
    ZSINT32 (*GetCharWdth) (PLOGFONT logfont, TXTMGT_DEVFONT* devfont, 
            const ZUINT8* mchar, ZSINT32 len);
    /*ȡַָĿ*/		
    ZSINT32 (*GetStrWidth) (PLOGFONT logfont, TXTMGT_DEVFONT* devfont, 
            const ZUINT8* mstr, ZSINT32 n, ZSINT32 cExtra);
    /*ȡַƽ<ȷTAB'\t'Ŀ>*/		
    ZSINT32 (*GetAveWidth) (PLOGFONT logfont, TXTMGT_DEVFONT* devfont);
    /*ȡַ*/		
    ZSINT32 (*GetMaxWidth) (PLOGFONT logfont, TXTMGT_DEVFONT* devfont);
    /*ȡַĸ߶*/		
    ZSINT32 (*GetFontHeight) (PLOGFONT logfont, TXTMGT_DEVFONT* devfont);
    /*ȡַsize <൱ڸ߶>*/	
    ZSINT32 (*GetFontSize) (PLOGFONT logfont, TXTMGT_DEVFONT* devfont, ZSINT32 expect);
    /*ȡַascent*/	
    ZSINT32 (*GetFontAscent) (PLOGFONT logfont, TXTMGT_DEVFONT* devfont);
    /*ȡַdescent*/	
    ZSINT32 (*GetFontDescent) (PLOGFONT logfont, TXTMGT_DEVFONT* devfont);
    /*ȡַbitmap*/	
    const ZVOID* (*GetCharBitmap) (PLOGFONT logfont, TXTMGT_DEVFONT* devfont, 
            const ZUINT8* mchar, ZSINT32 len, ZUINT16* scale);
    /*ȡַpixmap<λͼ>*/	
    const ZVOID* (*GetCharPixmap) (PLOGFONT logfont, TXTMGT_DEVFONT* devfont, 
            const ZUINT8* mchar, ZSINT32 len, ZSINT32* pitch);
    /*ȡַBOX*/	
    ZSINT32 (*GetCharBbox) (PLOGFONT logfont, TXTMGT_DEVFONT* devfont,
            const ZUINT8* mchar, ZSINT32 len,
            ZSINT32* px, ZSINT32* py, ZSINT32* pwidth, ZSINT32* pheight);
    /*ȡַԭ*/	
    ZVOID (*GetCharAdvance) (PLOGFONT logfont, TXTMGT_DEVFONT* devfont,
            const ZUINT8* mchar, ZSINT32 len, ZSINT32* px, ZSINT32* py);

    TXTMGT_DEVFONT* (*NewInstance) (PLOGFONT logfont, TXTMGT_DEVFONT* devfont, 
		ZBOOL need_sbc_font);
	/* Can be NULL */
    ZVOID (*DeleteInstance) (TXTMGT_DEVFONT* devfont);
	/* Can be NULL */
}TXTMGT_FONTOPRATE;

/*************ṹEND***********}*/

#define GDI_DEVFONTNAMELEN         (ZUINT16)127

typedef struct T_TXTMGT_DEVFONT
{
/*߼*/
    ZUINT8 bType;
/*߼ļ<""> */
    ZCHAR szFamily [LEN_FONT_NAME + 1];
/*豸ʽ*/
    ZDWORD dwStyle;
/*豸Ӧ*/
    TXTMGT_FONTOPRATE* ptFontOperate;
/*豸Ӧַ*/
    TXTMGT_CHARSETOPRATE* ptCharsetOperate;
/*豸ַ*/
    ZSINT32 iCharsNum;
/*豸*/	
    ZSINT32 iWidth;
/*豸߶*/	
    ZSINT32 iHeight;
/*豸ֿ*/	
    const ZUINT8* pcFont;
/*豸 ֿС*/
    ZLONG lFontSize;
/*ڵֽ豸еһ豸*/
    struct T_TXTMGT_DEVFONT* ptSBNext;
/*ڶֽ豸еһ豸*/
    struct T_TXTMGT_DEVFONT* ptMBNext;

    ZVOID *data;
};

/************ַṹSTART*************/

#define SBC_DEVFONT_INFO(logfont) (logfont.sbc_devfont)
#define MBC_DEVFONT_INFO(logfont) (logfont.mbc_devfont)

#define SBC_DEVFONT_INFO_P(logfont) (logfont->sbc_devfont)
#define MBC_DEVFONT_INFO_P(logfont) (logfont->mbc_devfont)

#define INV_LOGFONT     0


typedef struct _GLYPHBITMAP
{
    ZSINT32 bbox_x, bbox_y, bbox_w, bbox_h;
    ZSINT32 advance_x, advance_y;

    size_t bmp_size;
    ZSINT32 bmp_pitch;
    const ZUINT8* bits;
} GLYPHBITMAP;

MG_EXPORT ZVOID GUIAPI GetGlyphBitmap (LOGFONT* log_font, 
                const ZUINT8* mchar, ZSINT32 mchar_len, 
                GLYPHBITMAP* glyph_bitmap);

MG_EXPORT PLOGFONT GUIAPI CreateLogFontByName (const ZCHAR* font_name);
 

MG_EXPORT const DEVFONT* GUIAPI GetNextDevFont (const DEVFONT* dev_font);
        

 

#ifdef _UNICODE_SUPPORT

#include <stdlib.h>

MG_EXPORT ZSINT32 GUIAPI MB2WC (PLOGFONT log_font, 
                wchar_t* dest, const ZUINT8* mstr, ZSINT32 n);

MG_EXPORT ZSINT32 GUIAPI WC2MB (PLOGFONT log_font, ZUINT8 *s, wchar_t wc);

MG_EXPORT ZSINT32 GUIAPI MBS2WCS (PLOGFONT log_font, wchar_t* dest, 
                const ZUINT8* mstr, ZSINT32 mstr_len, ZSINT32 n);

MG_EXPORT ZSINT32 GUIAPI WCS2MBS (PLOGFONT log_font, ZUINT8* dest, 
                const wchar_t *wcs, ZSINT32 wcs_len, ZSINT32 n);

#endif /* _UNICODE_SUPPORT */

   

#ifdef _USE_NEWGAL

#define GetTextCharacterExtra(hdc)  (ZSINT32)GetDCAttr (hdc, DC_ATTR_CHAR_EXTRA)


#define GetTextAboveLineExtra(hdc)  (ZSINT32)GetDCAttr (hdc, DC_ATTR_ALINE_EXTRA)


#define GetTextBellowLineExtra(hdc) (ZSINT32)GetDCAttr (hdc, DC_ATTR_BLINE_EXTRA)

#define SetTextCharacterExtra(hdc, extra)       \
                (ZSINT32)SetDCAttr (hdc, DC_ATTR_CHAR_EXTRA, (ZDWORD) extra)


#else

MG_EXPORT ZSINT32 GUIAPI GetTextCharacterExtra (HDC hdc);
MG_EXPORT ZSINT32 GUIAPI SetTextCharacterExtra (HDC hdc, ZSINT32 extra);
MG_EXPORT ZSINT32 GUIAPI GetTextAboveLineExtra (HDC hdc);
MG_EXPORT ZSINT32 GUIAPI SetTextAboveLineExtra (HDC hdc, ZSINT32 extra);
MG_EXPORT ZSINT32 GUIAPI GetTextBellowLineExtra (HDC hdc);
MG_EXPORT ZSINT32 GUIAPI SetTextBellowLineExtra (HDC hdc, ZSINT32 extra);

#endif /* _USE_NEWGAL */
 
MG_EXPORT ZSINT32 GUIAPI TabbedTextOutLen (HDC hdc, ZSINT32 x, ZSINT32 y, 
                const ZCHAR* spText, ZSINT32 len); 
/*****************************************************************************
 *			txtmgtGetTabWidth
 *			ȡtabС
 *		     @HDC hdc 豸
                                 @ UINT nFormat ڸʽıķ:    
 *		
 *	ֵ˵int tabַ
 *	˵	
 *****************************************************************************/
  
ZSINT32 txtmgtGetTabWidth(HDC hdc,  ZDWORD nFormat);

#define TabbedTextOut(hdc, x, y, text)  TabbedTextOutLen (hdc, x, y, text, -1)
    

 

#include <stdio.h>
#include "endianrw.h"

typedef ZVOID (* CB_ONE_SCANLINE) (ZVOID* context, MYBITMAP* my_bmp, ZSINT32 y);

MG_EXPORT ZBOOL GUIAPI RegisterBitmapFileType (const ZCHAR *ext,
            ZVOID* (*init) (MG_RWops* fp, MYBITMAP *my_bmp, RGB *pal),
            ZSINT32 (*load) (MG_RWops* fp, ZVOID* init_info, MYBITMAP *my_bmp, 
                    CB_ONE_SCANLINE cb, ZVOID* context),
            ZVOID (*cleanup) (ZVOID* init_info),
            ZSINT32 (*save) (MG_RWops* fp, MYBITMAP *my_bmp, RGB *pal),
            ZBOOL (*check) (MG_RWops* fp));

MG_EXPORT const ZCHAR* GUIAPI CheckBitmapType (MG_RWops* fp);
 

MG_EXPORT ZSINT32 GUIAPI LoadBitmapEx (HDC hdc, PBITMAP pBitmap, 
                MG_RWops* area, const ZCHAR* ext);
 

MG_EXPORT ZSINT32 GUIAPI LoadBitmapFromMem (HDC hdc, PBITMAP pBitmap, 
                const ZVOID* mem, ZSINT32 size, const ZCHAR* ext);
 

MG_EXPORT ZVOID GUIAPI ReplaceBitmapColor (HDC hdc, PBITMAP pBitmap, 
                gal_pixel iOColor, gal_pixel iNColor);

MG_EXPORT ZVOID* GUIAPI InitMyBitmapSL (MG_RWops* area, 
                const ZCHAR* ext, MYBITMAP* my_bmp, RGB* pal);

MG_EXPORT ZSINT32 GUIAPI LoadMyBitmapSL (MG_RWops* area, ZVOID* load_info, 
                MYBITMAP* my_bmp, CB_ONE_SCANLINE cb, ZVOID* context);

MG_EXPORT ZSINT32 GUIAPI CleanupMyBitmapSL (MYBITMAP* my_bmp, ZVOID* load_info);

MG_EXPORT ZSINT32 GUIAPI LoadMyBitmapEx (PMYBITMAP my_bmp, RGB* pal, 
                MG_RWops* area, const ZCHAR* ext);

ZSINT32 GUIAPI LoadMyBitmapFromPngFile (MYBITMAP* my_bmp,const ZCHAR* file_name);


MG_EXPORT ZSINT32 GUIAPI LoadMyBitmapFromMem (PMYBITMAP my_bmp, RGB* pal, 
                const ZVOID* mem, ZSINT32 size, const ZCHAR* ext);

MG_EXPORT ZVOID GUIAPI UnloadMyBitmap (PMYBITMAP my_bmp);

#ifdef _SAVE_BITMAP

MG_EXPORT ZSINT32 GUIAPI SaveMyBitmapToFile (PMYBITMAP my_bmp, RGB* pal, 
                const ZCHAR* spFileName);


MG_EXPORT ZSINT32 GUIAPI SaveBitmapToFile (HDC hdc, PBITMAP pBitmap, 
                const ZCHAR* spFileName);
#define SaveBitmap  SaveBitmapToFile 
#endif
 

MG_EXPORT ZBOOL GUIAPI InitBitmapEx_256 (HDC hdc, ZUINT32 w, ZUINT32 h,ZUINT8* bits,PBITMAP bmp);


#ifdef _USE_NEWGAL

MG_EXPORT ZBOOL GUIAPI InitBitmapPixelFormat (HDC hdc, PBITMAP bmp);

MG_EXPORT ZVOID GUIAPI DeleteBitmapAlphaPixel (PBITMAP bmp); 

MG_EXPORT ZVOID GUIAPI ExpandMonoBitmap (HDC hdc, ZUINT8* bits, ZUINT32 pitch, 
                const ZUINT8* my_bits, ZUINT32 my_pitch, 
                ZUINT32 w, ZUINT32 h, ZDWORD flags, ZUINT32 bg, ZUINT32 fg);
MG_EXPORT ZVOID GUIAPI Expand16CBitmap (HDC hdc, ZUINT8* bits, ZUINT32 pitch, 
                const ZUINT8* my_bits, ZUINT32 my_pitch, 
                ZUINT32 w, ZUINT32 h, ZDWORD flags, const RGB* pal);
MG_EXPORT ZVOID GUIAPI Expand256CBitmap (HDC hdc, ZUINT8* bits, ZUINT32 pitch, 
                const ZUINT8* my_bits, ZUINT32 my_pitch, 
                ZUINT32 w, ZUINT32 h, ZDWORD flags, const RGB* pal);
MG_EXPORT ZVOID GUIAPI CompileRGBABitmap (HDC hdc, ZUINT8* bits, ZUINT32 pitch, 
                const ZUINT8* my_bits, ZUINT32 my_pitch, 
                ZUINT32 w, ZUINT32 h, ZDWORD flags, ZVOID* pixel_format);

#define CompileRGBBitmap CompileRGBABitmap 

MG_EXPORT ZSINT32 GUIAPI PaintImageEx (HDC hdc, ZSINT32 x, ZSINT32 y, 
                MG_RWops* area, const ZCHAR* ext);

MG_EXPORT ZSINT32 GUIAPI PaintImageFromFile (HDC hdc, ZSINT32 x, ZSINT32 y, 
                const ZCHAR* spFileName);

MG_EXPORT ZSINT32 GUIAPI PaintImageFromMem (HDC hdc, ZSINT32 x, ZSINT32 y, 
                const ZVOID* mem, ZSINT32 size, const ZCHAR* ext);

MG_EXPORT ZSINT32 GUIAPI StretchPaintImageEx (HDC hdc, ZSINT32 x, ZSINT32 y, ZSINT32 w, ZSINT32 h, 
                MG_RWops* area, const ZCHAR* ext);
 

MG_EXPORT ZSINT32 GUIAPI StretchPaintImageFromMem (HDC hdc, ZSINT32 x, ZSINT32 y, 
                ZSINT32 w, ZSINT32 h, const ZVOID* mem, ZSINT32 size, const ZCHAR* ext);

#else
 
MG_EXPORT ZVOID GUIAPI ExpandMonoBitmap (HDC hdc, ZSINT32 w, ZSINT32 h, 
                const ZUINT8* my_bits, ZSINT32 my_pitch, ZSINT32 bits_flow, 
                ZUINT8* bitmap, ZSINT32 pitch, ZSINT32 bg, ZSINT32 fg);
MG_EXPORT ZVOID GUIAPI Expand16CBitmap (HDC hdc, ZSINT32 w, ZSINT32 h, 
                const ZUINT8* my_bits, ZSINT32 my_pitch, ZSINT32 bits_flow,
                ZUINT8* bitmap, ZSINT32 pitch, const RGB* pal);
MG_EXPORT ZVOID GUIAPI Expand256CBitmap (HDC hdc, ZSINT32 w, ZSINT32 h, 
                const ZUINT8* my_bits, ZSINT32 my_pitch, ZSINT32 bits_flow,
                ZUINT8* bitmap, ZSINT32 pitch, const RGB* pal);
MG_EXPORT ZVOID GUIAPI CompileRGBBitmap (HDC hdc, ZSINT32 w, ZSINT32 h, 
                const ZUINT8* my_bits, ZSINT32 my_pitch, ZSINT32 bits_flow,
                ZUINT8* bitmap, ZSINT32 pitch, ZSINT32 rgb_order);

#endif /* _USE_NEWGAL */


#endif
#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif  /* _MGUI_GDI_H */
