#ifndef _ZCORE_GUI_INTERNALS_H_
#define _ZCORE_GUI_INTERNALS_H_

/******************* Internal data *******************************************/
#include "zcore_type.h"
#include "internals_msg.h"
#include "internals_win.h"
#include "osa_api_e.h"

#define DEF_NR_TIMERS       32

#define DEF_MSGQUEUE_LEN    64
#define SIZE_CLIPRECTHEAP   128
#define SIZE_INVRECTHEAP    128
#define SIZE_QMSG_HEAP      8
#define DEF_NR_THREADS      64     /* default number of system and application threads */

/******************* Internal data of fix string module **********************/
//#define MAX_LEN_FIXSTR    2048
//#define NR_HEAP           10
//#define LEN_BITMAP        (1+2+4+8+16+32+64+128+256+512)


#define TYPE_WINTODEL       0xF1

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

/* thread information structure */
struct _THREADINFO
{
    PMSGQUEUE           pMsgQueue;        /* pointer to message queue of the thread */
    pthread_t           th;               /* the thread id */
    PMAINWIN            pMainWin;         /* Top level main window of this thread */

    DWORD               dwState;          /* current thread status */
    pthread_mutex_t     lock;             /* access lock */
    struct _THREADINFO  *next;
};
typedef THREADINFO* PTHREADINFO;

/************************* Initialization/Termination ************************/
ZBOOL InitScreenDC (ZVOID);
ZVOID TerminateScreenDC (ZVOID);

ZBOOL InitGDI (ZVOID);
ZVOID TerminateGDI (ZVOID);

ZBOOL InitFixStr (ZVOID);
ZVOID TerminateFixStr (ZVOID);

ZBOOL InitMenu (ZVOID);
ZVOID TerminateMenu (ZVOID);

ZBOOL InitMainWinMetrics (ZVOID);
ZBOOL InitWindowElementColors (ZVOID);

ZBOOL InitDesktop (ZVOID);
ZVOID TerminateDesktop (ZVOID);

/* return main window contains hWnd. */
PMAINWIN GetMainWindowPtrOfControl (HWND hWnd);

/* check whether hWnd is main window and return pointer to main window hWnd. */
PMAINWIN CheckAndGetMainWindowPtr (HWND hWnd);

/* return the main window under specified point (x, y). */
PMAINWIN GetMainWindowPtrUnderPoint (ZSINT32 x, ZSINT32 y);

/*
 *:   GetWindowListByLayerId
 *:   ָ㣬ָ͵hwndб
 *˭:   id           layer id
 *				  style       MAIN_WIN            ȡMAIN
 *						   MIDDLE_WIN            ȡMIDDLE
 *						   TOP_WIN   ȡTOP
 *ֵ     :   ͷָ
 *                         NULL        ʧ
 */
MG_EXPORT PZORDERNODE GetWindowListByLayerId(ZSINT32 id, WINSTYLE style);

/* return message queue of window. */
PMSGQUEUE GetMsgQueue (HWND hWnd); 

/* return global clipping region of window. */
PGCRINFO GetGCRgnInfo (HWND hWnd); 

/* internal variables */
typedef struct _TRACKMENUINFO* PTRACKMENUINFO;

extern ZUINT32 __mg_timer_counter;

extern HWND __mg_capture_wnd;
extern HWND __mg_ime_wnd;
extern PMAINWIN __mg_active_mainwnd;
extern PTRACKMENUINFO __mg_ptmi;
extern PMAINWIN __mg_dsk_win;
extern HWND __mg_hwnd_desktop;

extern ZSINT32 DesktopWinProc (HWND hWnd, ZSINT32 message, WPARAM wParam, LPARAM lParam);
extern ZSINT32 SendSyncMessage(HWND hWnd, ZSINT32 msg, WPARAM wParam, LPARAM lParam);


/* get main window pointer of a window, including desktop window */
static inline PMAINWIN getMainWindowPtr (HWND hWnd)
{
    PMAINWIN pWin;

    MG_CHECK_RET (MG_IS_WINDOW(hWnd), NULL);
    pWin = MG_GET_WINDOW_PTR (hWnd);

    return pWin->pMainWin;
}

/* ---------------------------------------------------------------------------- */
/* Be careful: does not check validity of hWnd */
#ifndef NXP
#define os_thread_self tp_os_thread_self
#endif
extern OS_THREAD_ID tp_os_thread_self(void);
static inline ZBOOL BE_THIS_THREAD (HWND hWnd)
{
    PMAINWIN pMainWin = getMainWindowPtr(hWnd);
    if (NULL != pMainWin && pMainWin->th == tp_os_thread_self()) /*modify for klocwork*/
    {
        return TRUE;
    }

    return FALSE;
}

extern THREADINFO *__mg_dsk_threadinfo;

THREADINFO*   InitThreadInfo    (ZVOID);
ZVOID          FreeThreadInfo    (THREADINFO *thi);

THREADINFO*   GetThreadInfo (OS_THREAD_ID thread);
PMSGQUEUE     GetThreadMsgQueue (OS_THREAD_ID thread);

ZBOOL InitTimer(ZVOID);
ZBOOL InstallIntervalTimer(ZVOID);
ZBOOL UninstallIntervalTimer(ZVOID);

/* ---------------------------------------------------------------------------- */

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif // _ZCORE_GUI_INTERNALS_H_

