#ifndef _ZCORE_INTERNALS_MSG_H_
#define _ZCORE_INTERNALS_MSG_H_
#include "zcore_type.h"
#include "gui_g.h"

typedef struct _QMSG
{
    MSG                 Msg;
    struct _QMSG*       next;
}QMSG;

typedef QMSG* PQMSG;


typedef struct _SYNCMSG
{
    MSG              Msg;
    ZSINT32              retval;
    sem_t            sem_handle;
    struct _SYNCMSG* pNext;
}SYNCMSG;

typedef SYNCMSG* PSYNCMSG;

struct _MSGQUEUE
{
	ZSINT32 testvalue[100];
    ZDWORD dwState;             // message queue states

    OS_MUTEX_ID lock;           // lock
    ZCORE_OS_SEMA_ID wait;      // wait semaphores
    ZCORE_OS_SEMA_ID sync_msg;  // the semaphore for sync message  whb add  

    PQMSG  pFirstNotifyMsg;     // head of the notify message queue
    PQMSG  pLastNotifyMsg;      // tail of the notify message queue

//	#ifndef _LITE_VERSION
    PSYNCMSG pFirstSyncMsg;     // head of the sync message queue
    PSYNCMSG pLastSyncMsg;      // tail of the sync message queue
//	#else
//	    IDLEHANDLER OnIdle;     // Idle handler
//	#endif

    MSG* msg;                   // post message buffer
    ZSINT32 len;                // buffer len
    ZSINT32 readpos, writepos;  // positions for reading and writing

    ZDWORD TimerMask;           // used timer slots mask
    HWND  hCaretWnd;
    ZUINT8 QuitCount;
//	#endif

};
typedef struct _MSGQUEUE MSGQUEUE;
typedef MSGQUEUE* PMSGQUEUE;

ZBOOL InitFreeQMSGList (ZVOID);
ZVOID DestroyFreeQMSGList (ZVOID);
ZBOOL InitMsgQueue (PMSGQUEUE pMsgQueue, ZSINT32 iBufferLen);
ZVOID DestroyMsgQueue (PMSGQUEUE pMsgQueue);

extern PMSGQUEUE __mg_dsk_msgs;

  #define MG_MUTEX_INIT(lock)      pthread_mutex_init(lock, NULL)
  #define MG_MUTEX_DESTROY(lock)   pthread_mutex_destroy(lock)
  #define MG_MUTEX_LOCK(lock)      pthread_mutex_lock(lock)
  #define MG_MUTEX_UNLOCK(lock)    pthread_mutex_unlock(lock)

  #define POST_MSGQ(pMsgQueue) \
  { \
    ZSINT32 sem_value; \
    /* Signal that the msg queue contains one more element for reading */ \
    sem_getvalue (&(pMsgQueue)->wait, &sem_value); \
    if (sem_value <= 0) \
        sem_post(&(pMsgQueue)->wait); \
  }

#endif //_ZCORE_INTERNALS_MSG_H_
