#ifndef _PAL_LIST_H_
#define _PAL_LIST_H_

struct list_head {
    struct list_head *next, *prev;
};

typedef struct list_head list_t;

#define LIST_HEAD_INIT(name) { &(name), &(name) }

/* define and init a list head */
#define LIST_HEAD(name) \
    struct list_head name = LIST_HEAD_INIT(name)

/* init a list head */
#define INIT_LIST_HEAD(ptr) do { \
    (ptr)->next = (ptr); (ptr)->prev = (ptr); \
} while (0)

static inline ZVOID __list_add(struct list_head * new_node,
    struct list_head * prev,
    struct list_head * next)
{
    next->prev = new_node;
    new_node->next = next;
    new_node->prev = prev;
    prev->next = new_node;
}

static inline ZVOID list_add(struct list_head *new_node, struct list_head *head)
{
    __list_add(new_node, head, head->next);
}

static inline ZVOID list_add_tail(struct list_head *new_node, struct list_head *head)
{
    __list_add(new_node, head->prev, head);
}

static inline void __list_del(struct list_head * pprev, struct list_head * pnext)
{
    pnext->prev = pprev;
    pprev->next = pnext;
}

static inline void list_del(struct list_head *pentry)
{
    __list_del(pentry->prev, pentry->next);
}

static inline void list_del_init(struct list_head *pentry)
{
    __list_del(pentry->prev, pentry->next);
    INIT_LIST_HEAD(pentry);
}

static inline int list_empty(struct list_head *phead)
{
    return phead->next == phead;
}

#define list_entry(pptr, type, member) \
    ((type *)((char *)(pptr)-(unsigned long)(&((type *)0)->member)))

#define list_for_each(ppos, phead) \
    for (ppos = (phead)->next; ppos != (phead); ppos = ppos->next)

#define list_for_each_safe(ppos, n, phead) \
    for (ppos = (phead)->next, n = ppos->next; ppos != (phead) && ppos != NULL; \
        ppos = n, n = ppos->next)

#define list_for_each_ex(ppos, phead, begin) \
    for (ppos = (begin)->next; ppos != (phead); ppos = (ppos)->next)

#define list_for_index(ppos, i, phead, index) \
    for (ppos = (phead)->next, i=0; (ppos != (phead) && i < index); ppos = ppos->next,i++)

static inline int list_add_by_index(struct list_head *pnew_node, struct list_head *phead, int index)
{
    list_t *ppos = phead;
    int i = -1;

    if (index >= 0) {
        for (ppos = (phead)->next, i=0; (ppos != (phead) && i < index); ppos = ppos->next,i++);
    }
    list_add_tail (pnew_node, ppos);
    return i;
}

/* added for normal list operations */
#define GETBY_EX(func, phead, entrytype, member, datatype, ret, equal_cond) \
        void* func (datatype data) \
        { \
            list_t *pme; \
            entrytype *pdata; \
            int i = 0; \
            \
            list_for_each(pme, phead) { \
                pdata = list_entry(pme, entrytype, member); \
                if (equal_cond) \
                    return ret; \
            } \
            return NULL; \
        }

#define GET_LIST_BY_DATA(func, phead, entrytype, member, datamember, datatype) \
        GETBY_EX(func, phead, entrytype, member, datatype, pme, (pdata->datamember == data))

#define GET_ENTRY_BY_DATA(func, phead, entrytype, member, datamember, datatype) \
        GETBY_EX(func, phead, entrytype, member, datatype, pdata, (pdata->datamember == data))

/* for string */
#define GET_LIST_BY_STRING(func, phead, entrytype, member, datamember, datatype) \
        GETBY_EX(func, phead, entrytype, member, datatype, pme, (strcmp(pdata->datamember,data)==0))

#define GET_ENTRY_BY_STRING(func, phead, entrytype, member, datamember, datatype) \
        GETBY_EX(func, phead, entrytype, member, datatype, pdata, (strcmp(pdata->datamember,data)==0))

/* for index */
#define GET_ENTRY_BY_INDEX(func, entrytype, member) \
        static inline entrytype* func (list_t *phead, int index) \
        { \
            list_t *pme; \
            int i = 0; \
            \
            list_for_each(pme, phead) { \
                if (i++ == index) \
                    return list_entry(pme, entrytype, member); \
            } \
            return NULL; \
        }

#define GET_ENTRY_INDEX(func, entrytype, member) \
        static inline int func (list_t *phead, entrytype* pentry) \
        { \
            list_t *pme; \
            int i = 0; \
            \
            list_for_each(pme, phead) { \
                if (pentry == list_entry(pme, entrytype, member)) \
                    return i; \
                i++; \
            } \
            return -1; \
        }


#endif /* _MG_LIST_H */
