#ifndef Z3D_ENGINE_H
#define Z3D_ENGINE_H

#ifdef __cplusplus
extern "C" {
#endif

/********************************************************************************
    Include File                  ͷļ
********************************************************************************/

#include <z3dEngineMath.h>

/********************************************************************************
    Macro                           궨
********************************************************************************/

// ļ·
#undef  MAX_FILE_PATH
#define MAX_FILE_PATH    256

// Ⱦб
#undef  MAX_RENDER_LIST_POLYGONS
#define MAX_RENDER_LIST_POLYGONS    12

// 
#undef  MAX_MATERIALS
#define MAX_MATERIALS    8

// Դ
#undef  MAX_LIGHTS
#define MAX_LIGHTS    8

// ͸ȼȼԽС͸ЧԽ
#undef  MAX_ALPHA_LEVEL
#define MAX_ALPHA_LEVEL     32

// ȫֿݵȼȼԽСȫֿЧԽ
#undef  MAX_GLOBAL_AA_LEVEL
#define MAX_GLOBAL_AA_LEVEL    0xFF

/********************************************************************************
    Struct                       ݽṹ
********************************************************************************/

// 4D궥
typedef union VERTEX_TYPE
{
    float M[12];              // 洢ʽ

    // ṹ洢ʽ
    struct VERTEX_STRUCT_A
    {
        float x, y, z, w,       // 
              nx, ny, nz, nw,   // ()
              u, v,             // 
              lightColor;       // մĶɫ
        int state;              // ״̬
    } structa;

    struct VERTEX_STRUCT_B
    {
        POINT_4D  vertex;  // 
        VECTOR_4D normal;  // 
        POINT_2D  texture; // 
    } structb;

} VERTEX, *VERTEX_PTR;

// λͼͼ
typedef struct BITMAP_IMAGE_TYPE
{
    int x, y;                   // λͼλ

    unsigned int width, height, // λͼߴ
        numberBytes,   // λͼܹжֽ
        bitsPerPixel;  // ÿжλ

    void *pPixelData;           // λͼ

} BITMAP_IMAGE, *BITMAP_IMAGE_PTR;

// 
typedef struct POLYGON_TYPE
{
    int state,                        // ״̬
        material;                     // ID-1ʾ޲

    unsigned int vertexListIndex[3],  // ָ򶥵б
                 textureListIndex[3]; // ָб

    VERTEX_PTR pVertexList;           // б
    POINT_2D_PTR pTextureList;        // б
    BITMAP_IMAGE_PTR pTextureImage;   // ָϢָ룬ӳ

    struct POLYGON_TYPE *pNext,       // ָһεָ
                        *pPrev;       // ָһεָ

    unsigned short color,             // εɫ
                   lightColor[3];     // ڴ洢մɫ

    float normalLength;               // ߳

    VECTOR_4D normal;                 // εķ

    VERTEX modelVertex[3],            // εĶ㣬ģ
           transVertex[3];            // 任Ķ

} POLYGON, *POLYGON_PTR;

// ڶбͶб
typedef struct OBJECT_TYPE
{
    int id,                          // ID
        state,                       // ״̬
        material;                    // ID-1ʾ޲

    unsigned int numberFrames,       // ֡
                 currentFrame,       // ǰֻ֡һ֡Ϊ0
                 verticesPerFrame,   // ÿ֡Ķ
                 totalVertices,      // ȫÿ֡Ķ*֡
                 numberPolygons;     // еĶ

    VERTEX_PTR pModelVertexList,     // ǰ֡ģ궥б
               pTransVertexList,     // ǰ֡ı任Ķб
               pHeadModelVertexList, // ָģ궥бͷָ
               pHeadTransVertexList; // ָ任Ķбͷָ

    POLYGON_PTR pPolygonList;        // б

    POINT_2D_PTR pTextureList;       // бΪ3

    BITMAP_IMAGE_PTR pTextureImage;  // ָͼָ룬ӳ

    float *pMaxRadius;               // 뾶б֡ÿ֡ͬ

    POINT_4D worldPosition;          // ϵеλãͬģ굽ƽ

    VECTOR_4D modelAxisX,            // ڼ¼ģᣬʹ
              modelAxisY,
              modelAxisZ,
              transAxisX,            // 任ڼ¼ģᣬʹ
              transAxisY,
              transAxisZ;

} OBJECT, *OBJECT_PTR;

// 
typedef struct CAMERA_TYPE
{
    float visualDistance,    // ӾࣨˮƽʹֱӾͬ
          visualField,       // ҰˮƽʹֱҰͬ
          nearClipPlaneZ,    // üZ
          farClipPlaneZ,     // ԶüZ
          visualPlaneWidth,  // ƽĿ
          visualPlaneHeight, // ƽĸ߶
          screenWidth,       // Ļ
          screenHeight,      // Ļ߶
          screenCenterX,     // ĻX
          screenCenterY,     // ĻY
          aspectRatio;       // ĻĿ߱

    POINT_4D position,       // ϵеλ
             target;         // UVNģעĿλ

    VECTOR_4D direction,     // UVNģ͵עӷŷģ͵ĽǶ
              u,             // UVNģ͵֮һ
              v,             // UVNģ͵֮һ
              n;             // UVNģ͵ע֮һ

    MATRIX_4X4 cameraMatrix; // ڴ洢굽ı任

} CAMERA, *CAMERA_PTR;

// RGBAֵ
typedef union RGBA_TYPE
{
    unsigned int  rgba; // ѹʽ
    unsigned char M[4]; // 洢ʽ

    // ṹ洢ʽ
    struct RGBA_STRUCT
    {
        unsigned char r, g, b, a;
    } structa;

} RGBA, *RGBA_PTR;

// 
typedef struct MATERIAL_TYPE
{
    int id;                          // IDָб

    float ambient,                   // ķϵ
          diffuse,                   // ɢķϵ
          specular,                  // 淴ķϵ
          specularExponent;          // 淴ָ

    RGBA color,                      // ɫ
         colorAmbient,               // ԤȼõɫͷϵĻ
         colorDiffuse,
         colorSpecular;

    char texturePath[MAX_FILE_PATH]; // ͼļ·

    BITMAP_IMAGE textureImage;       // ͼ

} MATERIAL, *MATERIAL_PTR;

// Դ
typedef struct LIGHT_TYPE
{
    int id,                         // ԴIDָԴб
        state;                      // Դ״̬

    float constantAttenuation,      // ˥
          linearAttenuation,        // ˥
          quadricAttenuation,       // ˥
          spotInnerAngle,           // ۹׶
          spotOuterAngle,           // ۹׶
          spotExponent;             // ۹ָ

    RGBA ambient,                   // ǿ
         diffuse,                   // ɢǿ
         specular;                  // 淴ǿ

    POINT_4D position,              // Դλã
             positionTransformed;   // Դλã任

    VECTOR_4D direction,            // Դ
              directionTransformed; // Դ򣬱任

} LIGHT, *LIGHT_PTR;

// Ȼ
typedef struct ZBUFFER_TYPE
{
    unsigned int width,  // 
                 height, // ߶
                 pitch,  // ڴ
                 size;   // Сжֽ

    void *pBuffer;       // ָ洢ռָ

} ZBUFFER, *ZBUFFER_PTR;

// Ⱦб
typedef struct RENDER_LIST_TYPE
{
    int state,    // Ⱦб״̬
        isEdgeAA; // ǷʹñԵ

    unsigned int size,                // ȾбС
                 numberPolygons,      // 
                 alphaLevel,          // ε͸ȼֵ[0, MAX_ALPHA_LEVEL]ȼԽС͸ЧԽ
                 frameBufferPitch,    // 16λΪλԴڴ
                 zbufferPitch;        // 32λ˫ΪλȻڴ

    void *pFrameBuffer, // Դ
         *pZbuffer;     // Ȼ

    POLYGON_PTR *ppPolygonPtrList; // ָ飬ÿָָһ

    POLYGON_PTR pPolygonList; // 飬Ϊÿ֡ΪηͷŴ洢ռ䣬ݴ洢

    unsigned char globalAALevel,      // ȫֿݵȼֵ[0, MAX_GLOBAL_AA_LEVEL]ȼԽСЧԽ
                  alphaGlobalAALevel; // ͸ʱȫֿݵȼֵ[0, MAX_GLOBAL_AA_LEVEL]ȼԽСЧԽ

    unsigned short filling; // ֻ2ֽڣṹ岻ʹ

} RENDER_LIST, *RENDER_LIST_PTR;

/********************************************************************************
    Manifest Constant              
********************************************************************************/

// ״̬
enum VERTEX_STATE
{
    VERTEX_STATE_NULL   = 0x0000, // ״̬

    VERTEX_STATE_NORMAL = 0x0001  // зߣڹ
};

// Ϊӳ亯
enum TRIANGLE_TYPE
{
    TRIANGLE_TYPE_NULL        = 0x0000, // 
    TRIANGLE_TYPE_FLAT_TOP    = 0x0001, // ƽ
    TRIANGLE_TYPE_FLAT_BOTTOM = 0x0002, // ƽ
    TRIANGLE_TYPE_FLAT_MASK   = 0x0003, // ȡֵ
    TRIANGLE_TYPE_GENERAL     = 0x0004  // 
};

// ĸֵ߲
enum INTERPOLATION
{
    INTERPOLATION_LHS = 1, // ֵ߲
    INTERPOLATION_RHS = 2  // Ҳֵ߲
};

// ״̬
enum POLYGON_STATE
{
    POLYGON_STATE_NULL     = 0x0000, // ״̬

    POLYGON_STATE_CLIPPED  = 0x0001, // ѱü
    POLYGON_STATE_BACKFACE = 0x0002, // 治ɼ
    POLYGON_STATE_2SIDED   = 0x0004, // ˫
    POLYGON_STATE_TEXTURE  = 0x0008, // ɫģʽ

    POLYGON_STATE_LITGHTED = 0x0010, // Ѿչ
    POLYGON_STATE_CONSTANT = 0x0020, // ̶ɫģʽ
    POLYGON_STATE_FLAT     = 0x0040, // ƽɫģʽ
    POLYGON_STATE_GOURAUD  = 0x0080  // Gouraudɫģʽ
};

// ״̬
enum OBJECT_STATE
{
    OBJECT_STATE_NULL         = 0x0000, // ״̬

    OBJECT_STATE_CULLED       = 0x0001, // ޳״̬
    OBJECT_STATE_SINGLE_FRAME = 0x0002, // ֡
    OBJECT_STATE_MULTI_FRAME  = 0x0004  // ֡
};

// 任ʽ
enum TRANSFORM
{
    TRANSFORM_MODEL_ONLY          = 1, // ģ궥бб任
    TRANSFORM_TRANS_ONLY          = 2, // Ա任Ķбб任
    TRANSFORM_MODEL_TO_TRANS      = 3, // ģ궥бб任洢ڱ任Ķб
    TRANSFORM_COPY_MODEL_TO_TRANS = 4  // ģ궥бֵ任Ķб
};

// ޳ʱҪѡĲü
enum CULL_OBJECT
{
    CULL_OBJECT_X_PLANE    = 0x0001, // Ҳü޳
    CULL_OBJECT_Y_PLANE    = 0x0002, // ²ü޳
    CULL_OBJECT_Z_PLANE    = 0x0004, // Զü޳
    CULL_OBJECT_XYZ_PLANES = 0x0007  // ҡ¡Զü޳
};

// ȾбеĶν3DüʱҪѡĲü
enum CLIP_POLYGON
{
    CLIP_POLYGON_X_PLANE    = 0x0001, // Ҳü3Dü
    CLIP_POLYGON_Y_PLANE    = 0x0002, // ²ü3Dü
    CLIP_POLYGON_Z_PLANE    = 0x0004, // Զü3Dü
    CLIP_POLYGON_XYZ_PLANES = 0x0007  // ҡ¡Զü3Dü
};

// Ⱦбжб㷨
enum SORT_POLYGON_LIST
{
    SORT_POLYGON_LIST_AVGZ  = 1, // ƽZֵ
    SORT_POLYGON_LIST_NEARZ = 2, // СZֵ
    SORT_POLYGON_LIST_FARZ  = 3  // Zֵ
};

// ŷת˳
enum CAMERA_ROTATION_SEQUENCE
{
    CAMERA_ROTATION_SEQUENCE_XYZ = 1, // XYZת˳
    CAMERA_ROTATION_SEQUENCE_YXZ = 2, // YXZת˳
    CAMERA_ROTATION_SEQUENCE_XZY = 3, // XZYת˳
    CAMERA_ROTATION_SEQUENCE_YZX = 4, // YZXת˳
    CAMERA_ROTATION_SEQUENCE_ZYX = 5, // ZYXת˳
    CAMERA_ROTATION_SEQUENCE_ZXY = 6  // ZXYת˳
};

// UVNģʽ
enum UVN_CAMERA_MODE
{
    UVN_CAMERA_MODE_SIMPLE    = 1, // ģʽ
    UVN_CAMERA_MODE_SPHERICAL = 2  // ģʽ
};

// Դ״̬
enum LIGHT_STATE
{
    LIGHT_STATE_NULL = 0x0000, // ״̬

    LIGHT_STATE_ON   = 0x0001, // Դ
    LIGHT_STATE_OFF  = 0x0002, // Դر

    LIGHT_STATE_AMBIENT           = 0x0004, // Դ
    LIGHT_STATE_INFINITE          = 0x0008, // ԶԴ
    LIGHT_STATE_POINT             = 0x0010, // Դ
    LIGHT_STATE_SIMPLE_SPOTLIGHT  = 0x0020, // 򵥾۹
    LIGHT_STATE_COMPLEX_SPOTLIGHT = 0x0040  // Ӿ۹
};

// λͼɨȡģʽ
enum BITMAP_EXTRACT_MODE
{
    BITMAP_EXTRACT_MODE_CELL = 1, // Ԫģʽ
    BITMAP_EXTRACT_MODE_ABS  = 2  // ģʽ
};

// Ⱦб״̬
enum RL_STATE
{
    RL_STATE_NULL              = 0x0000, // ״̬

    RL_STATE_CONSTANT          = 0x0001, // ̶ɫģʽ
    RL_STATE_FLAT              = 0x0002, // ƽɫģʽ
    RL_STATE_GOURAUD           = 0x0004, // Gouraudɫģʽ
    RL_STATE_TEXTURED          = 0x0008  // ģʽ
};

/********************************************************************************
    Global Variable                ȫֱ
********************************************************************************/

extern LIGHT gLights[MAX_LIGHTS];          // Դб
extern MATERIAL gMaterials[MAX_MATERIALS]; // б

/********************************************************************************
    Global Function Prototype    ȫֺ
********************************************************************************/

/********************************************************************************
                                ģеĺ
********************************************************************************/

/********************************************************************************
      z3dNewObject
        ܣ½壬Ϊڴ
    numberFrames֡  verticesPerFrameÿ֡Ķ  numberPolygons  destroyǷɾԭ  pObject
    pObject
      ֵTRUE  FALSE
    ˵destroyTRUEͷԭռõڴ棬Ȼ·ڴ
********************************************************************************/
int z3dNewObject(const unsigned int numberFrames, const unsigned int verticesPerFrame, const unsigned int numberPolygons, const int destroy, OBJECT_PTR pObject);

/********************************************************************************
      z3dDeleteObject
        ܣɾ壬ͷռõڴ
    pObject
    
      ֵ
    ˵
********************************************************************************/
void z3dDeleteObject(OBJECT_PTR pObject);

/********************************************************************************
      z3dResetObjectState
        ܣ״ֵ̬
    pObject
    pObject
      ֵ
    ˵֡
********************************************************************************/
void z3dResetObjectState(OBJECT_PTR pObject);

/********************************************************************************
      z3dSetObjectFrame
        ܣ񶯻֡еĵǰ֡
    frameҪõ֡  pObject
    pObject
      ֵ
    ˵ûж֡OBJECT4DV2_ATTR_MULTI_FRAMEò
********************************************************************************/
void z3dSetObjectFrame(unsigned int frame, OBJECT_PTR pObject);

/********************************************************************************
      z3dTranslateObject
        ܣƽ
    pTranslationVectorƽ  transformChoice任ѡ  allFramesǷ֡  pObject
    pObject
      ֵ
    ˵
********************************************************************************/
void z3dTranslateObject(const VECTOR_4D_PTR pTranslationVector, const int transformChoice, const int allFrames, OBJECT_PTR pObject);

/********************************************************************************
      z3dScaleObject
        ܣ
    pScaledVector  transformChoice任ѡ  allFramesǷ֡  pObject
    pObject
      ֵ
    ˵
********************************************************************************/
void z3dScaleObject(const VECTOR_4D_PTR pScaledVector, const int transformChoice, const int allFrames, OBJECT_PTR pObject);

/********************************************************************************
      z3dRotateObject
        ܣת
    xAngleXתĽǶ  yAngleYתĽǶ  zAngleZתĽǶ  transformChoice任ѡ
              allFramesǷ֡  pObject
    pObject
      ֵ
    ˵
********************************************************************************/
void z3dRotateObject(const float xAngle, const float yAngle, const float zAngle, const int transformChoice, const int allFrames, OBJECT_PTR pObject);

/********************************************************************************
      z3dTransformObject
        ܣб任
    pTransformationMatrix任  transformChoice任ʽ  allFramesǷ֡  pObject
    pObject
      ֵ
    ˵任ʽΪTRANSFORM_COPY_LOCAL_TO_TRANSʱҪ任󣬱任ȡֵ
********************************************************************************/
void z3dTransformObject(const MATRIX_4X4_PTR pTransformationMatrix, const int transformChoice, const int allFrames, OBJECT_PTR pObject);

/********************************************************************************
      z3dModelToWorldObject
        ܣִģ굽任
    transformChoice任ѡ  allFramesǷ֡  pObject
    pObject
      ֵ
    ˵
********************************************************************************/
void z3dModelToWorldObject(const int transformChoice, const int allFrames, OBJECT_PTR pObject);

/********************************************************************************
      z3dCullObject
        ܣ޳
    pCamera  cullFlag޳ʱҪѡĲü  pObjectҪִ޳
    pObject
      ֵ
    ˵ֻĵǰ֡޳
********************************************************************************/
void z3dCullObject(const CAMERA_PTR pCamera, const int cullFlag, OBJECT_PTR pObject);

/********************************************************************************
      z3dRemoveBackfacesObject
        ܣִб
    pCameraʱʹõ  counterclockwise㰴ʱ뷽  pObjectҪִб
    pObject
      ֵ
    ˵
********************************************************************************/
void z3dRemoveBackfacesObject(const CAMERA_PTR pCamera, const int counterclockwise, OBJECT_PTR pObject);

/********************************************************************************
      z3dWorldToCameraObject
        ܣִ굽任
    pCamera  pObject
    pObject
      ֵ
    ˵
********************************************************************************/
void z3dWorldToCameraObject(const CAMERA_PTR pCamera, OBJECT_PTR pObject);

/********************************************************************************
      z3dCameraToPerspectiveObject
        ܣִ굽͸任
    pCamera  pObject
    pObject
      ֵ
    ˵
********************************************************************************/
void z3dCameraToPerspectiveObject(const CAMERA_PTR pCamera, OBJECT_PTR pObject);

/********************************************************************************
      z3dPerspectiveToScreenObject
        ܣִ͸굽Ļ任
    pCamera  pObject
    pObject
      ֵ
    ˵
********************************************************************************/
void z3dPerspectiveToScreenObject(const CAMERA_PTR pCamera, OBJECT_PTR pObject);

/********************************************************************************
      z3dCameraToScreenObject
        ܣִ굽Ļ任൱ڽ͸ӱ任Ļ任϶Ϊһ
    pCamera  pObject
    pObject
      ֵ
    ˵
********************************************************************************/
void z3dCameraToScreenObject(const CAMERA_PTR pCamera, OBJECT_PTR pObject);

/********************************************************************************
      z3dComputeObjectRadius
        ܣ嵱ǰ֡ƽ뾶뾶
    pObject
    pObject
      ֵ
    ˵
********************************************************************************/
void z3dComputeObjectRadius(OBJECT_PTR pObject);

/********************************************************************************
      z3dComputeObjectPolygonNormals
        ܣĶηߣʹ
    pObject
    pObject
      ֵ
    ˵
********************************************************************************/
void z3dComputeObjectPolygonNormals(OBJECT_PTR pObject);

/********************************************************************************
      z3dComputeObjectVertexNormals
        ܣĶ㷨ߣGouraudɫģʽʹ
    pObject
    pObject
      ֵTRUE  FALSE
    ˵
********************************************************************************/
int z3dComputeObjectVertexNormals(OBJECT_PTR pObject);

/********************************************************************************
                                ģеĺ
********************************************************************************/

/********************************************************************************
      z3dInitCamera
        ܣʼ
    pPositionĳʼλ  pTargetĳʼĿλ  pDirectionĳʼ
              nearClipPlaneZüZ  farClipPlaneZԶüZ  visualFieldҰλΪ
              screenWidthĻ  screenHeightĻ߶  pCamera
    pCamera
      ֵ
    ˵
********************************************************************************/
void z3dInitCamera(const POINT_4D_PTR   pPosition,
                   const POINT_4D_PTR   pTarget,
                   const VECTOR_4D_PTR  pDirection,
                   const float          nearClipPlaneZ,
                   const float          farClipPlaneZ,
                   const float          visualField,
                   const float          screenWidth,
                   const float          screenHeight,
                   CAMERA_PTR           pCamera);

/********************************************************************************
      z3dCreateEulerCameraMatrix
        ܣŷǶȴŷ任
    cameraRotationSequenceŷת˳  pCamera
    pCamera
      ֵ
    ˵
********************************************************************************/
void z3dCreateEulerCameraMatrix(const int cameraRotationSequence, CAMERA_PTR pCamera);

/********************************************************************************
      z3dCreateUVNCameraMatrix
        ܣUVעNUVN任
    cameraCoordinateModelUVNģʽ    pCamera
    pCamera
      ֵ
    ˵
********************************************************************************/
void z3dCreateUVNCameraMatrix(const int cameraCoordinateModel, CAMERA_PTR pCamera);

/********************************************************************************
                              任ģеĺ
********************************************************************************/

/********************************************************************************
      z3dCreateRotationMatrix
        ܣXYZתĽǶȴһת
    xThetaXתĽǶ  yThetaYתĽǶ  zThetaZתĽǶ
    pRotationMatrixת
      ֵ
    ˵
********************************************************************************/
void z3dCreateRotationMatrix(const float xTheta, const float yTheta, const float zTheta, MATRIX_4X4_PTR pRotationMatrix);

/********************************************************************************
      z3dCreateModelToWorldMatrix
        ܣƽһģ굽ı任
    pTranslationVectorƽ
    pTransformationMatrix任
      ֵ
    ˵
********************************************************************************/
void z3dCreateModelToWorldMatrix(const VECTOR_4D_PTR pTranslationVector, MATRIX_4X4_PTR pTransformationMatrix);

/********************************************************************************
      z3dCreateCameraToPerspectiveMatrix
        ܣһ굽͸ı任
    pCamera
    pTransformationMatrix任
      ֵ
    ˵
********************************************************************************/
void z3dCreateCameraToPerspectiveMatrix(const CAMERA_PTR pCamera, MATRIX_4X4_PTR pTransformationMatrix);

/********************************************************************************
      z3dCreatePerspectiveToScreenMatrix
        ܣһ͸굽Ļı任
    pCamera
    pTransformationMatrix任
      ֵ
    ˵
********************************************************************************/
void z3dCreatePerspectiveToScreenMatrix(const CAMERA_PTR pCamera, MATRIX_4X4_PTR pTransformationMatrix);

/********************************************************************************
      z3dCreateCameraToScreenMatrix
        ܣһ굽Ļı任
    pCamera
    pTransformationMatrix任
      ֵ
    ˵
********************************************************************************/
void z3dCreateCameraToScreenMatrix(const CAMERA_PTR pCamera, MATRIX_4X4_PTR pTransformationMatrix);

/********************************************************************************
                              Ⱦбģеĺ
********************************************************************************/

/********************************************************************************
      z3dNewRenderList
        ܣ½Ⱦб
    pRenderListȾб
    pRenderListȾб
      ֵTRUE  FALSE
    ˵ڵúz3dDrawRenderList֮ǰһ
********************************************************************************/
int z3dNewRenderList(RENDER_LIST_PTR pRenderList);

/********************************************************************************
      z3dDeleteRenderList
        ܣɾȾб
    pRenderListȾб
    pRenderListȾб
      ֵ
    ˵
********************************************************************************/
void z3dDeleteRenderList(RENDER_LIST_PTR pRenderList);

/********************************************************************************
      z3dResetRenderList
        ܣȾбһ֡ʹ
    pRenderListȾб
    pRenderListȾб
      ֵ
    ˵ÿһ֡Ҫ
********************************************************************************/
void z3dResetRenderList(RENDER_LIST_PTR pRenderList);

/********************************************************************************
      z3dInsertPolygonRenderList
        ܣβ뵽Ⱦб
    pPolygon  pRenderListȾб
    pRenderListȾб
      ֵ
    ˵Ⱦбʱú
********************************************************************************/
void z3dInsertPolygonRenderList(const POLYGON_PTR pPolygon, RENDER_LIST_PTR pRenderList);

/********************************************************************************
      z3dInsertObjectRenderList
        ܣ뵽Ⱦб
    pObject  insertModelģ궥任Ķ  pRenderListȾб
    pRenderListȾб
      ֵ
    ˵
********************************************************************************/
void z3dInsertObjectRenderList(const OBJECT_PTR pObject, const int insertModel, RENDER_LIST_PTR pRenderList);

/********************************************************************************
      z3dRemoveBackfacesRenderList
        ܣȾбдڱĶ
    pCamera  counterclockwise㰴ʱ뷽  pRenderListȾб
    pRenderListȾб
      ֵ
    ˵
********************************************************************************/
void z3dRemoveBackfacesRenderList(const CAMERA_PTR pCamera, const int counterclockwise, RENDER_LIST_PTR pRenderList);

/********************************************************************************
      z3dWorldToCameraRenderList
        ܣȾбִ굽任
    pCamera  pRenderListȾб
    pRenderListȾб
      ֵ
    ˵
********************************************************************************/
void z3dWorldToCameraRenderList(const CAMERA_PTR pCamera, RENDER_LIST_PTR pRenderList);

/********************************************************************************
      z3dCameraToPerspectiveRenderList
        ܣȾбִ굽͸任
    pCamera  pRenderListȾб
    pRenderListȾб
      ֵ
    ˵
********************************************************************************/
void z3dCameraToPerspectiveRenderList(const CAMERA_PTR pCamera, RENDER_LIST_PTR pRenderList);

/********************************************************************************
      z3dPerspectiveToScreenRenderList
        ܣȾбִ͸굽Ļ任
    pCamera  pRenderListȾб
    pRenderListȾб
      ֵ
    ˵
********************************************************************************/
void z3dPerspectiveToScreenRenderList(const CAMERA_PTR pCamera, RENDER_LIST_PTR pRenderList);

/********************************************************************************
      z3dCameraToScreenRenderList
        ܣȾбִ굽Ļ任൱ڽ͸ӱ任Ļ任϶Ϊһ
    pCamera  pRenderListȾб
    pRenderListȾб
      ֵ
    ˵
********************************************************************************/
void z3dCameraToScreenRenderList(const CAMERA_PTR pCamera, RENDER_LIST_PTR pRenderList);

/********************************************************************************
      z3dSortRenderList
        ܣȾбִZ򣨼
    sortMethod㷨  pRenderListȾб
    pRenderListȾб
      ֵ
    ˵ڼ
********************************************************************************/
void z3dSortRenderList(const int sortMethod, RENDER_LIST_PTR pRenderList);

/********************************************************************************
      z3dClipPolygonRenderList
        ܣȾбеĶν3Dü
    pCamera  clipFlag3DüʱҪѡĲü  pRenderListҪ3DüȾб
    pRenderListҪ3DüȾб
      ֵ
    ˵
********************************************************************************/
void z3dClipPolygonRenderList(const CAMERA_PTR pCamera, const int clipFlag, RENDER_LIST_PTR pRenderList);

/********************************************************************************
      z3dTransformRenderList
        ܣȾбб任
    pTransformationMatrix任  transformChoice任ʽ  pRenderListȾб
    pRenderListȾб
      ֵ
    ˵
********************************************************************************/
void z3dTransformRenderList(const MATRIX_4X4_PTR pTransformationMatrix, const int transformChoice, RENDER_LIST_PTR pRenderList);

/********************************************************************************
                                ģеĺ
********************************************************************************/

/********************************************************************************
      z3dInitLight
        ܣʼԴбָĹԴԴбΪȫֱ
    idҪʼĹԴ(0MAX_LIGHTS-1)  stateԴ״̬  ambientǿ
              diffuseɢǿ  specular淴ǿ  pPositionԴλ  pDirectionԴ
              constantAttenuation˥  linearAttenuation˥  quadricAttenuation˥
              spotInnerAngle۹׶  spotOuterAngle۹׶  spotExponent۹ָ
    
      ֵ
    ˵øúʱΪȷĹԴЧ뽫ҪĲֵΪ0Ӧȵúz3dResetLightsһ
********************************************************************************/
void z3dInitLight(const int            id,
                  const int            state,
                  const RGBA           ambient,
                  const RGBA           diffuse,
                  const RGBA           specular,
                  const POINT_4D_PTR   pPosition,
                  const VECTOR_4D_PTR  pDirection,
                  const float          constantAttenuation,
                  const float          linearAttenuation,
                  const float          quadricAttenuation,
                  const float          spotInnerAngle,
                  const float          spotOuterAngle,
                  const float          spotExponent);

/********************************************************************************
      z3dResetLights
        ܣùԴбԴбΪȫֱ
    
    
      ֵ
    ˵
********************************************************************************/
void z3dResetLights(void);

/********************************************************************************
      z3dResetMaterials
        ܣòббΪȫֱ
    
    
      ֵ
    ˵
********************************************************************************/
void z3dResetMaterials(void);

/********************************************************************************
      z3dLightRenderList
        ܣʹгʼĹԴȾбִйմԴбΪȫֱ
    pCamera  pRenderListȾб
    pRenderListȾб
      ֵ
    ˵
********************************************************************************/
void z3dLightRenderList(const CAMERA_PTR pCamera, RENDER_LIST_PTR pRenderList);

/********************************************************************************
      z3dTransformLights
        ܣʹñ任ȥ任гʼĹԴԴбΪȫֱ
    pTransformationMatrix任  transformChoice任ʽ
    
      ֵ
    ˵任ʽΪTRANSFORM_COPY_LOCAL_TO_TRANSʱҪ任󣬱任ȡֵ
********************************************************************************/
void z3dTransformLights(const MATRIX_4X4_PTR pTransformationMatrix, const int transformChoice);

/********************************************************************************
                                ģеĺ
********************************************************************************/

/********************************************************************************
      z3dNewBitmap
        ܣ½λͼͼλͼݶΪ0
    xXλ  yYλ  widthλͼ  heightλͼ߶  bitsPerPixelÿжλ
    pBitmapImageλͼͼ
      ֵTRUE  FALSE
    ˵øú֮Ҫúz3dLoadBitmapȥλͼ
********************************************************************************/
int z3dNewBitmap(const int x,
                 const int y,
                 const unsigned int width,
                 const unsigned int height,
                 const unsigned int bitsPerPixel,
                 BITMAP_IMAGE_PTR pBitmapImage);

/********************************************************************************
      z3dDeleteBitmap
        ܣͷλͼͼڴ
    pBitmapImageλͼͼ
    
      ֵ
    ˵
********************************************************************************/
void z3dDeleteBitmap(BITMAP_IMAGE_PTR pBitmapImage);

/********************************************************************************
      z3dReferBitmap
        ܣ½λͼͼλͼⲿڴ
    xXλ  yYλ  widthλͼ  heightλͼ߶  bitsPerPixelÿжλ  pBufferⲿڴ
    pBitmapImageλͼͼ
      ֵ
    ˵úֱⲿڴ棬µڴ
********************************************************************************/
void z3dReferBitmap(const int x,
                    const int y,
                    const unsigned int width,
                    const unsigned int height,
                    const unsigned int bitsPerPixel,
                    void* pBuffer,
                    BITMAP_IMAGE_PTR pBitmapImage);

/********************************************************************************
       z3dLoadBitmap
         ܣλͼļݵָλͼͼ
     pBitmapҪصλͼļ  bitsPerPixelÿжλ  bitmapWidthλͼļ
               xλX  yλY  bitmapExtractModeλͼȡģʽ
     pBitmapImageλͼͼ
       ֵ
     ˵
********************************************************************************/
void z3dLoadBitmap(const unsigned char* pBitmap,
                   const unsigned int bitsPerPixel,
                   const unsigned int bitmapWidth,
                   const int x,
                   const int y,
                   const int bitmapExtractMode,
                   BITMAP_IMAGE_PTR pBitmapImage);

/********************************************************************************
      z3dExtractFilenameFromPath
        ܣļ·ȡļ
    pFilepathļ·
    pFilenameļ
      ֵ
    ˵
********************************************************************************/
void z3dExtractFilenameFromPath(const char *pFilepath, char *pFilename);

/********************************************************************************
                               դģеĺ
********************************************************************************/

/********************************************************************************
      z3dDrawRenderList
        ܣȾб̶ֹ֧ɫƽɫGouraudɫ֧ӳ
    pRenderListȾб
    pRenderListȾб
      ֵ
    ˵
********************************************************************************/
void z3dDrawRenderList(RENDER_LIST_PTR pRenderList);

/********************************************************************************
      z3dInitScreenClip
        ܣʼĻü
    leftϽǵX  topϽǵY
             right½ǵX  bottom½ǵY
    
      ֵ
    ˵ڵúz3dDrawRenderList֮ǰһ
********************************************************************************/
void z3dInitScreenClip(const int left, const int top, const int right, const int bottom);

/********************************************************************************
                              Ȼģеĺ
********************************************************************************/

/********************************************************************************
      z3dNewZbuffer
        ܣ½Ȼ
    width  height߶  pZbufferȻ
    pZbufferȻ
      ֵTRUE  FALSE
    ˵
********************************************************************************/
int z3dNewZbuffer(const unsigned int width, const unsigned int height, ZBUFFER_PTR pZbuffer);

/********************************************************************************
      z3dDeleteZbuffer
        ܣɾȻ
    pZbufferȻ
    
      ֵ
    ˵
********************************************************************************/
void z3dDeleteZbuffer(ZBUFFER_PTR pZbuffer);

/********************************************************************************
      z3dReferZbuffer
        ܣ½Ȼ棬ⲿڴ
    width  height߶  pBufferⲿڴ  pZbufferȻ
    pZbufferȻ
      ֵ
    ˵úֱⲿڴ棬µڴ
********************************************************************************/
void z3dReferZbuffer(const unsigned int width, const unsigned int height, void *pBuffer, ZBUFFER_PTR pZbuffer);

/********************************************************************************
      z3SetZbuffer
        ܣȻ
    dataҪõֵ  pZbufferȻ
    pZbufferȻ
      ֵ
    ˵
********************************************************************************/
void z3dSetZbuffer(const unsigned int data, ZBUFFER_PTR pZbuffer);

/********************************************************************************
                               MIPӳģеĺ
********************************************************************************/

#ifdef __cplusplus
}
#endif

#endif
