#ifndef _ZCORE_2D_H
#define _ZCORE_2D_H

#include "zcore_type.h"
#include "gui_common.h"

typedef struct _EXEC2DEFFECT
{
    /* Ƿִ2DЧ */
    ZBOOL bExecute2DEffect;
    
    /* TRUEʾģFALSEʾڴģ
    ٣ڴʱ¼ǰǱסĴڣӦ¼ٴڵ2D
       ӦЧ */
    ZBOOL  bDestory;

    /*¼Ч*/
    ZDWORD dwStyle;
    
    /* ¼ */
    ZDWORD dwExStyle; 

    /* 2DЧӦĴھ,Ҫڴ˼¼
       GetMessageеòӦȷھ */
    HWND hWnd;
    
    /* ֤ЧȷϢִ */
    ZVOID *pMsgQueue;
    
    /* סٴڵĴС֤ģʽ
        ʱȷ*/
    RECT  rect;
}EXEC2DEFFECT;

/* TouchWizɳЧ*/
typedef struct _WIPE2DEFFECT
{
	/* TouchWiz*/
	zuint32 fStyle;
    
	/* شִзɳЧĻڵĿ*/
	ZSINT32 dWidth;
    
	/* ش*/
	RECT dRectTouchWin;
    
	/* ָʾ*/
	RECT dRectArrow;
    
	/* ָʾλͼڷֹô϶дб*/
	BITMAP dBmpArrow;
	
}WIPE2DEFFECT;

typedef struct _EXECTHUMBTOUCH
{
    /* ǷִĴָЧ */
    ZBOOL bExecuteTTouch;
    
    /*¼Ч*/
    ZDWORD dwStyle;
    
    /* 2DЧӦĴھ,Ҫڴ˼¼
       GetMessageеòӦȷھ */
    HWND hWnd;
    
    /* ֤ЧȷϢִ */
    ZVOID *pMsgQueue;
     
    //RECT  rect;
}EXECTHUMBTOUCH;

typedef enum
{   
    E_RANK_3X3 = 9,
    E_RANK_3X4 = 12      
}E_MAINMENUICONRANK;                // main menuiconзʽ

typedef struct
{
    E_MAINMENUICONRANK rank;        //зʽ 
    RECT mainMenuRect;              //û趨icon붼mainMenuRect֮

    union 
    {
		RECT rect3X4[E_RANK_3X4];
        RECT rect3X3[E_RANK_3X3];
    }icon;

    ZSINT32 bkgColor;               //ɫiconƶʱɫ
    
}T_ICONINFOINEFFECTZOOM;//iconϢzoomЧ,Ŀǰֻ֧3*4  3*3       


#define WHETHER_LOCATION_2D     (0)             // ЧǷֶеλ
//#define BEING_2D                (1 << WHETHER_LOCATION_2D)
#define BEING_2D                (0x90000000)
#define WHETHER_MASK_2D         (1 << WHETHER_LOCATION_2D)

#define THUMB_TOUCH_LOCATION_2D (1)             // ЧǷĴֶָеλ
#define THUMB_TOUCH_2D          (1 << THUMB_TOUCH_LOCATION_2D)
#define THUMB_TOUCH_MASK_2D     (1 << THUMB_TOUCH_LOCATION_2D)

#define ATTACH_LOCATION_2D      (2)             // ЧĸϢֶеλ
/* WIPE Կʼ     */
/* ֧ҷб߷򼷳Ч֧   */
#define ATTACH_EXTRUDE_2D       (1 << ATTACH_LOCATION_2D) // wipeЧ         
/* WIPE Խ     */
/* ZOOM Կʼ     */ 
#define ATTACH_FADE_2D          (1 << ATTACH_LOCATION_2D) // zoomЧ뵭
#define ATTACH_ICON_FLY_2D      (2 << ATTACH_LOCATION_2D) // zoomЧicon
/* ZOOM Խ     */
#define ATTACH_MASK_2D          (3 << ATTACH_LOCATION_2D)

#define DIRECTION_LOCATION_2D   (4)             // Чֶеλ
#define LEFT_2D                 (1 << DIRECTION_LOCATION_2D)
#define RIGHT_2D                (2 << DIRECTION_LOCATION_2D)
#define UP_2D                   (3 << DIRECTION_LOCATION_2D)
#define DOWN_2D                 (4 << DIRECTION_LOCATION_2D)
#define LEFT_UP_2D              (5 << DIRECTION_LOCATION_2D)
#define RIGHT_DOWN_2D           (6 << DIRECTION_LOCATION_2D)
#define LEFT_DOWN_2D            (7 << DIRECTION_LOCATION_2D)
#define RIGHT_UP_2D             (8 << DIRECTION_LOCATION_2D)
#define IN_2D                   (9 << DIRECTION_LOCATION_2D)
#define OUT_2D                  (10 << DIRECTION_LOCATION_2D)
#define DRICT_IN_2D             (11 << DIRECTION_LOCATION_2D)
#define DRICT_OUT_2D            (12 << DIRECTION_LOCATION_2D)
#define DIRECTION_MASK_2D       (15 << DIRECTION_LOCATION_2D)

#define MOTION_LOCATION_2D      (8)             // Ч˶ֶеλ
#define DECELERATE_2D           (1 << MOTION_LOCATION_2D)          
#define ACCELERATE_2D           (2 << MOTION_LOCATION_2D)        
#define BOUNCE_2D               (3 << MOTION_LOCATION_2D)               
#define LINEAR_2D               (4 << MOTION_LOCATION_2D)             
#define SINUS_2D                (5 << MOTION_LOCATION_2D)                  
#define ACCDEC_2D               (6 << MOTION_LOCATION_2D)
#define OVERSTEP_IN_START_2D    (7 << MOTION_LOCATION_2D)
#define OVERSTEP_IN_END_2D      (8 << MOTION_LOCATION_2D)
#define MOTION_MASK_2D          (15 << MOTION_LOCATION_2D)

#define TYPE_LOCATION_2D        (12)            // Чֶеλ
#define WIPE_2D                 (1 << TYPE_LOCATION_2D)
#define ZOOM_2D                 (2 << TYPE_LOCATION_2D)
#define FLIP_2D                 (3 << TYPE_LOCATION_2D)
#define BOX_2D                  (4 << TYPE_LOCATION_2D)
#define FADE_2D                 (5 << TYPE_LOCATION_2D)
#define PAGE_TURN_2D            (6 << TYPE_LOCATION_2D)
#define BLUR_2D                 (7 << TYPE_LOCATION_2D)
#define TYPE_MASK_2D            (15 << TYPE_LOCATION_2D)

/* 2DԷ񣬶嵽(ṩûʹ)*/
//WIPE
#define WS_2D_WIPE_LEFT                     (BEING_2D | WIPE_2D | LEFT_2D)          /*ҷз*/
#define WS_2D_WIPE_RIGHT                    (BEING_2D | WIPE_2D | RIGHT_2D)         /*з*/
#define WS_2D_WIPE_UP                       (BEING_2D | WIPE_2D | UP_2D)            /*·з*/
#define WS_2D_WIPE_DOWN                     (BEING_2D | WIPE_2D | DOWN_2D)          /*Ϸз*/
#define WS_2D_WIPE_LEFT_UP                  (BEING_2D | WIPE_2D | LEFT_UP_2D)       /*Ͻ½Ƿз*/
#define WS_2D_WIPE_RIGHT_DOWN               (BEING_2D | WIPE_2D | RIGHT_DOWN_2D)    /*½ϽǷз*/
#define WS_2D_WIPE_RIGHT_UP                 (BEING_2D | WIPE_2D | RIGHT_UP_2D)      /*Ͻ½Ƿз*/
#define WS_2D_WIPE_LEFT_DOWN                (BEING_2D | WIPE_2D | LEFT_DOWN_2D)     /*½ϽǷз*/
/* wipeЧЧ ʱֱʹü */
#define WS_2D_WIPE_LEFT_ATTACH_EXTRUDE      (WS_2D_WIPE_LEFT | ATTACH_EXTRUDE_2D)   /*ҷз񸽴Ч*/
#define WS_2D_WIPE_RIGHT_ATTACH_EXTRUDE     (WS_2D_WIPE_RIGHT| ATTACH_EXTRUDE_2D)   /*з񸽴Ч*/
#define WS_2D_WIPE_UP_ATTACH_EXTRUDE        (WS_2D_WIPE_UP   | ATTACH_EXTRUDE_2D)   /*·з񸽴Ч*/
#define WS_2D_WIPE_DOWN_ATTACH_EXTRUDE      (WS_2D_WIPE_DOWN | ATTACH_EXTRUDE_2D)   /*Ϸз񸽴Ч*/
//ZOOM
#define WS_2D_ZOOM_OUT                      (BEING_2D | ZOOM_2D | OUT_2D)               /*С*/  
#define WS_2D_ZOOM_IN                       (BEING_2D | ZOOM_2D | IN_2D)                /*ԴС*/
#define WS_2D_DRICT_ZOOM_OUT                (WS_2D_ZOOM_OUT)                            /*С(ݲ֧֣WS_2D_ZOOM_OUTΪͬ) */  
#define WS_2D_DRICT_ZOOM_IN                 (WS_2D_ZOOM_IN)                             /*ԴС(ݲ֧֣WS_2D_ZOOM_INΪͬ) */
#define WS_2D_ZOOM_OUT_ATTACH_FADE          (WS_2D_ZOOM_OUT | ATTACH_FADE_2D)           /*󸽴*/
#define WS_2D_ZOOM_IN_ATTACH_FADE           (WS_2D_ZOOM_IN  | ATTACH_FADE_2D)           /*С*/
#define WS_2D_OVERSTEP_ZOOM_OUT             (WS_2D_ZOOM_OUT | OVERSTEP_IN_END_2D)       /*ԽЧ*/
#define WS_2D_OVERSTEP_ZOOM_IN              (WS_2D_ZOOM_IN  | OVERSTEP_IN_START_2D)     /*СԽЧ*/
#define WS_2D_OVERSTEP_ZOOM_OUT_ATTACH_FADE (WS_2D_OVERSTEP_ZOOM_OUT | ATTACH_FADE_2D)  /*Խ͸*/
#define WS_2D_OVERSTEP_ZOOM_IN_ATTACH_FADE  (WS_2D_OVERSTEP_ZOOM_IN  | ATTACH_FADE_2D)  /*СԽ͸*/ 
#define WS_2D_ZOOM_OUT_ATTACH_ICON_FLY      (WS_2D_ZOOM_OUT | ATTACH_ICON_FLY_2D)       /*󸽴icon*/
#define WS_2D_ZOOM_IN_ATTACH_ICON_FLY       (WS_2D_ZOOM_IN | ATTACH_ICON_FLY_2D)        /*Сicon*/
//FLIP
#define WS_2D_FLIP_LEFT         (BEING_2D | FLIP_2D | LEFT_2D)      /*FLIP*/
#define WS_2D_FLIP_RIGHT        (BEING_2D | FLIP_2D | RIGHT_2D)     /*FLIP*/
#define WS_2D_FLIP_UP           (BEING_2D | FLIP_2D | UP_2D)        /*FLIP*/
#define WS_2D_FLIP_DOWN         (BEING_2D | FLIP_2D | DOWN_2D)      /*FLIP*/
//BOX
#define WS_2D_BOX_LEFT          (BEING_2D | BOX_2D | LEFT_2D)       /*BOX*/
#define WS_2D_BOX_RIGHT         (BEING_2D | BOX_2D | RIGHT_2D)      /*BOX*/
//FADE
#define WS_2D_FADE              (BEING_2D | FADE_2D)                /* 뵭 */
//PAGETURN
#define WS_2D_PAGETURN_LEFT     (BEING_2D | PAGE_TURN_2D | LEFT_2D) /*ҳ*/
#define WS_2D_PAGETURN_RIGHT    (BEING_2D | PAGE_TURN_2D | RIGHT_2D)/*ҷҳ*/
//BLUR
#define WS_2D_BLUR              (BEING_2D | BLUR_2D)                /*ģЧ */

/* 2D˶ʽ嵽(ṩûʹ)     */
/*  (WS_2D_WIPE_LEFT | WS_2D_DECELERATE)            */
#define WS_2D_DECELERATE        DECELERATE_2D           /**/
#define WS_2D_ACCELERATE        ACCELERATE_2D           /**/
#define WS_2D_BOUNCE            BOUNCE_2D               /**/
#define WS_2D_LINEAR            LINEAR_2D               /**/
#define WS_2D_SINUS             SINUS_2D                /*sin*/
#define WS_2D_ACCDEC            ACCDEC_2D               /*ȼٺ*/

#define WS_2D_EFFECT_ONLY       0x00000000L
/* , 嵽չ */
#define WS_2D_UPDATE_REMAIN_AREA        0x00008000L /* Ҫ³ָrect                                                                                           ƶʱrectϷǩҳʾ */
#define WS_2D_GRAY_EFFECT               0x00000400L    /* ʵֱĻһЧ */

/* ЧǷΪб */
//#define Is2D(dwStyle)               (((dwStyle)&WHETHER_MASK_2D) == BEING_2D)
#define Is2D(dwStyle)               (((dwStyle)&(BEING_2D)) == BEING_2D)

/* ЧǷĴָб */
#define IsThumbTouch(dwStyle)       (((dwStyle)&THUMB_TOUCH_MASK_2D) == THUMB_TOUCH_2D)

/* ЧǷ񸽴FADEб (ֻ֧zoom) */
#define IsAttachFade(dwStyle)       (((dwStyle)&ATTACH_MASK_2D) == ATTACH_FADE_2D)
/* ЧǷ񸽴icon flyб (ֻ֧zoom) */
#define IsAttachIconFly(dwStyle)    (((dwStyle)&ATTACH_MASK_2D) == ATTACH_ICON_FLY_2D)
/* ЧǷ񸽴FADEб (ֻ֧WIPE) */
#define IsAttachExtrude(dwStyle)    (((dwStyle)&ATTACH_MASK_2D) == ATTACH_EXTRUDE_2D)

/* Чзб */
#define IsLeft(dwStyle)             (((dwStyle)&DIRECTION_MASK_2D) == LEFT_2D)
#define IsRight(dwStyle)            (((dwStyle)&DIRECTION_MASK_2D) == RIGHT_2D)
#define IsUp(dwStyle)               (((dwStyle)&DIRECTION_MASK_2D) == UP_2D)
#define IsDown(dwStyle)             (((dwStyle)&DIRECTION_MASK_2D) == DOWN_2D)
#define IsLeftUp(dwstyle)           (((dwstyle)&DIRECTION_MASK_2D) == LEFT_UP_2D)
#define IsRightDown(dwstyle)        (((dwstyle)&DIRECTION_MASK_2D) == RIGHT_DOWN_2D)
#define IsRightUp(dwstyle)          (((dwstyle)&DIRECTION_MASK_2D) == RIGHT_UP_2D)
#define IsLeftDown(dwstyle)         (((dwstyle)&DIRECTION_MASK_2D) == LEFT_DOWN_2D)
#define IsOut(dwStyle)              (((dwStyle)&DIRECTION_MASK_2D) == OUT_2D)
#define IsIn(dwStyle)               (((dwStyle)&DIRECTION_MASK_2D) == IN_2D)

/* Чб  */
#define IsWipe(dwStyle)             (((dwStyle)&TYPE_MASK_2D) == WIPE_2D)
#define IsZoom(dwStyle)             (((dwStyle)&TYPE_MASK_2D) == ZOOM_2D)
#define IsFlip(dwStyle)             (((dwStyle)&TYPE_MASK_2D) == FLIP_2D)
#define IsBox(dwStyle)              (((dwStyle)&TYPE_MASK_2D) == BOX_2D)
#define IsPageTurn(dwStyle)         (((dwStyle)&TYPE_MASK_2D) == PAGE_TURN_2D)
#define IsFade(dwStyle)             (((dwStyle)&TYPE_MASK_2D) == FADE_2D)
#define IsBlur(dwStyle)             (((dwStyle)&TYPE_MASK_2D) == BLUR_2D)

/* Ч˶б */
#define IsDecelerate(dwStyle)       (((dwStyle)&(MOTION_MASK_2D)) == DECELERATE_2D)
#define IsAccelerate(dwStyle)       (((dwStyle)&(MOTION_MASK_2D)) == ACCELERATE_2D)
#define IsBounce(dwStyle)           (((dwStyle)&(MOTION_MASK_2D)) == BOUNCE_2D)
#define IsLinear(dwStyle)           (((dwStyle)&(MOTION_MASK_2D)) == LINEAR_2D)
#define IsSinus(dwStyle)            (((dwStyle)&(MOTION_MASK_2D)) == SINUS_2D)
#define IsAccDec(dwStyle)           (((dwStyle)&(MOTION_MASK_2D)) == ACCDEC_2D)
#define IsOverstepInStart(dwStyle)  (((dwStyle)&(MOTION_MASK_2D)) == OVERSTEP_IN_START_2D)
#define IsOverstepInEnd(dwStyle)    (((dwStyle)&(MOTION_MASK_2D)) == OVERSTEP_IN_END_2D)


/* Ҫб  */
#define Is2DWipe(dwStyle)           ((Is2D(dwStyle))&&(IsWipe(dwStyle)))
#define Is2DZoom(dwStyle)           ((Is2D(dwStyle))&&(IsZoom(dwStyle)))
#define Is2DFlip(dwStyle)           ((Is2D(dwStyle))&&(IsFlip(dwStyle)))
#define Is2DBox(dwStyle)            ((Is2D(dwStyle))&&(IsBox(dwStyle)))
#define Is2DPageTurn(dwStyle)       ((Is2D(dwStyle))&&(IsPageTurn(dwStyle)))
#define Is2DFade(dwStyle)           ((Is2D(dwStyle))&&(IsFade(dwStyle)))
#define Is2DBlur(dwStyle)           ((Is2D(dwStyle))&&(IsBlur(dwStyle)))

#define Is2DDecelerate(dwStyle)     ((Is2D(dwStyle))&&(IsDecelerate(dwStyle)))
#define Is2DAccelerate(dwStyle)     ((Is2D(dwStyle))&&(IsAccelerate(dwStyle)))
#define Is2DBounce(dwStyle)         ((Is2D(dwStyle))&&(IsBounce(dwStyle)))
#define Is2DLinear(dwStyle)         ((Is2D(dwStyle))&&(IsLinear(dwStyle)))
#define Is2DSinus(dwStyle)          ((Is2D(dwStyle))&&(IsSinus(dwStyle)))
#define Is2DAccDec(dwStyle)         ((Is2D(dwStyle))&&(IsAccDec(dwStyle)))
#define Is2DOverstepInStart(dwStyle)    ((Is2D(dwStyle))&&(IsOverstepInStart(dwStyle)))
#define Is2DOverstepInEnd(dwStyle)      ((Is2D(dwStyle))&&(IsOverstepInEnd(dwStyle)))


/* Ĵָbegin */
/* Ĵָ  . Ĵָ*/
#define WS_2D_THUMB_TOUCH       (BEING_2D | THUMB_TOUCH_2D)  

/* Ĵָ չ */
#define WS_2D_FORBID_REBOUND 			0x00000800L  	/* ˷ ֹ߽ */
#define WS_2D_FOR_WIDGET				0x00000010L  	/* ˷ÿؼԻƷʽ ԻƷʽʱ */
#define WS_2D_FOR_HIGHTLIGHT			0x00000001L     /* ˷ĴָЧʱĻʽ */
#define WS_2D_MULTI_PAGE				0x02000000L  	/* ˷ĴָЧƴͼʽԻҳǻʱᶯ */
#define WS_2D_NOT_ADJUST                0X04000000L     /* ˷ʾĴָ󣬲ٽ*/
/* Ĵָend */

#define THUMB_TOUCH_DOWN			(-1)    /* Ĵָ Ҫ»*/
#define THUMB_TOUCH_UP				(-2)     /* Ĵָ Ҫϻ*/
#define THUMB_TOUCH_INERTIA_PAGE_NUMBER  3    /* ĴָƴͼʽԻҳ*//*ZCORE V2.5.0B01*/

#define Is2DThumbTouch(dwStyle)     ((Is2D(dwStyle))&&(IsThumbTouch(dwStyle))) /* жǷĴָ */


#ifdef _TOUCHWIZ_EFFECTS
/**
 * \def WS_EX_MIDDLE
 * \brief The main window is a moddle (һֱͨڵ棬topmostڵ) window.
 */
#define WS_EX_MIDDLE           0x01000000L     /* ýƸһ УΪչ*/
#define WS_TOPMOST_ZORDER      0x02000000L  
#endif

/*******************************************************************************
* Ч֧
*******************************************************************************/
/*******************************************************************************
*  								ݽṹ
*******************************************************************************/
typedef struct
{
	ZSINT32 dwStyle; 				//Ч
	RECT 	rect;			 		//Ч
	ZBOOL 	beDestroy;				//Ƿٷʽ
	ZBOOL 	doNotFreshOtherImage;	//ˢЧ֮ͼ
}REGIONEFFECT;						//ЧϢûʹЧܣṩϢ

/*******************************************************************************
*  								
*******************************************************************************/
/*******************************************************************************
* : AddRegionEffect
* : Ч
* ˵: (IN)pRegionEffect	ЧϢָ
* ֵ  : TRUE				ӳɹ 
*			FALSE				ʧ
* ˵: ЧܣṩûʹãɽӶЧЧִʱ
*			ûӵϢЧĳ
*******************************************************************************/
ZBOOL AddRegionEffect(REGIONEFFECT *pRegionEffect);

#endif//_ZCORE_2D_H
