#ifndef _ZCORE_TIMER_H
#define _ZCORE_TIMER_H
#include "zcore_type.h"
/******************************** Timer Support ******************************/
/*Creates a timer with the specified timeout value.*/
ZBOOL SetTimer (HWND hWnd, ZSINT32 id, ZUINT32 speed);

/*Destroys a timer.*/
ZBOOL KillTimer (HWND hWnd, ZSINT32 id);

/*Adjusts a timer with a different timeout value.*/
ZBOOL ResetTimer (HWND hWnd, ZSINT32 id, ZUINT32 speed);

/*Retrieves the tick counts that have elapsed since GUI was started.*/
ZUINT32 GetTickCount (ZVOID);

/*Determines whether a timer is installed.*/
ZBOOL IsTimerInstalled (HWND hWnd, ZSINT32 id);

#endif//_ZCORE_TIMER_H
