#ifndef _ZGUI_ZCOREGUI_H
#define _ZGUI_ZCOREGUI_H

#include <stdio.h>
#include "zcore_type.h"

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */


/**
 *  g_rcScr
 * Ļ
 */
MG_EXPORT RECT g_rcScr;//MG_EXPORT == extern
#define g_rcDesktop     g_rcScr

/**
 * ƣ InitGUI
 * ʼGUI
 * ˵ mainһ
 *   ֵ  ɹ0
 * ˵ 
 */
//MG_EXPORT ZSINT32 GUIAPI InitGUI (ZSINT32, const ZCHAR **);
MG_EXPORT ZSINT32 GUIAPI InitGUI ();

/**
 * ƣ TerminateGUI
 * ֹGUI
 * ˵ʱû
 *   ֵ  
 * ˵ 
 */

MG_EXPORT ZVOID GUIAPI TerminateGUI (ZSINT32 rcByGUI);

/**
 * ƣ main_entry
 * zcoreguiӦóں
 * ˵ mainһ
 *   ֵ  ɹ0
 * ˵ 
 */

#define main_entry zcoregui_entry
ZSINT32 zcoregui_entry (ZSINT32 args, const ZCHAR* arg[]);

#define ZcoreGUIMain \
ZcoreGUIAppMain (ZSINT32 args, const ZCHAR* argv[]); \
ZSINT32 main_entry (ZSINT32 args, const ZCHAR* argv[]) \
{ \
    ZSINT32 iRet = 0; \
//    if (InitGUI (args, argv) != 0) { \
    if (InitGUI () != 0) { \
        return 1; \
    } \
    iRet = ZcoreGUIAppMain (args, argv); \
    TerminateGUI (iRet); \
    return iRet; \
} \
ZSINT32 ZcoreGUIAppMain


/**
	* ¶ļ
	* zcoreguiļwindows iniļʽ
	* ļsectionֶΣKey = Valueʽ洢ֵ
	**/
#define CBNAME_TEXT             ("text")


#define ETC_MAXLINE             1024
#define ETC_FILENOTFOUND        -1
#define ETC_SECTIONNOTFOUND     -2
#define ETC_KEYNOTFOUND         -3
#define ETC_TMPFILEFAILED       -4
#define ETC_FILEIOFAILED        -5
#define ETC_INTCONV             -6
#define ETC_CONTINUE         -7
#define ETC_OK                  0

#ifndef _INCORE_RES

/**
*  ETCFILEPATH
* zcoreguiļ·
*/
MG_EXPORT ZCHAR ETCFILEPATH [];

#endif /* _INCORE_RES */

/**
* ƣ GetValueFromEtcFile
* ƶļлȡֵ,ֵ
*                            ַʽ
* ˵pEtcFile(IN):ָļ
*                            pSection(IN):ָķ
*                            pKey(IN):ָļֵ
*                            pValue(OUT):ؼֵ
*                            iLen(IN):ֵ泤
*   ֵ   ɹETC_OK,С0ֵ
* ˵ ETC_OK:ȡɹ
*                             ETC_FILENOTFOUND:Ҳָļ
*                             ETC_SECTIONNOTFOUND:Ҳָsection
*                             ETC_KEYNOTFOUND:Ҳָļֵ
*                             ETC_FILEIOFAILED:ļд
*/
MG_EXPORT ZSINT32 GUIAPI GetValueFromEtcFile (const ZCHAR* pEtcFile, 
                const ZCHAR* pSection, const ZCHAR* pKey, ZCHAR* pValue, ZSINT32 iLen);

/**
* ƣ GetIntValueFromEtcFile
* ƶļлȡͼֵ
* ˵pEtcFile(IN):ָļ
*                            pSection(IN):ָķ
*                            pKey(IN):ָļֵ
*                            value(OUT):ͼֵ
*   ֵ   ɹETC_OK,С0ֵ
* ˵ ETC_OK:ȡɹ
*                             ETC_FILENOTFOUND:Ҳָļ
*                             ETC_SECTIONNOTFOUND:Ҳָsection
*                             ETC_KEYNOTFOUND:Ҳָļֵ
*                             ETC_FILEIOFAILED:ļд
*                             ETC_INTCONV:ַתͳ
* zcoreguiʹstrtolַתֵ
*/
MG_EXPORT ZSINT32 GUIAPI GetIntValueFromEtcFile (const ZCHAR* pEtcFile, 
                const ZCHAR* pSection, const ZCHAR* pKey, ZSINT32* value);

/**
* ƣ SetValueToEtcFile
* ļֵ浽ָļ,
*                            ļ,򴴽µļ
*                            ֵѾ,򸲸Ǿֵ
* ˵pEtcFile(IN):ָļ
*                            pSection(IN):ָķ
*                            pKey(IN):ָļֵ
*                            pValue(IN):Ҫ洢ļֵַ
*   ֵ   ɹETC_OK,С0ֵ
* ˵ ETC_OK:ȡɹ
*                             ETC_FILEIOFAILED:ļд
*                             ETC_TMPFILEFAILED:޷ʱļ
*/
MG_EXPORT ZSINT32 GUIAPI SetValueToEtcFile (const ZCHAR* pEtcFile, 
                const ZCHAR* pSection, const ZCHAR* pKey, ZCHAR* pValue);

/**
* ƣ LoadEtcFile
* ָļڴ,һþ
* ˵pEtcFile(IN):ָļ
*   ֵ   ɹö,NULL
* ˵
*/
MG_EXPORT GHANDLE GUIAPI LoadEtcFile (const ZCHAR * pEtcFile);

/**
* ƣ UnloadEtcFile
* ͷڴеļϢ
* ˵hEtc(IN):ö
*   ֵ   ɹ0,-1
* ˵
*/
MG_EXPORT ZSINT32 GUIAPI UnloadEtcFile (GHANDLE hEtc);

/**
* ƣ GetValueFromEtc
* ڴлȡֵ,ֵ
*                            ַʽ
* ˵hEtc(IN):ָö
*                            pSection(IN):ָķ
*                            pKey(IN):ָļֵ
*                            pValue(OUT):ؼֵ
*                            iLen(IN):ֵ泤
*   ֵ   ɹETC_OK,С0ֵ
* ˵ ETC_OK:ȡɹ
*                             ETC_FILENOTFOUND:Ҳָļ
*                             ETC_SECTIONNOTFOUND:Ҳָsection
*                             ETC_KEYNOTFOUND:Ҳָļֵ
*                             ETC_FILEIOFAILED:ļд
*/
MG_EXPORT ZSINT32 GUIAPI GetValueFromEtc (GHANDLE hEtc, const ZCHAR* pSection, 
                const ZCHAR* pKey, ZCHAR* pValue, ZSINT32 iLen);

/**
* ƣ GetIntValueFromEtcFile
* ڴлȡͼֵ
* ˵hEtc(IN):ָö
*                            pSection(IN):ָķ
*                            pKey(IN):ָļֵ
*                            value(OUT):ͼֵ
*   ֵ   ɹETC_OK,С0ֵ
* ˵ ETC_OK:ȡɹ
*                             ETC_FILENOTFOUND:Ҳָļ
*                             ETC_SECTIONNOTFOUND:Ҳָsection
*                             ETC_KEYNOTFOUND:Ҳָļֵ
*                             ETC_FILEIOFAILED:ļд
*                             ETC_INTCONV:ַתͳ
*/
MG_EXPORT ZSINT32 GUIAPI GetIntValueFromEtc (GHANDLE hEtc, const ZCHAR* pSection,
                const ZCHAR* pKey, ZSINT32* pValue);

/**
* ƣ SetValueToEtcFile
* ļֵ浽ָö,
*                            ֵѾ,򸲸Ǿֵ
* ˵hEtc(IN):ָö
*                            pSection(IN):ָķ
*                            pKey(IN):ָļֵ
*                            pValue(IN):Ҫ洢ļֵַ
*   ֵ   ɹETC_OK,С0ֵ
* ˵ ETC_OK:ȡɹ
*                             ETC_FILEIOFAILED:ļд
*/
#define SetValueToEtc(hEtc, pSection, pKey, pValue) \
        GetValueFromEtc(hEtc, pSection, pKey, pValue, -1)

	/**
	* ¶ܺ
	**/

/**
* ƣ Ping
* һbeep
* ˵
*   ֵ   
* ˵
*/
MG_EXPORT ZVOID GUIAPI Ping (ZVOID);

#define Beep Ping

/**
* ƣ Tone
* һtone,ýӿͬӿ,
*                            tone󷵻
* ˵frequency_hz(IN):toneƵ(λ:Hz)
*                            duration_ms(IN):tone(λ:ms)
*   ֵ   
* ˵
*/
MG_EXPORT ZVOID GUIAPI Tone (ZSINT32 frequency_hz, ZSINT32 duration_ms);

	/**
	* ¶ַ
	*zcoreguiṩһַ˽ж,ڵı
	*˵itemıȶԴз,ûҲ
	*ӶϷ̶ȵַڴ
	**/

/**
* ƣ FixStrAlloc
* Ϊַ˽жϷڴ
*				   ĳȲ
* ˵len(IN):ַ
*   ֵ   
* ˵ûɸıַ,ǲܸı䳤
*/
MG_EXPORT ZCHAR* GUIAPI FixStrAlloc (ZSINT32 len);

/**
* ƣ FreeFixStr
* ͷŶַʹõڴ
* ˵str(IN):ַָ
*   ֵ   
* ˵ûֱʹfreeӿͷڴ
*/
MG_EXPORT ZVOID GUIAPI FreeFixStr (ZCHAR* str);

	/**
	* ¶꺯
	**/

static ZVOID do_nothing (ZVOID) { return; }

/* System cursor index. */
#define IDC_ARROW       0
#define IDC_IBEAM       1
#define IDC_PENCIL      2
#define IDC_CROSS       3
#define IDC_MOVE        4
#define IDC_SIZENWSE    5
#define IDC_SIZENESW    6
#define IDC_SIZEWE      7
#define IDC_SIZENS      8
#define IDC_UPARROW     9
#define IDC_NONE        10
#define IDC_HELP        11
#define IDC_BUSY        12
#define IDC_WAIT        13
#define IDC_RARROW      14
#define IDC_COLOMN      15
#define IDC_ROW         16
#define IDC_DRAG        17
#define IDC_NODROP      18
#define IDC_HAND_POINT  19
#define IDC_HAND_SELECT 20
#define IDC_SPLIT_HORZ  21
#define IDC_SPLIT_VERT  22

/**
* ƣ ClipCursor
* ùļо,ʹĻ
* ˵prc(IN):еľ
*   ֵ   
* ˵
*/
MG_EXPORT ZVOID GUIAPI ClipCursor (const RECT* prc);

/**
* ƣ GetClipCursor
* ȡļо
* ˵prc(OUT):ȡļо
*   ֵ   
* ˵
*/
MG_EXPORT ZVOID GUIAPI GetClipCursor (RECT* prc);

/**
* ƣ GetCursorPos
* ȡ
* ˵ppt(OUT):ȡֵ
*   ֵ   
* ˵
*/
MG_EXPORT ZVOID GUIAPI GetCursorPos (POINT* ppt);

/**
* ƣ SetCursorPos
* ù
* ˵x(IN):xֵ
*                            y(IN):yֵ
*   ֵ   
* ˵
*/
MG_EXPORT ZVOID GUIAPI SetCursorPos (ZSINT32 x, ZSINT32 y);


#define SetCursorEx(hcsr, set_def)    (do_nothing(), 0)
#define SetCursor(hcsr)               (do_nothing(), 0)
#define SetDefaultCursor(hcsr)        (do_nothing(), 0)
#define GetDefaultCursor()            (do_nothing(), 0)

#define ShowCursor(fShow)             (do_nothing(), 0)

/**
 * \brief Locates character in the first \a n characters of string \a s.
 */
MG_EXPORT ZCHAR* strnchr (const ZCHAR* s, size_t n, ZSINT32 c);

/**
 * \brief Locates a substring delimited by one or more delimiters in the 
 * first \a len characters of string \a text.
 */
MG_EXPORT ZSINT32 substrlen (const ZCHAR* text, ZSINT32 len, ZCHAR delimiter, 
                ZSINT32* nr_delim);

/**
 * \brief Deletes all space characters.
 */
MG_EXPORT ZCHAR * strtrimall (ZCHAR* src);


    /** @} end of str_helpers */

/**
 * ƣ GetZcoreVerNumber
 * ȡZcore İ汾
 * ˵
 *   ֵ  
 * ˵ 
 */
const ZCHAR* GetZcoreVerNumber (ZVOID);
	
#define LoadCursorFromFile(filename)    (do_nothing(), 0)
#define CreateCursor(x, y, w, h, ANDbs, XORbs, cr) (do_nothing(), 0)
#define DestroyCursor(hcsr)             (do_nothing(), 0)
#define GetSystemCursor(csrid)          (do_nothing(), 0)
#define GetCurrentCursor()              (do_nothing(), 0)

#define MAX_SYSCURSORINDEX    22

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif /* _ZGUI_ZCOREGUI_H */

