#ifndef  _FW_PLUGIN_H
#define _FW_PLUGIN_H
#include "zcore_type.h"
#include "os_type.h"
#include "os_file_api.h"
#include "common.h"
#include "zcoregui.h"
#include "gdi.h"
#include "window.h"
//#include "ctrlclass.h"
//#include "fw_kernel.h"

/*
  The max-length(used by PMS) of PlugIn's name/description/path 
  ---referenced by PlugIn's designer
*/

// ļȫ·󳤶
#define PLUGIN_PATH_MAX_LEN   OS_FILE_MAX_PATH_NAME_LEN

// Ƶ󳤶
#define PLUGIN_NAME_MAX_LEN   32

// 󳤶
#define PLUGIN_AUTHOR_MAX_LEN 32

// Ϣ󳤶
#define PLUGIN_DESC_MAX_LEN   64

#define PLUGIN_CTRL_NAME_MAX_LEN 15

//Чʵ
#define PI_INSTANCE_INVALID   0x0

//ʵ
typedef UINT32 PI_INSTANCE;

/*
  Error code used when design PlugIn
*/
typedef enum
{
    PI_SUCCESS = 0    //ɹ
	,PI_FAILURE = -1  //ʧ	
}PI_ERR_CODE;


/*
  Define: the class of PlugIn
*/
typedef enum
{
     PI_CLASS_INVALID = 0   //Ч
	,PI_CLASS_WIDGET        //Widget
	,PI_CLASS_CTRL    //ؼ
	/*
	 TOADD: new PLUGIN type
	*/
	,PI_CLASS_ALL = 0xFF    //в
}PIClassId;


/*
 Define: the OPS type of PlugIn
*/
typedef enum
{
     PI_OPS_INVALID = 0     //Чӿڹ淶
	,PI_OPS_WIDGET_COMMON   //Widgetͨýӿڹ淶
	,PI_OPS_CTRL_CLASS      //ؼӿڹ淶
	/*
	 TOADD: new operation service type
	*/
}PIOpsType;


/*
  Define the Act type of Widget-plugin
*/
typedef enum
{
   WIDGET_ACT_INVALID = 0   //Ч
   ,WIDGET_ACT_START		//
   ,WIDGET_ACT_PAUSE        //ͣ
   ,WIDGET_ACT_PAUSE_HIDE   //ͣز
   ,WIDGET_ACT_RESUME       //ָ
   ,WIDGET_ACT_RESUME_SHOW  //ָʾ
   ,WIDGET_ACT_STOP         //ֹͣ
   ,WIDGET_ACT_SET_FOCUS    //òڻý
}PIWidgetAct;


/*
  Define the state type of Widget-plugin
*/
typedef enum
{
    WIDGET_INVALID = 0         /*Ч״̬*/
    ,WIDGET_WAIT_SETTING       /*Ҫ֤*/
	,WIDGET_READY              /*δ*/
	,WIDGET_RUNNING            /**/
	,WIDGET_PAUSED             /*ͣ*/
	,WIDGET_READY_ON_SETTING   /*δ,SettingѴ*/
	,WIDGET_RUNNING_ON_SETTING /*,SettingѴ*/
	,WIDGET_PAUSED_ON_SETTING  /*ͣ,SettingѴ*/
}PIWidgetState;

/*  
  WidgetMinZone:  ȡWidgetҪСʾ
  WidgetGetState: ȡWidgetʵ״̬
  WidgetWndProc: WidgetʾڵϢ
  WidgetDoSetting: Widgetʵô
*/
typedef struct _widget_ops_
{	
	SINT32  (*WidgetMinZone)   (UINT32* w, UINT32* h);
	SINT32  (*WidgetGetState)  (UINT32 instance);	
	SINT32  (*WidgetWndProc)   (HWND hwnd, ZSINT32 message, WPARAM w, LPARAM l, UINT32 instance_id);
	HWND    (*WidgetDoSetting) (HWND host, UINT32 instance_id);
}PIWidgetOps;


typedef struct _pi_wndclass_info_
{
    /** the class name */
    ZCHAR   spClassName[PLUGIN_CTRL_NAME_MAX_LEN+1];

    /** internal field, operation type */
    DWORD   opMask;

    /** window style for all instances of this window class */
    DWORD   dwStyle;

    /** extended window style for all instances of this window class */
    DWORD   dwExStyle;

    /** cursor handle to all instances of this window class */
    HCURSOR hCursor;

    /** background color pixel value of all instances of this window class */
    ZSINT32     iBkColor;

    /** window callback procedure of all instances of this window class */
    ZSINT32     (*WinProc) (HWND, ZSINT32, WPARAM, LPARAM);

    /** the private additional data associated with this window class */
    DWORD dwAddData;
}PIWndClassInfo;

typedef struct _ctrl_ops_
{
	SINT32 (*CtrlGetWndClassInfo) (PIWndClassInfo* class_info);
}PICtrlOps;


typedef struct _plugin_ops_
{	
	PIOpsType ops_type;   //ӿڹ淶
	union
	{
		PIWidgetOps widget_ops; //ӿڹ淶
		PICtrlOps   ctrl_ops;
        /*
	    TOADD: new PLUGIN type
	    */
	}ops_data;
}PIOps;

/************************************************************************
*ĵ
*PlUGIN_class : 
*PLUGIN_name  : 
*PLUGIN_desc  : 
*PLUGIN_author: 
*PLUGIN_version: 汾
*PLUGIN_init   : ʼԴ
*PLUGIN_create : ʵ
*PLUGIN_destroy: ٲʵ
*PLUGIN_release: ͷŲԴ
*
/************************************************************************/
typedef struct  _plugin_boot_strap_
{
	PIClassId PLUGIN_class;
	ZCHAR PLUGIN_name[PLUGIN_NAME_MAX_LEN+1];
	ZCHAR PLUGIN_desc[PLUGIN_DESC_MAX_LEN+1];
	ZCHAR PLUGIN_author[PLUGIN_AUTHOR_MAX_LEN+1];
	DWORD PLUGIN_version;	
	SINT32 (*PLUGIN_init)(CONST ZCHAR* install_path, PIOps* ops);
	PI_INSTANCE (*PLUGIN_create)();
	SINT32 (*PLUGIN_destroy)(PI_INSTANCE instance_id);
	SINT32 (*PLUGIN_release)();
}PIStrap;

/*
  ĵӿ  
*/
typedef SINT32 (*PLUGIN_BOOT_STRAP)(PIStrap* boot_strap);

/*
  ĵӿڷ
*/
#define SYM_PLUGIN_BOOT_STRAP  "plugin_boot_strap"

/*
  ļ
*/
#define PLUGIN_PLI_FILE_NAME   "plugin.pli"

/*
  Ϣ
*/
#define WIDGET_GUI_MSG_BEGIN    0x1A00

// lParam==ActType
#define WIDGET_GUI_MSG_COMMAND  0x1A01  

#define WIDGET_GUI_MSG_END  0x1AFF

#endif

