#ifndef FW_SEV_H
#define FW_SEV_H
#include "zcore_type.h"
#include "os_type.h"

#include "fw_pub.h"

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#define SEV_ERR_SUCCESS   		    	0		/* ɹ	*/
#define SEV_ERR_GENERAL				    -1		/* һ */
#define SEV_ERR_NOT_INIT      	    	-2		/* ûгԻ  */
#define SEV_ERR_ALREADY_REG   	    	-3		/* ˷Ѿע */
#define SEV_ERR_MEM_ERROR  				-4		/* ڴ	*/
#define SEV_ERR_EXCEED_MAX_LEN			-5		/* ָķֳ󳤶	*/
#define SEV_ERR_ALREADY_INIT			-6
#define SEV_ERR_MEMORY_NOT_ENOUGH		-7
#define	SEV_ERR_INVALID_PARA			-8		/* ЧĲ		*/
#define SEV_ERR_INVALID_HSERVICE		-9
#define SEV_ERR_NOT_REG   	    		-10		/* ˷ûбע */

/* define the max length of service name. */
#define SERVICE_NAME_MAX_LEN	64

/* defien the service handler type, */
typedef ZVOID * HSERVICE;	

//typedef UINT32 APP_ID;

/* define the service start function interface */
typedef SINT32 (*SERVICE_START_PROC)(HSERVICE sev, ZVOID *start_info);

/* define the service pause function interface */
typedef SINT32 (*SERVICE_PAUSE_PROC)(HSERVICE sev);

/* define the service resume function interface */
typedef SINT32 (*SERVICE_RESUME_PROC)(HSERVICE sev);

/* define the service stop interface*/
typedef SINT32 (*SERVICE_STOP_PROC)(HSERVICE sev);

/* define the notify callback function type, used to notify the service user. */
typedef SINT32 (*SERVICE_NOTIFY_PROC) (CONST ZCHAR *sev_name, ZVOID *notify_info);


/* define the stucture when register the service. */
typedef struct _SERVICE_REG_INFO
{
	SERVICE_START_PROC		start_proc;	/* the service start interface */
	SERVICE_PAUSE_PROC		pause_proc; /* the service pause interface */
	SERVICE_RESUME_PROC		resume_proc; /* the service resume interface */
	SERVICE_STOP_PROC		stop_proc; /* the service stop interface */
} SERVICE_REG_INFO;

/* define the runtime status of the service */
typedef enum _SERVICE_STATUS
{
	SERVICE_RUNNING,
	SERVICE_PAUSED,
	SERVICE_STOP,
	SERVICE_ERROR
}SERVICE_STATUS;

/*****************************************************************************
* Function: tp_service_init
* Purpose:  initialize service module
* Relation: N/A
* Params:
* 																			   
*   Name			Type		In/Out 		Description							   
* -------- 			---- 		------   	----------- 				       
*					 															   
* Return:  if success, return COMM_ERR_SUCCESS,
*		   or error code for some error, look up ERROR CODE.
*
* Note:    N/A.
*******************************************************************************/
SINT32 tp_service_init();

/*****************************************************************************
* Function: tp_service_release
* Purpose:  release service module
* Relation: N/A
* Params:
* 																			   
*   Name			Type		In/Out 		Description							   
* -------- 			---- 		------   	----------- 				       
*					 															   
* Return:  if success, return COMM_ERR_SUCCESS,
*		   or error code for some error, look up ERROR CODE.
*
* Note:    N/A.
*******************************************************************************/
SINT32 tp_service_release();

/*****************************************************************************
* Function: tp_service_reg
* Purpose:  regiser one service
* Relation: N/A
* Params:
* 																			   
*   Name			Type				In/Out	Description							   
* -------- 			---- 				------ 	----------- 				       
*  service_name		CONST CHAR*			In		the service name to be registered
*  sev_info			SERVICE_REG_INFO *	In		the register infomation of service
*					 															   
* Return:  if success, return COMM_ERR_SUCCESS,
*		   or error code for some error.
*
* Note:    N/A.
*******************************************************************************/
SINT32 tp_service_reg(CONST ZCHAR *serivce_name, SERVICE_REG_INFO *sev_info);

/*****************************************************************************
* Function: tp_service_unreg
* Purpose:  unregiser one service
* Relation: N/A
* Params:
* 																			   
*   Name			Type				In/Out	Description							   
* -------- 			---- 				------ 	----------- 				       
*  service_name		CONST CHAR*			In		the service name to be unregistered
*					 															   
* Return:  if success, return COMM_ERR_SUCCESS,
*		   or error code for some error.
*
* Note:    N/A.
*******************************************************************************/
SINT32 tp_service_unreg(CONST ZCHAR *serivce_name);

/*****************************************************************************
* Function: tp_service_query
* Purpose:  query the service is weather exist.
* Relation: N/A
* Params:
* 																			   
*   Name			Type				In/Out	Description							   
* -------- 			---- 				------ 	----------- 				       
*  service_name		CONST CHAR*			In		the queryed service name 
*					 															   
* Return:  return TURE means that it is existing.
*			FALSE means not exist or other error.
*
* Note:    N/A.
*******************************************************************************/
ZBOOL tp_service_query(CONST ZCHAR * service_name);

/*****************************************************************************
* Function: tp_service_start
* Purpose:  start service
* Relation: N/A
* Params:
* 																			   
*   Name			Type				In/Out 		Description							   
* -------- 			---- 				------   	----------- 				       
* service_name		CONST CHAR *		In			the service name to be started
* start_data		VOID *				In			the initial data to be passed to starting service
* notify_proc		SERVICE_NOTIFY_PROC In			the callback function address when service is finished, this 
*														funcation will be called as neccessary
*					 															   
* Return:  if success, return the handler of service,
*		   or NULL if any error occur.
*
* Note:    N/A.
*******************************************************************************/
HSERVICE tp_service_start_sev(APP_ID app_id, CONST ZCHAR *service_name, ZVOID *start_data, SERVICE_NOTIFY_PROC notify_proc);

/*****************************************************************************
* Function: tp_service_pause
* Purpose:  pause one running service
* Relation: N/A
* Params:
* 																			   
*   Name	Type		In/Out 		Description							   
* -------- 	---- 		------   	----------- 				       
*   sev		HSERVICE	In			the service handler to be paused.
*					 															   
* Return:  if success, return SEV_ERR_SUCCESS,
*		   or error code for some error.
*
* Note:    this function only work when the service is running.
*******************************************************************************/
SINT32 tp_service_pause_sev(HSERVICE hsv);

/*****************************************************************************
* Function: tp_service_resume
* Purpose:  resume one paused service
* Relation: N/A
* Params:
* 																			   
*   Name	Type		In/Out 		Description							   
* -------- 	---- 		------   	----------- 				       
*   sev		HSERVICE	In			the service handler to be resumed.
*					 															   
* Return:  if success, return SEV_ERR_SUCCESS,
*		   or error code for some error.
*
* Note:    this function only work when the service is paused.
*******************************************************************************/
SINT32 tp_service_resume_sev(HSERVICE hsv);

/*****************************************************************************
* Function: tp_service_stop
* Purpose:  stop one service
* Relation: N/A
* Params:
* 																			   
*   Name	Type		In/Out 		Description							   
* -------- 	---- 		------   	----------- 				       
*   sev		HSERVICE	In			the service handler to be stopped.
*					 															   
* Return:  if success, return SEV_ERR_SUCCESS,
*		   or error code for some error.
*
* Note:    stop one servicer wheather it is running or paused.
*******************************************************************************/
SINT32 tp_service_stop_sev(HSERVICE hsv);

/*****************************************************************************
* Function: tp_service_query_status
* Purpose:  query the status of one service instance
* Relation: N/A
* Params:
* 																			   
*   Name	Type		In/Out 		Description							   
* -------- 	---- 		------   	----------- 				       
*   hsv		HSERVICE	In			the service handler to be queryed.
*					 															   
* Return:  the status of hsv, if some error occur, return SERVICE_STOP status.
*
* Note:    N/A.
*******************************************************************************/
SERVICE_STATUS tp_service_query_status(HSERVICE hsv);

/*****************************************************************************
* Function: tp_service_set_sevdata
* Purpose:  set the service's private data. once you set, you can get it by HSERVICE.
* Relation: N/A
* Params:
* 																			   
*   Name		Type		In/Out 		Description							   
* -------- 		---- 		------   	----------- 				       
*   sev			HSERVICE	In			the service handler to be set sev-data to.
*   sev_data	VOID *		In			the data to be set
*					 															   
* Return:  if success, return SEV_ERR_SUCCESS,
*		   or error code for some error.
*
* Note:    N/A.
*******************************************************************************/
SINT32 tp_service_set_sevdata(HSERVICE sev, ZVOID *sev_data);

/*****************************************************************************
* Function: tp_service_get_sevdata
* Purpose:  get the service's private data by HSERVICE.
* Relation: N/A
* Params:
* 																			   
*   Name		Type		In/Out 		Description							   
* -------- 		---- 		------   	----------- 				       
*   sev			HSERVICE	In			get ser-data from which service
*					 															   
* Return:  the pointer to service data.
*		   or NULL if any error occur.
*
* Note:    N/A
*******************************************************************************/
ZVOID *tp_service_get_sevdata(HSERVICE sev);

/*****************************************************************************
* Function: tp_service_set_mapdata
* Purpose:  map one data to service. after map, you can get the service handler by mapping data anywhere.
* Relation: N/A
* Params:
* 																			   
*   Name		Type		In/Out 		Description							   
* -------- 		---- 		------   	----------- 				       
*   hsv			HSERVICE	In			the service
*   mapdata		SINT32		In			the data to be mapped to service
*					 															   
* Return:  if success, return SEV_ERR_SUCCESS,
*		   or error code for some error.
*
* Note:    the mapdata is globe of all the service instances.
*			if you map one mapdata which has been mapped to another service to your service,
*			the service which mapping the data before will now not map the data again.
*
*		   One hsv can map to one or more mapdata.
*		   One mapdata can only map to one hsv.
*******************************************************************************/
SINT32 tp_service_set_mapdata(HSERVICE hsv, SINT32 mapdata);

/*****************************************************************************
* Function: tp_servicesss_get_hsv
* Purpose:  get the service handler by mapdata.
* Relation: N/A
* Params:
* 					s														   
*   Name		Type		In/Out 		Description							   
* -------- 		---- 		------   	----------- 				       
*   mapdata		SINT32		In			the mapdata by which to get service
*					 															   
* Return:  the service handler if successful.
*			or NULL if any error occur.
*
* Note:    the map data is globe of all the service instances.
*******************************************************************************/
HSERVICE tp_service_get_hsv(SINT32 interdata);

/*****************************************************************************
* Function: tp_service_get_notify_proc
* Purpose:  get the service callback function address
* Relation: N/A
* Params:
* 					s														   
*   Name		Type		In/Out 		Description							   
* -------- 		---- 		------   	----------- 				       
*   hsv			HSERVICE	In			the service handler
*					 															   
* Return:  callback function address.
*			or NULL if any error occur.
*
* Note:    N/A.
*******************************************************************************/
SERVICE_NOTIFY_PROC tp_service_get_notify_proc(HSERVICE hsv);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif
