#ifndef __SPSMEX_HEADER_FILE_
#define __SPSMEX_HEADER_FILE_

#include "zcore_type.h"
#include "os_type.h"
#include "fw_comm.h"
#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

/* handle of power saving request */
typedef ZVOID* HSPSM;

/* invalid handle of spsm */
#define HSPSM_INVALID (0)

typedef struct tagPSMData
{
     /* lcd's power saving status */
     ZUINT8                 lcd;
}PSMData;

typedef ZVOID (*SPSM_CBFUNC)(ZVOID);
typedef struct
{
    SPSM_CBFUNC sleep;
    SPSM_CBFUNC wakeup;
} T_SPSM_CB;

#define SPSM_CHNL_MSG_ID_BASE            (MSG_ID_FW + 0x030)

#define SPSM_CHNL_MSG_ID_PSM_DATA     (SPSM_CHNL_MSG_ID_BASE+1)


/*******************************************************
 * FUNCTION
 *      tp_spsm_init
 * PARAM
 *
 * RETURN VALUE
 *      0       successed.
 *      -1      failed,sth wrong.
 * COMMENT
 *      this function initialize internal data only.It will
 *      not create check thread,so user can customize power 
 *      saveingcheck behavior
 * ******************************************************/
SINT32 tp_spsm_init(ZVOID);

/*******************************************************
 * FUNCTION
 *      tp_spsm_release
 * PARAM
 *      
 * RETURN VALUE
 *      0       successed.
 *      -1      failed,sth wrong.
 * COMMENT
 *      this function clear all internal data.if you create 
 *      check thread,please term it by your self
 * ******************************************************/
SINT32 tp_spsm_release(ZVOID);

/*******************************************************
 * FUNCTION
 *      tp_spsm_req_reg
 * PARAM
 *     lcd     lcd's power saving status
 *     keypad  keypad's power saving status
 *     sleep   true,allow system sleep,else not
 * RETURN VALUE
 *      HSPSM_INVALID   failed,sth wrong.
 *      others          handle of spsm request,will be 
 *                      used in unreg 
 * COMMENT
 *      
 * ******************************************************/
HSPSM tp_spsm_req_reg(ZUINT8 lcd,ZUINT8 keypad,ZBOOL sleep);

/*******************************************************
 * FUNCTION
 *      tp_spsm_req_unreg
 * PARAM
 *      hspsm   handle of SPSM request,is returned from 
 *              tp_spsm_req_reg
 * RETURN VALUE
 *      0       successed.
 *      -1      failed,sth wrong.
 * COMMENT
 *      
 * ******************************************************/
SINT32 tp_spsm_req_unreg(HSPSM hspsm);

/*******************************************************
 * FUNCTION
 *      tp_spsm_set_max_idle_time
 * PARAM
 *      max_idle_time   max idle time before power saving.
 *                      0 is acceptable,but not recommend
 *                      [0 - 255]
 *      half_idle_time  half idle check time 
 * RETURN VALUE
 *      0       successed.
 *      -1      failed,sth wrong.
 * COMMENT
 *      if max_idle_time is set to 0,system will try power 
 *      saving any time when checking
 * ******************************************************/
SINT32 tp_spsm_set_check_interval(ZUINT8 max_idle_time,ZUINT8 half_idle_time);

/*******************************************************
 * FUNCTION
 *      tp_spsm_get_check_interval
 * PARAM
 *      query_max_idle  TRUE will return max_idle_time,
 *                      else will return half_idle_time,
 * RETURN VALUE
 *      idle check time 
 * COMMENT
 *      
 * ******************************************************/
ZUINT8 tp_spsm_get_check_interval(ZBOOL query_max_idle);

/*******************************************************
 * FUNCTION
 *      tp_spsm_set_lcd_max_light
 * PARAM
 *      max_light       max lcd backlight,shouldn't equal
 *                      to 0,else we will see nothing for
 *                      rever.if max_light is 0,this function
 *                      will return -1.
 *                      [1 - 255]
 * RETURN VALUE
 *      0       successed.
 *      -1      failed,sth wrong.
 * COMMENT
 *      IF MAX_LIGHT IS 0,THIS FUNCTION WILL RETURN -1.
 * ******************************************************/
SINT32 tp_spsm_set_lcd_max_light(ZUINT8 max_light);

/*******************************************************
 * FUNCTION
 *      tp_spsm_get_lcd_max_light
 * PARAM
 *      
 * RETURN VALUE
 *      max lcd light if system is activated
 * COMMENT
 *      
 * ******************************************************/
ZUINT8 tp_spsm_get_lcd_max_light(ZVOID);

/*******************************************************
 * FUNCTION
 *      tp_spsm_set_kpd_max_light
 * PARAM
 *      max_light       max keypad backlight
 *                      [0 - 255]
 * RETURN VALUE
 *      0       successed.
 *      -1      failed,sth wrong.
 * COMMENT
 * ******************************************************/
SINT32 tp_spsm_set_kpd_max_light(ZUINT8 max_light);

/*******************************************************
 * FUNCTION
 *      tp_spsm_get_kpd_max_light
 * PARAM
 *      
 * RETURN VALUE
 *      max keypad backlight.
 * COMMENT
 *      
 * ******************************************************/
ZUINT8 tp_spsm_get_kpd_max_light(ZVOID);

/*******************************************************
 * FUNCTION
 *      tp_spsm_mousemove_activate_system
 * PARAM
 *      
 * RETURN VALUE
 *      
 * COMMENT
 *      this function reset idle time stamp,then set lcd backlight
 *      and keypad backlight to max.
 *      if you want close backlight,but not suspend system,
 *      you should reg/unreg power saving request
 * ******************************************************/

ZVOID tp_spsm_mousemove_activate_system(ZVOID);

/*******************************************************
 * FUNCTION
 *      tp_spsm_activatesystem
 * PARAM
 *      
 * RETURN VALUE
 *      
 * COMMENT
 *      this function reset idle time stamp,then set lcd backlight
 *      and keypad backlight to max.
 *      if you want close backlight,but not suspend system,
 *      you should reg/unreg power saving request
 * ******************************************************/
ZVOID tp_spsm_activate_system(ZVOID);

/*******************************************************
 * FUNCTION
 *      tp_spsm_set_half_light_ratio
 * PARAM
 *      ratio           ratio to full light
 * RETURN VALUE
 *      0               succeessed
 *      -1              failed
 * COMMENT
 *      
 * ******************************************************/
SINT32 tp_spsm_set_half_light_ratio(ZUINT8 ratio);

/*******************************************************
 * FUNCTION
 *      tp_spsm_set_half_light_ratio
 * PARAM
 *      ratio           ratio to full light,in percentage
 * RETURN VALUE
 *      0               succeessed
 *      -1              failed
 * COMMENT
 *      
 * ******************************************************/
SINT32 tp_spsm_set_half_light_ratio(ZUINT8 ratio);

/*******************************************************
 * FUNCTION
 *      tp_spsm_get_half_light_ratio
 * PARAM
 *      
 * RETURN VALUE
 *      ratio to full light,0-100,else means sth wrong.
 * COMMENT
 *      
 * ******************************************************/
ZUINT8 tp_spsm_get_half_light_ratio(ZVOID);

/*******************************************************
 * FUNCTION
 *      tp_spsm_enable_spsmcheck
 * PARAM
 *      enable_spsm_check    TRUE will enable spsm check,else
 *                           will disable spsm check
 *
 * RETURN VALUE
 *      
 * COMMENT
 *      
 * ******************************************************/
ZVOID tp_spsm_enable_spsmcheck(ZBOOL enable_spsm_check);

ZVOID tp_spsm_allow_poweron_delay_interval(ZBOOL allowed,ZSINT32 interval);

ZVOID tp_spsm_activate_app(ZVOID);
ZVOID tp_spsm_reg_callback( T_SPSM_CB *cb );
ZVOID spsm_reg_callback(ZVOID);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif /* __SPSMEX_HEADER_FILE_ */
