#ifndef MMI_GM_GUI_HELPER_H
#define MMI_GM_GUI_HELPER_H

/**************************************************************************
 *                        ͷļ                                       *
 **************************************************************************/
#ifdef WIN32
#include "assert.h"
#endif
#include "os_type.h"
#include "app_global_defines.h"
#include "mmiGmUtilities.h"
#include "mmiGmMap.h"

/**************************************************************************
 *                         궨                                          *
 **************************************************************************/
 #define MMI_DEBUG_SWITCH  1
 #define MMI_TRACE_SWITCH 1

#ifdef MMI_DEBUG_SWITCH

#define IS_FLAG_SET(n, f)           (((n) & (f)) != 0)

#ifdef WIN32    
#define MMI_ASSERT(expr)  assert(expr)
#else
#define MMI_ASSERT(expr) TP_OS_ASSERT(expr)
#endif  /* WIN32 */
 
#else
#define MMI_ASSERT(expr)
#endif/* MMI_DEBUG_SWITCH */


#ifdef MMI_TRACE_SWITCH
#define MMI_TRACE   MMI_Trace
#else
#define MMI_TRACE
#endif  /* MMI_TRACE_SWITCH */

#define MMI_GM_MALLOC        tp_os_mem_malloc
#define MMI_GM_FREE             tp_os_mem_free

 

#define MMI_GM_HIGHLIGHT_COLOR      0x0000c6ff      /* RGB2Pixel(hdc, 193, 223, 253) */

 /*  */
#define MMI_GM_SCROLLBAR_WIDTH		6	// 10
#define MMI_GM_SCROLLBAR_ARROW_H	0	// ¼ͷĸ߶

/*  */
#define MMI_GM_WIN_H		(SCREEN_H-CAPTIONBAR_H)	// ߶:127
#define MMI_GM_CLIENT_H	(MMI_GM_WIN_H -WIN_TITLE_H) // û߶:110


#define GRAY_BK_GET_X 		0
#define GRAY_BK_GET_Y		CAPTIONBAR_H
#define GRAY_BK_DRAW_X	0
#define GRAY_BK_DRAW_Y	0
#define GRAY_BK_W			SCREEN_W
#define GRAY_BK_H			((SCREEN_H - SOFTKEY_H) - CAPTIONBAR_H)

/**************************************************************************
 *                         Ͷ                                    *
 **************************************************************************/

/* ۽ */
typedef enum 
{
	SCROLLBAR_FOCUS_NULL = 0, 
	SCROLLBAR_FOCUS_UP,     //ϷͼƬ
	SCROLLBAR_FOCUS_DOWN,	//·ͼƬ
	SCROLLBAR_FOCUS_MAIN,	//ͼƬ
	SCROLLBAR_FOCUS_BAR
}E_SCROLLBAR_FOCUS_TYPE;

/**************************************************************************
 *                        ȫֱ                                     *
 **************************************************************************/

/**************************************************************************
 *                        ԭ                                         *
 **************************************************************************/ 
//extern HDC mmiGmInitGrayBkDC(int iX, int iY, UINT32 uiWidth, UINT32 uiHeight);
//extern HDC mmiGmInitBrushTranspBkDC(int iX, int iY, UINT32 uiWidth, UINT32 uiHeight);
//extern void mmiGmFreeGrayBkDC(HDC hMem);

extern void mmiGmDrawGrayBk(HDC hMem, int iX, int iY, UINT32 uiWidth, UINT32 uiHeight);
extern void mmiGmDrawGrayBkEx(HDC hdc, HDC hMem, int iX, int iY, UINT32 uiWidth, UINT32 uiHeight);
extern void mmiGmAdjustDrawRect(RECT *prtDraw, UINT32 uiHeight);

extern void mmiGmDrawScrollBar(HDC       hdc,
                              int       iX,
                              int       iY,
                              int       iH,
                              UINT32    uiCurrent,
                              UINT32    uiTotal,
                              int       iBkX,
                              int       iBkY,
                              const BITMAP *pbmpBk);

 /* ƹ¼ͷͼƬ */
extern void mmiGmDrawScrollBarEx(HDC hdc, int iX, int iY, int iH,
							UINT32 uiCurrent, UINT32 uiTotal);


extern void mmiGmDrawHighLightRect(HDC hdc, int iX, int iY, UINT32 uiWidth, UINT32 uiHeight);
extern void mmiGmDrawHighLightRectEx(HDC hdc, int iX, int iY, UINT32 uiWidth, UINT32 uiHeight, gal_pixel clrHL);

extern void mmiGmDTScrollViewOnTimer(HWND hWnd, UINT32 uiUserData);
extern void mmiGmDTOnWndProc(HWND       hWnd,
                             int        iMsg,
                             WPARAM     wParam,
                             LPARAM     lParam,
                             void (*OnTimer)(HWND hWnd, UINT32 uiUserData),
                             UINT32     uiUserData);

#define MMI_GM_DT_SOLID     0x00008000

extern void mmiGmDTDrawText(HDC         hdc,
					const CHAR *pText,
					int         iCount,
					RECT       *pRect,
					UINT16        nFormat,
					BOOL        bHighlight);

extern void mmiGmDTDrawTextEx(HDC           hdc,
					const CHAR   *pText,
					int           iCount,
					RECT         *pRect,
					UINT16          nFormat,
					BOOL          bHighlight,
					int          *iPos,
					int          *scroll);

extern void mmiGmDTDrawTextEx2(HWND hScroll, HDC hdc,
					const CHAR *pText,
					int iCount,
					RECT *pRect,
					UINT16 nFormat,
					BOOL bHighlight,
					int *iPos,
					int *scroll);

extern void mmiGmASOnWndProc(HWND      hDlg,
                             int       iMsg,
                             WPARAM    wParam,
                             LPARAM    lParam,
                             int       iScrViwId);

int UCS2ToUTF8(const UINT16 *pwBufIn, UINT32 uiLenIn /* in UINT16 */, char *pszBufOut, UINT32 uiLenOut);
int UTF8ToUCS2(const char *pszBufIn, UINT32 uiLenIn, UINT16 *pwBufOut, UINT32 uiLenOut /* in UINT16 */);

/* window private data manager */
void mmiGmAddAdditionalData(HWND hWnd, void *pData);
void* mmiGmGetAdditionalData(HWND hWnd);
void mmiGmRemoveAdditionalData(HWND hWnd);
/* end */

/* ȡıɫ */
extern UINT32 mmiGmGetTextColor(BOOL bHilight, BOOL bDisabled);
/* ȡıɫɫͼƬ */
extern UINT32 mmiGmGetTextColorForWhiteBg(BOOL bHilight, BOOL bDisabled);

/* ƴڱⱳͼƬ */ 
extern void mmiGmDrawTitleBmp(HDC hdc, const BITMAP *pTitleBmp);

/* ƴڱⱳͼƬ */ 
extern void mmiGmDrawTitleBmpById(HDC hdc, UINT32 uiBmpTitleid);

/* ƴڱⱳͼƬ(ñ߶) */ 
extern void mmiGmDrawTitleBmpEx(HDC hdc, const BITMAP *pTitleBmp, int iTitleH);

/* ƴڱⱳͼƬ(ñ߶) */ 
extern void mmiGmDrawTitleBmpByIdEx(HDC hdc, UINT32 uiBmpTitleid, int iTitleH);

/* ƴڱ */ 
extern void mmiGmDrawTitleText(HWND hWnd, HDC hdc, const CHAR *strTitle);

/* ƴڱ(Զ) */ 
extern void mmiGmDrawTitleTextEx(HWND hWnd, HDC hdc, const CHAR *strTitle);

/* ƴڱ(ñ߶) */ 
extern void mmiGmDrawTitleTextEx2(HWND hWnd, HDC hdc, const CHAR *strTitle, int iTitleH, BOOL bScroll, int *iPos,int * scroll);

//extern void mmiGmDTDrawTitleTextEx2(HWND hScroll, HDC hdc, const CHAR *pText, int iTitleH, BOOL bScroll, int *iPos);
extern void mmiGmDTDrawTitleTextEx2(HWND hScroll, HDC hdc,
                        const CHAR *pText,
                        int iCount,
                        RECT *pRect,
                        UINT16 nFormat,
                        BOOL bHighlight,
                        int *iPos,
                        int *scroll);

/* ƴڱͼƬ */ 
extern void mmiGmDrawTitle(HWND hWnd, HDC hdc, const BITMAP *pTitleBmp, const CHAR *strTitle);

/* ƴڱͼƬ */ 
extern void mmiGmDrawTitleById(HWND hWnd, HDC hdc, UINT32 uiBmpTitleid, const CHAR *strTitle);

/* жǷ */  
extern BOOL mmiGmGetSoftkeyIsSet(const CHAR *szLeftSoftkey, const CHAR *szMidSoftkey);

/* title_ctrlؼ */  
extern SINT32 mmiGmHandleClickForTitleCtrl(HWND hWnd, UINT32 iTitleId, WPARAM wParam,LPARAM lParam);

/* жǷЧͼƬid */
extern BOOL mmiGmGetBmpIdIsValid(UINT32 uiBmpId);

/* עṫؼ */ 
extern void mmiGmRegisterControl(void);

/* ʹؼ */
extern BOOL mmiGmReverseCtrlRect(HWND hCtrl, int x, int y, int w, int h);
/* ȡͼƬID */
extern UINT32 mmiGmGetBgBmpId(BOOL bNoItem,BOOL bHintList);

/* ô */
extern BOOL mmiGmSetWinFont(HWND hWnd, HDC hdc, UINT32 *pOldFont, UINT32 *pNewFont, UINT32 uiFontSize);

/* ָ */
extern void mmiGmRestoreWinFont(HDC hdc, BOOL bSet, UINT32 pOldFont, UINT32 pNewFont);

#endif
