#ifndef DCMGT_E_H
#define DCMGT_E_H

/***********************************ͷļ*******************************/
#include "zcore_type.h"
#include "gui_g.h"
#include "SDEV_e.h"
#include "imgmgt_e.h"
#include "txtmgt_e.h"
#include "zcore_dc.h"
#include "gui_common.h"
/*******************************궨*******************************/

#define _ADV_2DAPI

#define DC_ATTR_PEN_TYPE        10
#define DC_ATTR_PEN_CAP_STYLE   11
#define DC_ATTR_PEN_JOIN_STYLE  12
#define DC_ATTR_PEN_WIDTH       13
#define DC_ATTR_BRUSH_TYPE      14
#define NR_DC_ATTRS             15

#define MEMDC_FLAG_NONE         0x00000000  /* None. */
#define MEMDC_FLAG_SWSURFACE    0x00000000  /* DC is in system memory */
#define MEMDC_FLAG_HWSURFACE    0x00000001  /* DC is in video memory */
#define MEMDC_FLAG_SRCCOLORKEY  0x00001000  /* Blit uses a source color key */
#define MEMDC_FLAG_SRCALPHA     0x00010000  /* Blit uses source alpha blending*/
#define MEMDC_FLAG_RLEACCEL     0x00004000  /* Surface is RLE encoded */
#define MEMDC_FLAG_PREALLOC     0x10000000
#define MEMDC_FLAG_USEPAL       0x01000000

#define GAL_SWSURFACE        MEMDC_FLAG_SWSURFACE
#define GAL_HWSURFACE        MEMDC_FLAG_HWSURFACE
#define GAL_ASYNCBLIT        0x00000004

#define GAL_ANYFORMAT        0x10000000
#define GAL_HWPALETTE        0x20000000
#define GAL_DOUBLEBUF        0x40000000
#define GAL_FULLSCREEN       0x80000000

#define GAL_HWACCEL          0x00000100
#define GAL_SRCCOLORKEY      MEMDC_FLAG_SRCCOLORKEY
#define GAL_RLEACCELOK       0x00002000
#define GAL_RLEACCEL         MEMDC_FLAG_RLEACCEL
#define GAL_SRCALPHA         MEMDC_FLAG_SRCALPHA
#define GAL_PREALLOC         0x01000000             /* Surface uses preallocated memory */

/*******************************ṹ嶨*******************************/

extern STATE GetGDCapability( HDC hdc, ZSINT32  iItem);

extern STATE DCMgt_GetGDCapability(HDC hdc, ZSINT32 iItem);

extern     ZBOOL Draw_SetMemDCAlpha (HDC mem_dc, ZDWORD flags, ZUINT8 alpha);
//extern     BOOL Draw_SetMemDCColorKey (HDC mem_dc, ZDWORD flags, Uint32 color_key);
extern     ZBOOL  Draw_GetPalette (HDC hdc, ZSINT32 start, ZSINT32 len, RGB* cmap);
extern     gal_pixel  Draw_GetTextColor (HDC hdc);

extern     HDC  CreateCompatibleDC (HDC hdc);

extern     ZBOOL SetMemDCAlpha (HDC mem_dc, ZDWORD flags, ZUINT8 alpha);
//extern     BOOL SetMemDCColorKey (HDC mem_dc, ZDWORD flags, Uint32 color_key);
extern     ZBOOL  GetPalette (HDC hdc, ZSINT32 start, ZSINT32 len, RGB* cmap);
extern     gal_pixel  GetTextColor (HDC hdc);
extern     PenType SetPenType(HDC hdc, ZSINT32 iPenType);
extern	ZUINT32 SetPenWidth(HDC hdc, ZDWORD width);
extern	ZVOID  SetPenDashes (HDC hdc, ZSINT32 dash_offset, const ZUINT8* dash_list, ZSINT32 n);
//extern	ZSINT32 InitGUI (ZSINT32 argc, const ZCHAR* agr[]);
extern	ZSINT32 InitGUI ();
extern	ZVOID  TerminateGUI (ZSINT32 rcByGUI);
extern	ZBOOL InitZcoreGUIExt (ZVOID);
extern	ZVOID ZcoreGUIExtCleanUp (ZVOID);
extern	ZBOOL dc_IsMemHDC (HDC hdc);
extern	ZBOOL dc_IsScreenHDC (HDC hdc);
extern	ZBOOL dc_IsGeneralHDC (HDC hdc);
extern	ZBOOL dc_IsMemDC (PT_DCMgt_DC pdc);
extern	ZBOOL dc_IsScreenDC (PT_DCMgt_DC pdc);
extern	ZBOOL dc_IsGeneralDC (PT_DCMgt_DC pdc);
extern ZBOOL IsInRcBound(HDC hdc, RECT *rcOutput);
/*******************************궨*******************************/
#define 	DrawHDotLine(hdc, x, y, w)		Draw_HVDotLine(hdc, x, y, w, TRUE)
#define 	DrawVDotLine(hdc, x, y, h)		Draw_HVDotLine(hdc, x, y, h, FALSE)

/* ˢı */
extern ZSINT32 my_gdi;
#if 1
#define LOCK_GDI() zcore_mutex_get(my_gdi, ZCORE_WAIT_FOREVER);

#define UNLOCK_GDI()  zcore_mutex_put(my_gdi);
#else
#define LOCK_GDI()    zcore_mutex_get(my_gdi, ZCORE_WAIT_FOREVER);\
	                  SDev_LockScreen();

#define UNLOCK_GDI()  SDev_UnlockScreen();\
                      zcore_mutex_put(my_gdi);
#endif

#define LOCK_ECRGN_EX(pdc, hdc, action) \
    if (dc_IsGeneralHDC(hdc)) { \
        zcore_mutex_get(pdc -> ptDCMgtWGINFO->lock, ZCORE_WAIT_FOREVER); \
        if (!RegionGenerateECRgn (pdc, FALSE)) { \
            zcore_mutex_put(pdc -> ptDCMgtWGINFO->lock); \
            action; \
        } \
    }

#define LOCK_ECRGN_NORETURN(pdc, hdc, action) \
    if (dc_IsGeneralHDC(hdc)) { \
        zcore_mutex_get(pdc -> ptDCMgtWGINFO->lock, ZCORE_WAIT_FOREVER); \
        if (!RegionGenerateECRgn (pdc, FALSE)) { \
            action; \
        } \
    }


#define UNLOCK_ECRGN_EX(pdc, hdc) \
    if (dc_IsGeneralHDC(hdc)) zcore_mutex_put(pdc -> ptDCMgtWGINFO->lock);

#define LOCK_ECRGN(pdc,hdc,action) LOCK_ECRGN_EX(pdc, hdc, action)
#define UNLOCK_ECRGN(pdc,hdc) UNLOCK_ECRGN_EX(pdc, hdc)


#endif

