#ifndef _OS_API_E_H_
#define _OS_API_E_H_

#include "zcore_type.h"
#include "os_type.h"

/*  pipe event queue   */
#define PIPE_EVENT_ARRAY_NUM  100
/*  pipe event queue   */

#define MAX_THREAD_NAME_LEN   20

#ifndef _TYPE_OS_MUTEX_ID
#define _TYPE_OS_MUTEX_ID
typedef UINT32 OS_MUTEX_ID;
#endif

#ifndef _TYPE_OS_STATUS
#define _TYPE_OS_STATUS
typedef UINT32 OS_STATUS;
#endif

#ifndef _TYPE_OS_THREAD_ID
#define _TYPE_OS_THREAD_ID
typedef UINT32 OS_THREAD_ID;
#endif

#ifndef _TYPE_OS_SEMA_ID
#define _TYPE_OS_SEMA_ID
typedef UINT32 OS_SEMA_ID;
#endif

#ifndef _TYPE_OS_EVENT_ID
#define _TYPE_OS_EVENT_ID
typedef UINT32 OS_EVENT_ID;
#endif

#ifndef _TYPE_OS_QUEUE_ID
#define _TYPE_OS_QUEUE_ID
typedef UINT32 OS_QUEUE_ID;
#endif

#ifndef _TYPE_OS_TIMER_ID
#define _TYPE_OS_TIMER_ID
typedef UINT32 OS_TIMER_ID;
#endif

#define  OS_OK           0
#define  OS_FAIL        -1

#define OS_INVALID_THREAD_ID   0xffffffff
#define OS_INVALID_SEMA_ID     0xffffffff
#define OS_INVALID_MUTEX_ID    0xffffffff
#define OS_INVALID_EVENT_ID    0xffffffff

#define OS_SEMA_INVALID_ID		0xFFFFFFFF
#define OS_MUTEX_INVALID_ID		0xFFFFFFFF
#define OS_TIMER_INVALID_ID		0xFFFFFFFF
#define OS_THREAD_INVALID_ID	0xFFFFFFFF


#define OS_NULL_PARAM           0x10000002

#define HANDLE ZSINT32

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#define MAX_SEMA_RESOURCE_NUM   10
/* API return values.  */
#ifndef OS_SUCCESS
#define OS_SUCCESS          0x00000000
#endif

#ifndef OS_FAILURE
#define OS_FAILURE          0xffffffff
#endif

#define OS_NO_WAIT          0x00000000
#define OS_WAIT_FOREVER     0xffffffff

#ifndef INFINITE 
#define INFINITE            0xffffffff
#endif

/*  timer start mode  */
#ifndef OS_AUTO_ACTIVATE
#define OS_AUTO_ACTIVATE 0x0001 
#endif

#ifndef OS_AUTO_LOAD
#define OS_AUTO_LOAD      0x0002
#endif


#ifndef TYPE_OS_THREAD_ENTRY
#define TYPE_OS_THREAD_ENTRY
typedef ZVOID (*OS_THREAD_ENTRY)(ZVOID* param);
#endif
extern OS_THREAD_ID tp_os_thread_create(ZCHAR *name, OS_THREAD_ENTRY entry, ZUINT8 pri, UINT32 size, ZVOID* param);
extern OS_STATUS tp_os_thread_delete(OS_THREAD_ID tid);

extern OS_STATUS tp_os_thread_suspend(OS_THREAD_ID tid);
extern OS_STATUS tp_os_thread_resume(OS_THREAD_ID tid);
extern OS_THREAD_ID tp_os_thread_self(ZVOID);
extern OS_STATUS tp_os_thread_sleep(UINT32 timeout);


OS_STATUS os_init_all(ZVOID);
OS_STATUS os_destroy_all(ZVOID);

#define os_thread_create(szName,proc_ThreadEntry, pri, size, param)  tp_os_thread_create((ZCHAR *)szName, (OS_THREAD_ENTRY) proc_ThreadEntry, (ZUINT8)pri, (UINT32)size, (ZVOID*)param)
#define os_thread_delete(threadID) tp_os_thread_delete(( OS_THREAD_ID )threadID)
#define os_thread_suspend(threadID) tp_os_thread_suspend(( OS_THREAD_ID )threadID)
#define os_thread_resume(threadID) tp_os_thread_resume(( OS_THREAD_ID )threadID)
#define os_thread_is_created(threadID)  tp_os_thread_is_created(( OS_THREAD_ID )threadID)
#ifdef WIN32
OS_THREAD_ID os_thread_self(ZVOID);
#else
#define os_thread_self tp_os_thread_self
#endif

#define os_thread_sleep(timeout) tp_os_thread_sleep(( UINT32 )timeout)
ZBOOL check_thread_name_valid(const ZCHAR* thread_name);
OS_STATUS os_thread_sendMsg(OS_THREAD_ID thread_id, ZVOID *msg_ptr,  UINT32 size, UINT32 timeout);
OS_STATUS os_thread_getMessage(ZVOID**msg_ptr, UINT32 *size, UINT32  timeout);

//OS_THREAD_ID os_thread_create(CHAR *szName, OS_THREAD_ENTRY proc_ThreadEntry, UINT8 pri, UINT32 size, void* param);
//OS_STATUS os_thread_delete(OS_THREAD_ID threadID);
//OS_STATUS os_thread_suspend(OS_THREAD_ID threadID);
//OS_STATUS os_thread_resume(OS_THREAD_ID threadID);
//OS_THREAD_ID os_thread_self(void);
//OS_STATUS os_thread_sleep(UINT32 timeout);
//BOOL check_thread_name_valid(const CHAR* thread_name);
//OS_STATUS os_thread_sendMsg(OS_THREAD_ID thread_id, VOID *msg_ptr,  UINT32 size, UINT32 timeout);
//OS_STATUS os_thread_getMessage(VOID**msg_ptr, UINT32 *size, UINT32  timeout);

extern OS_SEMA_ID tp_os_sema_create(ZCHAR *name,UINT32 init_count);
extern OS_STATUS tp_os_sema_delete(OS_SEMA_ID sid);
extern OS_STATUS tp_os_sema_get(OS_SEMA_ID sid, UINT32 timeout);
extern OS_STATUS tp_os_sema_put(OS_SEMA_ID sid);
extern OS_STATUS tp_os_sema_count_get(OS_SEMA_ID sid,UINT32 *count_ptr);

#define os_sema_create(name, init_count)	 tp_os_sema_create(( ZCHAR *)name,(UINT32 ) init_count)
#define os_sema_delete(semaID)	 tp_os_sema_delete(( OS_SEMA_ID) semaID)
#define os_sema_get(semaID, timeout) 	tp_os_sema_get(( OS_SEMA_ID) semaID, ( UINT32) timeout)
#define os_sema_put(semaID) 	tp_os_sema_put(( OS_SEMA_ID )semaID) 
#define os_sema_count_get(semaID,count_ptr)	 tp_os_sema_count_get(( OS_SEMA_ID )semaID,( UINT32 *)count_ptr) 


//OS_SEMA_ID os_sema_create(CHAR *name,UINT32 init_count);
//OS_STATUS os_sema_delete(OS_SEMA_ID semaID);
//OS_STATUS os_sema_get(OS_SEMA_ID semaID, UINT32 timeout); /* timeout: -1 means waiting forever*/
//OS_STATUS os_sema_put(OS_SEMA_ID semaID);
//OS_STATUS os_sema_count_get(OS_SEMA_ID semaID,UINT32 *count_ptr);
/*mutex*/
#ifndef WIN32
extern OS_MUTEX_ID tp_os_mutex_create(ZCHAR *name, ZBOOL flag);
extern OS_STATUS tp_os_mutex_delete(OS_MUTEX_ID mid);
extern OS_STATUS tp_os_mutex_get(OS_MUTEX_ID mid, UINT32 timeout);
extern OS_STATUS tp_os_mutex_put(OS_MUTEX_ID mid);

#define os_mutex_create(szName,bLockFlag) tp_os_mutex_create(( ZCHAR *)szName,( ZBOOL ) bLockFlag) 
#define  os_mutex_delete(mutexID) tp_os_mutex_delete((OS_MUTEX_ID  )mutexID)
#define  os_mutex_get(mutexID, timeout) tp_os_mutex_get(( OS_MUTEX_ID )mutexID,(UINT32 )  timeout)
#define  os_mutex_put(mutexID) tp_os_mutex_put((OS_MUTEX_ID  )mutexID)
#else
extern OS_MUTEX_ID win32_os_mutex_create(ZCHAR *name, ZBOOL flag);
extern OS_STATUS win32_os_mutex_delete(OS_MUTEX_ID mid);
extern OS_STATUS win32_os_mutex_get(OS_MUTEX_ID mid, UINT32 timeout);
extern OS_STATUS win32_os_mutex_put(OS_MUTEX_ID mid);


#define os_mutex_create(szName,bLockFlag) win32_os_mutex_create(( ZCHAR *)szName,( ZBOOL ) bLockFlag) 
#define  os_mutex_delete(mutexID) win32_os_mutex_delete((OS_MUTEX_ID  )mutexID)
#define  os_mutex_get(mutexID, timeout) win32_os_mutex_get(( OS_MUTEX_ID )mutexID,(UINT32 )  timeout)
#define  os_mutex_put(mutexID) win32_os_mutex_put((OS_MUTEX_ID  )mutexID)
#endif

/*mutex*/
//OS_MUTEX_ID os_mutex_create(CHAR *szName, BOOL bLockFlag);
//OS_STATUS os_mutex_delete(OS_MUTEX_ID mutexID);
//OS_STATUS os_mutex_get(OS_MUTEX_ID mutexID, UINT32 timeout); /* timeout: -1 means waiting forever*/
//OS_STATUS os_mutex_put(OS_MUTEX_ID mutexID);


#define os_mutex_unlock os_mutex_put
extern OS_EVENT_ID tp_os_event_create(ZCHAR *name,ZBOOL flag);
extern OS_STATUS tp_os_event_delete(OS_EVENT_ID eid);
extern OS_STATUS tp_os_event_get(OS_EVENT_ID eid, UINT32 timeout);
extern OS_STATUS tp_os_event_set(OS_EVENT_ID eid);

/*event*/
#define os_event_create(szName, flag) tp_os_event_create((ZCHAR *)szName, (ZBOOL) flag)
#define os_event_delete(eventID) tp_os_event_delete((OS_EVENT_ID )eventID)
#define os_event_get(eventID,  timeout) tp_os_event_get((OS_EVENT_ID) eventID, (UINT32) timeout) /* timeout: -1 means waiting forever*/
#define os_event_set( eventID) tp_os_event_set((OS_EVENT_ID) eventID)

//OS_EVENT_ID os_event_create(CHAR *szName, BOOL flag);
//OS_STATUS os_event_delete(OS_EVENT_ID eventID);
//OS_STATUS os_event_get(OS_EVENT_ID eventID, UINT32 timeout); /* timeout: -1 means waiting forever*/
//OS_STATUS os_event_set(OS_EVENT_ID eventID);


//extern VOID *tp_os_mem_malloc(UINT32 bytes);
//extern OS_STATUS tp_os_mem_free(VOID *mem_ptr);
//extern VOID tp_os_mem_cpy(VOID *dest_ptr, VOID *src_ptr, UINT32 copy_len);
//extern VOID tp_os_mem_set(VOID *dest_ptr, UINT8 value, UINT32 len);


/*memory*/
//void *os_mem_malloc(UINT32 size); 
//void  os_mem_free(void* pMem);
//void  os_mem_set(void *dest_ptr, UINT8 value, UINT32 len);
//void  os_mem_cpy(void *dest_ptr, void *src_ptr, UINT32 copy_len);
#define os_mem_malloc(size) tp_os_mem_malloc((UINT32)size)
#define os_mem_free(pMem)  tp_os_mem_free((ZVOID *)pMem) 
#define os_mem_set(dest_ptr,value, len) tp_os_mem_set ((ZVOID * )dest_ptr,( ZUINT8 ) value, ( UINT32) len) 
#define os_mem_cpy(dest_ptr,src_ptr, copy_len)  tp_os_mem_cpy(( ZVOID *)dest_ptr, (ZVOID * )src_ptr,(UINT32  ) copy_len) 



/*Queue*/
extern OS_QUEUE_ID tp_os_queue_create(ZCHAR *name,UINT32 msg_size,UINT32 max_nums);
extern OS_STATUS tp_os_queue_delete(OS_QUEUE_ID qid);
extern OS_STATUS tp_os_queue_receive(OS_QUEUE_ID qid, ZVOID **msg_ptr, UINT32 timeout);
extern OS_STATUS tp_os_queue_send(OS_QUEUE_ID qid, ZVOID *msg_ptr,UINT32 timeout);

#define  os_queue_create(name,msg_size,max_nums) tp_os_queue_create((ZCHAR *)name,(UINT32)msg_size,(UINT32)max_nums)
#define os_queue_send(qid,msg_ptr,timeout) tp_os_queue_delete((OS_QUEUE_ID)qid,(ZVOID *)msg_ptr,(UINT32)timeout)
#define os_queue_receive(qid, msg_ptr, timeout) tp_os_queue_receive((OS_QUEUE_ID)qid, (ZVOID **)msg_ptr, (UINT32)timeout)
#define  os_queue_delete(qid) tp_os_queue_send((OS_QUEUE_ID)qid)



/*Timer */
#define  os_timer_create(name, expir_func,  expire_para_ptr, interval, flag)  tp_os_timer_create(name, expir_func,  expire_para_ptr, interval, flag)
#define  os_timer_start(id)  tp_os_timer_start(id)
#define  os_timer_restart(id,interval)  tp_os_timer_restart(id,interval)

OS_STATUS os_timer_delete(OS_TIMER_ID id);
//OS_STATUS os_timer_start(OS_TIMER_ID id);
//OS_STATUS os_timer_restart(OS_TIMER_ID id,UINT32 interval);
OS_STATUS os_timer_stop(OS_TIMER_ID id);


//othre function
typedef enum _PRINT_LOG_LEVEL
{
	PRINT_LOG_INFO = 0x1,
	PRINT_LOG_WARNING= 0x2,
	PRINT_LOG_ERROR = 0x4
}T_OS_PRINT_LOG_LEVEL;

typedef enum _PRINT_TYPE
{
	PRINT_TO_SCREEN,
	PRINT_TO_FILE,
	PRINT_TO_BUFF
}T_OS_PRINT_TYPE;

typedef enum _PRINT_LOG_FORMAT
{
	PRINT_LOG_TIME = 0x1,     /*显示时间*/
	PRINT_LOG_FILE_LINE= 0x2, /*显示文件名和行号*/
	PRINT_LOG_THREAD_ID = 0x4,/*显示线程号*/
	PRINT_LOG_SENQUENCE = 0x8 /*显示序号*/
}T_OS_PRINT_LOG_FORMAT;



/*使用宏定义LOG_M 进行打印，不要直接使用os_print_log，以便简化应用代码*/
ZVOID os_print_log(ZCHAR *pszFileName, ZSINT32 iLineNum, ZCHAR* pModuleName, ZSINT32 iLevel, ZCHAR *format, ...);
ZVOID os_print_cfg( ZSINT32 iPrintType, ZSINT32 iPrintLevelMask, ZSINT32 iPrintFormatMask );



//#define LOG_M  os_print_log
#define LOG_M  printf
#define LOG_LEVEL_INFO  __FILE__,__LINE__,0,PRINT_LOG_INFO
#define LOG_LEVEL_ERROR  __FILE__,__LINE__,0,PRINT_LOG_ERROR


#endif

