#ifndef __FTSYNTH_H__
#define __FTSYNTH_H__


#include <ft2build.h>
#include FT_FREETYPE_H

#ifdef FREETYPE_H
#error "freetype.h of FreeType 1 has been loaded!"
#error "Please fix the directory search order for header files"
#error "so that freetype.h of FreeType 2 is found first."
#endif


FT_BEGIN_HEADER

/* Embolden a glyph by a `reasonable' value (which is highly a matter of */
/* taste).  This function is actually a convenience function, providing  */
/* a wrapper for @FT_Outline_Embolden and @FT_Bitmap_Embolden.           */
/*                                                                       */
/* For emboldened outlines the metrics are estimates only; if you need   */
/* precise values you should call @FT_Outline_Get_CBox.                  */
FT_EXPORT( void )
FT_GlyphSlot_Embolden( FT_GlyphSlot  slot );

/* Slant an outline glyph to the right by about 12 degrees. */
FT_EXPORT( void )
FT_GlyphSlot_Oblique( FT_GlyphSlot  slot );

/* */

FT_END_HEADER

#endif /* __FTSYNTH_H__ */


/* END */
