#ifndef	TIMER_H
#define	TIMER_H
/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include "gui_g.h"
#include "WM_date_e.h"
#include "zcore_window.h"
/**************************************************************************
 *                                                                    *
 **************************************************************************/

 /**************************************************************************
 *                         궨                                         *
 **************************************************************************/

#ifndef MAX_TIMERS
#define MAX_TIMERS      32
#endif


#ifndef USEC_1S
#define USEC_1S         1000000
#endif
#ifndef USEC_10MS
#define USEC_10MS       10000
#endif


/**************************************************************************
 *                         ṹͶ                                    *
 **************************************************************************/
typedef struct _timer {
    HWND    hWnd;
    ZSINT32     id;
	ZUINT32 speed;
	ZUINT32 count;
	PMSGQUEUE msg_queue;
}TIMER;
typedef TIMER* PTIMER;
/**************************************************************************
 *                        ԭ                                     *
 **************************************************************************/

ZBOOL InitTimer (ZVOID);
 ZVOID* TimerEntry (ZVOID* data);
ZVOID TimerOriginLoop(ZVOID);
ZVOID TerminateTimer (ZVOID);
ZBOOL AddTimer (HWND hWnd, ZSINT32 id, ZUINT32 speed);
ZBOOL RemoveTimer (HWND hWnd, ZSINT32 id);
ZBOOL IsTimerInstalled (HWND hWnd, ZSINT32 id);
ZBOOL SetTimerSpeed (HWND hWnd, ZSINT32 id, ZUINT32 speed);
ZVOID DispatchTimerMessage (ZUINT32 inter);
TIMER*  mg_get_timer (ZSINT32 slot);

static __inline HWND __mg_get_timer_hwnd (ZSINT32 slot)
{
    TIMER* ptimer = mg_get_timer (slot);
    if (ptimer)
        return ptimer->hWnd;

    return HWND_NULL;
}
#endif  /* xxxx_H */
