#ifndef _ZCORE_GUI_BLOCKHEAP_H_
#define _ZCORE_GUI_BLOCKHEAP_H_
#include "zcore_type.h"

#define BDS_FREE        0x0000
#define BDS_SPECIAL     0x0001
#define BDS_USED        0x0002

#ifndef _MGUI_GDI_H /* included in include/gdi.h */
typedef struct tagBLOCKHEAP
{
#ifndef _LITE_VERSION
    pthread_mutex_t lock;
#endif
    size_t          bd_size;
    size_t          heap_size;
    ZSINT32             free;
    ZVOID*           heap;
} BLOCKHEAP;
typedef BLOCKHEAP* PBLOCKHEAP;

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

/* Function definitions */

ZVOID InitBlockDataHeap (PBLOCKHEAP heap, size_t bd_size, size_t heap_size);
ZVOID* BlockDataAlloc (PBLOCKHEAP heap);
ZVOID BlockDataFree (PBLOCKHEAP heap, ZVOID* data);
ZVOID DestroyBlockDataHeap (PBLOCKHEAP heap);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif  /* GUI_GDI_H */

#endif  /* _ZCORE_GUI_BLOCKHEAP_H_ */


