#ifndef _ZCORE_GUI_DEVFONT_H_
#define _ZCORE_GUI_DEVFONT_H_


#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#include "zcore_type.h"

#ifdef _VBF_SUPPORT
ZBOOL InitIncoreVBFonts (ZVOID);
ZVOID TermIncoreVBFonts (ZVOID);

ZBOOL InitVarBitmapFonts (ZVOID);
ZVOID TermVarBitmapFonts (ZVOID);
#endif

#ifdef _RBF_SUPPORT

#ifdef _INCORE_RES
ZBOOL InitIncoreRBFonts (ZVOID);
ZVOID TermIncoreRBFonts (ZVOID);
#else
ZBOOL InitRawBitmapFonts (ZVOID);
ZVOID TermRawBitmapFonts (ZVOID);
#endif /* _INCORE_RES */

#endif

#ifdef _QPF_SUPPORT
ZBOOL InitQPFonts (ZVOID);
ZVOID TermQPFonts (ZVOID);
ZBOOL InitIncoreQPFonts (ZVOID);
ZVOID TermIncoreQPFonts (ZVOID);
#endif

#ifdef _TTF_SUPPORT
ZBOOL InitFreeTypeFonts (ZVOID);
ZVOID TermFreeTypeFonts (ZVOID);
#endif

#ifdef _TYPE1_SUPPORT
ZBOOL InitType1Fonts (ZVOID);
ZVOID TermType1Fonts (ZVOID);
#endif

/* Device font management functions */
ZVOID AddSBDevFont (DEVFONT* dev_font);
ZVOID AddMBDevFont (DEVFONT* dev_font);
ZVOID ResetDevFont (ZVOID);

DEVFONT* GetMatchedSBDevFont (LOGFONT* log_font);
DEVFONT* GetMatchedMBDevFont (LOGFONT* log_font);

#define GET_DEVFONT_SCALE(logfont, devfont) \
        ((devfont->charset_ops->bytes_per_char > 1)?logfont->sbc_scale:logfont->mbc_scale)

#define SET_DEVFONT_SCALE(logfont, devfont, scale) \
        ((devfont->charset_ops->bytes_per_char > 1)?(logfont->sbc_scale = scale):(logfont->mbc_scale = scale))

#ifdef _USE_NEWGAL
extern ZUINT16 GetBestScaleFactor (ZSINT32 height, ZSINT32 expect);
#endif
#ifdef _DEBUG
ZVOID dumpDevFonts (ZVOID);
#endif

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif // _ZCORE_GUI_DEVFONT_H_

