#ifndef _ZCORE_GUI_DRAWSEMOP_H_
#define _ZCORE_GUI_DRAWSEMOP_H_

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */
#include "zcore_type.h"
#include <errno.h>

static inline ZVOID my_sem_op (ZSINT32 num, ZSINT32 op)
{
    struct sembuf sb;

again:
    sb.sem_num = num;
    sb.sem_op = op;
    sb.sem_flg = SEM_UNDO;

    if (semop (SHAREDRES_SEMID, &sb, 1) == -1) {
        if (errno == EINTR) {
            goto again;
        }
    }
}

#define lock_draw_sem()     my_sem_op(_IDX_SEM_DRAW, -1)
#define unlock_draw_sem()   my_sem_op(_IDX_SEM_DRAW, 1)

#define lock_scr_sem()      my_sem_op(_IDX_SEM_SCR, -1)
#define unlock_scr_sem()    my_sem_op(_IDX_SEM_SCR, 1)

#ifdef _CURSOR_SUPPORT

#define lock_cursor_sem()   my_sem_op(_IDX_SEM_CURSOR, -1)
#define unlock_cursor_sem() my_sem_op(_IDX_SEM_CURSOR, 1)

static inline ZSINT32 get_sem_pid (ZSINT32 num)
{
    ZSINT32 pid;
    union semun ignored;

    pid = semctl (SHAREDRES_SEMID, num, GETPID, ignored);
#ifdef _DEBUG
    if (pid == -1)
        perror ("get_sem_pid");
#endif

    return pid;
}

#define get_cursor_sem_pid() get_sem_pid(_IDX_SEM_CURSOR)

static inline ZSINT32 get_hidecursor_sem_val (ZVOID)
{
    ZSINT32 val;
    union semun ignored;

    val = semctl (SHAREDRES_SEMID, _IDX_SEM_HIDECOUNT, GETVAL, ignored);
#ifdef _DEBUG
    if (val == -1)
        perror ("get_hidecursor_sem_val");
#endif

    return val;
}

static inline ZVOID reset_hidecursor_sem (ZVOID)
{
    ZSINT32 ret;
    union semun sunion;

    sunion.val = 0;
    ret = semctl (SHAREDRES_SEMID, _IDX_SEM_HIDECOUNT, SETVAL, sunion) == -1;
#ifdef _DEBUG
    if (ret == -1)
        perror ("reset_hidecursor_sem");
#endif
}

static inline ZVOID inc_hidecursor_sem (ZVOID)
{
    struct sembuf sb;

again:
    sb.sem_num = _IDX_SEM_HIDECOUNT;
    sb.sem_op = 1;
    sb.sem_flg = 0;

    if (semop (SHAREDRES_SEMID, &sb, 1) == -1) {
        if (errno == EINTR) {
            goto again;
        }
    }
}

#endif /* _CURSOR_SUPPORT */

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif // _ZCORE_GUI_DRAWSEMOP_H_

